/*
 * Decompiled with CFR 0.152.
 */
package devRiemannSurface.branchgraph;

import dev.vecmath.PiDynVector;
import devCovering.PgCovering;
import devGraph.PgAbstractGraph;
import devGraph.PgGraphOnElementSet;
import devGraph.PnAbstractGraph;
import devGraph.PnGraphOnElementSet;
import devRiemannSurface.branchgraph.PgBranchGraph;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PbVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;

public class PnBranchGraph {
    public static PgBranchGraph makeBranchGraphFromBranchPoints(PgElementSet geom, PiVector bPoints, PiVector bTypes, int symmetryOrder, PgGraphOnElementSet tree) {
        int sum = bTypes.sum();
        if (symmetryOrder > 0) {
            sum = PuMath.modulo((int)sum, (int)symmetryOrder);
        }
        if (sum != 0) {
            PsDebug.warning((String)"Indices do not sum to 0.");
            return null;
        }
        PiVector bBases = new PiVector(bTypes.getSize());
        bBases.setConstant(symmetryOrder);
        int numBPoints = bPoints.getSize();
        PgBranchGraph graph = new PgBranchGraph(geom);
        graph.setNodes(bPoints, bTypes, bBases);
        tree = tree == null ? PnGraphOnElementSet.makeShortestCutGraph((PgElementSet)geom, null, (PiVector)bPoints) : PgGraphOnElementSet.copyNew((PgGraphOnElementSet)tree);
        PnAbstractGraph.makeSubtree((PgAbstractGraph)tree, (PgAbstractGraph)tree, (PiVector)new PiVector(new int[]{bPoints.getFirstEntry()}));
        PnAbstractGraph.removeStubs((PgAbstractGraph)tree, (PiVector)bPoints);
        int numHandledEdges = 0;
        int numVertices = geom.getNumVertices();
        PbVector markedNodes = new PbVector(numVertices);
        PiVector nodeToVertex = new PiVector(numVertices);
        nodeToVertex.setConstant(-1);
        int i = 0;
        while (i < numBPoints) {
            markedNodes.m_data[bPoints.m_data[i]] = true;
            nodeToVertex.m_data[bPoints.m_data[i]] = i;
            ++i;
        }
        while (numHandledEdges < numBPoints - 1) {
            int bp = 1;
            while (bp < numBPoints) {
                int actNodeVertex = bPoints.m_data[bp];
                if (tree.getValence(actNodeVertex) == 1) {
                    ++numHandledEdges;
                    PiVector neighb = graph.getNeighbours(bp);
                    int m = bTypes.m_data[bp] - neighb.sum();
                    PiDynVector path = new PiDynVector();
                    int nodeVertex = actNodeVertex;
                    markedNodes.m_data[nodeVertex] = false;
                    while (!markedNodes.m_data[nodeVertex] && tree.getParent(nodeVertex) >= 0) {
                        path.appendEntry(nodeVertex);
                        nodeVertex = tree.getParent(nodeVertex);
                    }
                    path.appendEntry(nodeVertex);
                    PiVector edgeVertices = path.toPiVector();
                    graph.addEdge(bp, nodeToVertex.m_data[edgeVertices.getLastEntry()], edgeVertices, m, symmetryOrder);
                    PnAbstractGraph.removeStub((PgAbstractGraph)tree, (int)actNodeVertex, (PbVector)markedNodes);
                }
                ++bp;
            }
        }
        return graph;
    }

    public static PgCovering makeCovering(PgBranchGraph graph, int symmetryOrder) {
        PgElementSet geom = graph.getGeometry();
        PgCovering cov = new PgCovering(geom, symmetryOrder);
        cov.setBranchPoints(graph.getNodes(), graph.getNodeShift());
        int numNodes = graph.getNumNodes();
        if (numNodes == 0) {
            return cov;
        }
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        int i = 0;
        while (i < numNodes) {
            PiVector neighbour = graph.getNeighbours(i);
            int valence = neighbour.getSize();
            int j = 0;
            while (j < valence) {
                int n = neighbour.getEntry(j);
                if (i <= n) {
                    int m = graph.getEdgeType(i, j);
                    PiVector path = graph.getEdgeVertices(i, j);
                    int size = path.getSize();
                    int k = 0;
                    while (k < size - 1) {
                        PgVertexStar star = new PgVertexStar();
                        int v = path.m_data[k];
                        star.makeVertexStar(geom, v, elementPerVertex.m_data[v]);
                        PiVector link = star.getLink();
                        int loc = link.getIndexOf(path.m_data[k + 1]);
                        if (loc < 0) {
                            PsDebug.warning((String)"Error in neighbours");
                            return null;
                        }
                        int e = star.getElement().m_data[loc];
                        int dim = geom.getDimOfElement(e);
                        int locVInd = (dim + star.getVertexLocInd().m_data[loc] - 1) % dim;
                        cov.setMatching(e, locVInd, m + cov.getMatching(e, locVInd));
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return cov;
    }
}

