/*
 * Decompiled with CFR 0.152.
 */
package devRiemannSurface.branchgraph;

import devCovering.PgCovering;
import devCovering.PnCovering;
import devGraph.PgAbstractGraph;
import devGraph.PgGraphOnElementSet;
import devGraph.PnGraphOnElementSet;
import devRiemannSurface.branchgraph.PgBranchCut;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;
import jvx.util.PuQueue;

public class PgBranchGraph
extends PgAbstractGraph {
    protected PgElementSet m_geom;
    protected PiVector m_nodeVertexInd;
    protected PiVector m_nodeShift;
    protected PiVector m_nodeBases;
    protected PiVector[][] m_edgeVertices;
    protected PiVector[] m_edgeTypes;
    protected PiVector[] m_edgeBases;
    private PgCovering m_cov;
    private int m_numOfSheets;

    public PgBranchGraph(PgElementSet geom) {
        this.m_geom = geom;
        this.m_nodeVertexInd = new PiVector();
        this.m_nodeShift = new PiVector();
        this.m_nodeBases = new PiVector();
        this.m_edgeTypes = new PiVector[0];
        this.m_edgeBases = new PiVector[0];
        this.m_edgeVertices = new PiVector[0][0];
        this.m_neighbour = new PiVector[0];
    }

    public int addNode(int vertexInd, int shift, int basis) {
        int found = this.m_nodeVertexInd.getIndexOf(vertexInd);
        if (-1 != found) {
            return found;
        }
        this.setNumNodes(this.m_numNodes + 1);
        this.m_nodeVertexInd.setEntry(this.m_numNodes - 1, vertexInd);
        this.m_nodeShift.setEntry(this.m_numNodes - 1, shift);
        this.m_nodeBases.setEntry(this.m_numNodes - 1, basis);
        return this.m_numNodes - 1;
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    public int getVertex(int node) {
        return this.m_nodeVertexInd.getEntry(node);
    }

    public int getNodeShift(int node) {
        return this.m_nodeShift.getEntry(node);
    }

    public void setNodeShift(int node, int type) {
        this.m_nodeShift.setEntry(node, type);
    }

    public void setNodeBasis(int node, int basis) {
        this.m_nodeBases.setEntry(node, basis);
    }

    public PiVector getNodeShift() {
        return this.m_nodeShift;
    }

    public int getNodeBasis(int node) {
        return this.m_nodeBases.getEntry(node);
    }

    public void setNodes(PiVector vertexInd, PiVector types, PiVector bases) {
        int size = vertexInd.getSize();
        if (types.getSize() != size || bases.getSize() != size) {
            PsDebug.warning((String)"Vector sizes not compatible");
            return;
        }
        if (size != this.getNumNodes()) {
            this.setNumNodes(size);
        }
        this.m_nodeVertexInd = vertexInd;
        this.m_nodeShift = types;
        this.m_nodeBases = bases;
    }

    public PiVector getNodes() {
        return this.m_nodeVertexInd;
    }

    public void setNode(int node, int vertexInd, int type, int basis) {
        this.m_nodeVertexInd.m_data[node] = vertexInd;
        this.m_nodeShift.m_data[node] = type;
        this.m_nodeBases.m_data[node] = basis;
    }

    public boolean addEdge(int startBP, int endBP) {
        boolean res = super.addEdge(startBP, endBP);
        if (res) {
            this.m_edgeTypes[startBP].addEntry(-1);
            this.m_edgeBases[startBP].addEntry(-1);
            this.m_edgeTypes[endBP].addEntry(-1);
            this.m_edgeBases[endBP].addEntry(-1);
            this.m_edgeVertices[startBP] = PiVector.realloc((PiVector[])this.m_edgeVertices[startBP], (int)(this.m_edgeVertices[startBP].length + 1));
            this.m_edgeVertices[endBP] = PiVector.realloc((PiVector[])this.m_edgeVertices[endBP], (int)(this.m_edgeVertices[endBP].length + 1));
        }
        return res;
    }

    public void setEdge(int startBP, int locNB, PiVector vertices, int type, int basis) {
        this.m_edgeBases[startBP].setEntry(locNB, basis);
        this.m_edgeTypes[startBP].setEntry(locNB, type);
        this.m_edgeVertices[startBP][locNB] = vertices;
    }

    public boolean addEdge(int startBP, int endBP, PiVector vertices, int type, int basis) {
        if (startBP >= this.m_numNodes) {
            PsDebug.warning((String)"startBP index out of range");
            return false;
        }
        boolean res = this.addEdge(startBP, endBP);
        if (res) {
            int locNBStart = this.m_neighbour[startBP].getSize() - 1;
            int locNBEnd = this.m_neighbour[endBP].getSize() - 1;
            this.setEdge(startBP, locNBStart, vertices, type, basis);
            PiVector invVertices = PiVector.copyNew((PiVector)vertices);
            if (invVertices != null) {
                invVertices.invert();
            }
            this.setEdge(endBP, locNBEnd, invVertices, -type, basis);
        }
        return res;
    }

    public int getEdgeType(int startBP, int locNB) {
        return this.m_edgeTypes[startBP].getEntry(locNB);
    }

    private void setEdgeType(int startBP, int locNB, int type) {
        this.m_edgeTypes[startBP].setEntry(locNB, type);
    }

    public int getEdgeBasis(int startBP, int locNB) {
        return this.m_edgeBases[startBP].getEntry(locNB);
    }

    public PiVector getEdgeVertices(int startBP, int locNB) {
        return this.m_edgeVertices[startBP][locNB];
    }

    public boolean removeEdge(int ind1, int ind2) {
        super.removeEdge(ind1, ind2);
        return true;
    }

    public void setNumNodes(int numNodes) {
        if (numNodes == this.m_numNodes) {
            return;
        }
        this.m_nodeVertexInd.setSize(numNodes);
        this.m_nodeShift.setSize(numNodes);
        this.m_nodeBases.setSize(numNodes);
        this.m_neighbour = PiVector.realloc((PiVector[])this.m_neighbour, (int)numNodes);
        this.m_edgeTypes = PiVector.realloc((PiVector[])this.m_edgeTypes, (int)numNodes);
        this.m_edgeBases = PiVector.realloc((PiVector[])this.m_edgeBases, (int)numNodes);
        PiVector[][] newEdgeVertices = new PiVector[numNodes][];
        int min = Math.min(numNodes, this.m_numNodes);
        if (min > 0) {
            System.arraycopy(this.m_edgeVertices, 0, newEdgeVertices, 0, min);
        }
        int j = min;
        while (j < numNodes) {
            newEdgeVertices[j] = new PiVector[0];
            ++j;
        }
        this.m_edgeVertices = newEdgeVertices;
        this.m_numNodes = numNodes;
    }

    public PgBranchCut[] getBranchCuts() {
        int numOfCuts = this.countEdges();
        PgBranchCut[] branchCuts = new PgBranchCut[numOfCuts];
        int count = 0;
        int i = 0;
        while (i < this.m_numNodes) {
            int l = this.m_neighbour[i].getSize();
            int j = 0;
            while (j < l) {
                int neighbour = this.m_neighbour[i].getEntry(j);
                if (i <= neighbour) {
                    int bpStart = this.m_nodeVertexInd.getEntry(i);
                    int bpStartType = this.m_nodeShift.getEntry(i);
                    int bpStartBasis = this.m_nodeBases.getEntry(i);
                    int bpEnd = this.m_nodeVertexInd.getEntry(neighbour);
                    int bpEndType = this.m_nodeShift.getEntry(neighbour);
                    int bpEndBasis = this.m_nodeBases.getEntry(neighbour);
                    int type = this.getEdgeType(i, j);
                    int basis = this.getEdgeBasis(i, j);
                    PiVector vertices = this.getEdgeVertices(i, j);
                    branchCuts[count] = new PgBranchCut(bpStart, bpStartType, bpStartBasis, bpEnd, bpEndType, bpEndBasis, vertices, type, basis);
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        return branchCuts;
    }

    public PgGraphOnElementSet makeGraphOnElementSet() {
        PgGraphOnElementSet G = new PgGraphOnElementSet(this.m_geom, 0);
        G.setName("Branch Graph as GraphOnElementSet");
        int n = 0;
        while (n < this.m_numNodes) {
            int vn = this.m_nodeVertexInd.getEntry(n);
            PiVector neighbours = this.getNeighbours(n);
            int size = neighbours.getSize();
            int j = 0;
            while (j < size) {
                int vj = this.m_nodeVertexInd.getEntry(j);
                if (vj <= vn) {
                    PiVector vertices = this.getEdgeVertices(n, j);
                    int vsSize = vertices.getSize();
                    int i = 0;
                    while (i < vsSize - 1) {
                        G.addEdge(vertices.getEntry(i), vertices.getEntry(i + 1));
                        ++i;
                    }
                }
                ++j;
            }
            ++n;
        }
        return G;
    }

    public int getNumEdges() {
        return 0;
    }

    private void normalize() {
        int nov = this.getNumNodes();
        int lcm = 1;
        int i = 0;
        while (i < nov) {
            int basis = this.getNodeBasis(i);
            int shift = this.getNodeShift(i);
            int gcd = this.gcd2(shift, basis);
            this.setNodeBasis(i, basis / gcd);
            this.setNodeShift(i, shift / gcd);
            lcm = PuMath.lcm((int)lcm, (int)this.getNodeBasis(i));
            ++i;
        }
        this.m_numOfSheets = lcm;
        i = 0;
        while (i < nov) {
            int nb = this.getNodeBasis(i);
            if (nb != lcm) {
                this.setNodeShift(i, this.getNodeShift(i) * lcm / nb);
            }
            this.setNodeBasis(i, lcm);
            ++i;
        }
    }

    private void assignEdgeTypes() {
        int nov = this.getNumNodes();
        PiVector elements = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
        int i = 0;
        while (i < nov) {
            PiVector neighbors = this.m_neighbour[i];
            int size = neighbors.getSize();
            int j = 0;
            while (j < size) {
                int type = this.getEdgeTypeFromCovering(i, j, this.m_cov, elements);
                this.setEdgeType(i, j, type);
                ++j;
            }
            ++i;
        }
    }

    public int getNumOfSheets() {
        return this.m_numOfSheets;
    }

    private int getEdgeTypeFromCovering(int node, int locNB, PgCovering cov, PiVector nbElements) {
        PiVector vertices = this.m_edgeVertices[node][locNB];
        int bp = vertices.getFirstEntry();
        int v = vertices.getEntry(1);
        PgElementSet geom = cov.getGeometry();
        int nbElement = nbElements == null ? -1 : nbElements.m_data[bp];
        PgVertexStar vertexStar = new PgVertexStar();
        vertexStar.makeVertexStar(geom, bp, nbElement);
        PiVector link = vertexStar.getLink();
        int indOfV = link.getIndexOf(v);
        PiVector elements = vertexStar.getElement();
        int el = elements.getEntry(indOfV);
        int noe = vertexStar.getSize();
        int prevElInd = (indOfV + noe - 1) % noe;
        int prevElV = elements.getEntry(prevElInd);
        PiVector nbElementsOfEl = geom.getNeighbour(el);
        int locNBIndPrevEl = nbElementsOfEl.getIndexOf(prevElV);
        int matching = cov.getMatching(el, locNBIndPrevEl);
        return matching;
    }

    public PgCovering getAssociatedCovering() {
        return this.m_cov;
    }

    public void complete() throws Exception {
        this.normalize();
        this.m_cov = PnCovering.makeCoveringFromBranchPoints2((PgElementSet)this.m_geom, (PiVector)this.m_nodeVertexInd, (PiVector)this.m_nodeShift, (int)this.getNumOfSheets(), (PgGraphOnElementSet)this.makeGraphOnElementSet());
        if (this.m_cov == null) {
            throw new Exception("Branch graph not valid");
        }
        this.assignEdgeTypes();
    }

    public void makeDefaultCutGraph() {
        PgGraphOnElementSet tree = PnGraphOnElementSet.makeShortestCutGraph((PgElementSet)this.m_geom, null, (PiVector)this.m_nodeVertexInd);
        boolean[] isBranchPoint = new boolean[this.m_geom.getNumVertices()];
        int numOfBranchPoints = this.m_nodeVertexInd.getSize();
        int i = 0;
        while (i < numOfBranchPoints) {
            isBranchPoint[this.m_nodeVertexInd.getEntry((int)i)] = true;
            ++i;
        }
        PuQueue QBranchPoints = new PuQueue(this.m_nodeVertexInd.m_data);
        block1: while (!QBranchPoints.isEmpty()) {
            int curBP = QBranchPoints.extractFirst();
            if (tree.getValence(curBP) != 1) {
                QBranchPoints.enqueue(curBP);
                continue;
            }
            PiVector vertices = new PiVector();
            vertices.addEntry(curBP);
            int current = curBP;
            int parent = tree.getParent(curBP);
            while (tree.getValence(parent) == 2) {
                vertices.addEntry(parent);
                tree.removeEdge(current, parent);
                current = parent;
                if (isBranchPoint[parent]) continue block1;
            }
        }
    }

    public int gcd2(int a, int b) {
        int h = 0;
        while (b != 0) {
            h = a % b;
            a = b;
            b = h;
        }
        return Math.abs(a);
    }
}

