/*
 * Decompiled with CFR 0.152.
 */
package devRiemannSurface;

import devRiemannSurface.PjRiemannSurfGen;
import devRiemannSurface.PnDijkstra;
import devRiemannSurface.branchgraph.PgBranchCut;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.object.PsDialog;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PsAddBranchCutDlg
extends PsDialog
implements PvPickListenerIf {
    private static final int MODE_ADD_START_BP = 1;
    private static final int MODE_ADD_END_BP = 2;
    private static final int MODE_ADD_VERTICES = 3;
    private final Color COL_BP_START = Color.green;
    private final Color COL_BP_END = Color.blue;
    private final Color COL_CUT_VERTEX = Color.yellow;
    private final Color COL_VERTEX_DEFAULT = Color.red;
    int m_curMode = 1;
    Vector<Integer> m_vertices;
    PgElementSet m_geom;
    PsPanel m_pBranchPoints;
    PsPanel m_pStartBP;
    TextField m_tfStartBPVertex;
    TextField m_tfStartBPType;
    TextField m_tfStartBPBasis;
    PsPanel m_pEndBP;
    TextField m_tfEndBPVertex;
    TextField m_tfEndBPType;
    TextField m_tfEndBPBasis;
    PsPanel m_pAddVertices;
    List m_lVertices;
    Button m_bShortestLine;
    Button m_bResetVertices;
    PsPanel m_pNavi;
    Button m_bNext;
    Button m_bPrevious;

    public PsAddBranchCutDlg(Frame frame, String name, boolean modal, PgElementSet geom) {
        super(frame, name, modal);
        this.m_geom = geom;
        this.m_vertices = new Vector();
        this.m_pStartBP = new PsPanel((LayoutManager)new GridLayout(4, 1));
        this.m_tfStartBPVertex = new TextField();
        this.m_tfStartBPType = new TextField();
        this.m_tfStartBPBasis = new TextField();
        this.m_tfStartBPVertex.setBackground(Color.yellow);
        this.m_pStartBP.add((Component)new Label("Starting Branch Point"));
        this.m_pStartBP.add((Component)this.m_tfStartBPVertex);
        this.m_pStartBP.add((Component)this.m_tfStartBPType);
        this.m_pStartBP.add((Component)this.m_tfStartBPBasis);
        this.m_pEndBP = new PsPanel((LayoutManager)new GridLayout(4, 1));
        this.m_tfEndBPVertex = new TextField();
        this.m_tfEndBPType = new TextField();
        this.m_tfEndBPBasis = new TextField();
        this.m_pEndBP.add((Component)new Label("Ending Branch Point"));
        this.m_pEndBP.add((Component)this.m_tfEndBPVertex);
        this.m_pEndBP.add((Component)this.m_tfEndBPType);
        this.m_pEndBP.add((Component)this.m_tfEndBPBasis);
        this.m_pEndBP.setEnabled(false);
        PsPanel pLabels = new PsPanel((LayoutManager)new GridLayout(4, 1));
        pLabels.add((Component)new Label(""));
        pLabels.add((Component)new Label("Vertex"));
        pLabels.add((Component)new Label("Branch Shift"));
        pLabels.add((Component)new Label("Branch Index"));
        this.m_pBranchPoints = new PsPanel((LayoutManager)new GridLayout(1, 3));
        this.m_pBranchPoints.add((Component)pLabels);
        this.m_pBranchPoints.add((Component)this.m_pStartBP);
        this.m_pBranchPoints.add((Component)this.m_pEndBP);
        this.m_pAddVertices = new PsPanel((LayoutManager)new GridLayout(1, 3));
        this.m_pAddVertices.addTitle("Vertices of cut line");
        this.m_lVertices = new List(5);
        this.m_bShortestLine = new Button("Shortest Line");
        this.m_bShortestLine.addActionListener((ActionListener)((Object)this));
        this.m_pAddVertices.add((Component)this.m_lVertices);
        this.m_pAddVertices.add((Component)this.m_bShortestLine);
        this.m_pAddVertices.setEnabled(false);
        this.m_pNavi = new PsPanel((LayoutManager)new GridLayout(1, 3));
        this.m_bNext = new Button(">");
        this.m_bNext.addActionListener((ActionListener)((Object)this));
        this.m_bPrevious = new Button("<");
        this.m_bPrevious.addActionListener((ActionListener)((Object)this));
        this.m_bPrevious.setEnabled(false);
        this.m_pNavi.add((Component)this.m_bPrevious);
        this.m_pNavi.add((Component)this.m_bNext);
        Panel pBottomActions = this.getBottomButtons(5);
        this.m_bOk.setEnabled(false);
        this.m_pNavi.add((Component)pBottomActions);
        this.add((Component)this.m_pBranchPoints);
        this.add((Component)this.m_pAddVertices);
        this.add((Component)this.m_pNavi);
        this.pack();
        this.init();
    }

    public boolean update(Object event) {
        return super.update(event);
    }

    public void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
        Object o = event.getSource();
        if (o == this.m_bNext) {
            ++this.m_curMode;
        } else if (o == this.m_bPrevious) {
            --this.m_curMode;
        } else if (o == this.m_bShortestLine) {
            int startVertex = -1;
            int endVertex = -1;
            try {
                startVertex = Integer.parseInt(this.m_tfStartBPVertex.getText());
                endVertex = Integer.parseInt(this.m_tfEndBPVertex.getText());
            }
            catch (Exception e) {
                System.out.println("At least one branch point vertex index is not valid");
                return;
            }
            PiVector vertices = PnDijkstra.getShortestPathBetween(this.m_geom, startVertex, endVertex);
            int size = vertices.getSize();
            Vector<Integer> tmpVertices = new Vector<Integer>(size - 2);
            int i = 1;
            while (i < size - 1) {
                int v = vertices.getEntry(i);
                this.m_lVertices.add(Integer.toString(v));
                tmpVertices.addElement(v);
                this.m_geom.setVertexColor(v, this.COL_CUT_VERTEX);
                ++i;
            }
            this.m_vertices = tmpVertices;
            this.m_geom.update((Object)this.m_geom);
        } else {
            return;
        }
        switch (this.m_curMode) {
            case 1: {
                this.m_bNext.setEnabled(true);
                this.m_bPrevious.setEnabled(false);
                this.m_bOk.setEnabled(false);
                this.m_tfStartBPVertex.setBackground(Color.yellow);
                this.m_tfEndBPVertex.setBackground(Color.white);
                this.m_pStartBP.setEnabled(true);
                this.m_pEndBP.setEnabled(false);
                this.m_pAddVertices.setEnabled(false);
                break;
            }
            case 2: {
                try {
                    Integer.parseInt(this.m_tfStartBPVertex.getText());
                    Integer.parseInt(this.m_tfStartBPType.getText());
                    Integer.parseInt(this.m_tfStartBPBasis.getText());
                }
                catch (Exception e) {
                    System.out.println("Starting Branch Point not specified correctly.");
                    --this.m_curMode;
                    break;
                }
                int startType = Integer.parseInt(this.m_tfStartBPType.getText());
                this.m_tfEndBPType.setText(Integer.toString(-startType));
                this.m_tfEndBPBasis.setText(this.m_tfStartBPBasis.getText());
                this.m_bNext.setEnabled(true);
                this.m_bPrevious.setEnabled(true);
                this.m_bOk.setEnabled(false);
                this.m_tfStartBPVertex.setBackground(Color.white);
                this.m_tfEndBPVertex.setBackground(Color.yellow);
                this.m_lVertices.setBackground(Color.white);
                this.m_pStartBP.setEnabled(false);
                this.m_pEndBP.setEnabled(true);
                this.m_pAddVertices.setEnabled(false);
                break;
            }
            case 3: {
                try {
                    Integer.parseInt(this.m_tfEndBPVertex.getText());
                    Integer.parseInt(this.m_tfEndBPType.getText());
                    Integer.parseInt(this.m_tfEndBPBasis.getText());
                }
                catch (Exception e) {
                    System.out.println("Ending Branch Point not specified correctly.");
                    --this.m_curMode;
                    break;
                }
                this.m_bPrevious.setEnabled(true);
                this.m_bNext.setEnabled(false);
                this.m_bOk.setEnabled(true);
                this.m_tfEndBPVertex.setBackground(Color.white);
                this.m_lVertices.setBackground(Color.yellow);
                this.m_pStartBP.setEnabled(false);
                this.m_pEndBP.setEnabled(false);
                this.m_pAddVertices.setEnabled(true);
            }
        }
    }

    public void setParent(PsUpdateIf object) {
        super.setParent(object);
        ((PjRiemannSurfGen)object).getDisplay().addPickListener((PvPickListenerIf)this);
    }

    public void pickInitial(PvPickEvent pos) {
        PdBary bary = pos.getBary();
        int el = bary.getElementInd();
        int index = bary.m_data[0] > bary.m_data[1] && bary.m_data[0] > bary.m_data[2] ? 0 : (bary.m_data[1] > bary.m_data[2] ? 1 : 2);
        int v = this.m_geom.getElement((int)el).m_data[index];
        if (v != -1) {
            PgElementSet geom = (PgElementSet)pos.getGeometry();
            switch (this.m_curMode) {
                case 1: {
                    String s = this.m_tfStartBPVertex.getText();
                    try {
                        int oldV = Integer.parseInt(s);
                        geom.setVertexColor(oldV, this.COL_VERTEX_DEFAULT);
                    }
                    catch (NumberFormatException oldV) {
                        // empty catch block
                    }
                    geom.setVertexColor(v, this.COL_BP_START);
                    this.m_tfStartBPVertex.setText(Integer.toString(v));
                    break;
                }
                case 2: {
                    String s = this.m_tfEndBPVertex.getText();
                    try {
                        int oldV = Integer.parseInt(s);
                        geom.setVertexColor(oldV, this.COL_VERTEX_DEFAULT);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    geom.setVertexColor(v, this.COL_BP_END);
                    this.m_tfEndBPVertex.setText(Integer.toString(v));
                    break;
                }
                case 3: {
                    int ind = this.m_vertices.indexOf(new Integer(v));
                    if (-1 != ind) {
                        geom.setVertexColor(v, this.COL_VERTEX_DEFAULT);
                        this.m_lVertices.remove(ind);
                        this.m_vertices.removeElement(new Integer(v));
                        break;
                    }
                    geom.setVertexColor(v, this.COL_CUT_VERTEX);
                    this.m_lVertices.add(Integer.toString(v));
                    this.m_vertices.addElement(new Integer(v));
                    break;
                }
            }
            geom.update((Object)geom);
        }
    }

    public PgBranchCut getBranchCut() throws NumberFormatException {
        int startBPVertex = 0;
        int startBPType = 0;
        int startBPBasis = 0;
        int endBPVertex = 0;
        int endBPType = 0;
        int endBPBasis = 0;
        startBPVertex = Integer.parseInt(this.m_tfStartBPVertex.getText());
        startBPType = Integer.parseInt(this.m_tfStartBPType.getText());
        startBPBasis = Integer.parseInt(this.m_tfStartBPBasis.getText());
        endBPVertex = Integer.parseInt(this.m_tfEndBPVertex.getText());
        endBPType = Integer.parseInt(this.m_tfEndBPType.getText());
        endBPBasis = Integer.parseInt(this.m_tfEndBPBasis.getText());
        int vertSize = this.m_vertices.size();
        PiVector vertices = new PiVector(vertSize + 2);
        vertices.setEntry(0, startBPVertex);
        vertices.setEntry(vertSize + 1, endBPVertex);
        int i = 0;
        while (i < vertSize) {
            vertices.setEntry(i + 1, this.m_vertices.get(i).intValue());
            ++i;
        }
        PgBranchCut bc = new PgBranchCut(startBPVertex, startBPType, startBPBasis, endBPVertex, endBPType, endBPBasis, vertices, 0, 0);
        return bc;
    }

    public void dragDisplay(PvPickEvent pos) {
    }

    public void dragInitial(PvPickEvent pos) {
    }

    public void dragVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void markVertices(PvPickEvent pos) {
    }

    public void pickDisplay(PvPickEvent pos) {
    }

    public void pickVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void selectGeometry(PgGeometryIf geom) {
    }

    public void unmarkVertices(PvPickEvent pos) {
    }
}

