/*
 * Decompiled with CFR 0.152.
 */
package devRiemannSurface;

import dev.vecmath.PiDynVector;
import jv.geom.PgElementSet;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.util.PuPriorityQueue;

public class PnDijkstra {
    public static PiVector dijkstra(PgElementSet geom, int startVertex) {
        int nov = geom.getNumVertices();
        PuPriorityQueue Q = new PuPriorityQueue(nov, 2.147483647E9);
        Q.decreaseKey(startVertex, 0.0);
        PiVector[] neighbors = PgVertexStar.makeVertexNeighbours((PgElementSet)geom);
        PiVector predecessors = new PiVector(nov);
        int i = 0;
        while (i < nov) {
            predecessors.setEntry(i, -1);
            ++i;
        }
        predecessors.setEntry(startVertex, startVertex);
        while (!Q.isEmpty()) {
            int u = Q.extractMin();
            int uDist = (int)Q.getKey(u);
            if (uDist >= Integer.MAX_VALUE) break;
            PiVector uNeighbors = neighbors[u];
            int l = uNeighbors.getSize();
            int j = 0;
            while (j < l) {
                int vCurDist = 1 + uDist;
                int v = uNeighbors.getEntry(j);
                int vDist = (int)Q.getKey(v);
                if (vCurDist < vDist) {
                    Q.decreaseKey(v, (double)vCurDist);
                    predecessors.setEntry(v, u);
                }
                ++j;
            }
        }
        return predecessors;
    }

    public static PiVector getShortestPathBetween(PgElementSet geom, int startVertex, int endVertex) {
        PiVector predecessors = PnDijkstra.dijkstra(geom, startVertex);
        PiDynVector revPath = new PiDynVector();
        int predecessor = predecessors.getEntry(endVertex);
        if (predecessor == -1) {
            return null;
        }
        revPath.appendEntry(endVertex);
        while (predecessor != startVertex) {
            revPath.appendEntry(predecessor);
            predecessor = predecessors.getEntry(predecessor);
        }
        revPath.appendEntry(startVertex);
        int length = revPath.getSize();
        PiVector path = new PiVector(length);
        int i = 0;
        while (i < length) {
            path.setEntry(i, revPath.getEntry(length - 1 - i));
            ++i;
        }
        return path;
    }
}

