/*
 * Decompiled with CFR 0.152.
 */
package devRiemannSurface;

import devRiemannSurface.PjRiemannSurfGen;
import devRiemannSurface.PsAddBranchCutDlg;
import devRiemannSurface.branchgraph.PgBranchCut;
import devRiemannSurface.branchgraph.PgBranchGraph;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;

public class PjRiemannSurfGen_IP
extends PjProject_IP
implements ActionListener,
WindowListener {
    PjRiemannSurfGen m_pjRiemannGen;
    PgBranchGraph m_branchGraph;
    PsAddBranchCutDlg m_dlgAddBranchCut;
    List m_awtlBranchCuts;
    Button m_bAddBranchCut;
    Button m_bComputeModel;
    Button m_bReset;

    public PjRiemannSurfGen_IP() {
        if (this.getClass() == PjRiemannSurfGen_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addTitle("Riemann Surface Generation");
        PsPanel pList = new PsPanel((LayoutManager)new GridLayout(2, 1));
        pList.addTitle("Branch Cuts");
        this.m_awtlBranchCuts = new List();
        pList.add((Component)this.m_awtlBranchCuts);
        this.add((Component)pList);
        PsPanel pButtons = new PsPanel((LayoutManager)new FlowLayout(1));
        this.m_bAddBranchCut = new Button("Add new Branch Cut");
        this.m_bAddBranchCut.addActionListener(this);
        pButtons.add((Component)this.m_bAddBranchCut);
        this.m_bComputeModel = new Button("Compute Model");
        this.m_bComputeModel.addActionListener(this);
        this.m_bComputeModel.setEnabled(false);
        pButtons.add((Component)this.m_bComputeModel);
        this.m_bReset = new Button("Reset");
        this.m_bReset.addActionListener(this);
        pButtons.add((Component)this.m_bReset);
        this.add((Component)pButtons);
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_pjRiemannGen = (PjRiemannSurfGen)parent;
        this.m_branchGraph = new PgBranchGraph(this.m_pjRiemannGen.m_baseGeom);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        if (o == this.m_bAddBranchCut) {
            this.m_dlgAddBranchCut = new PsAddBranchCutDlg(null, "Add Branch Cut", false, this.m_pjRiemannGen.m_baseGeom);
            this.m_dlgAddBranchCut.addWindowListener(this);
            this.m_dlgAddBranchCut.setParent((PsUpdateIf)this.m_pjRiemannGen);
            this.m_dlgAddBranchCut.setVisible(true);
            return;
        }
        if (o == this.m_bComputeModel) {
            this.m_bAddBranchCut.setEnabled(false);
            this.m_bComputeModel.setEnabled(false);
            this.m_pjRiemannGen.computeModel();
            return;
        }
        if (o == this.m_bReset) {
            this.m_bAddBranchCut.setEnabled(true);
            this.m_branchGraph = new PgBranchGraph(this.m_pjRiemannGen.m_baseGeom);
            this.m_awtlBranchCuts.removeAll();
            this.m_pjRiemannGen.reset();
            return;
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        System.out.println("Window Closed");
        int userAction = this.m_dlgAddBranchCut.getUserAction();
        switch (userAction) {
            case 4: {
                PgBranchCut bc = this.m_dlgAddBranchCut.getBranchCut();
                if (bc != null) {
                    int bpStartVertex = bc.getBpStartVertex();
                    int bpStartType = bc.getBPStartShift();
                    int bpStartBasis = bc.getBpStartBasis();
                    int startBPInd = this.m_branchGraph.addNode(bpStartVertex, bpStartType, bpStartBasis);
                    int bpEndVertex = bc.getBpEndVertex();
                    int bpEndType = bc.getBpEndShift();
                    int bpEndBasis = bc.getBpEndBasis();
                    int endBPInd = this.m_branchGraph.addNode(bpEndVertex, bpEndType, bpEndBasis);
                    this.m_branchGraph.addEdge(startBPInd, endBPInd, bc.getVertices(), 0, 0);
                    String entry = String.valueOf(bpStartVertex) + " (" + bpStartType + "/" + bpStartBasis + ") ---> " + bpEndVertex + " (" + bpEndType + "/" + bpEndBasis + ")";
                    this.m_awtlBranchCuts.add(entry);
                    this.m_pjRiemannGen.setBranchGraph(this.m_branchGraph);
                } else {
                    System.out.println("BranchCut not correct.");
                }
                System.out.println("OK Pressed");
                this.m_bComputeModel.setEnabled(true);
                break;
            }
            case 1: {
                System.out.println("Cancel pressed");
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

