/*
 * Decompiled with CFR 0.152.
 */
package devRiemannSurface;

import devCovering.PgCovering;
import devCovering.PnCovering;
import devRiemannSurface.HarmonicLevelFunction;
import devRiemannSurface.branchgraph.PgBranchGraph;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvPickListenerIf;

public class PjRiemannSurfGen
extends PjProject
implements PvPickListenerIf {
    private final int NOV_HOR = 71;
    private final int NOV_VER = 71;
    protected PgElementSet m_baseGeom;
    private PgBranchGraph m_branchGraph;
    private PgPointSet m_branchGraphGeom;

    public PjRiemannSurfGen() {
        super("Template");
        this.reset();
    }

    public void setBranchGraph(PgBranchGraph bc) {
        if (bc != null) {
            if (this.m_branchGraphGeom != null) {
                this.removeGeometry((PgGeometryIf)this.m_branchGraphGeom);
            }
            this.m_branchGraph = bc;
            this.m_branchGraphGeom = bc.makeGraphOnElementSet().getVisualizingGeometry();
            this.addGeometry((PgGeometryIf)this.m_branchGraphGeom);
        }
        this.m_branchGraphGeom.update((Object)this.m_branchGraphGeom);
    }

    public void reset() {
        this.removeGeometries();
        this.m_branchGraph = null;
        this.m_branchGraphGeom = null;
        this.m_baseGeom = new PgElementSet();
        this.m_baseGeom.showVertices(true);
        this.m_baseGeom.showVertexColors(true);
        this.m_baseGeom.computePlane(71, 71, -5.0, -5.0, 5.0, 5.0);
        int nov = this.m_baseGeom.getNumVertices();
        int i = 0;
        while (i < nov) {
            this.m_baseGeom.setVertexColor(i, Color.red);
            ++i;
        }
        PgElementSet.triangulate((PgElementSet)this.m_baseGeom);
        this.addGeometry((PgGeometryIf)this.m_baseGeom);
    }

    public void computeModel() {
        if (this.m_branchGraph == null) {
            System.out.println("No branch graph specified.");
            return;
        }
        PsDebug.notify((String)"Computing model...");
        PsDebug.notify((String)"Validity check of entered branch graph... ");
        List<PgElementSet> cutGeoms = null;
        try {
            this.m_branchGraph.complete();
            PsDebug.notify((String)"OK");
            PsDebug.notify((String)"Adjust topology, cut plane...");
            cutGeoms = PjRiemannSurfGen.createCutSheets(this.m_branchGraph);
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
        PsDebug.notify((String)"OK");
        this.removeGeometry((PgGeometryIf)this.m_baseGeom);
        HarmonicLevelFunction f = new HarmonicLevelFunction();
        int size = cutGeoms.size();
        int i = 0;
        while (i < size) {
            PsDebug.notify((String)("Apply level function to sheet " + i));
            PgElementSet curSheet = cutGeoms.get(i);
            f.applyTo(curSheet, this.m_branchGraph, i);
            int r = 127 * (i % 3);
            int g = 85 * (i % 4);
            int b = 255 - 21 * (i % 13);
            curSheet.showElementColors(false);
            curSheet.setGlobalElementColor(new Color(r, g, b));
            curSheet.makeElementNormals();
            this.addGeometry((PgGeometryIf)curSheet);
            curSheet.update((Object)curSheet);
            System.out.println("Done.");
            ++i;
        }
    }

    public static PgElementSet createCutSheet(PgCovering cov) throws Exception {
        int noeGeom = cov.getGeometry().getNumElements();
        PgElementSet geom = null;
        try {
            geom = PnCovering.calcCoveringGeometry((PgCovering)cov);
        }
        catch (Exception e) {
            throw new Exception("Invalid branch graph, probably vertices on the border");
        }
        int noeCovGeom = geom.getNumElements();
        int i = noeGeom;
        while (i < noeCovGeom) {
            geom.setTagElement(i, 2);
            ++i;
        }
        geom.removeMarkedElements();
        geom.removeUnusedVertices();
        return geom;
    }

    public static PgElementSet createCutSheet(PgBranchGraph branchgraph) throws Exception {
        PgCovering cov = branchgraph.getAssociatedCovering();
        return PjRiemannSurfGen.createCutSheet(cov);
    }

    public static List<PgElementSet> createCutSheets(PgBranchGraph branchgraph) throws Exception {
        PgCovering cov = branchgraph.getAssociatedCovering();
        int n = branchgraph.getNumOfSheets();
        return PjRiemannSurfGen.createCutSheets(cov, n);
    }

    public static List<PgElementSet> createCutSheets(PgCovering cov, int n) throws Exception {
        ArrayList<PgElementSet> l = new ArrayList<PgElementSet>(n);
        PgElementSet cutGeom = PjRiemannSurfGen.createCutSheet(cov);
        cutGeom.setName("Layer 0");
        l.add(cutGeom);
        int i = 1;
        while (i < n) {
            PgElementSet clone = (PgElementSet)cutGeom.clone();
            clone.setName("Layer " + i);
            l.add(clone);
            ++i;
        }
        return l;
    }
}

