/*
 * Decompiled with CFR 0.152.
 */
package devRiemannSurface;

import dev.numeric.PuSparseMatrix;
import devRiemannSurface.LevelFunction;
import devRiemannSurface.branchgraph.PgBranchCut;
import devRiemannSurface.branchgraph.PgBranchGraph;
import devRiemannSurface.branchgraph.PnBranchGraphAnalyzer;
import jv.geom.PgElementSet;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;
import jvx.numeric.PnConjugateGradientMatrix;
import jvx.numeric.PnSparseMatrix;
import jvx.numeric.PnStiffDiriConforming;

public class HarmonicLevelFunction
implements LevelFunction {
    private final double PRECISION = Math.pow(10.0, -8.0);
    public static final double GAP = 2.0;

    @Override
    public void applyTo(PgElementSet cutGeom, PgBranchGraph bg, int layer) {
        int nov = cutGeom.getNumVertices();
        int nol = bg.getNumOfSheets();
        PgVertexStar vs = new PgVertexStar();
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)cutGeom);
        PdVector height = new PdVector(nov);
        boolean[] isBoundaryVertex = new boolean[nov];
        int j = 0;
        while (j < nov) {
            vs.makeVertexStar(cutGeom, j, elementPerVertex.m_data[j]);
            if (!vs.isClosed()) {
                double h = this.computeBoundaryValue(j, cutGeom, layer, nol, bg);
                isBoundaryVertex[j] = true;
                height.m_data[j] = h;
            }
            ++j;
        }
        PnStiffDiriConforming mat = new PnStiffDiriConforming(cutGeom);
        PnSparseMatrix smallMat = new PnSparseMatrix();
        PdVector right = new PdVector(nov);
        PdVector smallRight = new PdVector();
        PdVector out = new PdVector(nov);
        PuSparseMatrix.getReducedSystem((PnSparseMatrix)mat, (PnSparseMatrix)smallMat, (PdVector)height, (PdVector)right, (PdVector)smallRight, (boolean[])isBoundaryVertex, null);
        PnConjugateGradientMatrix solver = new PnConjugateGradientMatrix();
        PdVector smallHeight = new PdVector(smallRight.getSize());
        solver.solve(smallMat, smallHeight, smallRight);
        PuSparseMatrix.enlargeReducedSolutionVector((PdVector)height, (boolean[])isBoundaryVertex, (PdVector)smallHeight, (PdVector)out);
        height.copy(out);
        int k = 0;
        while (k < nov) {
            PdVector v = cutGeom.getVertex(k);
            v.m_data[2] = height.m_data[k];
            ++k;
        }
    }

    public static int heightIncr(int type, int layer, int numOfLayers) {
        int mod = (layer + type) % numOfLayers;
        if (mod < 0) {
            mod += numOfLayers;
        }
        int inc = mod - layer;
        return inc;
    }

    public double computeBoundaryValue(int vertex, PgElementSet geom, int curSheet, int nos, PgBranchGraph bg) {
        PgBranchCut[] branchCuts = bg.getBranchCuts();
        PgBranchCut curBC = null;
        PdVector vertexInCoords = geom.getVertex(vertex);
        int bc = 0;
        while (bc < branchCuts.length) {
            curBC = branchCuts[bc];
            PiVector vertices = curBC.getVertices();
            int length = vertices.getSize();
            int minVertex = PnBranchGraphAnalyzer.computeMinVertexInd(vertex, vertices, geom);
            PdVector minVertexInCoords = geom.getVertex(vertices.getEntry(minVertex));
            if (PdVector.dist((PdVector)vertexInCoords, (PdVector)minVertexInCoords) < this.PRECISION) {
                int bt = curBC.getShift();
                int branchIndex = nos / PuMath.gcd((int)bt, (int)nos);
                int numOfComp = nos / branchIndex;
                int curComp = curSheet % numOfComp;
                double absHeightOfCurBP = (double)(numOfComp * (branchIndex - 1)) * 2.0 / 2.0 + (double)curComp * 2.0;
                int connectivity = PnBranchGraphAnalyzer.computeConnectivity(vertex, vertices, geom);
                int inc = 0;
                if (1 == connectivity) {
                    inc = HarmonicLevelFunction.heightIncr(-bt, curSheet, nos);
                } else if (-1 == connectivity) {
                    inc = HarmonicLevelFunction.heightIncr(bt, curSheet, nos);
                } else {
                    return absHeightOfCurBP;
                }
                double middle = (double)inc * 2.0 / 2.0;
                double relHeight = HarmonicLevelFunction.relHeightOnCutSpline(minVertex, length);
                double height = absHeightOfCurBP * (1.0 - relHeight) + ((double)curSheet * 2.0 + middle) * relHeight;
                return height;
            }
            ++bc;
        }
        return (double)curSheet * 2.0;
    }

    @Deprecated
    public static double relHeightOnCut(int vertex, int length) {
        int nonconstant = length / 3;
        double value = 0.0;
        value = vertex <= nonconstant ? (double)vertex / (double)nonconstant : (length - vertex <= nonconstant ? ((double)length - 1.0 - (double)vertex) / (double)nonconstant : 1.0);
        return Math.pow(value, 0.3333333333333333);
    }

    public static double relHeightOnCutSpline(int vertexInd, int length) {
        int nonconstant = length / 3;
        double rel = 0.0;
        rel = vertexInd <= nonconstant ? (double)vertexInd / (double)nonconstant : (length - vertexInd <= nonconstant ? ((double)length - 1.0 - (double)vertexInd) / (double)nonconstant : 1.0);
        double value = HarmonicLevelFunction.cubicSpline(rel, 0.0, 1.0, 0.0, 1.0, 2.0, 0.0);
        return value;
    }

    public static double cubicSpline(double x, double x0, double x1, double fx0, double fx1, double gradf_x0, double gradf_x1) {
        double Dx = x1 - x0;
        double Dx2 = Dx * Dx;
        double Dx3 = Dx2 * Dx;
        double a = fx0;
        double b = gradf_x0;
        double d = (gradf_x0 + gradf_x1) / Dx2 - 2.0 * (fx1 - fx0) / Dx3;
        double c = (gradf_x1 - gradf_x0) / (2.0 * Dx) - 3.0 * d * Dx / 2.0;
        double s = a + b * (x - x0) + c * (x - x0) * (x - x0) + d * (x - x0) * (x - x0) * (x - x0);
        return s;
    }
}

