/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.util;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuReflect;

public class PuUtil {
    public static int[] uniqueValuesOf(int[] array) {
        HashSet<Integer> set = new HashSet<Integer>(array.length);
        int i = 0;
        while (i < array.length) {
            set.add(new Integer(array[i]));
            ++i;
        }
        int[] uniqueArray = new int[set.size()];
        int i2 = 0;
        for (Integer value : set) {
            uniqueArray[i2++] = value;
        }
        return uniqueArray;
    }

    public static void normalize(double[] values, boolean absoluteValues) {
        double[][] val = new double[][]{values};
        PuUtil.normalize(val, absoluteValues);
    }

    public static void normalize(double[][] values, boolean absoluteValues) {
        double max = PuUtil.maxAbs(values);
        if (max == 0.0) {
            return;
        }
        if (absoluteValues) {
            int i = 0;
            while (i < values.length) {
                int j = 0;
                while (j < values[i].length) {
                    values[i][j] = Math.abs(values[i][j]) / max;
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < values.length) {
                int j = 0;
                while (j < values[i].length) {
                    double[] dArray = values[i];
                    int n = j++;
                    dArray[n] = dArray[n] / max;
                }
                ++i;
            }
        }
    }

    public static double maxAbs(double[][] values) {
        double max = 0.0;
        int i = 0;
        while (i < values.length) {
            int j = 0;
            while (j < values[i].length) {
                double val = Math.abs(values[i][j]);
                max = val > max ? val : max;
                ++j;
            }
            ++i;
        }
        return max;
    }

    public static Color[] colorsFromNormedValues(double[] values, boolean greyscale) {
        Color[] colors = new Color[values.length];
        int i = 0;
        while (i < values.length) {
            float val = (float)values[i];
            colors[i] = greyscale ? new Color(1.0f - val, 1.0f - val, 1.0f - val) : new Color(val, 1.0f - val, 0.0f);
            ++i;
        }
        return colors;
    }

    public static Color[] colorsFromPosValues(double[] values, double upperBound) {
        float max = (float)upperBound;
        Color[] colors = new Color[values.length];
        int i = 0;
        while (i < values.length) {
            if (values[i] < 0.0) {
                throw new IllegalArgumentException("Values must be >= 0");
            }
            float val = (float)values[i];
            if (values[i] <= 1.0) {
                colors[i] = new Color(0.0f, val, 1.0f - val);
            } else {
                val = (val - 1.0f) / (max - 1.0f);
                colors[i] = new Color(val, 1.0f - val, 0.0f);
            }
            ++i;
        }
        return colors;
    }

    public static void adjustOutliers(double[] values, double lowerBound, double upperBound) {
        if (lowerBound < 0.0 || lowerBound > 0.4) {
            throw new IllegalArgumentException();
        }
        if (upperBound < 0.6 || upperBound > 1.0) {
            throw new IllegalArgumentException();
        }
        double[] sorted = Arrays.copyOf(values, values.length);
        Arrays.sort(sorted);
        double lowestValue = sorted[(int)((double)(sorted.length - 1) * lowerBound)];
        double highestValue = sorted[(int)((double)(sorted.length - 1) * upperBound)];
        int i = 0;
        while (i < values.length) {
            if (values[i] < lowestValue) {
                values[i] = lowestValue;
            }
            if (values[i] > highestValue) {
                values[i] = highestValue;
            }
            ++i;
        }
    }

    public static void adjustOutliers(double[][] values, double lowerBound, double upperBound) {
        int j;
        int m = values.length;
        int n = values[0].length;
        double[] vals = new double[m * n];
        int i = 0;
        while (i < m) {
            j = 0;
            while (j < n) {
                vals[i * n + j] = values[i][j];
                ++j;
            }
            ++i;
        }
        PuUtil.adjustOutliers(vals, lowerBound, upperBound);
        i = 0;
        while (i < m) {
            j = 0;
            while (j < n) {
                values[i][j] = vals[i * n + j];
                ++j;
            }
            ++i;
        }
    }

    public static PdMatrix makeBasisChangeMatrix(PdVector[] sourceBasis, PdVector[] targetBasis) {
        if (sourceBasis.length == 0 || sourceBasis.length != targetBasis.length || sourceBasis[0].getSize() != targetBasis[0].getSize()) {
            throw new IllegalArgumentException();
        }
        PdMatrix B = new PdMatrix(sourceBasis.length);
        PdMatrix T = new PdMatrix(3);
        int j = 0;
        while (j < targetBasis.length) {
            T.setColumn(j, targetBasis[j]);
            ++j;
        }
        T.invert();
        int i = 0;
        while (i < sourceBasis.length) {
            B.setColumn(i, T.leftMultMatrix(null, sourceBasis[i]));
            ++i;
        }
        return B;
    }

    public static PdMatrix[] localBasisChangeMatrices(PdVector[] localBasis) {
        PdMatrix T_local_std = new PdMatrix(localBasis.length);
        int i = 0;
        while (i < localBasis.length) {
            T_local_std.setColumn(i, localBasis[i]);
            ++i;
        }
        PdMatrix T_std_local = new PdMatrix(localBasis.length);
        T_std_local.invert(T_local_std);
        PdMatrix[] matrices = new PdMatrix[]{T_std_local, T_local_std};
        return matrices;
    }

    public static PdVector getCenter(PdVector[] points) {
        double numPoints = points.length;
        PdVector center = (PdVector)points[0].clone();
        int i = 1;
        while ((double)i < numPoints) {
            center.add(points[i]);
            ++i;
        }
        center.multScalar(1.0 / numPoints);
        return center;
    }

    public static void translate(PdVector[] points, PdVector direction) {
        double numPoints = points.length;
        int i = 0;
        while ((double)i < numPoints) {
            points[i].add(direction);
            ++i;
        }
    }

    public static PdVector[] perpendiculars(PdVector v1) {
        int dim = v1.getSize();
        PdVector largestSPVector = new PdVector(dim);
        largestSPVector.setEntry(0, 1.0);
        double largestSPValue = v1.dot(largestSPVector);
        int i = 1;
        while (i < dim) {
            PdVector h = new PdVector(dim);
            h.setEntry(i, 1.0);
            double s = v1.dot(h);
            if (s > largestSPValue) {
                largestSPVector = h;
                largestSPValue = s;
            }
            ++i;
        }
        PdVector v2 = PdVector.crossNew((PdVector)v1, (PdVector)largestSPVector);
        PdVector v3 = PdVector.crossNew((PdVector)v1, (PdVector)v2);
        return new PdVector[]{v2, v3};
    }

    public static PdVector[] makeOrthonormalBasisR3(PdVector vector) {
        if (vector.getSize() != 3) {
            throw new IllegalArgumentException();
        }
        PdVector[] basis = new PdVector[3];
        basis[0] = (PdVector)vector.clone();
        basis[0].normalize();
        basis[1] = PdVector.normalToVectorNew((PdVector)basis[0]);
        basis[2] = PdVector.crossNew((PdVector)basis[0], (PdVector)basis[1]);
        return basis;
    }

    public static PdVector[] euclideanBasis(int dim) {
        PdVector[] euclideanBasis = new PdVector[dim];
        int d = 0;
        while (d < dim) {
            euclideanBasis[d] = new PdVector(dim);
            euclideanBasis[d].setEntry(d, 1.0);
            ++d;
        }
        return euclideanBasis;
    }

    public static PdMatrix scaleInDirectionMatrix(PdVector direction, double factor) {
        switch (direction.getSize()) {
            case 2: {
                return PuUtil.scaleInDirectionMatrixR2(direction, factor);
            }
            case 3: {
                return PuUtil.scaleInDirectionMatrixR3(direction, factor);
            }
        }
        throw new IllegalArgumentException();
    }

    protected static PdMatrix scaleInDirectionMatrixR3(PdVector direction, double factor) {
        PdMatrix transform = new PdMatrix(3);
        direction = (PdVector)direction.clone();
        direction.normalize();
        PdVector[] basis = PuUtil.makeOrthonormalBasisR3(direction);
        PdMatrix rotateBack = new PdMatrix(3);
        int i = 0;
        while (i < 3) {
            rotateBack.setColumn(i, basis[i]);
            ++i;
        }
        PdMatrix rotateToX = new PdMatrix(3);
        rotateToX.invert(rotateBack);
        transform.setDiagonal(new PdVector(factor, 1.0, 1.0));
        transform.rightMult(rotateToX);
        transform.leftMult(rotateBack);
        return transform;
    }

    protected static PdMatrix scaleInDirectionMatrixR2(PdVector direction, double factor) {
        PdMatrix transform = new PdMatrix(2);
        direction = (PdVector)direction.clone();
        direction.normalize();
        PdVector[] basis = new PdVector[]{direction, PdVector.normalToVectorNew((PdVector)direction)};
        PdMatrix rotateBack = new PdMatrix(2);
        int i = 0;
        while (i < 2) {
            rotateBack.setColumn(i, basis[i]);
            ++i;
        }
        PdMatrix rotateToX = new PdMatrix(2);
        rotateToX.invert(rotateBack);
        transform.setDiagonal(new PdVector(factor, 1.0));
        transform.rightMult(rotateToX);
        transform.leftMult(rotateBack);
        return transform;
    }

    public static PdMatrix rotateVectorIntoVectorMatrix(PdVector source, PdVector target) {
        PdMatrix rotation = new PdMatrix(3);
        double angle = Math.acos(PdVector.dot((PdVector)source, (PdVector)target) / (source.length() * target.length()));
        PdVector axis = PdVector.crossNew((PdVector)source, (PdVector)target);
        if (axis.length() == 0.0) {
            rotation.setDiagonal(1.0);
        } else {
            PuReflect.makeRotation((PdMatrix)rotation, (PdVector)axis, (double)angle);
        }
        return rotation;
    }

    public static PdVector interpolate(PdVector one, PdVector two, double weightOfOne) {
        if (weightOfOne < 0.0 || weightOfOne > 1.0) {
            throw new IllegalArgumentException();
        }
        if (one.getSize() != two.getSize()) {
            throw new IllegalArgumentException();
        }
        one = (PdVector)one.clone();
        one.multScalar(weightOfOne);
        two = (PdVector)two.clone();
        two.multScalar(1.0 - weightOfOne);
        one.add(two);
        return one;
    }

    public static PdVector meanOf(PdVector[] vectors) {
        if (vectors == null || vectors.length == 0) {
            throw new IllegalArgumentException();
        }
        int numVectors = vectors.length;
        PdVector mean = (PdVector)vectors[0].clone();
        int i = 1;
        while (i < numVectors) {
            mean.add(vectors[i]);
            ++i;
        }
        mean.multScalar(1.0 / (double)numVectors);
        return mean;
    }

    public static PdVector weightedMeanOf(PdVector[] vectors, double[] weights) {
        if (vectors == null || vectors.length == 0) {
            throw new IllegalArgumentException();
        }
        if (weights == null || vectors.length != vectors.length) {
            throw new IllegalArgumentException();
        }
        int numVectors = vectors.length;
        PdVector mean = (PdVector)vectors[0].clone();
        double sumWeights = 0.0;
        int i = 1;
        while (i < numVectors) {
            mean.add(weights[i], vectors[i]);
            sumWeights += weights[i];
            ++i;
        }
        mean.multScalar(1.0 / sumWeights);
        return mean;
    }

    public static PdMatrix makeHomogeneousTransform(PdVector translation, PdMatrix linearTransform) {
        int dim = translation.getSize();
        if (linearTransform.getNumRows() != dim || linearTransform.getNumCols() != dim) {
            throw new IllegalArgumentException();
        }
        PdMatrix transform = (PdMatrix)linearTransform.clone();
        transform.setSize(dim + 1);
        int i = 0;
        while (i < dim) {
            transform.setEntry(i, dim, translation.getEntry(i));
            ++i;
        }
        transform.setEntry(dim, dim, 1.0);
        return transform;
    }
}

