/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.util;

import devProjection.PnProjection;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.util.PuPriorityQueue;

public class PuGeometry {
    public static int[] getNeighbourhood(PgElementSet geometry, Collection vertices, int order) {
        int[] verticesArray = new int[vertices.size()];
        int index = 0;
        Iterator i = vertices.iterator();
        while (i.hasNext()) {
            verticesArray[index++] = (Integer)i.next();
        }
        return PuGeometry.getNeighbourhood(geometry, verticesArray, order);
    }

    public static int[] getNeighbourhood(PgElementSet geometry, int[] vertices, int order) {
        if (order < 0) {
            throw new IllegalArgumentException();
        }
        HashSet<Integer> neighbourhoodSet = new HashSet<Integer>(vertices.length);
        int v = 0;
        while (v < vertices.length) {
            neighbourhoodSet.add(new Integer(vertices[v]));
            ++v;
        }
        geometry.makeNeighbour();
        int i = 0;
        while (i < order) {
            HashSet<Integer> added = new HashSet<Integer>();
            for (Integer current : neighbourhoodSet) {
                PiVector neighbours = PgVertexStar.makeVertexNeighbours((PgElementSet)geometry)[current];
                int n = 0;
                while (n < neighbours.getSize()) {
                    added.add(new Integer(neighbours.getEntry(n)));
                    ++n;
                }
            }
            neighbourhoodSet.addAll(added);
            ++i;
        }
        int[] neighbourhood = new int[neighbourhoodSet.size()];
        int i2 = 0;
        for (Integer value : neighbourhoodSet) {
            neighbourhood[i2++] = value;
        }
        return neighbourhood;
    }

    public static int[] getElementNeighbourhood(PgElementSet geometry, int element, int order) {
        if (order < 0) {
            throw new IllegalArgumentException();
        }
        PiVector[] neighbours = geometry.getNeighbours();
        HashSet neighbourhoodSet = new HashSet();
        HashSet<Integer> added = new HashSet<Integer>();
        HashSet<Integer> add = new HashSet<Integer>();
        added.add(new Integer(element));
        int o = 1;
        while (o < order + 1) {
            Iterator i = added.iterator();
            while (i.hasNext()) {
                PiVector elementNeighbours = neighbours[(Integer)i.next()];
                int n = 0;
                while (n < elementNeighbours.getSize()) {
                    if (elementNeighbours.getEntry(n) != -1) {
                        Integer elementToCheck = new Integer(elementNeighbours.getEntry(n));
                        if (!neighbourhoodSet.contains(elementToCheck)) {
                            // empty if block
                        }
                        add.add(elementToCheck);
                    }
                    ++n;
                }
            }
            added = add;
            neighbourhoodSet.addAll(add);
            add = new HashSet();
            ++o;
        }
        int[] neighbourhood = new int[neighbourhoodSet.size()];
        int i = 0;
        for (Integer value : neighbourhoodSet) {
            neighbourhood[i++] = value;
        }
        return neighbourhood;
    }

    public static PiVector getElementsAround(PgElementSet geometry, int centerElement, double maxDistance, PdVector distances) {
        return PuGeometry.getElementsAround(geometry, centerElement, maxDistance, null, distances);
    }

    public static PiVector getElementsAround(PgElementSet geometry, int centerElement, double maxDistance, PdVector[] centers, PdVector distances) {
        int e;
        PuPriorityQueue distanceQueue = new PuPriorityQueue(geometry.getNumElements(), 1000000.0);
        HashSet<Integer> visited = new HashSet<Integer>(0);
        distanceQueue.decreaseKey(centerElement, 0.0);
        int currentElement = distanceQueue.extractMin();
        while (distanceQueue.getKey(currentElement) < maxDistance) {
            PiVector neighbours = geometry.getNeighbour(currentElement);
            int i = 0;
            while (i < neighbours.getSize()) {
                int element = neighbours.getEntry(i);
                if (element != -1 && !visited.contains(new Integer(element))) {
                    double distanceToCenter = centers == null ? PdVector.subNew((PdVector)geometry.getCenterOfElement(null, element), (PdVector)geometry.getCenterOfElement(null, centerElement)).length() : PdVector.subNew((PdVector)centers[element], (PdVector)centers[centerElement]).length();
                    distanceQueue.decreaseKey(element, distanceToCenter);
                }
                ++i;
            }
            visited.add(new Integer(currentElement));
            currentElement = distanceQueue.extractMin();
        }
        PiVector elements = new PiVector(visited.size());
        if (distances != null) {
            distances.setSize(visited.size());
            e = 0;
            Iterator i = visited.iterator();
            while (i.hasNext()) {
                int current = (Integer)i.next();
                elements.setEntry(e, current);
                distances.setEntry(e++, distanceQueue.getKey(current));
            }
        } else {
            e = 0;
            Iterator i = visited.iterator();
            while (i.hasNext()) {
                int current = (Integer)i.next();
                elements.setEntry(e++, current);
            }
        }
        return elements;
    }

    public static PiVector getElementsAroundPoint(PgElementSet geometry, PdVector point, double maxDistance, PdVector[] centers, PdVector distances) {
        int e;
        PgPointSet pointAsSet = new PgPointSet(3);
        pointAsSet.addVertex(point);
        PdBary[] projected = PnProjection.projectPointSetOntoElementSet((PgPointSet)pointAsSet, (PgElementSet)geometry, (boolean)false);
        int centerElement = projected[0].getElementInd();
        PdVector projectedPoint = point;
        PuPriorityQueue distanceQueue = new PuPriorityQueue(geometry.getNumElements(), 1000000.0);
        HashSet<Integer> visited = new HashSet<Integer>(0);
        double centerDistance = centers == null ? PdVector.subNew((PdVector)geometry.getCenterOfElement(null, centerElement), (PdVector)projectedPoint).length() : PdVector.subNew((PdVector)centers[centerElement], (PdVector)projectedPoint).length();
        distanceQueue.decreaseKey(centerElement, centerDistance);
        int currentElement = distanceQueue.extractMin();
        while (distanceQueue.getKey(currentElement) < maxDistance) {
            PiVector neighbours = geometry.getNeighbour(currentElement);
            int i = 0;
            while (i < neighbours.getSize()) {
                int element = neighbours.getEntry(i);
                if (element != -1 && !visited.contains(new Integer(element))) {
                    double distanceToCenter = centers == null ? PdVector.subNew((PdVector)geometry.getCenterOfElement(null, element), (PdVector)projectedPoint).length() : PdVector.subNew((PdVector)centers[element], (PdVector)point).length();
                    distanceQueue.decreaseKey(element, distanceToCenter);
                }
                ++i;
            }
            visited.add(new Integer(currentElement));
            currentElement = distanceQueue.extractMin();
        }
        PiVector elements = new PiVector(visited.size());
        if (distances != null) {
            distances.setSize(visited.size());
            e = 0;
            Iterator i = visited.iterator();
            while (i.hasNext()) {
                int current = (Integer)i.next();
                elements.setEntry(e, current);
                distances.setEntry(e++, distanceQueue.getKey(current));
            }
        } else {
            e = 0;
            Iterator i = visited.iterator();
            while (i.hasNext()) {
                int current = (Integer)i.next();
                elements.setEntry(e++, current);
            }
        }
        return elements;
    }

    public static PiVector getElementsAroundVertex(PgElementSet geometry, int vertex, double maxDistance, PdVector[] centers, PdVector distances) {
        PdVector point = geometry.getVertex(vertex);
        return PuGeometry.getElementsAroundPoint(geometry, point, maxDistance, centers, distances);
    }

    public static int[] getStencil(PgElementSet geometry, int[] vertices) {
        HashSet<Integer> stencilSet = new HashSet<Integer>();
        int v = 0;
        while (v < vertices.length) {
            PgVertexStar star = new PgVertexStar();
            star.makeVertexStar(geometry, vertices[v], -1);
            PiVector elements = star.getElement();
            int e = 0;
            while (e < elements.getSize()) {
                stencilSet.add(new Integer(elements.getEntry(e)));
                ++e;
            }
            ++v;
        }
        int[] stencil = new int[stencilSet.size()];
        int i = 0;
        for (Integer value : stencilSet) {
            stencil[i++] = value;
        }
        return stencil;
    }

    public static void setMarkedVertices(PgPointSet geometry, PiVector markedVertices) {
        PuGeometry.setMarkedVertices(geometry, markedVertices.m_data);
    }

    public static void setMarkedVertices(PgPointSet geometry, int[] vertices) {
        if (vertices == null) {
            vertices = new int[]{};
        }
        int v = 0;
        while (v < geometry.getNumVertices()) {
            geometry.clearTagVertex(v, 1);
            ++v;
        }
        v = 0;
        while (v < vertices.length) {
            geometry.setTagVertex(vertices[v], 1);
            ++v;
        }
    }

    public static int[] getMarkedElements(PgElementSet geometry) {
        int num = 0;
        int[] markedTemp = new int[geometry.getNumElements()];
        int e = 0;
        while (e < geometry.getNumElements()) {
            if (geometry.getElement(e).hasTag(1)) {
                markedTemp[num++] = e;
            }
            ++e;
        }
        int[] marked = Arrays.copyOf(markedTemp, num);
        return marked;
    }

    public static void setMarkedElements(PgElementSet geometry, int[] elements) {
        if (elements == null) {
            elements = new int[]{};
        }
        int e = 0;
        while (e < geometry.getNumElements()) {
            geometry.clearTagElement(e, 1);
            ++e;
        }
        e = 0;
        while (e < elements.length) {
            geometry.setTagElement(elements[e], 1);
            ++e;
        }
    }

    public static long getVertexHash(PgPointSet geometry) {
        PdVector hashVector = new PdVector(3);
        int numVertices = geometry.getNumVertices();
        if (numVertices < 100) {
            int v = 0;
            while (v < numVertices) {
                hashVector.add(geometry.getVertex(v));
                ++v;
            }
        } else {
            double increment = (double)numVertices / 100.0;
            int v = 0;
            while (v < 100) {
                hashVector.add(geometry.getVertex((int)((double)v * increment)));
                ++v;
            }
        }
        return Double.doubleToLongBits(hashVector.length());
    }

    public static void flashElements(PgElementSet geometry, PiVector elements) {
        Color color = new Color(1.0f, 0.0f, 1.0f);
        PuGeometry.flashElements(geometry, elements, color);
    }

    public static void flashElements(PgElementSet geometry, PiVector elements, Color color) {
        final PgElementSet currentGeometry = geometry;
        final PiVector flashedElements = elements;
        final Color[] originalColors = new Color[flashedElements.getSize()];
        int e = 0;
        while (e < flashedElements.getSize()) {
            originalColors[e] = currentGeometry.getElementColor(e);
            currentGeometry.setElementColor(flashedElements.getEntry(e), color);
            ++e;
        }
        currentGeometry.showElementColors(true);
        currentGeometry.update((Object)currentGeometry);
        Timer timer = new Timer();
        TimerTask todo = new TimerTask(){

            @Override
            public void run() {
                int e = 0;
                while (e < flashedElements.getSize()) {
                    currentGeometry.setElementColor(flashedElements.getEntry(e), originalColors[e]);
                    ++e;
                }
                currentGeometry.showElementColors(false);
                currentGeometry.update((Object)currentGeometry);
            }
        };
        timer.schedule(todo, 700L);
    }

    public static double elementDistance(PgElementSet geom, int e, int ne) {
        PdVector center = geom.getCenterOfElement(null, e);
        PdVector nCenter = geom.getCenterOfElement(null, ne);
        return center.dist(nCenter) / (double)geom.getDimOfVertices();
    }
}

