/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.util;

import devRetarget.retargeting.PuRetargeting;
import jv.geom.PgElementSet;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.geom.PwCurvature;
import jvx.geom.PwShapeOperator;
import jvx.numeric.PnMassMatrix;

public class PuCurvature {
    public static double[][] vertexPrincipalCurvatureValues(PgElementSet geometry) {
        int numVertices = geometry.getNumVertices();
        PdVector[] pcValuesVector = new PdVector[]{new PdVector(numVertices), new PdVector(numVertices)};
        PwCurvature.getPrincipalCurvatures((PgElementSet)geometry, null, (PdVector[])pcValuesVector, null, (boolean)true);
        PnMassMatrix.multInvMassMatrix((PgElementSet)geometry, (PdVector)pcValuesVector[0], (boolean)true);
        PnMassMatrix.multInvMassMatrix((PgElementSet)geometry, (PdVector)pcValuesVector[1], (boolean)true);
        double[][] pcValues = new double[2][numVertices];
        pcValues[0] = pcValuesVector[0].getEntries();
        pcValues[1] = pcValuesVector[1].getEntries();
        return pcValues;
    }

    public static PdVector[][] vertexPrincipalCurvatureDirections(PgElementSet geometry) {
        int numVertices = geometry.getNumVertices();
        PdVector[][] pcDirections = new PdVector[][]{PdVector.realloc(null, (int)numVertices, (int)3), PdVector.realloc(null, (int)numVertices, (int)3)};
        PwCurvature.getPrincipalCurvatures((PgElementSet)geometry, null, null, (PdVector[][])pcDirections, (boolean)true);
        return pcDirections;
    }

    public static double[] vertexMeanCurvatureValues(PgElementSet geometry) {
        int numVertices = geometry.getNumVertices();
        PdVector mcValuesVector = new PdVector(numVertices);
        PwCurvature.getMeanCurvature((PgElementSet)geometry, (PdVector)mcValuesVector);
        PnMassMatrix.multInvMassMatrix((PgElementSet)geometry, (PdVector)mcValuesVector, (boolean)true);
        double[] mcValues = mcValuesVector.getEntries();
        return mcValues;
    }

    public static PdMatrix[] elementShapeOperators(PgElementSet geometry) {
        geometry.makeElementNormals();
        PdMatrix[] vertexShapeOperators = new PdMatrix[geometry.getNumVertices()];
        PwCurvature.getShapeOperator((PgElementSet)geometry, (PdMatrix[])vertexShapeOperators);
        PnMassMatrix.multInvMassMatrix((PgElementSet)geometry, (PdMatrix[])vertexShapeOperators, (boolean)true);
        PdMatrix[] elementShapeOperators = PuRetargeting.vertexToElementOperators(vertexShapeOperators, geometry);
        return elementShapeOperators;
    }

    public static PdVector[][] elementPrincipalCurvatureDirections(PgElementSet geometry) {
        geometry.makeElementNormals();
        PdMatrix[] elementShapeOperators = PuCurvature.elementShapeOperators(geometry);
        PdVector[][] directions = new PdVector[2][geometry.getNumElements()];
        int e = 0;
        while (e < geometry.getNumElements()) {
            PdVector[] vec = PwShapeOperator.calcEigensystem((PdMatrix)elementShapeOperators[e], (PdVector)geometry.getElementNormal(e), null, null);
            directions[0][e] = vec[0];
            directions[1][e] = vec[1];
            ++e;
        }
        return directions;
    }

    public static double[][] elementPrincipalCurvatureValues(PgElementSet geometry) {
        geometry.makeElementNormals();
        PdMatrix[] vertexShapeOperators = new PdMatrix[geometry.getNumVertices()];
        PwCurvature.getShapeOperator((PgElementSet)geometry, (PdMatrix[])vertexShapeOperators);
        PnMassMatrix.multInvMassMatrix((PgElementSet)geometry, (PdMatrix[])vertexShapeOperators, (boolean)true);
        PdMatrix[] elementShapeOperators = PuRetargeting.vertexToElementOperators(vertexShapeOperators, geometry);
        double[][] values = new double[2][geometry.getNumElements()];
        int e = 0;
        while (e < geometry.getNumElements()) {
            PdVector val = new PdVector(2);
            PwShapeOperator.calcEigensystem((PdMatrix)elementShapeOperators[e], (PdVector)geometry.getElementNormal(e), null, (PdVector)val);
            values[0][e] = val.getEntry(0);
            values[1][e] = val.getEntry(1);
            ++e;
        }
        return values;
    }
}

