/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.retargeting;

import devRetarget.retargeting.RetargetingModule_IP;
import devRetarget.retargeting.RmLocalScalar;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;

public class RmLocalScalar_IP
extends RetargetingModule_IP
implements ItemListener {
    private static final long serialVersionUID = 1L;
    protected static final int[] measureMapping = new int[]{1, 2, 3, 4, 5};
    protected static final int[] eColorMapping;
    protected RmLocalScalar parent;
    protected Choice measureChooser;
    protected Choice eColorChooser;
    protected Checkbox showImportant;
    protected PuDouble sizeFactor;
    protected PuDouble measureImpact;
    protected PuDouble distExponent;
    protected PuDouble distLowerBound;
    protected Checkbox lowerToZero;
    protected PuDouble distUpperBound;

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        eColorMapping = nArray;
    }

    protected static int measureToIndex(int measure) {
        int i = 0;
        while (i < measureMapping.length) {
            if (measureMapping[i] == measure) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToMeasure(int index) {
        if (index < measureMapping.length) {
            return measureMapping[index];
        }
        throw new IllegalArgumentException();
    }

    protected static int eColorToIndex(int eColor) {
        int i = 0;
        while (i < eColorMapping.length) {
            if (eColorMapping[i] == eColor) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToEColor(int index) {
        if (index < eColorMapping.length) {
            return eColorMapping[index];
        }
        throw new IllegalArgumentException();
    }

    public RmLocalScalar_IP() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        layoutConstraints.gridwidth = 1;
        layoutConstraints.gridy = 0;
        layoutConstraints.gridx = 0;
        this.add(new Label("Scalar Measure:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.measureChooser = new Choice();
        this.measureChooser.add("Mean Curvatures");
        this.measureChooser.add("Larger Principal Curvatures");
        this.measureChooser.add("Smaller Principal Curvatures");
        this.measureChooser.add("Uniform 0-Measure");
        this.measureChooser.add("Uniform 0.5-Measure");
        this.measureChooser.addItemListener(this);
        this.add(this.measureChooser, layoutConstraints);
        ++layoutConstraints.gridy;
        layoutConstraints.gridx = 0;
        this.add(new Label("Element Color:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.eColorChooser = new Choice();
        this.eColorChooser.add("None");
        this.eColorChooser.add("Measure Values");
        this.eColorChooser.add("Measure Effective");
        this.eColorChooser.add("Measure Impact");
        this.eColorChooser.add("Effective Scaling");
        this.eColorChooser.addItemListener(this);
        this.add(this.eColorChooser, layoutConstraints);
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        ++layoutConstraints.gridy;
        this.showImportant = new Checkbox("Highlight important elements");
        this.showImportant.addItemListener(this);
        this.add(this.showImportant, layoutConstraints);
        ++layoutConstraints.gridy;
        this.sizeFactor = new PuDouble("Size Factor", (PsUpdateIf)this);
        this.add((Component)this.sizeFactor.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.measureImpact = new PuDouble("Measure-Impact", (PsUpdateIf)this);
        this.add((Component)this.measureImpact.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.distExponent = new PuDouble("Dist.-Exponent", (PsUpdateIf)this);
        this.add((Component)this.distExponent.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.distLowerBound = new PuDouble("Lower bound", (PsUpdateIf)this);
        this.add((Component)this.distLowerBound.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.lowerToZero = new Checkbox("Set lower values to Zero");
        this.lowerToZero.addItemListener(this);
        this.add(this.lowerToZero, layoutConstraints);
        ++layoutConstraints.gridy;
        this.distUpperBound = new PuDouble("Upper bound(%)", (PsUpdateIf)this);
        this.add((Component)this.distUpperBound.newInspector("_IP"), layoutConstraints);
        this.validate();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.parent = (RmLocalScalar)parent;
        this.init();
    }

    public void init() {
        super.init();
        this.setName("InfoPanel for Retargeting Method Scalar");
        this.measureChooser.select(RmLocalScalar_IP.measureToIndex(this.parent.getMeasure()));
        this.eColorChooser.select(RmLocalScalar_IP.eColorToIndex(this.parent.getEColor()));
        this.showImportant.setState(this.parent.isShowImportant());
        this.sizeFactor.setDefBounds(0.0, 3.0, 0.1, 0.1);
        this.sizeFactor.setDefValue(this.parent.getSizeFactor());
        this.sizeFactor.init();
        this.measureImpact.setDefBounds(0.0, 1.0, 0.1, 0.1);
        this.measureImpact.setDefValue(this.parent.getMeasureImpact());
        this.measureImpact.init();
        this.distExponent.setDefBounds(0.5, 3.0, 0.1, 0.1);
        this.distExponent.setDefValue(this.parent.getDistExponent());
        this.distExponent.init();
        this.distLowerBound.setDefBounds(0.0, 0.4, 0.01, 0.05);
        this.distLowerBound.setDefValue(this.parent.getDistLowerBound());
        this.distLowerBound.init();
        this.lowerToZero.setState(this.parent.isLowerToZero());
        this.distUpperBound.setDefBounds(0.6, 1.0, 0.01, 0.05);
        this.distUpperBound.setDefValue(this.parent.getDistUpperBound());
        this.distUpperBound.init();
    }

    public boolean update(Object eventSource) {
        if (eventSource == this.parent) {
            this.measureChooser.select(RmLocalScalar_IP.measureToIndex(this.parent.getMeasure()));
            this.eColorChooser.select(RmLocalScalar_IP.eColorToIndex(this.parent.getEColor()));
            this.showImportant.setState(this.parent.isShowImportant());
            this.sizeFactor.setValue(this.parent.getSizeFactor());
            this.measureImpact.setValue(this.parent.getMeasureImpact());
            this.distExponent.setValue(this.parent.getDistExponent());
            this.distLowerBound.setValue(this.parent.getDistLowerBound());
            this.lowerToZero.setState(this.parent.isLowerToZero());
            this.distUpperBound.setValue(this.parent.getDistUpperBound());
        }
        if (eventSource == this.sizeFactor) {
            this.parent.setSizeFactor(this.sizeFactor.getValue());
            return true;
        }
        if (eventSource == this.measureImpact) {
            this.parent.setMeasureImpact(this.measureImpact.getValue());
            return true;
        }
        if (eventSource == this.distExponent) {
            this.parent.setDistExponent(this.distExponent.getValue());
            return true;
        }
        if (eventSource == this.distLowerBound) {
            this.parent.setDistLowerBound(this.distLowerBound.getValue());
            return true;
        }
        if (eventSource == this.distUpperBound) {
            this.parent.setDistUpperBound(this.distUpperBound.getValue());
            return true;
        }
        return super.update(eventSource);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.measureChooser) {
            this.parent.setMeasure(RmLocalScalar_IP.indexToMeasure(this.measureChooser.getSelectedIndex()));
            return;
        }
        if (source == this.eColorChooser) {
            this.parent.setEColor(RmLocalScalar_IP.eColorToIndex(this.eColorChooser.getSelectedIndex()));
            return;
        }
        if (source == this.showImportant) {
            this.parent.setShowImportant(this.showImportant.getState());
            return;
        }
        if (source == this.lowerToZero) {
            this.parent.setLowerToZero(this.lowerToZero.getState());
            return;
        }
    }
}

