/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.retargeting;

import devRetarget.retargeting.PuRetargeting;
import devRetarget.retargeting.RetargetingModule;
import devRetarget.util.PuUtil;
import java.awt.Color;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdVector;

public class RmLocalScalar
extends RetargetingModule {
    private static final long serialVersionUID = 1L;
    public static final int MEASURE_MEAN = 1;
    public static final int MEASURE_LPC = 2;
    public static final int MEASURE_SPC = 3;
    public static final int MEASURE_UNIFORM0 = 4;
    public static final int MEASURE_UNIFORM05 = 5;
    public static final int ECOLOR_NONE = 0;
    public static final int ECOLOR_MEASURE = 1;
    public static final int ECOLOR_EFFECTIVE = 2;
    public static final int ECOLOR_IMPACT = 3;
    public static final int ECOLOR_SCALING = 4;
    protected static final double sizeFactorMax = 3.0;
    protected int measure;
    protected int eColor;
    protected boolean showImportant;
    protected double sizeFactor;
    protected double measureImpact;
    protected double distExponent;
    protected double distLowerBound;
    protected boolean lowerToZero;
    protected double distUpperBound;

    public RmLocalScalar() {
        this.setName("RM Local Scalar");
        this.setType(0);
        if (((Object)((Object)this)).getClass() == RmLocalScalar.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.measure = 1;
        this.eColor = 2;
        this.showImportant = true;
        this.sizeFactor = 1.0;
        this.measureImpact = 1.0;
        this.distExponent = 1.0;
        this.distLowerBound = 0.05;
        this.lowerToZero = true;
        this.distUpperBound = 0.9;
    }

    @Override
    protected void enable() {
        this.update((Object)this);
    }

    @Override
    protected void disable() {
        this.m_outputGeometry.showElementColors(false);
    }

    public boolean update(Object source) {
        if (source == this) {
            if (!this.m_bEnabled) {
                return true;
            }
            switch (this.eColor) {
                case 0: {
                    Color defaultColor = new Color(150, 220, 255);
                    int e = 0;
                    while (e < this.m_numElements) {
                        this.m_outputGeometry.setElementColor(e, defaultColor);
                        ++e;
                    }
                    this.m_outputGeometry.showElementColors(false);
                    break;
                }
                case 1: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromNormedValues(this.currentMeasureValues(), false));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 2: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromNormedValues(this.effectiveMeasureValues(), false));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 3: {
                    double[] effectiveImpacts = this.effectiveImpacts();
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromNormedValues(effectiveImpacts, false));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 4: {
                    double[] effectiveValues = this.effectiveScalings();
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromPosValues(effectiveValues, 3.0));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.showImportant) {
                int[] importantElements = this.m_measureGeometry.importantElements();
                Color importantColor = new Color(1.0f, 1.0f, 0.0f);
                int e = 0;
                while (e < importantElements.length) {
                    this.m_outputGeometry.setElementColor(importantElements[e], importantColor);
                    ++e;
                }
                this.m_outputGeometry.showElementColors(true);
            }
            this.m_outputGeometry.update((Object)this.m_outputGeometry);
            return true;
        }
        return super.update(source);
    }

    @Override
    public void retarget() {
        if (!this.m_bAutoRetarget) {
            PsDebug.pushStatus((String)"Retargeting. Please wait...");
        }
        PgVectorField[] effectiveGradients = this.getEffectiveGradients();
        PdVector[] vertices = this.m_solver.retarget(effectiveGradients);
        this.m_outputGeometry.setVertices(vertices);
        this.m_outputGeometry.update((Object)this.m_outputGeometry);
        if (!this.m_bAutoRetarget) {
            PsDebug.pushStatus((String)"Retargeting finished.");
        }
    }

    @Override
    public PgVectorField[] getEffectiveGradients() {
        return this.effectiveGradients();
    }

    protected PgVectorField[] effectiveGradients() {
        PgVectorField[] effectiveGradients = new PgVectorField[3];
        int i = 0;
        while (i < 3) {
            effectiveGradients[i] = (PgVectorField)this.m_inputGeometry.coordinateGradients()[i].clone();
            ++i;
        }
        double[] scalings = this.effectiveScalings();
        int e = 0;
        while (e < this.m_numElements) {
            effectiveGradients[0].getVector(e).multScalar(scalings[e]);
            effectiveGradients[1].getVector(e).multScalar(scalings[e]);
            effectiveGradients[2].getVector(e).multScalar(scalings[e]);
            ++e;
        }
        return effectiveGradients;
    }

    protected double[] effectiveScalings() {
        double[] effectiveScalings = new double[this.m_numElements];
        double[] effectiveImpacts = this.effectiveImpacts();
        int i = 0;
        while (i < effectiveScalings.length) {
            effectiveScalings[i] = 1.0 + (this.sizeFactor - 1.0) * effectiveImpacts[i];
            ++i;
        }
        return effectiveScalings;
    }

    protected double[] effectiveImpacts() {
        double[] effectiveImpacts = new double[this.m_numElements];
        double[] effectiveMeasureValues = this.effectiveMeasureValues();
        int i = 0;
        while (i < effectiveImpacts.length) {
            effectiveImpacts[i] = 1.0 - this.measureImpact + this.measureImpact * (1.0 - effectiveMeasureValues[i]);
            ++i;
        }
        return effectiveImpacts;
    }

    protected double[] effectiveMeasureValues() {
        double[] effectiveMeasureValues = this.currentMeasureValues();
        double[] userValues = this.m_measureGeometry.userValues();
        if (this.measure != 4 && this.measure != 5) {
            PuUtil.adjustOutliers(effectiveMeasureValues, 0.0, this.distUpperBound);
            PuUtil.normalize(effectiveMeasureValues, false);
            PuRetargeting.cutAtLowerThreshold(effectiveMeasureValues, this.distLowerBound, true, this.lowerToZero);
        }
        int i = 0;
        while (i < effectiveMeasureValues.length) {
            effectiveMeasureValues[i] = userValues[i] < 0.0 ? Math.pow(effectiveMeasureValues[i], this.distExponent) : userValues[i];
            ++i;
        }
        return effectiveMeasureValues;
    }

    protected double[] currentMeasureValues() {
        switch (this.measure) {
            case 1: {
                return this.m_measureGeometry.meanCurvatures();
            }
            case 2: {
                return this.m_measureGeometry.largerPrincipalCurvatureValues();
            }
            case 3: {
                return this.m_measureGeometry.smallerPrincipalCurvatureValues();
            }
            case 4: {
                return this.m_measureGeometry.uniform0Values();
            }
            case 5: {
                return this.m_measureGeometry.uniform05Values();
            }
        }
        throw new IllegalStateException();
    }

    public int getMeasure() {
        return this.measure;
    }

    public void setMeasure(int measure) {
        switch (measure) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.measure = measure;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.update((Object)this);
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getSizeFactor() {
        return this.sizeFactor;
    }

    public void setSizeFactor(double sizeFactor) {
        if (sizeFactor < 0.0 || sizeFactor > 3.0) {
            throw new IllegalArgumentException();
        }
        this.sizeFactor = sizeFactor;
        if (this.eColor == 4) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getMeasureImpact() {
        return this.measureImpact;
    }

    public void setMeasureImpact(double measureImpact) {
        if (measureImpact < 0.0 || measureImpact > 1.0) {
            throw new IllegalArgumentException();
        }
        this.measureImpact = measureImpact;
        if (this.eColor == 3 || this.eColor == 4) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getDistExponent() {
        return this.distExponent;
    }

    public void setDistExponent(double distExponent) {
        if (distExponent < 0.0) {
            throw new IllegalArgumentException();
        }
        this.distExponent = distExponent;
        if (this.eColor == 2 || this.eColor == 3 || this.eColor == 4) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getDistLowerBound() {
        return this.distLowerBound;
    }

    public void setDistLowerBound(double distLowerBound) {
        if (distLowerBound > 0.4) {
            throw new IllegalArgumentException();
        }
        this.distLowerBound = distLowerBound;
        if (this.eColor == 2 || this.eColor == 3 || this.eColor == 4) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getDistUpperBound() {
        return this.distUpperBound;
    }

    public void setDistUpperBound(double distUpperBound) {
        if (distUpperBound < 0.6) {
            throw new IllegalArgumentException();
        }
        this.distUpperBound = distUpperBound;
        if (this.eColor == 2 || this.eColor == 3 || this.eColor == 4) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public int getEColor() {
        return this.eColor;
    }

    public void setEColor(int eColor) {
        switch (eColor) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.eColor = eColor;
                this.update((Object)this);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean isShowImportant() {
        return this.showImportant;
    }

    public void setShowImportant(boolean showImportant) {
        this.showImportant = showImportant;
        this.update((Object)this);
    }

    public boolean isLowerToZero() {
        return this.lowerToZero;
    }

    public void setLowerToZero(boolean lowerToZero) {
        this.lowerToZero = lowerToZero;
        if (this.eColor != 0 && this.eColor != 1) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }
}

