/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.retargeting;

import devRetarget.retargeting.PuRetargeting;
import devRetarget.retargeting.RetargetingModule;
import devRetarget.util.PuUtil;
import java.awt.Color;
import java.util.Arrays;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;

public class RmLocalDirectionsScaling
extends RetargetingModule {
    private static final long serialVersionUID = 1L;
    public static final int MODE_COMPONENTS = 1;
    public static final int MODE_INNERPROD = 2;
    public static final int DIRECTIONS_LPC = 2;
    public static final int DIRECTIONS_SPC = 3;
    public static final int MEASURE_LPC = 3;
    public static final int MEASURE_SPC = 4;
    public static final int MEASURE_MEAN = 2;
    public static final int MEASURE_UNIFORM0 = 5;
    public static final int MEASURE_UNIFORM05 = 6;
    public static final int ECOLOR_NONE = 0;
    public static final int ECOLOR_MEASURE = 1;
    public static final int ECOLOR_EFFECTIVE = 2;
    public static final int ECOLOR_IMPACT_X = 5;
    public static final int ECOLOR_IMPACT_Y = 6;
    public static final int ECOLOR_IMPACT_Z = 7;
    public static final int ECOLOR_SCALING_X = 8;
    public static final int ECOLOR_SCALING_Y = 9;
    public static final int ECOLOR_SCALING_Z = 10;
    protected static final double sizeFactorMax = 5.0;
    protected static final int maxNumDirections = 2;
    protected int m_mode;
    protected boolean m_usePCs;
    protected int m_numDirections;
    protected int m_numDirectionsBackup;
    protected int[] m_directions;
    protected int[] m_measures;
    protected double m_sizeFactor;
    protected double m_measureImpact;
    protected double m_distExponent;
    protected double m_distLowerBound;
    protected boolean m_lowerToZero;
    protected double m_distUpperBound;
    protected int m_eColor;
    protected int m_dirForEColors;
    protected boolean m_showImportant;
    protected boolean[] m_directionsAreShowing;
    protected PgVectorField[] m_displayedFields;

    public RmLocalDirectionsScaling() {
        this.setName("RM Local Directions Scaling");
        this.setType(1);
        if (((Object)((Object)this)).getClass() == RmLocalDirectionsScaling.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_mode = 1;
        this.m_usePCs = true;
        this.m_numDirectionsBackup = this.m_numDirections = 2;
        this.m_directions = new int[]{2, 3};
        this.m_measures = new int[]{3, 4};
        this.m_eColor = 2;
        this.m_dirForEColors = 0;
        this.m_showImportant = true;
        this.m_directionsAreShowing = new boolean[2];
        this.m_displayedFields = new PgVectorField[2];
        this.m_sizeFactor = 1.0;
        this.m_measureImpact = 1.0;
        this.m_distExponent = 1.0;
        this.m_distLowerBound = 0.05;
        this.m_lowerToZero = true;
        this.m_distUpperBound = 0.9;
    }

    @Override
    protected void enable() {
        this.update((Object)this);
    }

    @Override
    protected void disable() {
        this.m_outputGeometry.showElementColors(false);
        int i = 0;
        while (i < this.m_displayedFields.length) {
            this.m_outputGeometry.removeVectorField((PgGeometryIf)this.m_displayedFields[i]);
            ++i;
        }
    }

    public boolean update(Object source) {
        if (source == this) {
            if (!this.m_bEnabled) {
                return true;
            }
            int i = 0;
            while (i < this.m_displayedFields.length) {
                this.m_outputGeometry.removeVectorField((PgGeometryIf)this.m_displayedFields[i]);
                ++i;
            }
            PdVector[][] directions = this.currentDirections();
            int i2 = 0;
            while (i2 < this.m_numDirections) {
                if (this.m_directionsAreShowing[i2]) {
                    this.m_displayedFields[i2] = new PgVectorField(3, 1);
                    this.m_displayedFields[i2].setGeometry((PgPointSet)this.m_outputGeometry);
                    this.m_displayedFields[i2].setVectors(directions[i2]);
                    this.m_displayedFields[i2].setGlobalVectorLength(0.05 * this.m_outputGeometry.getDiameter());
                    this.m_displayedFields[i2].setGlobalVectorSize(2.0);
                    float cValue = this.m_numDirections == 1 ? 1.0f : ((float)this.m_numDirections - 1.0f - (float)i2) / ((float)this.m_numDirections - 1.0f);
                    this.m_displayedFields[i2].setGlobalVectorColor(new Color(1.0f - cValue, cValue, 0.0f));
                    this.m_displayedFields[i2].showIndividualMaterial(true);
                    this.m_outputGeometry.addVectorField(this.m_displayedFields[i2]);
                }
                ++i2;
            }
            this.m_outputGeometry.showVectorFields(true);
            int dir = this.m_dirForEColors >= this.m_numDirections ? 0 : this.m_dirForEColors;
            switch (this.m_eColor) {
                case 0: {
                    Color defaultColor = new Color(150, 220, 255);
                    int e = 0;
                    while (e < this.m_numElements) {
                        this.m_outputGeometry.setElementColor(e, defaultColor);
                        ++e;
                    }
                    this.m_outputGeometry.showElementColors(false);
                    break;
                }
                case 1: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromNormedValues(this.currentMeasureValues()[dir], false));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 2: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromNormedValues(this.effectiveMeasureValues()[dir], false));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 5: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromNormedValues(this.effectiveImpacts()[0], false));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 6: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromNormedValues(this.effectiveImpacts()[1], false));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 7: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromNormedValues(this.effectiveImpacts()[2], false));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 8: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromPosValues(this.effectiveScalings()[0], 3.0));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 9: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromPosValues(this.effectiveScalings()[1], 3.0));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 10: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromPosValues(this.effectiveScalings()[2], 5.0));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.m_showImportant) {
                int[] importantElements = this.m_measureGeometry.importantElements();
                Color importantColor = new Color(1.0f, 1.0f, 0.0f);
                int e = 0;
                while (e < importantElements.length) {
                    this.m_outputGeometry.setElementColor(importantElements[e], importantColor);
                    ++e;
                }
                this.m_outputGeometry.showElementColors(true);
            }
            this.m_outputGeometry.update((Object)this.m_outputGeometry);
            return true;
        }
        if (source == this.m_outputGeometry) {
            return true;
        }
        return super.update(source);
    }

    @Override
    public void retarget() {
        if (!this.m_bAutoRetarget) {
            PsDebug.pushStatus((String)"Retargeting. Please wait...");
        }
        PgVectorField[] effectiveGradients = this.getEffectiveGradients();
        PdVector[] vertices = this.m_solver.retarget(effectiveGradients);
        this.m_outputGeometry.setVertices(vertices);
        this.m_outputGeometry.update((Object)this.m_outputGeometry);
        if (!this.m_bAutoRetarget) {
            PsDebug.pushStatus((String)"Retargeting finished.");
        }
    }

    @Override
    public PgVectorField[] getEffectiveGradients() {
        return this.effectiveGradients();
    }

    protected PgVectorField[] effectiveGradients() {
        PgVectorField[] effectiveGradients = new PgVectorField[3];
        int i = 0;
        while (i < 3) {
            effectiveGradients[i] = (PgVectorField)this.m_inputGeometry.coordinateGradients()[i].clone();
            ++i;
        }
        double[][] scalings = this.effectiveScalings();
        int e = 0;
        while (e < this.m_numElements) {
            effectiveGradients[0].getVector(e).multScalar(scalings[0][e]);
            effectiveGradients[1].getVector(e).multScalar(scalings[1][e]);
            effectiveGradients[2].getVector(e).multScalar(scalings[2][e]);
            ++e;
        }
        return effectiveGradients;
    }

    protected double[][] effectiveScalings() {
        double[][] effectiveImpacts = this.effectiveImpacts();
        double[][] effectiveScalings = new double[3][this.m_numElements];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < this.m_numElements) {
                effectiveScalings[i][j] = 1.0 + (this.m_sizeFactor - 1.0) * effectiveImpacts[i][j];
                ++j;
            }
            ++i;
        }
        return effectiveScalings;
    }

    protected double[][] effectiveImpacts() {
        int e;
        double[][] effectiveMeasureValues = this.effectiveMeasureValues();
        PdVector[][] currentDirections = this.currentDirections();
        double[][] effectiveImpacts = new double[3][this.m_numElements];
        switch (this.m_mode) {
            case 1: {
                int d = 0;
                while (d < 3) {
                    e = 0;
                    while (e < this.m_numElements) {
                        int i = 0;
                        while (i < this.m_numDirections) {
                            double w = Math.abs(currentDirections[i][e].getEntry(d));
                            double[] dArray = effectiveImpacts[d];
                            int n = e;
                            dArray[n] = dArray[n] + w * effectiveMeasureValues[i][e];
                            ++i;
                        }
                        double[] dArray = effectiveImpacts[d];
                        int n = e++;
                        dArray[n] = dArray[n] / (double)this.m_numDirections;
                    }
                    ++d;
                }
                if (this.m_measures[0] == 5 && this.m_measures[1] == 5 || this.m_measures[0] == 6 && this.m_measures[1] == 6) break;
                PuUtil.normalize(effectiveImpacts, false);
                break;
            }
            case 2: {
                PgVectorField[] gradients = this.m_inputGeometry.coordinateGradients();
                int d = 0;
                while (d < 3) {
                    int e2 = 0;
                    while (e2 < this.m_numElements) {
                        int i = 0;
                        while (i < this.m_numDirections) {
                            double w = Math.abs(currentDirections[i][e2].dot(gradients[d].getVector(e2)));
                            double[] dArray = effectiveImpacts[d];
                            int n = e2;
                            dArray[n] = dArray[n] + w * effectiveMeasureValues[i][e2];
                            ++i;
                        }
                        double[] dArray = effectiveImpacts[d];
                        int n = e2++;
                        dArray[n] = dArray[n] / (double)this.m_numDirections;
                    }
                    ++d;
                }
                if (this.m_measures[0] == 5 && this.m_measures[1] == 5 || this.m_measures[0] == 6 && this.m_measures[1] == 6) break;
                PuUtil.normalize(effectiveImpacts, false);
                break;
            }
            default: {
                throw new IllegalThreadStateException();
            }
        }
        int i = 0;
        while (i < 3) {
            e = 0;
            while (e < this.m_numElements) {
                effectiveImpacts[i][e] = 1.0 - this.m_measureImpact + this.m_measureImpact * (1.0 - effectiveImpacts[i][e]);
                ++e;
            }
            ++i;
        }
        return effectiveImpacts;
    }

    protected double[][] effectiveMeasureValues() {
        double[][] values = this.currentMeasureValues();
        double[][] effectiveMeasureValues = new double[this.m_numDirections][];
        if (this.m_usePCs) {
            effectiveMeasureValues[0] = Arrays.copyOf(values[0], this.m_numElements);
            effectiveMeasureValues[1] = Arrays.copyOf(values[1], this.m_numElements);
            PuUtil.adjustOutliers(effectiveMeasureValues, 0.0, this.m_distUpperBound);
            PuUtil.normalize(effectiveMeasureValues, false);
            PuRetargeting.cutAtLowerThreshold(effectiveMeasureValues, this.m_distLowerBound, true, this.m_lowerToZero);
        } else {
            int i = 0;
            while (i < this.m_numDirections) {
                effectiveMeasureValues[i] = Arrays.copyOf(values[i], this.m_numElements);
                if (this.m_measures[i] != 5 && this.m_measures[i] != 6) {
                    PuUtil.adjustOutliers(effectiveMeasureValues[i], 0.0, this.m_distUpperBound);
                    PuUtil.normalize(effectiveMeasureValues[i], false);
                    PuRetargeting.cutAtLowerThreshold(effectiveMeasureValues[i], this.m_distLowerBound, true, this.m_lowerToZero);
                }
                ++i;
            }
        }
        double[] userValues = this.m_measureGeometry.userValues();
        int i = 0;
        while (i < this.m_numDirections) {
            int e = 0;
            while (e < this.m_numElements) {
                effectiveMeasureValues[i][e] = userValues[e] < 0.0 ? Math.pow(effectiveMeasureValues[i][e], this.m_distExponent) : userValues[e];
                ++e;
            }
            ++i;
        }
        return effectiveMeasureValues;
    }

    protected PdVector[][] currentDirections() {
        if (this.m_usePCs) {
            return this.m_inputGeometry.pcDirections();
        }
        PdVector[][] dirs = new PdVector[this.m_numDirections][];
        int i = 0;
        while (i < this.m_numDirections) {
            switch (this.m_directions[i]) {
                case 2: {
                    dirs[i] = this.m_inputGeometry.pcDirections()[0];
                    break;
                }
                case 3: {
                    dirs[i] = this.m_inputGeometry.pcDirections()[1];
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++i;
        }
        return dirs;
    }

    protected double[][] currentMeasureValues() {
        if (this.m_usePCs) {
            return this.m_measureGeometry.pcValues();
        }
        double[][] values = new double[this.m_numDirections][];
        int i = 0;
        while (i < this.m_numDirections) {
            switch (this.m_measures[i]) {
                case 2: {
                    values[i] = this.m_measureGeometry.meanCurvatures();
                    break;
                }
                case 3: {
                    values[i] = this.m_measureGeometry.largerPrincipalCurvatureValues();
                    break;
                }
                case 4: {
                    values[i] = this.m_measureGeometry.smallerPrincipalCurvatureValues();
                    break;
                }
                case 5: {
                    values[i] = this.m_measureGeometry.uniform0Values();
                    break;
                }
                case 6: {
                    values[i] = this.m_measureGeometry.uniform05Values();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++i;
        }
        return values;
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: {
                this.m_mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public int getNumDirections() {
        return this.m_numDirections;
    }

    public void setNumDirections(int numDirections) {
        if (numDirections > 2 || numDirections < 1) {
            throw new IllegalArgumentException();
        }
        if (this.m_usePCs) {
            this.m_numDirectionsBackup = numDirections;
        } else {
            this.m_numDirections = numDirections;
            this.update((Object)this);
        }
    }

    public int getDirections(int number) {
        if (number >= 2) {
            throw new IllegalArgumentException();
        }
        return this.m_directions[number];
    }

    public void setDirections(int number, int directions) {
        if (number >= 2) {
            throw new IllegalArgumentException();
        }
        switch (directions) {
            case 2: 
            case 3: {
                this.m_directions[number] = directions;
                this.update((Object)this);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public int getMeasure(int measureNumber) {
        if (measureNumber >= 2) {
            throw new IllegalArgumentException();
        }
        return this.m_measures[measureNumber];
    }

    public void setMeasure(int measureNumber, int measure) {
        if (measureNumber >= 2) {
            throw new IllegalArgumentException();
        }
        switch (measure) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.m_measures[measureNumber] = measure;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.update((Object)this);
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getSizeFactor() {
        return this.m_sizeFactor;
    }

    public void setSizeFactor(double sizeFactor) {
        if (sizeFactor < 0.0 || sizeFactor > 5.0) {
            throw new IllegalArgumentException();
        }
        this.m_sizeFactor = sizeFactor;
        if (this.m_eColor == 8 || this.m_eColor == 9 || this.m_eColor == 10) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getMeasureImpact() {
        return this.m_measureImpact;
    }

    public void setMeasureImpact(double measureImpact) {
        if (measureImpact < 0.0 || measureImpact > 1.0) {
            throw new IllegalArgumentException();
        }
        this.m_measureImpact = measureImpact;
        if (this.m_eColor != 1 && this.m_eColor != 0 && this.m_eColor != 2) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getDistExponent() {
        return this.m_distExponent;
    }

    public void setDistExponent(double distExponent) {
        if (distExponent < 0.0) {
            throw new IllegalArgumentException();
        }
        this.m_distExponent = distExponent;
        if (this.m_eColor != 1 && this.m_eColor != 0) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getDistLowerBound() {
        return this.m_distLowerBound;
    }

    public void setDistLowerBound(double distLowerBound) {
        if (distLowerBound > 0.4) {
            throw new IllegalArgumentException();
        }
        this.m_distLowerBound = distLowerBound;
        if (this.m_eColor != 1 && this.m_eColor != 0) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getDistUpperBound() {
        return this.m_distUpperBound;
    }

    public void setDistUpperBound(double distUpperBound) {
        if (distUpperBound < 0.6) {
            throw new IllegalArgumentException();
        }
        this.m_distUpperBound = distUpperBound;
        if (this.m_eColor != 1 && this.m_eColor != 0) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public int getEColor() {
        return this.m_eColor;
    }

    public void setEColor(int eColor) {
        switch (eColor) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.m_eColor = eColor;
                this.update((Object)this);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.update((Object)this);
    }

    public int getDirForEColors() {
        return this.m_dirForEColors;
    }

    public void setDirForEColors(int dirForEColors) {
        if (dirForEColors >= 2) {
            throw new IllegalArgumentException();
        }
        this.m_dirForEColors = dirForEColors;
        this.update((Object)this);
    }

    public boolean getDirectionsAreShowing(int number) {
        if (number >= 2) {
            throw new IllegalArgumentException();
        }
        return this.m_directionsAreShowing[number];
    }

    public void setDirectionsAreShowing(int number, boolean directionsAreShowing) {
        if (number >= 2) {
            throw new IllegalArgumentException();
        }
        this.m_directionsAreShowing[number] = directionsAreShowing;
        this.update((Object)this);
    }

    public boolean isUsePCs() {
        return this.m_usePCs;
    }

    public void setUsePCs(boolean usePCs) {
        if (usePCs) {
            this.m_numDirectionsBackup = this.m_numDirections;
            this.m_numDirections = 2;
        } else {
            this.m_numDirections = this.m_numDirectionsBackup;
        }
        this.m_usePCs = usePCs;
        this.update((Object)this);
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public boolean isShowImportant() {
        return this.m_showImportant;
    }

    public void setShowImportant(boolean showImportant) {
        this.m_showImportant = showImportant;
        this.update((Object)this);
    }

    public boolean isLowerToZero() {
        return this.m_lowerToZero;
    }

    public void setLowerToZero(boolean lowerToZero) {
        this.m_lowerToZero = lowerToZero;
        if (this.m_eColor != 0 && this.m_eColor != 1) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }
}

