/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.retargeting;

import devRetarget.retargeting.RetargetingModule_IP;
import devRetarget.retargeting.RmLocalDirectionsIntrinsic;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;

public class RmLocalDirectionsIntrinsic_IP
extends RetargetingModule_IP
implements ItemListener {
    private static final long serialVersionUID = 1L;
    protected static final int[] localBasisMapping = new int[]{1};
    protected static final int[] directionsMapping = new int[]{2, 3};
    protected static final int[] measureMapping = new int[]{3, 4, 2, 5, 6};
    protected static final int[] eColorMapping;
    protected RmLocalDirectionsIntrinsic parent;
    protected Choice localBasisChooser;
    protected Checkbox usePCs;
    protected Checkbox useSecondDirection;
    protected Choice directions0Chooser;
    protected Choice directions1Chooser;
    protected Choice measure0Chooser;
    protected Choice measure1Chooser;
    protected Choice eColorChooser;
    protected Checkbox showDir1Values;
    protected Checkbox showImportant;
    protected Checkbox showDir0;
    protected Checkbox showDir1;
    protected Checkbox sizeAdaptive;
    protected PuDouble sizeFactor;
    protected PuDouble measureImpact;
    protected PuDouble distExponent;
    protected PuDouble distLowerBound;
    protected Checkbox lowerToZero;
    protected PuDouble distUpperBound;

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        eColorMapping = nArray;
    }

    protected static int basisToIndex(int basis) {
        int i = 0;
        while (i < localBasisMapping.length) {
            if (localBasisMapping[i] == basis) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToBasis(int index) {
        if (index < localBasisMapping.length) {
            return localBasisMapping[index];
        }
        throw new IllegalArgumentException();
    }

    protected static int directionsToIndex(int directions) {
        int i = 0;
        while (i < directionsMapping.length) {
            if (directionsMapping[i] == directions) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToDirections(int index) {
        if (index < directionsMapping.length) {
            return directionsMapping[index];
        }
        throw new IllegalArgumentException();
    }

    protected static int measureToIndex(int measure) {
        int i = 0;
        while (i < measureMapping.length) {
            if (measureMapping[i] == measure) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToMeasure(int index) {
        if (index < measureMapping.length) {
            return measureMapping[index];
        }
        throw new IllegalArgumentException();
    }

    protected static int eColorToIndex(int eColor) {
        int i = 0;
        while (i < eColorMapping.length) {
            if (eColorMapping[i] == eColor) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToEColor(int index) {
        if (index < eColorMapping.length) {
            return eColorMapping[index];
        }
        throw new IllegalArgumentException();
    }

    public RmLocalDirectionsIntrinsic_IP() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        ++layoutConstraints.gridy;
        this.usePCs = new Checkbox("Principal Curvatures for Basis, Values & Directions");
        this.usePCs.addItemListener(this);
        this.add(this.usePCs, layoutConstraints);
        layoutConstraints.gridwidth = 1;
        ++layoutConstraints.gridy;
        layoutConstraints.gridx = 0;
        this.add(new Label("Local Basis:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.localBasisChooser = new Choice();
        this.localBasisChooser.add("Principal Curvatures");
        this.localBasisChooser.addItemListener(this);
        this.add(this.localBasisChooser, layoutConstraints);
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        ++layoutConstraints.gridy;
        this.useSecondDirection = new Checkbox("Use second direction");
        this.useSecondDirection.addItemListener(this);
        this.add(this.useSecondDirection, layoutConstraints);
        layoutConstraints.gridwidth = 1;
        ++layoutConstraints.gridy;
        layoutConstraints.gridx = 0;
        this.add(new Label("Local Directions 1:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.directions0Chooser = new Choice();
        this.directions0Chooser.add("Larger Principal Curv.");
        this.directions0Chooser.add("Smaller Principal Curv.");
        this.directions0Chooser.addItemListener(this);
        this.add(this.directions0Chooser, layoutConstraints);
        ++layoutConstraints.gridy;
        layoutConstraints.gridx = 0;
        this.add(new Label("Local Directions 2:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.directions1Chooser = new Choice();
        this.directions1Chooser.add("Larger Principal Curv.");
        this.directions1Chooser.add("Smaller Principal Curv.");
        this.directions1Chooser.addItemListener(this);
        this.add(this.directions1Chooser, layoutConstraints);
        ++layoutConstraints.gridy;
        layoutConstraints.gridx = 0;
        this.add(new Label("Measure Dir1:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.measure0Chooser = new Choice();
        this.measure0Chooser.add("Larger Principal Curv.");
        this.measure0Chooser.add("Smaller Principal Curv.");
        this.measure0Chooser.add("Mean Curvatures");
        this.measure0Chooser.add("Uniform 0-Measure");
        this.measure0Chooser.add("Uniform 0.5-Measure");
        this.measure0Chooser.addItemListener(this);
        this.add(this.measure0Chooser, layoutConstraints);
        ++layoutConstraints.gridy;
        layoutConstraints.gridx = 0;
        this.add(new Label("Measure Dir2:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.measure1Chooser = new Choice();
        this.measure1Chooser.add("Larger Principal Curv.");
        this.measure1Chooser.add("Smaller Principal Curv.");
        this.measure1Chooser.add("Mean Curvatures");
        this.measure1Chooser.add("Uniform 0-Measure");
        this.measure1Chooser.add("Uniform 0.5-Measure");
        this.measure1Chooser.addItemListener(this);
        this.add(this.measure1Chooser, layoutConstraints);
        ++layoutConstraints.gridy;
        layoutConstraints.gridx = 0;
        this.add(new Label("Element Color:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.eColorChooser = new Choice();
        this.eColorChooser.add("None");
        this.eColorChooser.add("Measure Values");
        this.eColorChooser.add("Measure Effective");
        this.eColorChooser.add("Impact");
        this.eColorChooser.add("Scaling");
        this.eColorChooser.addItemListener(this);
        this.add(this.eColorChooser, layoutConstraints);
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        ++layoutConstraints.gridy;
        this.showDir1Values = new Checkbox("Make Element Colors from 2nd directions");
        this.showDir1Values.addItemListener(this);
        this.add(this.showDir1Values, layoutConstraints);
        ++layoutConstraints.gridy;
        this.showImportant = new Checkbox("Highlight important elements");
        this.showImportant.addItemListener(this);
        this.add(this.showImportant, layoutConstraints);
        ++layoutConstraints.gridy;
        this.showDir0 = new Checkbox("Show 1st directions");
        this.showDir0.addItemListener(this);
        this.add(this.showDir0, layoutConstraints);
        ++layoutConstraints.gridy;
        this.showDir1 = new Checkbox("Show 2nd directions");
        this.showDir1.addItemListener(this);
        this.add(this.showDir1, layoutConstraints);
        ++layoutConstraints.gridy;
        this.sizeAdaptive = new Checkbox("Size adaptive");
        this.sizeAdaptive.addItemListener(this);
        this.add(this.sizeAdaptive, layoutConstraints);
        ++layoutConstraints.gridy;
        this.sizeFactor = new PuDouble("Size Factor", (PsUpdateIf)this);
        this.add((Component)this.sizeFactor.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.measureImpact = new PuDouble("Measure-Impact", (PsUpdateIf)this);
        this.add((Component)this.measureImpact.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.distExponent = new PuDouble("Dist.-Exponent", (PsUpdateIf)this);
        this.add((Component)this.distExponent.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.distLowerBound = new PuDouble("Lower bound", (PsUpdateIf)this);
        this.add((Component)this.distLowerBound.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.lowerToZero = new Checkbox("Set lower values to Zero");
        this.lowerToZero.addItemListener(this);
        this.add(this.lowerToZero, layoutConstraints);
        ++layoutConstraints.gridy;
        this.distUpperBound = new PuDouble("Upper bound(%)", (PsUpdateIf)this);
        this.add((Component)this.distUpperBound.newInspector("_IP"), layoutConstraints);
        this.validate();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.parent = (RmLocalDirectionsIntrinsic)parent;
        this.init();
    }

    public void init() {
        super.init();
        this.setName("Local Directions Intrinsic InfoPanel");
        this.localBasisChooser.select(RmLocalDirectionsIntrinsic_IP.basisToIndex(this.parent.getLocalBasis()));
        this.usePCs.setState(this.parent.isUsePCs());
        this.useSecondDirection.setState(this.parent.getNumDirections() == 2);
        this.directions0Chooser.select(RmLocalDirectionsIntrinsic_IP.directionsToIndex(this.parent.getDirections(0)));
        this.directions1Chooser.select(RmLocalDirectionsIntrinsic_IP.directionsToIndex(this.parent.getDirections(1)));
        this.measure0Chooser.select(RmLocalDirectionsIntrinsic_IP.measureToIndex(this.parent.getMeasure(0)));
        this.measure1Chooser.select(RmLocalDirectionsIntrinsic_IP.measureToIndex(this.parent.getMeasure(1)));
        this.eColorChooser.select(RmLocalDirectionsIntrinsic_IP.eColorToIndex(this.parent.getEColor()));
        this.showDir1Values.setState(this.parent.getDirForEColors() == 1);
        this.showImportant.setState(this.parent.isShowImportant());
        this.showDir0.setState(this.parent.getDirectionsAreShowing(0));
        this.showDir1.setState(this.parent.getDirectionsAreShowing(1));
        this.sizeAdaptive.setState(this.parent.isSizeAdaptive());
        this.sizeFactor.setDefBounds(0.0, 5.0, 0.1, 0.1);
        this.sizeFactor.setDefValue(this.parent.getSizeFactor());
        this.sizeFactor.init();
        this.measureImpact.setDefBounds(0.0, 1.0, 0.1, 0.1);
        this.measureImpact.setDefValue(this.parent.getMeasureImpact());
        this.measureImpact.init();
        this.distExponent.setDefBounds(0.5, 3.0, 0.1, 0.1);
        this.distExponent.setDefValue(this.parent.getDistExponent());
        this.distExponent.init();
        this.distLowerBound.setDefBounds(0.0, 0.4, 0.01, 0.05);
        this.distLowerBound.setDefValue(this.parent.getDistLowerBound());
        this.distLowerBound.init();
        this.lowerToZero.setState(this.parent.isLowerToZero());
        this.distUpperBound.setDefBounds(0.6, 1.0, 0.01, 0.05);
        this.distUpperBound.setDefValue(this.parent.getDistUpperBound());
        this.distUpperBound.init();
        this.update(this);
    }

    public boolean update(Object eventSource) {
        if (eventSource == this.parent) {
            this.localBasisChooser.select(RmLocalDirectionsIntrinsic_IP.basisToIndex(this.parent.getLocalBasis()));
            this.usePCs.setState(this.parent.isUsePCs());
            this.useSecondDirection.setState(this.parent.getNumDirections() == 2);
            this.directions0Chooser.select(RmLocalDirectionsIntrinsic_IP.directionsToIndex(this.parent.getDirections(0)));
            this.directions1Chooser.select(RmLocalDirectionsIntrinsic_IP.directionsToIndex(this.parent.getDirections(1)));
            this.measure0Chooser.select(RmLocalDirectionsIntrinsic_IP.measureToIndex(this.parent.getMeasure(0)));
            this.measure1Chooser.select(RmLocalDirectionsIntrinsic_IP.measureToIndex(this.parent.getMeasure(1)));
            this.eColorChooser.select(RmLocalDirectionsIntrinsic_IP.eColorToIndex(this.parent.getEColor()));
            this.showDir1Values.setState(this.parent.getDirForEColors() == 1);
            this.showImportant.setState(this.parent.isShowImportant());
            this.showDir0.setState(this.parent.getDirectionsAreShowing(0));
            this.showDir1.setState(this.parent.getDirectionsAreShowing(1));
            this.sizeAdaptive.setState(this.parent.isSizeAdaptive());
            this.sizeFactor.setValue(this.parent.getSizeFactor());
            this.measureImpact.setValue(this.parent.getMeasureImpact());
            this.distExponent.setValue(this.parent.getDistExponent());
            this.distLowerBound.setValue(this.parent.getDistLowerBound());
            this.lowerToZero.setState(this.parent.isLowerToZero());
            this.distUpperBound.setValue(this.parent.getDistUpperBound());
        }
        if (eventSource == this) {
            if (this.usePCs.getState()) {
                this.localBasisChooser.setEnabled(false);
                this.useSecondDirection.setEnabled(false);
                this.directions0Chooser.setEnabled(false);
                this.directions1Chooser.setEnabled(false);
                this.measure0Chooser.setEnabled(false);
                this.measure1Chooser.setEnabled(false);
                this.showDir1Values.setEnabled(true);
                this.showDir1.setEnabled(true);
            } else {
                boolean dir2state = this.useSecondDirection.getState();
                this.localBasisChooser.setEnabled(true);
                this.useSecondDirection.setEnabled(true);
                this.directions0Chooser.setEnabled(true);
                this.directions1Chooser.setEnabled(dir2state);
                this.measure0Chooser.setEnabled(true);
                this.measure1Chooser.setEnabled(dir2state);
                this.showDir1Values.setEnabled(dir2state);
                this.showDir1.setEnabled(dir2state);
            }
            return true;
        }
        if (eventSource == this.sizeFactor) {
            this.parent.setSizeFactor(this.sizeFactor.getValue());
            return true;
        }
        if (eventSource == this.measureImpact) {
            this.parent.setMeasureImpact(this.measureImpact.getValue());
            return true;
        }
        if (eventSource == this.distExponent) {
            this.parent.setDistExponent(this.distExponent.getValue());
            return true;
        }
        if (eventSource == this.distLowerBound) {
            this.parent.setDistLowerBound(this.distLowerBound.getValue());
            return true;
        }
        if (eventSource == this.distUpperBound) {
            this.parent.setDistUpperBound(this.distUpperBound.getValue());
            return true;
        }
        return super.update(eventSource);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.localBasisChooser) {
            this.parent.setLocalBasis(RmLocalDirectionsIntrinsic_IP.indexToBasis(this.localBasisChooser.getSelectedIndex()));
        }
        if (source == this.usePCs) {
            this.parent.setUsePCs(this.usePCs.getState());
            this.update(this);
            return;
        }
        if (source == this.useSecondDirection) {
            this.parent.setNumDirections(this.useSecondDirection.getState() ? 2 : 1);
            this.update(this);
            return;
        }
        if (source == this.directions0Chooser) {
            this.parent.setDirections(0, RmLocalDirectionsIntrinsic_IP.indexToDirections(this.directions0Chooser.getSelectedIndex()));
            return;
        }
        if (source == this.directions1Chooser) {
            this.parent.setDirections(1, RmLocalDirectionsIntrinsic_IP.indexToDirections(this.directions1Chooser.getSelectedIndex()));
            return;
        }
        if (source == this.measure0Chooser) {
            this.parent.setMeasure(0, RmLocalDirectionsIntrinsic_IP.indexToMeasure(this.measure0Chooser.getSelectedIndex()));
            return;
        }
        if (source == this.measure1Chooser) {
            this.parent.setMeasure(1, RmLocalDirectionsIntrinsic_IP.indexToMeasure(this.measure1Chooser.getSelectedIndex()));
            return;
        }
        if (source == this.eColorChooser) {
            this.parent.setEColor(RmLocalDirectionsIntrinsic_IP.indexToEColor(this.eColorChooser.getSelectedIndex()));
            return;
        }
        if (source == this.showDir1Values) {
            this.parent.setDirForEColors(this.showDir1Values.getState() ? 1 : 0);
            return;
        }
        if (source == this.showImportant) {
            this.parent.setShowImportant(this.showImportant.getState());
            return;
        }
        if (source == this.showDir0) {
            this.parent.setDirectionsAreShowing(0, this.showDir0.getState());
            return;
        }
        if (source == this.showDir1) {
            this.parent.setDirectionsAreShowing(1, this.showDir1.getState());
            return;
        }
        if (source == this.sizeAdaptive) {
            this.parent.setSizeAdaptive(this.sizeAdaptive.getState());
            return;
        }
        if (source == this.lowerToZero) {
            this.parent.setLowerToZero(this.lowerToZero.getState());
            return;
        }
    }
}

