/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.retargeting;

import devRetarget.retargeting.PuRetargeting;
import devRetarget.retargeting.RetargetingModule;
import devRetarget.util.PuUtil;
import java.awt.Color;
import java.util.Arrays;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdVector;

public class RmGlobalDirectionsScaling
extends RetargetingModule {
    private static final long serialVersionUID = 1L;
    public static final int MEASURE_SHAPE_OPERATOR = 1;
    public static final int MEASURE_MEAN = 2;
    public static final int MEASURE_UNIFORM0 = 5;
    public static final int MEASURE_UNIFORM05 = 6;
    public static final int ECOLOR_NONE = 0;
    public static final int ECOLOR_MEASURE = 1;
    public static final int ECOLOR_EFFECTIVE = 4;
    public static final int ECOLOR_IMPACT = 7;
    public static final int ECOLOR_SCALING = 10;
    protected static final double sizeFactorMax = 3.0;
    protected int measure;
    protected boolean respectOrientation;
    protected boolean iterative;
    protected boolean sizeAdaptive;
    protected double[] sizeFactors;
    protected double measureImpact;
    protected double distExponent;
    protected double distLowerBound;
    protected boolean lowerToZero;
    protected double distUpperBound;
    protected int eColor;
    protected int directionForEColor;
    protected boolean showImportant;

    public RmGlobalDirectionsScaling() {
        this.setName("RM Global Directions Scaling");
        this.setType(3);
        if (((Object)((Object)this)).getClass() == RmGlobalDirectionsScaling.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.measure = 1;
        this.eColor = 4;
        this.showImportant = true;
        this.directionForEColor = 0;
        this.respectOrientation = true;
        this.iterative = true;
        this.sizeAdaptive = true;
        this.sizeFactors = new double[]{1.0, 1.0, 1.0};
        this.measureImpact = 1.0;
        this.distExponent = 1.0;
        this.distLowerBound = 0.05;
        this.lowerToZero = true;
        this.distUpperBound = 0.9;
    }

    @Override
    protected void enable() {
        this.update((Object)this);
    }

    @Override
    protected void disable() {
        this.m_outputGeometry.showElementColors(false);
    }

    public boolean update(Object source) {
        if (source == this) {
            if (!this.m_bEnabled) {
                return true;
            }
            switch (this.eColor) {
                case 0: {
                    Color defaultColor = new Color(150, 220, 255);
                    int e = 0;
                    while (e < this.m_numElements) {
                        this.m_outputGeometry.setElementColor(e, defaultColor);
                        ++e;
                    }
                    this.m_outputGeometry.showElementColors(false);
                    break;
                }
                case 1: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromNormedValues(this.currentMeasureValues()[this.directionForEColor], false));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 4: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromNormedValues(this.effectiveMeasureValues()[this.directionForEColor], false));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 7: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromNormedValues(this.effectiveImpacts()[this.directionForEColor], false));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 10: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromPosValues(this.effectiveScalings()[this.directionForEColor], 3.0));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.showImportant) {
                int[] importantElements = this.m_measureGeometry.importantElements();
                Color importantColor = new Color(1.0f, 1.0f, 0.0f);
                int e = 0;
                while (e < importantElements.length) {
                    this.m_outputGeometry.setElementColor(importantElements[e], importantColor);
                    ++e;
                }
                this.m_outputGeometry.showElementColors(true);
            }
            this.m_outputGeometry.update((Object)this.m_outputGeometry);
            return true;
        }
        if (source == this.m_outputGeometry) {
            return true;
        }
        return super.update(source);
    }

    @Override
    public void retarget() {
        if (!this.m_bAutoRetarget) {
            PsDebug.pushStatus((String)"Retargeting. Please wait...");
        }
        PgVectorField[] effectiveGradients = this.getEffectiveGradients();
        PdVector[] vertices = this.m_solver.retarget(effectiveGradients);
        this.m_outputGeometry.setVertices(vertices);
        if (!this.m_bAutoRetarget) {
            PsDebug.pushStatus((String)"Retargeting finished.");
        }
        if (this.iterative) {
            if (!this.m_bAutoRetarget) {
                PsDebug.pushStatus((String)"Iterative Retargeting started. Please wait...");
            }
            double[] sizeFactorsBackup = Arrays.copyOf(this.sizeFactors, 3);
            int i = 0;
            while (i < 10) {
                PdVector[] currentBounds = this.m_outputGeometry.getAmbientBounds();
                double[] currentDimensions = PdVector.subNew((PdVector)currentBounds[1], (PdVector)currentBounds[0]).m_data;
                double[] inputDimensions = this.m_inputGeometry.dimensions().m_data;
                double[] factors = new double[3];
                boolean finished = true;
                int d = 0;
                while (d < 3) {
                    factors[d] = Math.abs(currentDimensions[d] / inputDimensions[d]);
                    if (Math.abs(sizeFactorsBackup[d] / factors[d] - 1.0) > 0.05) {
                        finished = false;
                    }
                    ++d;
                }
                if (!finished) {
                    d = 0;
                    while (d < 3) {
                        int n = d;
                        this.sizeFactors[n] = this.sizeFactors[n] * (sizeFactorsBackup[d] / factors[d]);
                        ++d;
                    }
                } else {
                    this.sizeFactors = sizeFactorsBackup;
                    this.m_outputGeometry.update((Object)this.m_outputGeometry);
                    if (!this.m_bAutoRetarget) {
                        PsDebug.pushStatus((String)("Iterative Retargeting finished after " + (i + 1) + " iteratrions."));
                    }
                    return;
                }
                effectiveGradients = this.getEffectiveGradients();
                vertices = this.m_solver.retarget(effectiveGradients);
                this.m_outputGeometry.setVertices(vertices);
                ++i;
            }
            this.sizeFactors = sizeFactorsBackup;
            if (!this.m_bAutoRetarget) {
                PsDebug.warning((String)"Iterative Retargeting was aborted after 10 iterations. Try to decrease the measure impact.");
            }
        }
        this.m_outputGeometry.update((Object)this.m_outputGeometry);
    }

    @Override
    public PgVectorField[] getEffectiveGradients() {
        return this.effectiveGradients();
    }

    protected PgVectorField[] effectiveGradients() {
        PgVectorField[] effectiveGradients = new PgVectorField[3];
        int i = 0;
        while (i < 3) {
            effectiveGradients[i] = (PgVectorField)this.m_inputGeometry.coordinateGradients()[i].clone();
            ++i;
        }
        double[][] scalings = this.effectiveScalings();
        int e = 0;
        while (e < this.m_numElements) {
            effectiveGradients[0].getVector(e).multScalar(scalings[0][e]);
            effectiveGradients[1].getVector(e).multScalar(scalings[1][e]);
            effectiveGradients[2].getVector(e).multScalar(scalings[2][e]);
            ++e;
        }
        return effectiveGradients;
    }

    protected double[][] effectiveScalings() {
        double[][] effectiveImpacts = this.effectiveImpacts();
        double[][] effectiveScalings = new double[3][this.m_numElements];
        int i = 0;
        while (i < 3) {
            double adaptivePower;
            if (this.sizeAdaptive) {
                if (this.sizeFactors[i] < 0.33 || this.sizeFactors[i] > 3.0) {
                    adaptivePower = 1.0;
                } else {
                    adaptivePower = this.sizeFactors[i] < 1.0 ? (1.0 - this.sizeFactors[i]) / 0.77 : (this.sizeFactors[i] - 1.0) / 2.0;
                    adaptivePower = Math.pow(adaptivePower, 2.0);
                }
                adaptivePower = 1.0 - adaptivePower / 2.0;
            } else {
                adaptivePower = 1.0;
            }
            int j = 0;
            while (j < this.m_numElements) {
                effectiveScalings[i][j] = 1.0 + (this.sizeFactors[i] - 1.0) * Math.pow(effectiveImpacts[i][j], adaptivePower);
                ++j;
            }
            ++i;
        }
        return effectiveScalings;
    }

    protected double[][] effectiveImpacts() {
        double[][] effectiveMeasureValues = this.effectiveMeasureValues();
        double[][] effectiveImpacts = new double[3][this.m_numElements];
        int i = 0;
        while (i < 3) {
            int e = 0;
            while (e < this.m_numElements) {
                effectiveImpacts[i][e] = 1.0 - this.measureImpact + this.measureImpact * (1.0 - effectiveMeasureValues[i][e]);
                ++e;
            }
            ++i;
        }
        return effectiveImpacts;
    }

    protected double[][] effectiveMeasureValues() {
        double[][] values = this.currentMeasureValues();
        double[][] effectiveMeasureValues = new double[3][];
        double[][] projectedLength = this.m_measureGeometry.stdBasisProjectionLengths();
        double[] userValues = this.m_measureGeometry.userValues();
        int i = 0;
        while (i < 3) {
            effectiveMeasureValues[i] = Arrays.copyOf(values[i], this.m_numElements);
            if (this.measure != 5 && this.measure != 6) {
                PuUtil.adjustOutliers(effectiveMeasureValues[i], 0.0, this.distUpperBound);
                PuUtil.normalize(effectiveMeasureValues[i], false);
                PuRetargeting.cutAtLowerThreshold(effectiveMeasureValues[i], this.distLowerBound, true, this.lowerToZero);
            }
            int e = 0;
            while (e < this.m_numElements) {
                if (userValues[e] < 0.0) {
                    effectiveMeasureValues[i][e] = Math.pow(effectiveMeasureValues[i][e], this.distExponent);
                    if (this.respectOrientation) {
                        double projectionImpact = Math.pow(projectedLength[i][e], 1.0);
                        effectiveMeasureValues[i][e] = 1.0 - projectionImpact + projectionImpact * effectiveMeasureValues[i][e];
                    }
                } else {
                    effectiveMeasureValues[i][e] = userValues[e];
                }
                ++e;
            }
            ++i;
        }
        return effectiveMeasureValues;
    }

    protected double[][] currentMeasureValues() {
        double[][] values = new double[3][];
        int i = 0;
        while (i < 3) {
            switch (this.measure) {
                case 2: {
                    values[i] = this.m_measureGeometry.meanCurvatures();
                    break;
                }
                case 5: {
                    values[i] = this.m_measureGeometry.uniform0Values();
                    break;
                }
                case 6: {
                    values[i] = this.m_measureGeometry.uniform05Values();
                    break;
                }
                case 1: {
                    values[i] = this.m_measureGeometry.stdDirsShapeOpValues()[i];
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++i;
        }
        return values;
    }

    public int getMeasure() {
        return this.measure;
    }

    public void setMeasure(int measure) {
        switch (measure) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.measure = measure;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.update((Object)this);
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getSizeFactor(int number) {
        if (number > 2 || number < 0) {
            throw new IllegalArgumentException();
        }
        return this.sizeFactors[number];
    }

    public void setSizeFactor(int number, double sizeFactor) {
        if (number > 2 || number < 0 || sizeFactor < 0.0 || sizeFactor > 3.0) {
            throw new IllegalArgumentException();
        }
        this.sizeFactors[number] = sizeFactor;
        if (this.eColor == 10) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getMeasureImpact() {
        return this.measureImpact;
    }

    public void setMeasureImpact(double measureImpact) {
        if (measureImpact < 0.0 || measureImpact > 1.0) {
            throw new IllegalArgumentException();
        }
        this.measureImpact = measureImpact;
        if (this.eColor != 1 && this.eColor != 0 && this.eColor != 4) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getDistExponent() {
        return this.distExponent;
    }

    public void setDistExponent(double distExponent) {
        if (distExponent < 0.0) {
            throw new IllegalArgumentException();
        }
        this.distExponent = distExponent;
        if (this.eColor != 1 && this.eColor != 0) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getDistLowerBound() {
        return this.distLowerBound;
    }

    public void setDistLowerBound(double distLowerBound) {
        if (distLowerBound > 0.4) {
            throw new IllegalArgumentException();
        }
        this.distLowerBound = distLowerBound;
        if (this.eColor != 1 && this.eColor != 0) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public double getDistUpperBound() {
        return this.distUpperBound;
    }

    public void setDistUpperBound(double distUpperBound) {
        if (distUpperBound < 0.6) {
            throw new IllegalArgumentException();
        }
        this.distUpperBound = distUpperBound;
        if (this.eColor != 1 && this.eColor != 0) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public int getEColor() {
        return this.eColor;
    }

    public void setEColor(int eColor) {
        switch (eColor) {
            case 0: 
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                this.eColor = eColor;
                this.update((Object)this);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.update((Object)this);
    }

    public boolean isRespectOrientation() {
        return this.respectOrientation;
    }

    public void setRespectOrientation(boolean respectOrientation) {
        this.respectOrientation = respectOrientation;
        this.update((Object)this);
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public int getDirectionForEColor() {
        return this.directionForEColor;
    }

    public void setDirectionForEColor(int directionForEColor) {
        if (directionForEColor < 0 || directionForEColor > 2) {
            throw new IllegalArgumentException();
        }
        this.directionForEColor = directionForEColor;
        this.update((Object)this);
    }

    public boolean isIterative() {
        return this.iterative;
    }

    public void setIterative(boolean iterative) {
        this.iterative = iterative;
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public boolean isSizeAdaptive() {
        return this.sizeAdaptive;
    }

    public void setSizeAdaptive(boolean sizeAdaptive) {
        this.sizeAdaptive = sizeAdaptive;
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public boolean isShowImportant() {
        return this.showImportant;
    }

    public void setShowImportant(boolean showImportant) {
        this.showImportant = showImportant;
        this.update((Object)this);
    }

    public boolean isLowerToZero() {
        return this.lowerToZero;
    }

    public void setLowerToZero(boolean lowerToZero) {
        this.lowerToZero = lowerToZero;
        if (this.eColor != 0 && this.eColor != 1) {
            this.update((Object)this);
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }
}

