/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.retargeting;

import devRetarget.retargeting.RetargetingModule_IP;
import devRetarget.retargeting.RmGlobalDirectionsIntrinsic;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;

public class RmGlobalDirectionsIntrinsic_IP
extends RetargetingModule_IP
implements ItemListener {
    private static final long serialVersionUID = 1L;
    protected static final int[] measureMapping = new int[]{1, 2, 5, 6};
    protected static final int[] eColorMapping;
    protected RmGlobalDirectionsIntrinsic parent;
    protected Choice measureChooser;
    protected Checkbox respectOrientation;
    protected Choice eColorChooser;
    protected Choice directionForEColorChooser;
    protected Checkbox showImportant;
    protected Checkbox iterative;
    protected Checkbox sizeAdaptive;
    protected PuDouble sizeFactorX;
    protected PuDouble sizeFactorY;
    protected PuDouble sizeFactorZ;
    protected PuDouble measureImpact;
    protected PuDouble distExponent;
    protected PuDouble distLowerBound;
    protected Checkbox lowerToZero;
    protected PuDouble distUpperBound;

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 7;
        nArray[4] = 10;
        eColorMapping = nArray;
    }

    protected static int measureToIndex(int measure) {
        int i = 0;
        while (i < measureMapping.length) {
            if (measureMapping[i] == measure) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToMeasure(int index) {
        if (index < measureMapping.length) {
            return measureMapping[index];
        }
        throw new IllegalArgumentException();
    }

    protected static int eColorToIndex(int eColor) {
        int i = 0;
        while (i < eColorMapping.length) {
            if (eColorMapping[i] == eColor) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToEColor(int index) {
        if (index < eColorMapping.length) {
            return eColorMapping[index];
        }
        throw new IllegalArgumentException();
    }

    public RmGlobalDirectionsIntrinsic_IP() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        layoutConstraints.gridwidth = 1;
        layoutConstraints.gridy = 0;
        layoutConstraints.gridx = 0;
        this.add(new Label("Measure:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.measureChooser = new Choice();
        this.measureChooser.add("Shape Operator Values");
        this.measureChooser.add("Mean Curvatures");
        this.measureChooser.add("Uniform 0-Measure");
        this.measureChooser.add("Uniform 0.5-Measure");
        this.measureChooser.addItemListener(this);
        this.add(this.measureChooser, layoutConstraints);
        ++layoutConstraints.gridy;
        layoutConstraints.gridx = 0;
        this.add(new Label("Element Color:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.eColorChooser = new Choice();
        this.eColorChooser.add("None");
        this.eColorChooser.add("Measure Values");
        this.eColorChooser.add("Measure Effective");
        this.eColorChooser.add("Impact");
        this.eColorChooser.add("Scaling");
        this.eColorChooser.addItemListener(this);
        this.add(this.eColorChooser, layoutConstraints);
        ++layoutConstraints.gridy;
        layoutConstraints.gridx = 0;
        this.add(new Label("Color Dir:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.directionForEColorChooser = new Choice();
        this.directionForEColorChooser.add("X");
        this.directionForEColorChooser.add("Y");
        this.directionForEColorChooser.add("Z");
        this.directionForEColorChooser.addItemListener(this);
        this.add(this.directionForEColorChooser, layoutConstraints);
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        ++layoutConstraints.gridy;
        this.showImportant = new Checkbox("Highlight important elements");
        this.showImportant.addItemListener(this);
        this.add(this.showImportant, layoutConstraints);
        ++layoutConstraints.gridy;
        this.respectOrientation = new Checkbox("Respect Orientation");
        this.respectOrientation.addItemListener(this);
        this.add(this.respectOrientation, layoutConstraints);
        ++layoutConstraints.gridy;
        this.iterative = new Checkbox("Iterative");
        this.iterative.addItemListener(this);
        this.add(this.iterative, layoutConstraints);
        ++layoutConstraints.gridy;
        this.sizeAdaptive = new Checkbox("Size adaptive");
        this.sizeAdaptive.addItemListener(this);
        this.add(this.sizeAdaptive, layoutConstraints);
        ++layoutConstraints.gridy;
        this.sizeFactorX = new PuDouble("Size Factor X", (PsUpdateIf)this);
        this.add((Component)this.sizeFactorX.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.sizeFactorY = new PuDouble("Size Factor Y", (PsUpdateIf)this);
        this.add((Component)this.sizeFactorY.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.sizeFactorZ = new PuDouble("Size Factor Z", (PsUpdateIf)this);
        this.add((Component)this.sizeFactorZ.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.measureImpact = new PuDouble("Measure-Impact", (PsUpdateIf)this);
        this.add((Component)this.measureImpact.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.distExponent = new PuDouble("Dist.-Exponent", (PsUpdateIf)this);
        this.add((Component)this.distExponent.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.distLowerBound = new PuDouble("Lower bound", (PsUpdateIf)this);
        this.add((Component)this.distLowerBound.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.lowerToZero = new Checkbox("Set lower values to Zero");
        this.lowerToZero.addItemListener(this);
        this.add(this.lowerToZero, layoutConstraints);
        ++layoutConstraints.gridy;
        this.distUpperBound = new PuDouble("Upper bound(%)", (PsUpdateIf)this);
        this.add((Component)this.distUpperBound.newInspector("_IP"), layoutConstraints);
        this.validate();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.parent = (RmGlobalDirectionsIntrinsic)parent;
        this.init();
    }

    public void init() {
        super.init();
        this.setName("Local Directions Scaling InfoPanel");
        this.measureChooser.select(RmGlobalDirectionsIntrinsic_IP.measureToIndex(this.parent.getMeasure()));
        this.eColorChooser.select(RmGlobalDirectionsIntrinsic_IP.eColorToIndex(this.parent.getEColor()));
        this.directionForEColorChooser.select(this.parent.getDirectionForEColor());
        this.showImportant.setState(this.parent.isShowImportant());
        this.respectOrientation.setState(this.parent.isRespectOrientation());
        this.iterative.setState(this.parent.isIterative());
        this.sizeAdaptive.setState(this.parent.isSizeAdaptive());
        this.sizeFactorX.setDefBounds(0.0, 3.0, 0.1, 0.1);
        this.sizeFactorX.setDefValue(this.parent.getSizeFactor(0));
        this.sizeFactorX.init();
        this.sizeFactorY.setDefBounds(0.0, 3.0, 0.1, 0.1);
        this.sizeFactorY.setDefValue(this.parent.getSizeFactor(1));
        this.sizeFactorY.init();
        this.sizeFactorZ.setDefBounds(0.0, 3.0, 0.1, 0.1);
        this.sizeFactorZ.setDefValue(this.parent.getSizeFactor(2));
        this.sizeFactorZ.init();
        this.measureImpact.setDefBounds(0.0, 1.0, 0.1, 0.1);
        this.measureImpact.setDefValue(this.parent.getMeasureImpact());
        this.measureImpact.init();
        this.distExponent.setDefBounds(0.5, 3.0, 0.1, 0.1);
        this.distExponent.setDefValue(this.parent.getDistExponent());
        this.distExponent.init();
        this.distLowerBound.setDefBounds(0.0, 0.4, 0.01, 0.05);
        this.distLowerBound.setDefValue(this.parent.getDistLowerBound());
        this.distLowerBound.init();
        this.lowerToZero.setState(this.parent.isLowerToZero());
        this.distUpperBound.setDefBounds(0.6, 1.0, 0.01, 0.05);
        this.distUpperBound.setDefValue(this.parent.getDistUpperBound());
        this.distUpperBound.init();
        this.update(this);
    }

    public boolean update(Object eventSource) {
        if (eventSource == this.parent) {
            this.measureChooser.select(RmGlobalDirectionsIntrinsic_IP.measureToIndex(this.parent.getMeasure()));
            this.eColorChooser.select(RmGlobalDirectionsIntrinsic_IP.eColorToIndex(this.parent.getEColor()));
            this.directionForEColorChooser.select(this.parent.getDirectionForEColor());
            this.showImportant.setState(this.parent.isShowImportant());
            this.respectOrientation.setState(this.parent.isRespectOrientation());
            this.iterative.setState(this.parent.isIterative());
            this.sizeAdaptive.setState(this.parent.isSizeAdaptive());
            this.sizeFactorX.setValue(this.parent.getSizeFactor(0));
            this.sizeFactorY.setValue(this.parent.getSizeFactor(1));
            this.sizeFactorZ.setValue(this.parent.getSizeFactor(2));
            this.measureImpact.setValue(this.parent.getMeasureImpact());
            this.distExponent.setValue(this.parent.getDistExponent());
            this.distLowerBound.setValue(this.parent.getDistLowerBound());
            this.lowerToZero.setState(this.parent.isLowerToZero());
            this.distUpperBound.setValue(this.parent.getDistUpperBound());
        }
        if (eventSource == this) {
            return true;
        }
        if (eventSource == this.sizeFactorX) {
            this.parent.setSizeFactor(0, this.sizeFactorX.getValue());
            return true;
        }
        if (eventSource == this.sizeFactorY) {
            this.parent.setSizeFactor(1, this.sizeFactorY.getValue());
            return true;
        }
        if (eventSource == this.sizeFactorZ) {
            this.parent.setSizeFactor(2, this.sizeFactorZ.getValue());
            return true;
        }
        if (eventSource == this.measureImpact) {
            this.parent.setMeasureImpact(this.measureImpact.getValue());
            return true;
        }
        if (eventSource == this.distExponent) {
            this.parent.setDistExponent(this.distExponent.getValue());
            return true;
        }
        if (eventSource == this.distLowerBound) {
            this.parent.setDistLowerBound(this.distLowerBound.getValue());
            return true;
        }
        if (eventSource == this.distUpperBound) {
            this.parent.setDistUpperBound(this.distUpperBound.getValue());
            return true;
        }
        return super.update(eventSource);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.measureChooser) {
            this.parent.setMeasure(RmGlobalDirectionsIntrinsic_IP.indexToMeasure(this.measureChooser.getSelectedIndex()));
            return;
        }
        if (source == this.eColorChooser) {
            this.parent.setEColor(RmGlobalDirectionsIntrinsic_IP.indexToEColor(this.eColorChooser.getSelectedIndex()));
            return;
        }
        if (source == this.directionForEColorChooser) {
            this.parent.setDirectionForEColor(this.directionForEColorChooser.getSelectedIndex());
            return;
        }
        if (source == this.showImportant) {
            this.parent.setShowImportant(this.showImportant.getState());
            return;
        }
        if (source == this.respectOrientation) {
            this.parent.setRespectOrientation(this.respectOrientation.getState());
            return;
        }
        if (source == this.iterative) {
            this.parent.setIterative(this.iterative.getState());
            return;
        }
        if (source == this.sizeAdaptive) {
            this.parent.setSizeAdaptive(this.sizeAdaptive.getState());
            return;
        }
        if (source == this.lowerToZero) {
            this.parent.setLowerToZero(this.lowerToZero.getState());
            return;
        }
    }
}

