/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.retargeting;

import devRetarget.retargeting.RetargetingModule_IP;
import devRetarget.retargeting.RmConstraints;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;

public class RmConstraints_IP
extends RetargetingModule_IP
implements ItemListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    protected static final int[] measureMapping = new int[]{1, 2, 3, 10, 11, 12, 4, 5};
    protected static final int[] eColorMapping;
    protected RmConstraints parent;
    protected Choice measureChooser;
    protected Choice eColorChooser;
    protected Checkbox showImportant;
    protected Checkbox showFixedVertices;
    protected Button addToFixed;
    protected Button removeFromFixed;
    protected Button clearFixed;
    protected Button selectFixed;
    protected Checkbox useStencil;
    protected PuInteger stencilSize;
    protected PuDouble stencilPower;
    protected Checkbox respectOrientation;
    protected PuDouble measureImpact;
    protected PuDouble distExponent;
    protected PuDouble distLowerBound;
    protected PuDouble distUpperBound;

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        eColorMapping = nArray;
    }

    protected static int measureToIndex(int measure) {
        int i = 0;
        while (i < measureMapping.length) {
            if (measureMapping[i] == measure) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToMeasure(int index) {
        if (index < measureMapping.length) {
            return measureMapping[index];
        }
        throw new IllegalArgumentException();
    }

    protected static int eColorToIndex(int eColor) {
        int i = 0;
        while (i < eColorMapping.length) {
            if (eColorMapping[i] == eColor) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToEColor(int index) {
        if (index < eColorMapping.length) {
            return eColorMapping[index];
        }
        throw new IllegalArgumentException();
    }

    public RmConstraints_IP() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        layoutConstraints.gridwidth = 1;
        layoutConstraints.gridy = 0;
        layoutConstraints.gridx = 0;
        this.add(new Label("Scalar Measure:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.measureChooser = new Choice();
        this.measureChooser.add("Mean Curvatures");
        this.measureChooser.add("Larger Principal Curvatures");
        this.measureChooser.add("Smaller Principal Curvatures");
        this.measureChooser.add("Shape Operator X");
        this.measureChooser.add("Shape Operator Y");
        this.measureChooser.add("Shape Operator Z");
        this.measureChooser.add("Uniform 0-Measure");
        this.measureChooser.add("Uniform 0.5-Measure");
        this.measureChooser.addItemListener(this);
        this.add(this.measureChooser, layoutConstraints);
        ++layoutConstraints.gridy;
        layoutConstraints.gridx = 0;
        this.add(new Label("Element Color:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.eColorChooser = new Choice();
        this.eColorChooser.add("None");
        this.eColorChooser.add("Measure Values");
        this.eColorChooser.add("Measure Effective");
        this.eColorChooser.add("Measure Impact");
        this.eColorChooser.add("Stencil");
        this.eColorChooser.addItemListener(this);
        this.add(this.eColorChooser, layoutConstraints);
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        ++layoutConstraints.gridy;
        this.showImportant = new Checkbox("Highlight important elements");
        this.showImportant.addItemListener(this);
        this.add(this.showImportant, layoutConstraints);
        ++layoutConstraints.gridy;
        this.showFixedVertices = new Checkbox("Show fixed Vertices");
        this.showFixedVertices.addItemListener(this);
        this.add(this.showFixedVertices, layoutConstraints);
        ++layoutConstraints.gridy;
        this.addToFixed = new Button("Add Selected Vertices to Fixed");
        this.addToFixed.addActionListener(this);
        this.add(this.addToFixed, layoutConstraints);
        ++layoutConstraints.gridy;
        this.removeFromFixed = new Button("Remove Selected Vertices from Fixed");
        this.removeFromFixed.addActionListener(this);
        this.add(this.removeFromFixed, layoutConstraints);
        ++layoutConstraints.gridy;
        this.selectFixed = new Button("Select Fixed Vertices");
        this.selectFixed.addActionListener(this);
        this.add(this.selectFixed, layoutConstraints);
        ++layoutConstraints.gridy;
        this.clearFixed = new Button("Clear Fixed Vertices");
        this.clearFixed.addActionListener(this);
        this.add(this.clearFixed, layoutConstraints);
        ++layoutConstraints.gridy;
        this.stencilSize = new PuInteger("Stencil size", (PsUpdateIf)this);
        this.add((Component)this.stencilSize.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.stencilPower = new PuDouble("Stencil power", (PsUpdateIf)this);
        this.add((Component)this.stencilPower.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.useStencil = new Checkbox("Use Stencil");
        this.useStencil.addItemListener(this);
        this.add(this.useStencil, layoutConstraints);
        ++layoutConstraints.gridy;
        this.respectOrientation = new Checkbox("Respect Orientation");
        this.respectOrientation.addItemListener(this);
        this.add(this.respectOrientation, layoutConstraints);
        ++layoutConstraints.gridy;
        this.measureImpact = new PuDouble("Measure-Impact", (PsUpdateIf)this);
        this.add((Component)this.measureImpact.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.distExponent = new PuDouble("Dist.-Exponent", (PsUpdateIf)this);
        this.add((Component)this.distExponent.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.distLowerBound = new PuDouble("Lower bound(%)", (PsUpdateIf)this);
        this.add((Component)this.distLowerBound.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.distUpperBound = new PuDouble("Upper bound(%)", (PsUpdateIf)this);
        this.add((Component)this.distUpperBound.newInspector("_IP"), layoutConstraints);
        this.validate();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.parent = (RmConstraints)parent;
        this.init();
    }

    public void init() {
        super.init();
        this.setName("InfoPanel for Retargeting Method Scalar");
        this.measureChooser.select(RmConstraints_IP.measureToIndex(this.parent.getMeasure()));
        this.eColorChooser.select(RmConstraints_IP.eColorToIndex(this.parent.getEColor()));
        this.showImportant.setState(this.parent.isShowImportant());
        this.showFixedVertices.setState(this.parent.isShowFixedVertices());
        this.stencilSize.setDefBounds(1, 10, 1, 1);
        this.stencilSize.setDefValue(this.parent.getStencilSize());
        this.stencilSize.init();
        this.stencilPower.setDefBounds(0.5, 100.0, 0.5, 0.5);
        this.stencilPower.setDefValue(this.parent.getStencilPower());
        this.stencilPower.init();
        this.useStencil.setState(this.parent.isUseStencil());
        this.respectOrientation.setState(this.parent.isRespectOrientation());
        this.measureImpact.setDefBounds(0.0, 1.0, 0.1, 0.1);
        this.measureImpact.setDefValue(this.parent.getMeasureImpact());
        this.measureImpact.init();
        this.distExponent.setDefBounds(0.5, 4.0, 0.1, 0.1);
        this.distExponent.setDefValue(this.parent.getDistExponent());
        this.distExponent.init();
        this.distLowerBound.setDefBounds(0.1, 0.5, 0.05, 0.05);
        this.distLowerBound.setDefValue(this.parent.getDistLowerBound());
        this.distLowerBound.init();
        this.distUpperBound.setDefBounds(0.6, 1.0, 0.05, 0.05);
        this.distUpperBound.setDefValue(this.parent.getDistUpperBound());
        this.distUpperBound.init();
    }

    public boolean update(Object eventSource) {
        if (eventSource == this.parent) {
            this.measureChooser.select(RmConstraints_IP.measureToIndex(this.parent.getMeasure()));
            this.eColorChooser.select(RmConstraints_IP.eColorToIndex(this.parent.getEColor()));
            this.showImportant.setState(this.parent.isShowImportant());
            this.showFixedVertices.setState(this.parent.isShowFixedVertices());
            this.stencilSize.setValue(this.parent.getStencilSize());
            this.stencilPower.setValue(this.parent.getStencilPower());
            this.respectOrientation.setState(this.parent.isRespectOrientation());
            this.measureImpact.setValue(this.parent.getMeasureImpact());
            this.distExponent.setValue(this.parent.getDistExponent());
            this.distLowerBound.setValue(this.parent.getDistLowerBound());
            this.distUpperBound.setValue(this.parent.getDistUpperBound());
        }
        if (eventSource == this.stencilSize) {
            this.parent.setStencilSize(this.stencilSize.getValue());
            return true;
        }
        if (eventSource == this.stencilPower) {
            this.parent.setStencilPower(this.stencilPower.getValue());
            return true;
        }
        if (eventSource == this.measureImpact) {
            this.parent.setMeasureImpact(this.measureImpact.getValue());
            return true;
        }
        if (eventSource == this.distExponent) {
            this.parent.setDistExponent(this.distExponent.getValue());
            return true;
        }
        if (eventSource == this.distLowerBound) {
            this.parent.setDistLowerBound(this.distLowerBound.getValue());
            return true;
        }
        if (eventSource == this.distUpperBound) {
            this.parent.setDistUpperBound(this.distUpperBound.getValue());
            return true;
        }
        return super.update(eventSource);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.measureChooser) {
            this.parent.setMeasure(RmConstraints_IP.indexToMeasure(this.measureChooser.getSelectedIndex()));
            return;
        }
        if (source == this.eColorChooser) {
            this.parent.setEColor(RmConstraints_IP.eColorToIndex(this.eColorChooser.getSelectedIndex()));
            return;
        }
        if (source == this.showImportant) {
            this.parent.setShowImportant(this.showImportant.getState());
            return;
        }
        if (source == this.showFixedVertices) {
            this.parent.setShowFixedVertices(this.showFixedVertices.getState());
            return;
        }
        if (source == this.useStencil) {
            this.parent.setUseStencil(this.useStencil.getState());
            return;
        }
        if (source == this.respectOrientation) {
            this.parent.setRespectOrientation(this.respectOrientation.getState());
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.addToFixed) {
            this.parent.addToFixed();
            return;
        }
        if (source == this.removeFromFixed) {
            this.parent.removeFromFixed();
            return;
        }
        if (source == this.clearFixed) {
            this.parent.clearFixed();
            return;
        }
        if (source == this.selectFixed) {
            this.parent.selectFixed();
            return;
        }
    }
}

