/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.retargeting;

import devRetarget.retargeting.PnRetargeting;
import devRetarget.retargeting.PuRetargeting;
import devRetarget.retargeting.RetargetingModule;
import devRetarget.util.PuGeometry;
import devRetarget.util.PuUtil;
import java.awt.Color;
import java.util.Arrays;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class RmConstraints
extends RetargetingModule {
    public static final int MODE_WEIGHTS = 0;
    public static final int MODE_DIRECT = 1;
    public static final int MODE_BOTH = 2;
    public static final int MEASURE_MEAN = 1;
    public static final int MEASURE_LPC = 2;
    public static final int MEASURE_SPC = 3;
    public static final int MEASURE_SHAPE_X = 10;
    public static final int MEASURE_SHAPE_Y = 11;
    public static final int MEASURE_SHAPE_Z = 12;
    public static final int MEASURE_UNIFORM0 = 4;
    public static final int MEASURE_UNIFORM05 = 5;
    public static final int ECOLOR_NONE = 0;
    public static final int ECOLOR_MEASURE = 1;
    public static final int ECOLOR_EFFECTIVE = 2;
    public static final int ECOLOR_IMPACT = 3;
    public static final int ECOLOR_STENCIL = 4;
    protected int mode;
    protected int measure;
    protected int eColor;
    protected boolean showImportant;
    protected boolean showFixedVertices;
    protected int[] fixedVertices;
    protected boolean useStencil;
    protected int stencilSize;
    protected double stencilPower;
    protected boolean respectOrientation;
    protected double measureImpact;
    protected double distExponent;
    protected double distLowerBound;
    protected double distUpperBound;

    public RmConstraints() {
        if (((Object)((Object)this)).getClass() == RmConstraints.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setName("RM Constraints");
        this.setType(5);
        this.mode = 0;
        this.measure = 1;
        this.eColor = 2;
        this.showImportant = true;
        this.showFixedVertices = false;
        this.fixedVertices = new int[0];
        this.useStencil = true;
        this.stencilSize = 2;
        this.stencilPower = 10.0;
        this.respectOrientation = true;
        this.measureImpact = 1.0;
        this.distExponent = 2.0;
        this.distLowerBound = 0.2;
        this.distUpperBound = 0.9;
    }

    @Override
    protected void enable() {
        this.update((Object)this);
    }

    @Override
    protected void disable() {
        this.m_outputGeometry.showElementColors(false);
        this.m_outputGeometry.removeVertexColors();
        this.m_outputGeometry.removeVertexSizes();
        this.m_outputGeometry.showVertices(false);
    }

    public boolean update(Object source) {
        if (source == this) {
            if (!this.m_bEnabled) {
                return true;
            }
            switch (this.eColor) {
                case 0: {
                    Color defaultColor = new Color(150, 220, 255);
                    int e = 0;
                    while (e < this.m_numElements) {
                        this.m_outputGeometry.setElementColor(e, defaultColor);
                        ++e;
                    }
                    this.m_outputGeometry.showElementColors(false);
                    break;
                }
                case 1: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromNormedValues(this.currentMeasureValues(), false));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 2: {
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromNormedValues(this.effectiveMeasureValues(), false));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 3: {
                    double[] effectiveImpacts = this.effectiveImpacts();
                    this.m_outputGeometry.setElementColors(PuUtil.colorsFromNormedValues(effectiveImpacts, false));
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                case 4: {
                    Color notStencil = new Color(0.0f, 1.0f, 0.0f);
                    int e = 0;
                    while (e < this.m_numElements) {
                        this.m_outputGeometry.setElementColor(e, notStencil);
                        ++e;
                    }
                    Color stencil = new Color(1.0f, 0.0f, 0.0f);
                    int[] stencilElements = this.currentStencilElements();
                    int e2 = 0;
                    while (e2 < stencilElements.length) {
                        this.m_outputGeometry.setElementColor(stencilElements[e2], stencil);
                        ++e2;
                    }
                    this.m_outputGeometry.showElementColors(true);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.showImportant) {
                int[] importantElements = this.m_measureGeometry.importantElements();
                Color importantColor = new Color(1.0f, 1.0f, 0.0f);
                int e = 0;
                while (e < importantElements.length) {
                    this.m_outputGeometry.setElementColor(importantElements[e], importantColor);
                    ++e;
                }
                this.m_outputGeometry.showElementColors(true);
            }
            this.m_outputGeometry.removeVertexColors();
            this.m_outputGeometry.removeVertexSizes();
            this.m_outputGeometry.showVertices(false);
            if (this.showFixedVertices && this.fixedVertices != null) {
                int i = 0;
                while (i < this.m_outputGeometry.getNumVertices()) {
                    this.m_outputGeometry.setVertexSize(i, 0.8);
                    ++i;
                }
                Color colorOfFixed = new Color(1.0f, 0.0f, 0.0f);
                int i2 = 0;
                while (i2 < this.fixedVertices.length) {
                    this.m_outputGeometry.setVertexColor(this.fixedVertices[i2], colorOfFixed);
                    this.m_outputGeometry.setVertexSize(this.fixedVertices[i2], 2.5);
                    ++i2;
                }
                this.m_outputGeometry.showVertexColors(true);
                this.m_outputGeometry.showVertexSizes(true);
                this.m_outputGeometry.showVertices(true);
            }
            this.m_outputGeometry.update((Object)this.m_outputGeometry);
            return true;
        }
        return super.update(source);
    }

    @Override
    public void retarget() {
        PsDebug.pushStatus((String)"Retargeting. Please wait...");
        boolean[] fixed = new boolean[this.m_inputGeometry.getNumVertices()];
        int i = 0;
        while (i < this.fixedVertices.length) {
            fixed[this.fixedVertices[i]] = true;
            ++i;
        }
        PdVector[] fixedValues = new PdVector[3];
        int i2 = 0;
        while (i2 < 3) {
            fixedValues[i2] = new PdVector(this.m_inputGeometry.getNumVertices());
            int j = 0;
            while (j < this.fixedVertices.length) {
                fixedValues[i2].setEntry(this.fixedVertices[j], this.m_outputGeometry.getVertex(this.fixedVertices[j]).getEntry(i2));
                ++j;
            }
            ++i2;
        }
        PdVector weights = new PdVector(this.effectiveImpacts());
        if (this.useStencil) {
            int[] stencilElements = this.currentStencilElements();
            int e = 0;
            while (e < stencilElements.length) {
                weights.m_data[stencilElements[e]] = this.stencilPower;
                ++e;
            }
        }
        int[] importantElements = this.m_measureGeometry.importantElements();
        double importance = this.m_measureGeometry.getImportance();
        int e = 0;
        while (e < importantElements.length) {
            weights.m_data[importantElements[e]] = importance;
            ++e;
        }
        PdVector[] vertices = PnRetargeting.integrate(this.m_inputGeometry, this.m_inputGeometry.coordinateGradients(), weights, fixed, fixedValues);
        this.m_outputGeometry.setVertices(vertices);
        this.m_outputGeometry.update((Object)this.m_outputGeometry);
        PsDebug.pushStatus((String)"Retargeting finished.");
    }

    @Override
    public PgVectorField[] getEffectiveGradients() {
        return null;
    }

    protected double[] effectiveImpacts() {
        double[] effectiveImpacts = new double[this.m_numElements];
        double[] effectiveMeasureValues = this.effectiveMeasureValues();
        int i = 0;
        while (i < effectiveImpacts.length) {
            effectiveImpacts[i] = 1.0 - this.measureImpact + this.measureImpact * effectiveMeasureValues[i];
            ++i;
        }
        return effectiveImpacts;
    }

    protected double[] effectiveMeasureValues() {
        int e;
        double[] values = this.currentMeasureValues();
        double[] effectiveMeasureValues = Arrays.copyOf(values, this.m_numElements);
        if (this.measure != 4 && this.measure != 5) {
            PuUtil.adjustOutliers(effectiveMeasureValues, 0.0, this.distUpperBound);
            PuUtil.normalize(effectiveMeasureValues, false);
            PuRetargeting.cutAtLowerThreshold(effectiveMeasureValues, this.distLowerBound, true, false);
        }
        int i = 0;
        while (i < effectiveMeasureValues.length) {
            effectiveMeasureValues[i] = Math.pow(effectiveMeasureValues[i], this.distExponent);
            ++i;
        }
        if (this.respectOrientation) {
            double[] projectionLength;
            switch (this.measure) {
                case 10: {
                    projectionLength = this.m_measureGeometry.stdBasisProjectionLengths()[0];
                    break;
                }
                case 11: {
                    projectionLength = this.m_measureGeometry.stdBasisProjectionLengths()[1];
                    break;
                }
                case 12: {
                    projectionLength = this.m_measureGeometry.stdBasisProjectionLengths()[2];
                    break;
                }
                default: {
                    projectionLength = null;
                }
            }
            if (projectionLength != null) {
                e = 0;
                while (e < this.m_numElements) {
                    double projectionImpact = Math.pow(projectionLength[e], 0.5);
                    effectiveMeasureValues[e] = 1.0 - projectionImpact + projectionImpact * effectiveMeasureValues[e];
                    ++e;
                }
            }
        }
        double[] userValues = this.m_measureGeometry.userValues();
        e = 0;
        while (e < this.m_numElements) {
            if (!(userValues[e] < 0.0)) {
                effectiveMeasureValues[e] = userValues[e];
            }
            ++e;
        }
        if (this.useStencil) {
            int[] stencilElements = this.currentStencilElements();
            int e2 = 0;
            while (e2 < stencilElements.length) {
                effectiveMeasureValues[stencilElements[e2]] = 1.0;
                ++e2;
            }
        }
        return effectiveMeasureValues;
    }

    protected double[] currentMeasureValues() {
        switch (this.measure) {
            case 1: {
                return this.m_measureGeometry.meanCurvatures();
            }
            case 2: {
                return this.m_measureGeometry.largerPrincipalCurvatureValues();
            }
            case 3: {
                return this.m_measureGeometry.smallerPrincipalCurvatureValues();
            }
            case 10: {
                return this.m_measureGeometry.stdDirsShapeOpValues()[0];
            }
            case 11: {
                return this.m_measureGeometry.stdDirsShapeOpValues()[1];
            }
            case 12: {
                return this.m_measureGeometry.stdDirsShapeOpValues()[2];
            }
            case 4: {
                return this.m_measureGeometry.uniform0Values();
            }
            case 5: {
                return this.m_measureGeometry.uniform05Values();
            }
        }
        throw new IllegalStateException();
    }

    protected int[] currentStencilElements() {
        int[] stencilVertices = PuGeometry.getNeighbourhood(this.m_outputGeometry, this.fixedVertices, this.stencilSize - 1);
        int[] stencilElements = PuGeometry.getStencil(this.m_outputGeometry, stencilVertices);
        return stencilElements;
    }

    public int getMeasure() {
        return this.measure;
    }

    public void setMeasure(int measure) {
        switch (measure) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                this.measure = measure;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.update((Object)this);
    }

    public double getMeasureImpact() {
        return this.measureImpact;
    }

    public void setMeasureImpact(double measureImpact) {
        if (measureImpact < 0.0 || measureImpact > 1.0) {
            throw new IllegalArgumentException();
        }
        this.measureImpact = measureImpact;
        if (this.eColor == 3) {
            this.update((Object)this);
        }
    }

    public double getDistExponent() {
        return this.distExponent;
    }

    public void setDistExponent(double distExponent) {
        if (distExponent < 0.0) {
            throw new IllegalArgumentException();
        }
        this.distExponent = distExponent;
        if (this.eColor == 2 || this.eColor == 3) {
            this.update((Object)this);
        }
    }

    public double getDistLowerBound() {
        return this.distLowerBound;
    }

    public void setDistLowerBound(double distLowerBound) {
        if (distLowerBound > 0.5) {
            throw new IllegalArgumentException();
        }
        this.distLowerBound = distLowerBound;
        if (this.eColor == 2 || this.eColor == 3) {
            this.update((Object)this);
        }
    }

    public double getDistUpperBound() {
        return this.distUpperBound;
    }

    public void setDistUpperBound(double distUpperBound) {
        if (distUpperBound < 0.6) {
            throw new IllegalArgumentException();
        }
        this.distUpperBound = distUpperBound;
        if (this.eColor == 2 || this.eColor == 3) {
            this.update((Object)this);
        }
    }

    public int getEColor() {
        return this.eColor;
    }

    public void setEColor(int eColor) {
        switch (eColor) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.eColor = eColor;
                this.update((Object)this);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void addToFixed() {
        PiVector markedVertices = this.m_outputGeometry.getMarkedVertices(1);
        int numMarked = markedVertices.getSize();
        int numPrevious = this.fixedVertices.length;
        int[] merged = Arrays.copyOf(this.fixedVertices, numPrevious + numMarked);
        int e = 0;
        while (e < numMarked) {
            merged[numPrevious + e] = markedVertices.getEntry(e);
            ++e;
        }
        this.fixedVertices = PuUtil.uniqueValuesOf(merged);
        PuGeometry.setMarkedVertices((PgPointSet)this.m_outputGeometry, null);
        this.update((Object)this);
    }

    public void removeFromFixed() {
        PiVector markedVertices = this.m_outputGeometry.getMarkedVertices(1);
        int numMarked = markedVertices.getSize();
        int[] difference = new int[this.fixedVertices.length];
        int differenceLength = 0;
        Arrays.sort(markedVertices.m_data);
        int e = 0;
        while (e < this.fixedVertices.length) {
            if (Arrays.binarySearch(markedVertices.m_data, this.fixedVertices[e]) < 0) {
                difference[differenceLength++] = this.fixedVertices[e];
            }
            ++e;
        }
        this.fixedVertices = Arrays.copyOf(difference, differenceLength);
        PuGeometry.setMarkedElements(this.m_outputGeometry, null);
        this.update((Object)this);
    }

    public void clearFixed() {
        this.fixedVertices = new int[0];
        this.update((Object)this);
    }

    public void selectFixed() {
        PuGeometry.setMarkedVertices((PgPointSet)this.m_outputGeometry, this.fixedVertices);
        this.m_outputGeometry.update((Object)this.m_outputGeometry);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: {
                this.mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean isUseStencil() {
        return this.useStencil;
    }

    public void setUseStencil(boolean useStencil) {
        this.useStencil = useStencil;
        if (this.eColor != 0 && this.eColor != 1) {
            this.update((Object)this);
        }
    }

    public int getStencilSize() {
        return this.stencilSize;
    }

    public void setStencilSize(int stencilSize) {
        if (stencilSize < 1) {
            throw new IllegalArgumentException();
        }
        this.stencilSize = stencilSize;
        if (this.eColor != 0 && this.eColor != 1) {
            this.update((Object)this);
        }
    }

    public boolean isShowFixedVertices() {
        return this.showFixedVertices;
    }

    public void setShowFixedVertices(boolean showFixedVertices) {
        this.showFixedVertices = showFixedVertices;
        this.update((Object)this);
    }

    public double getStencilPower() {
        return this.stencilPower;
    }

    public void setStencilPower(double stencilPower) {
        if (stencilPower < 0.1) {
            throw new IllegalArgumentException();
        }
        this.stencilPower = stencilPower;
    }

    public boolean isRespectOrientation() {
        return this.respectOrientation;
    }

    public void setRespectOrientation(boolean respectOrientation) {
        this.respectOrientation = respectOrientation;
        if (this.eColor != 0 && this.eColor != 4) {
            this.update((Object)this);
        }
    }

    public boolean isShowImportant() {
        return this.showImportant;
    }

    public void setShowImportant(boolean showImportant) {
        this.showImportant = showImportant;
        this.update((Object)this);
    }
}

