/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.retargeting;

import devRetarget.PjRetargeting;
import devRetarget.retargeting.PgRetargetingGeometry;
import devRetarget.retargeting.PnRetargeting;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsObject;

public abstract class RetargetingModule
extends PsObject {
    protected PnRetargeting m_solver;
    protected PgRetargetingGeometry m_inputGeometry;
    protected PgRetargetingGeometry m_measureGeometry;
    protected PgElementSet m_outputGeometry;
    protected int m_numElements;
    protected boolean m_bEnabled = false;
    protected boolean m_bAutoRetarget = false;
    protected int m_type;

    public void setDock(PjRetargeting dock) {
        this.m_inputGeometry = dock.getInputGeometry();
        this.m_numElements = this.m_inputGeometry.getNumElements();
        this.m_measureGeometry = dock.getMeasureGeometry();
        this.m_outputGeometry = dock.getOutputGeometry();
    }

    public void setSolver(PnRetargeting solver) {
        this.m_solver = solver;
    }

    public abstract void retarget();

    public abstract PgVectorField[] getEffectiveGradients();

    protected abstract void enable();

    protected abstract void disable();

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public boolean isEnabled() {
        return this.m_bEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_bEnabled = enabled;
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public boolean isAutoRetarget() {
        return this.m_bAutoRetarget;
    }

    public void setAutoRetarget(boolean autoRetarget) {
        this.m_bAutoRetarget = autoRetarget;
    }
}

