/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.retargeting;

import devRetarget.util.PuCurvature;
import devRetarget.util.PuGeometry;
import java.util.Arrays;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PuRetargeting {
    public static double[] vertexToElementValues(double[] vertexValues, PgElementSet domain) {
        if (vertexValues.length != domain.getNumVertices()) {
            throw new IllegalArgumentException("The number of supplied values at the vertices did not match number of vertices of the domain.");
        }
        int numElements = domain.getNumElements();
        PiVector[] element = domain.getElements();
        PdVector elementValues = new PdVector(numElements);
        int e = 0;
        while (e < numElements) {
            int elemLen = element[e].getSize();
            int i = 0;
            while (i < elemLen) {
                int n = e;
                elementValues.m_data[n] = elementValues.m_data[n] + vertexValues[element[e].getEntry(i)];
                ++i;
            }
            int n = e++;
            elementValues.m_data[n] = elementValues.m_data[n] / (double)elemLen;
        }
        return elementValues.m_data;
    }

    public static PdVector[] vertexToElementVectors(PdVector[] vertexVectors, PgElementSet domain, boolean directionsOnly, boolean normalize) {
        if (vertexVectors.length != domain.getNumVertices()) {
            throw new IllegalArgumentException("Missmatch of number of supplied vectors.");
        }
        if (directionsOnly) {
            int i = 0;
            while (i < vertexVectors.length) {
                vertexVectors[i].normalize();
                ++i;
            }
        }
        int numElements = domain.getNumElements();
        PiVector[] element = domain.getElements();
        int dim = domain.getDimOfVertices();
        PdVector[] elementVectors = PdVector.realloc(null, (int)numElements, (int)dim);
        int e = 0;
        while (e < numElements) {
            elementVectors[e] = new PdVector();
            int elemLen = element[e].getSize();
            int i = 0;
            while (i < elemLen) {
                elementVectors[e].add(vertexVectors[element[e].getEntry(i)]);
                ++i;
            }
            if (normalize) {
                elementVectors[e].normalize();
            }
            ++e;
        }
        return elementVectors;
    }

    public static PdMatrix[] vertexToElementOperators(PdMatrix[] vertexOperators, PgElementSet domain) {
        int numElements = domain.getNumElements();
        PiVector[] element = domain.getElements();
        int dim = vertexOperators[0].getSize();
        PdMatrix[] elementOperators = new PdMatrix[numElements];
        int e = 0;
        while (e < numElements) {
            elementOperators[e] = new PdMatrix(dim);
            int elemLen = element[e].getSize();
            int i = 0;
            while (i < elemLen) {
                elementOperators[e].add(vertexOperators[element[e].getEntry(i)]);
                ++i;
            }
            elementOperators[e].multScalar(1.0 / (double)elemLen);
            ++e;
        }
        return elementOperators;
    }

    public static void cutAtLowerThreshold(double[] values, double threshold, boolean absThreshold, boolean lowerToZero) {
        if (threshold < 0.0 || threshold > 0.5) {
            throw new IllegalArgumentException();
        }
        if (!absThreshold) {
            double[] sorted = Arrays.copyOf(values, values.length);
            Arrays.sort(sorted);
            threshold = sorted[(int)((double)(sorted.length - 1) * threshold)];
        }
        int i = 0;
        while (i < values.length) {
            if (values[i] < threshold) {
                values[i] = threshold;
            }
            ++i;
        }
        if (lowerToZero) {
            double intervalLength = 1.0 - threshold;
            int i2 = 0;
            while (i2 < values.length) {
                values[i2] = (values[i2] - threshold) / intervalLength;
                ++i2;
            }
        }
    }

    public static void cutAtLowerThreshold(double[][] values, double threshold, boolean absThreshold, boolean moveToZero) {
        int j;
        int m = values.length;
        int n = values[0].length;
        double[] vals = new double[m * n];
        int i = 0;
        while (i < m) {
            j = 0;
            while (j < n) {
                vals[i * n + j] = values[i][j];
                ++j;
            }
            ++i;
        }
        PuRetargeting.cutAtLowerThreshold(vals, threshold, absThreshold, moveToZero);
        i = 0;
        while (i < m) {
            j = 0;
            while (j < n) {
                values[i][j] = vals[i * n + j];
                ++j;
            }
            ++i;
        }
    }

    public static PgVectorField[] computeLocalFrames(PgElementSet geometry) {
        PgVectorField[] localFrames = new PgVectorField[3];
        int i = 0;
        while (i < localFrames.length) {
            localFrames[i] = new PgVectorField(3, 1);
            localFrames[i].setName("PC-Frame[" + i + "]");
            localFrames[i].setGeometry((PgPointSet)geometry);
            ++i;
        }
        PdVector[][] pcDirs = PuCurvature.elementPrincipalCurvatureDirections(geometry);
        PdVector[] normals = geometry.getElementNormals();
        localFrames[0].setVectors(pcDirs[0]);
        localFrames[1].setVectors(pcDirs[1]);
        localFrames[2].setVectors(normals);
        return localFrames;
    }

    public static PdVector computeWeightsFromVertices(PgElementSet geometry, PiVector vertices, double weight, double radius) {
        PdVector weights = new PdVector(geometry.getNumElements());
        weights.setConstant(1.0);
        int v = 0;
        while (v < vertices.getSize()) {
            int vertex = vertices.getEntry(v);
            PdVector distances = new PdVector();
            PiVector elements = PuGeometry.getElementsAroundVertex(geometry, vertex, radius, null, distances);
            int e = 0;
            while (e < elements.getSize()) {
                int element = elements.getEntry(e);
                double normedDistance = distances.getEntry(e) / radius;
                double elementWeight = (1.0 - normedDistance) * weight;
                weights.m_data[element] = Math.max(weights.m_data[element], 1.0 + elementWeight);
                ++e;
            }
            ++v;
        }
        return weights;
    }
}

