/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.retargeting;

import dev.numeric.PnTaucsSolver;
import dev.numeric.PuSparseMatrix;
import devRetarget.retargeting.PgRetargetingGeometry;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jvx.numeric.PnConjugateGradientMatrix;
import jvx.numeric.PnPreconditioner;
import jvx.numeric.PnPreconditionerJacobi;
import jvx.numeric.PnSparseMatrix;
import jvx.numeric.PnStiffMatrix;

public class PnRetargeting {
    private static final boolean PRINT_SOLVING_TIME = false;
    private static final int SOLVER_JV_CONJUGATE_CG = 0;
    private static final int SOLVER_TAUCS = 1;
    private int m_solverType = 1;
    private PgRetargetingGeometry m_geom;
    private PnSparseMatrix m_matrix;
    private PnSparseMatrix m_reducedMatrix;
    private PnPreconditionerJacobi m_preconditioner;
    private long m_cholFact;
    private boolean[] m_fixed;
    private PdVector[] m_fixedValues;
    private PdVector m_weights;

    public PnRetargeting() {
        if (this.m_solverType == 1 && !PnTaucsSolver.isAvailable()) {
            PsDebug.warning((String)"TAUCS solver selected, but library not found.");
            this.m_solverType = 0;
        }
    }

    public void setGeometry(PgRetargetingGeometry geom) {
        this.m_geom = geom;
        this.m_fixed = geom.getFixed();
        this.m_fixedValues = geom.getFixedValues();
        this.m_weights = geom.getWeights();
        this.m_matrix = null;
        this.m_reducedMatrix = null;
        this.m_preconditioner = null;
        this.m_cholFact = 0L;
    }

    public void computeAndFactorizeStiffnessMatrix() {
        this.m_matrix = PnStiffMatrix.computeStiffnessMatrix((PgElementSet)this.m_geom, (boolean)true, (PdVector)this.m_weights);
        this.m_matrix.compress();
        this.m_matrix.addDiagonal(1.0E-6);
        if (this.m_fixed != null) {
            this.m_reducedMatrix = new PnSparseMatrix();
            PuSparseMatrix.getReducedSystemMatrix((PnSparseMatrix)this.m_matrix, (PnSparseMatrix)this.m_reducedMatrix, (boolean[])this.m_fixed, null);
        } else {
            this.m_reducedMatrix = this.m_matrix;
        }
        switch (this.m_solverType) {
            case 0: {
                this.m_preconditioner = new PnPreconditionerJacobi(this.m_reducedMatrix);
                break;
            }
            case 1: {
                this.m_cholFact = PnTaucsSolver.getCholeksyFactorization((PnSparseMatrix)this.m_reducedMatrix, (boolean)true, (boolean)true);
            }
        }
    }

    public PdVector[] retarget(PgVectorField[] grad) {
        long startTime = 0L;
        if (this.m_matrix == null) {
            this.computeAndFactorizeStiffnessMatrix();
        }
        int nov = this.m_geom.getNumVertices();
        int dim = grad.length;
        PdVector[] coordinates = PdVector.realloc(null, (int)nov, (int)dim);
        int i = 0;
        while (i < dim) {
            PdVector fixedValues = this.m_fixedValues != null ? this.m_fixedValues[i] : null;
            PdVector coord = this.solve(grad[i], fixedValues, true, false);
            grad[i].update((Object)grad[i]);
            int v = 0;
            while (v < nov) {
                coordinates[v].m_data[i] = coord.m_data[v];
                ++v;
            }
            ++i;
        }
        return coordinates;
    }

    private PdVector solve(PgVectorField field, PdVector fixedValues, boolean conforming, boolean rotateGradient) {
        PdVector rv = PnStiffMatrix.computeRightVector((PgElementSet)this.m_geom, (PgVectorField)field, (boolean)conforming, (boolean)rotateGradient, (PdVector)this.m_weights);
        if (rv == null) {
            return null;
        }
        if (this.m_fixed != null) {
            PdVector reducedRV = new PdVector();
            PuSparseMatrix.getReducedSystemRV((PnSparseMatrix)this.m_matrix, (PdVector)fixedValues, (PdVector)rv, (PdVector)reducedRV, (boolean[])this.m_fixed, null);
            rv = reducedRV;
        }
        PdVector coordinates = new PdVector(this.m_reducedMatrix.getNumCols());
        switch (this.m_solverType) {
            case 1: {
                PnTaucsSolver.solveUseFactorization((long)this.m_cholFact, (double[])coordinates.m_data, (double[])rv.m_data);
                break;
            }
            case 0: {
                PnConjugateGradientMatrix solver = new PnConjugateGradientMatrix();
                solver.setPreconditioner((PnPreconditioner)this.m_preconditioner);
                solver.solve(this.m_matrix, coordinates, rv);
            }
        }
        if (this.m_fixed != null) {
            PdVector enlargedCoords = new PdVector();
            PuSparseMatrix.enlargeReducedSolutionVector((PdVector)fixedValues, (boolean[])this.m_fixed, (PdVector)coordinates, (PdVector)enlargedCoords);
            coordinates = enlargedCoords;
        }
        return coordinates;
    }

    private static PdVector solve(PgElementSet domain, PnSparseMatrix stiffnessMatrix, PgVectorField gradientField, PdVector weights, boolean[] fixed, PdVector fixedValues, boolean conforming, boolean rotateGradient) {
        PdVector rv = PnStiffMatrix.computeRightVector((PgElementSet)domain, (PgVectorField)gradientField, (boolean)conforming, (boolean)rotateGradient, (PdVector)weights);
        if (rv == null) {
            return null;
        }
        PdVector coord = new PdVector(stiffnessMatrix.getNumCols());
        PnConjugateGradientMatrix solver = new PnConjugateGradientMatrix();
        if (fixed != null && fixedValues != null) {
            PnSparseMatrix reducedMatrix = new PnSparseMatrix();
            PdVector reducedRV = new PdVector();
            PuSparseMatrix.getReducedSystem((PnSparseMatrix)stiffnessMatrix, (PnSparseMatrix)reducedMatrix, (PdVector)fixedValues, (PdVector)rv, (PdVector)reducedRV, (boolean[])fixed, null);
            PdVector reducedCoord = new PdVector();
            solver.solve(reducedMatrix, reducedCoord, reducedRV);
            PuSparseMatrix.enlargeReducedSolutionVector((PdVector)fixedValues, (boolean[])fixed, (PdVector)reducedCoord, (PdVector)coord);
        } else {
            solver.solve(stiffnessMatrix, coord, rv);
        }
        return coord;
    }

    public static PdVector[] integrate(PgElementSet domain, PgVectorField[] gradients, PdVector weights, boolean[] fixed, PdVector[] fixedValues) {
        PnSparseMatrix matrix = PnStiffMatrix.computeStiffnessMatrix((PgElementSet)domain, (boolean)true, (PdVector)weights);
        matrix.compress();
        matrix.addDiagonal(1.0E-6);
        int nov = domain.getNumVertices();
        int numCoords = gradients.length;
        PdVector[] coordinates = PdVector.realloc(null, (int)nov, (int)numCoords);
        int i = 0;
        while (i < numCoords) {
            PdVector values = fixedValues == null ? null : fixedValues[i];
            PdVector coord = PnRetargeting.solve(domain, matrix, gradients[i], weights, fixed, values, true, false);
            gradients[i].update((Object)gradients[i]);
            int v = 0;
            while (v < nov) {
                coordinates[v].m_data[i] = coord.m_data[v];
                ++v;
            }
            ++i;
        }
        return coordinates;
    }

    public static PgVectorField[] computeGradientFields(PgElementSet domain, PdVector[] coordinates) {
        int dim = domain.getDimOfVertices();
        PgVectorField[] fields = new PgVectorField[dim];
        int i = 0;
        while (i < dim) {
            fields[i] = new PgVectorField(3, 1);
            fields[i].setName("Gradient " + i);
            fields[i].setGeometry((PgPointSet)domain);
            ++i;
        }
        i = 0;
        while (i < dim) {
            fields[i].computeGradient(domain, coordinates, i);
            ++i;
        }
        return fields;
    }
}

