/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.retargeting;

import devRetarget.retargeting.PnRetargeting;
import devRetarget.retargeting.PuRetargeting;
import devRetarget.util.PuCurvature;
import devRetarget.util.PuUtil;
import java.util.Arrays;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgRetargetingGeometry
extends PgElementSet {
    private PdVector m_dimensions;
    private PgVectorField[] m_coordinateGradients;
    private PdMatrix[] m_stackedCoordinateGradients;
    private int[] m_importantElements;
    private double m_importance;
    private double[] m_meanCurvatures;
    private double[] m_lPcValues;
    private double[] m_sPcValues;
    private double[] m_uniform0Values;
    private double[] m_uniform05Values;
    private double[] m_customMeasure;
    private double[] m_userValues;
    private PdVector[][] m_pcDirections;
    private double[][] m_pcValues;
    private PdMatrix[] m_shapeOperators;
    private PdVector[][] m_stdBasisProjectionDirs;
    private double[][] m_stdBasisProjectionLengths;
    private double[][] m_stdDirsShapeOpValues;
    private boolean[] m_fixed;
    private PdVector[] m_fixedValues;
    private PdVector m_weights;

    public PgRetargetingGeometry() {
        if (((Object)((Object)this)).getClass() == PgRetargetingGeometry.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_importantElements = null;
        this.m_importance = 1.0;
        this.m_dimensions = null;
        this.m_coordinateGradients = null;
        this.m_stackedCoordinateGradients = null;
        this.m_meanCurvatures = null;
        this.m_lPcValues = null;
        this.m_sPcValues = null;
        this.m_uniform0Values = null;
        this.m_uniform05Values = null;
        this.m_customMeasure = null;
        this.m_userValues = null;
        this.m_pcDirections = null;
        this.m_pcValues = null;
        this.m_shapeOperators = null;
        this.m_stdBasisProjectionDirs = null;
        this.m_stdBasisProjectionLengths = null;
        this.m_stdDirsShapeOpValues = null;
        this.m_fixed = null;
        this.m_fixedValues = null;
        this.m_weights = null;
    }

    protected PdVector dimensions() {
        if (this.m_dimensions == null) {
            PdVector[] ambientBounds = this.getAmbientBounds();
            this.m_dimensions = PdVector.subNew((PdVector)ambientBounds[1], (PdVector)ambientBounds[0]);
        }
        return this.m_dimensions;
    }

    protected PdMatrix[] stackedCoordinateGradients() {
        if (this.m_stackedCoordinateGradients == null) {
            PgVectorField[] gradients = this.coordinateGradients();
            this.m_stackedCoordinateGradients = new PdMatrix[this.m_numElements];
            int e = 0;
            while (e < this.m_numElements) {
                this.m_stackedCoordinateGradients[e] = new PdMatrix(3);
                int i = 0;
                while (i < 3) {
                    this.m_stackedCoordinateGradients[e].setRow(i, gradients[i].getVector(e));
                    ++i;
                }
                ++e;
            }
        }
        return this.m_stackedCoordinateGradients;
    }

    public PgVectorField[] coordinateGradients() {
        if (this.m_coordinateGradients == null) {
            this.m_coordinateGradients = PnRetargeting.computeGradientFields(this, this.getVertices());
        }
        return this.m_coordinateGradients;
    }

    public PgVectorField[] getCoordinateGradients() {
        PgVectorField[] gradients = new PgVectorField[3];
        int i = 0;
        while (i < 3) {
            gradients[i] = (PgVectorField)this.coordinateGradients()[i].clone();
            ++i;
        }
        return gradients;
    }

    public void setFixedVertices(PiVector vertices, PdVector[] positions) {
        if (vertices != null && positions == null) {
            positions = new PdVector[vertices.getSize()];
            int i = 0;
            while (i < vertices.getSize()) {
                positions[i] = this.getVertex(vertices.getEntry(i));
                ++i;
            }
        }
        this.setFixedTo(vertices, positions);
    }

    private void setFixedTo(PiVector fixedVertices, PdVector[] positions) {
        if (fixedVertices == null && positions == null) {
            this.setFixed(null, null);
            return;
        }
        if (fixedVertices == null || positions == null || positions.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fixedVertices.getSize() != positions.length) {
            throw new IllegalArgumentException();
        }
        boolean[] fixed = new boolean[this.m_numVertices];
        PdVector[] fixedValues = new PdVector[this.m_dim];
        int d = 0;
        while (d < this.m_dim) {
            fixedValues[d] = new PdVector(this.m_numVertices);
            ++d;
        }
        int i = 0;
        while (i < fixedVertices.getSize()) {
            fixed[fixedVertices.getEntry((int)i)] = true;
            int d2 = 0;
            while (d2 < this.m_dim) {
                fixedValues[d2].setEntry(fixedVertices.getEntry(i), positions[i].getEntry(d2));
                ++d2;
            }
            ++i;
        }
        this.setFixed(fixed, fixedValues);
    }

    public void setFixed(boolean[] fixed, PdVector[] fixedValues) {
        if (fixed != null && this.m_numVertices != fixed.length || fixedValues != null && this.m_numVertices != fixedValues[0].getSize()) {
            throw new IllegalArgumentException();
        }
        this.m_fixed = fixed;
        this.m_fixedValues = fixedValues;
    }

    public void addFixedVertices(PiVector vertices, PdVector[] positions) {
        if (vertices != null && positions == null) {
            positions = new PdVector[vertices.getSize()];
            int i = 0;
            while (i < vertices.getSize()) {
                positions[i] = this.getVertex(vertices.getEntry(i));
                ++i;
            }
        }
        this.addToFixed(vertices, positions);
    }

    public PdVector getWeights() {
        return this.m_weights;
    }

    public void setWeights(PiVector elements, double weight) {
        PdVector weights = new PdVector(this.m_numElements);
        weights.setConstant(1.0);
        int e = 0;
        while (e < elements.getSize()) {
            weights.setEntry(elements.getEntry(e), weight);
            ++e;
        }
        this.setWeights(weights);
    }

    public void setWeights(PdVector weights) {
        if (weights != null && this.m_numElements != weights.getSize()) {
            throw new IllegalArgumentException();
        }
        this.m_weights = weights;
    }

    public void addToFixed(PiVector fixedVertices, PdVector[] positions) {
        if (fixedVertices == null || positions == null || fixedVertices.getSize() == 0 || positions.length == 0) {
            return;
        }
        int numCoordinates = positions[0].getSize();
        boolean[] fixed = this.m_fixed;
        PdVector[] fixedValues = this.m_fixedValues;
        if (fixed == null) {
            fixed = new boolean[this.m_numVertices];
        }
        if (fixedValues == null) {
            fixedValues = new PdVector[numCoordinates];
            int d = 0;
            while (d < numCoordinates) {
                fixedValues[d] = new PdVector(this.m_numVertices);
                ++d;
            }
        }
        int i = 0;
        while (i < fixedVertices.getSize()) {
            fixed[fixedVertices.getEntry((int)i)] = true;
            int d = 0;
            while (d < numCoordinates) {
                fixedValues[d].setEntry(fixedVertices.getEntry(i), positions[i].getEntry(d));
                ++d;
            }
            ++i;
        }
        this.setFixed(fixed, fixedValues);
    }

    public void removeFromFixed(PiVector vertices) {
        boolean[] fixed = this.m_fixed;
        PdVector[] fixedValues = this.m_fixedValues;
        if (fixed == null) {
            return;
        }
        int i = 0;
        while (i < vertices.getSize()) {
            fixed[vertices.getEntry((int)i)] = false;
            ++i;
        }
        this.setFixed(fixed, fixedValues);
    }

    public boolean[] getFixed() {
        return this.m_fixed;
    }

    public PdVector[] getFixedValues() {
        return this.m_fixedValues;
    }

    public PiVector getFixedVertices() {
        PiVector fixed = new PiVector();
        if (this.m_fixed == null) {
            return fixed;
        }
        int i = 0;
        while (i < this.m_numVertices) {
            if (this.m_fixed[i]) {
                fixed.addEntry(i);
            }
            ++i;
        }
        return fixed;
    }

    public boolean hasFixedVertices() {
        if (this.m_fixed == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_fixed.length) {
            if (this.m_fixed[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected double[] meanCurvatures() {
        if (this.m_meanCurvatures == null) {
            this.m_meanCurvatures = PuCurvature.vertexMeanCurvatureValues(this);
            this.m_meanCurvatures = PuRetargeting.vertexToElementValues(this.m_meanCurvatures, this);
            PuUtil.normalize(this.m_meanCurvatures, true);
        }
        return this.m_meanCurvatures;
    }

    protected double[] largerPrincipalCurvatureValues() {
        if (this.m_lPcValues == null) {
            this.m_pcValues = PuCurvature.elementPrincipalCurvatureValues(this);
            this.m_lPcValues = (double[])this.m_pcValues[0].clone();
            this.m_sPcValues = (double[])this.m_pcValues[1].clone();
            PuUtil.normalize(this.m_pcValues, true);
            PuUtil.normalize(this.m_lPcValues, true);
            PuUtil.normalize(this.m_sPcValues, true);
        }
        return this.m_lPcValues;
    }

    protected double[] smallerPrincipalCurvatureValues() {
        if (this.m_sPcValues == null) {
            this.m_pcValues = PuCurvature.elementPrincipalCurvatureValues(this);
            this.m_lPcValues = (double[])this.m_pcValues[0].clone();
            this.m_sPcValues = (double[])this.m_pcValues[1].clone();
            PuUtil.normalize(this.m_pcValues, true);
            PuUtil.normalize(this.m_lPcValues, true);
            PuUtil.normalize(this.m_sPcValues, true);
        }
        return this.m_sPcValues;
    }

    protected double[] uniform0Values() {
        if (this.m_uniform0Values == null) {
            this.m_uniform0Values = new double[this.m_numElements];
        }
        return this.m_uniform0Values;
    }

    protected double[] uniform05Values() {
        if (this.m_uniform05Values == null) {
            this.m_uniform05Values = new double[this.m_numElements];
            Arrays.fill(this.m_uniform05Values, 0.5);
        }
        return this.m_uniform05Values;
    }

    protected PdVector[][] pcDirections() {
        if (this.m_pcDirections == null) {
            this.m_pcDirections = PuCurvature.elementPrincipalCurvatureDirections(this);
        }
        return this.m_pcDirections;
    }

    protected double[][] pcValues() {
        if (this.m_pcValues == null) {
            this.m_pcValues = PuCurvature.elementPrincipalCurvatureValues(this);
            this.m_lPcValues = (double[])this.m_pcValues[0].clone();
            this.m_sPcValues = (double[])this.m_pcValues[1].clone();
            PuUtil.normalize(this.m_pcValues, true);
            PuUtil.normalize(this.m_lPcValues, true);
            PuUtil.normalize(this.m_sPcValues, true);
        }
        return this.m_pcValues;
    }

    protected PdMatrix[] shapeOperators() {
        if (this.m_shapeOperators == null) {
            this.m_shapeOperators = PuCurvature.elementShapeOperators(this);
        }
        return this.m_shapeOperators;
    }

    protected PdVector[][] stdBasisProjectionDirs() {
        if (this.m_stdBasisProjectionDirs == null) {
            this.computeStdBasisProjectionDirs(this.m_numElements, 3);
        }
        return this.m_stdBasisProjectionDirs;
    }

    protected double[][] stdBasisProjectionLengths() {
        if (this.m_stdBasisProjectionLengths == null) {
            this.computeStdBasisProjectionDirs(this.m_numElements, 3);
        }
        return this.m_stdBasisProjectionLengths;
    }

    private void computeStdBasisProjectionDirs(int numElem, int dim) {
        this.m_stdBasisProjectionDirs = PdVector.alloc((int)dim, (int)numElem, (int)dim);
        this.m_stdBasisProjectionLengths = new double[dim][numElem];
        PdVector direction = new PdVector(dim);
        int i = 0;
        while (i < dim) {
            direction.setConstant(0.0);
            direction.setEntry(i, 1.0);
            PdVector[] dirArr = this.m_stdBasisProjectionDirs[i];
            int e = 0;
            while (e < numElem) {
                PuVectorGeom.projectOntoPlane((PdVector)dirArr[e], (PdVector)direction, (PdVector)this.getElementNormal(e));
                this.m_stdBasisProjectionLengths[i][e] = dirArr[e].length();
                dirArr[e].normalize();
                ++e;
            }
            ++i;
        }
    }

    protected double[][] stdDirsShapeOpValues() {
        if (this.m_stdDirsShapeOpValues == null) {
            this.m_stdDirsShapeOpValues = new double[3][this.m_numElements];
            PdVector[][] directions = this.stdBasisProjectionDirs();
            PdMatrix[] shapeOps = this.shapeOperators();
            int i = 0;
            while (i < 3) {
                int e = 0;
                while (e < this.m_numElements) {
                    PdVector result = (PdVector)directions[i][e].clone();
                    result.leftMultMatrix(shapeOps[e]);
                    this.m_stdDirsShapeOpValues[i][e] = result.length();
                    ++e;
                }
                PuUtil.normalize(this.m_stdDirsShapeOpValues[i], false);
                ++i;
            }
        }
        return this.m_stdDirsShapeOpValues;
    }

    protected double[] getCustomMeasure() {
        return this.m_customMeasure;
    }

    public void setCustomMeasure(double[] measure) {
        if (measure.length != this.m_numElements) {
            throw new IllegalArgumentException();
        }
        this.m_customMeasure = measure;
    }

    public void addUserValues(double[] values) {
        if (values.length != this.m_numElements) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this.m_numElements) {
            if (values[i] >= 0.0) {
                this.m_userValues[i] = values[i];
            }
            ++i;
        }
    }

    protected double[] userValues() {
        if (this.m_userValues == null) {
            this.m_userValues = new double[this.m_numElements];
            Arrays.fill(this.m_userValues, -1.0);
        }
        return this.m_userValues;
    }

    public void setUserValues(double[] values) {
        if (values.length != this.m_numElements) {
            throw new IllegalArgumentException();
        }
        this.m_userValues = values;
    }

    protected int[] importantElements() {
        if (this.m_importantElements == null) {
            this.m_importantElements = new int[0];
        }
        return this.m_importantElements;
    }

    public PiVector getImportantElements() {
        return new PiVector(this.importantElements());
    }

    public void setImportantElements(int[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException();
        }
        this.m_importantElements = elements;
    }

    public double getImportance() {
        return this.m_importance;
    }

    public void setImportance(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException();
        }
        this.m_importance = value;
    }
}

