/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import java.awt.Color;
import java.util.Timer;
import java.util.TimerTask;
import jv.geom.PgElementSet;
import jv.object.PsObject;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;

public class SphereVisualizer
extends PsObject {
    private static final long serialVersionUID = 1L;
    protected PvDisplayIf display;
    protected Color color;
    protected double transparancy;
    protected double radius;
    protected PgElementSet sphere;

    public SphereVisualizer(PvDisplayIf display) {
        this.display = display;
        if (((Object)((Object)this)).getClass() == SphereVisualizer.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.sphere = new PgElementSet(3);
        this.sphere.setName("Sphere visualizer");
        this.sphere.computeSphere(20, 20, 1.0);
        this.sphere.showTransparency(true);
        this.sphere.showEdges(false);
        this.sphere.setVisible(true);
        this.setColor(new Color(1.0f, 0.0f, 1.0f));
        this.setTransparancy(0.6);
    }

    public void flashAt(PdVector position) {
        this.flashAt(position, 500);
    }

    public void flashAt(PdVector position, int milliseconds) {
        final PgElementSet actualSphere = (PgElementSet)this.sphere.clone();
        actualSphere.scale(this.radius);
        actualSphere.translate(position);
        this.display.addGeometry((PgGeometryIf)actualSphere);
        this.display.update((Object)actualSphere);
        TimerTask todo = new TimerTask(){

            @Override
            public void run() {
                SphereVisualizer.this.display.removeGeometry((PgGeometryIf)actualSphere);
                SphereVisualizer.this.display.update((Object)actualSphere);
            }
        };
        Timer timer = new Timer();
        timer.schedule(todo, milliseconds);
    }

    public PvDisplayIf getDisplay() {
        return this.display;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.sphere.setGlobalElementColor(color);
        this.color = color;
    }

    public double getTransparancy() {
        return this.transparancy;
    }

    public void setTransparancy(double transparancy) {
        if (transparancy < 0.0 || transparancy > 1.0) {
            throw new IllegalArgumentException();
        }
        this.sphere.setTransparency(transparancy);
        this.transparancy = transparancy;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }
}

