/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.util.PuUtil;
import java.awt.Color;
import java.util.Timer;
import java.util.TimerTask;
import jv.geom.PgPolygon;
import jv.object.PsObject;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;

public class RingVisualizer
extends PsObject {
    private static final long serialVersionUID = 1L;
    protected static final int numVertices = 30;
    protected PvDisplayIf display;
    protected Color color;
    protected double transparancy;
    protected double radius;
    protected PgPolygon ring;

    public RingVisualizer(PvDisplayIf display) {
        this.display = display;
        if (((Object)((Object)this)).getClass() == RingVisualizer.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.ring = new PgPolygon(3);
        this.ring.setName("Ring visualizer");
        this.ring.computeCircle(30, 1.0);
        this.ring.showTransparency(false);
        this.ring.showEdges(true);
        this.ring.showVertices(false);
        this.ring.setGlobalEdgeSize(5.0);
        this.ring.setVisible(true);
        this.setColor(new Color(1.0f, 0.0f, 1.0f));
    }

    public void flashAt(PdVector position, PdVector normal) {
        this.flashAt(position, normal, 500);
    }

    public void flashAt(PdVector position, PdVector normal, int milliseconds) {
        final PgPolygon actualRing = (PgPolygon)this.ring.clone();
        actualRing.scale(this.radius);
        PdMatrix rotation = PuUtil.rotateVectorIntoVectorMatrix(new PdVector(0.0, 0.0, 1.0), normal);
        PdMatrix modellingMatrix = PuUtil.makeHomogeneousTransform(position, rotation);
        actualRing.setModelMatrix(modellingMatrix);
        actualRing.applyModelingMatrix();
        this.display.addGeometry((PgGeometryIf)actualRing);
        this.display.update((Object)actualRing);
        Timer timer = new Timer();
        TimerTask todo = new TimerTask(){

            @Override
            public void run() {
                RingVisualizer.this.display.removeGeometry((PgGeometryIf)actualRing);
                RingVisualizer.this.display.update((Object)actualRing);
            }
        };
        timer.schedule(todo, milliseconds);
    }

    public PvDisplayIf getDisplay() {
        return this.display;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.ring.setGlobalEdgeColor(color);
        this.color = color;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }
}

