/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.retargeting.PgRetargetingGeometry;
import devRetarget.retargeting.PnRetargeting;
import devRetarget.retargeting.PuRetargeting;
import devRetarget.util.PuGeometry;
import devRetarget.util.PuUtil;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsObject;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgVertexStar;

public class PgBrushGeometry
extends PgRetargetingGeometry {
    private PgVectorField[] m_frames;
    private PdVector[] m_baryCenters;
    private PdMatrix[] m_transformStdToFrames;
    private PdMatrix[] m_transformFramesToStd;
    private boolean m_bTextured;
    private PgVectorField[] m_textureGradients;
    private PdVector m_textureCenter;
    private PdMatrix[] m_transformTextureToFrames;
    private PdMatrix[] m_transformFramesToTexture;
    private int m_minDimension;
    private int m_maxDimension;
    private PiVector m_elementPerVertex;
    private PiVector m_boundaryVertices;
    private boolean[] m_fixedTexture;
    private PdVector[] m_fixedValuesTexture;
    private PdVector m_weightsTexture;

    public PgBrushGeometry() {
        if (((Object)((Object)this)).getClass() == PgBrushGeometry.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.m_frames = null;
        this.m_baryCenters = null;
        this.m_transformStdToFrames = null;
        this.m_transformFramesToStd = null;
        this.m_bTextured = false;
        this.m_textureGradients = null;
        this.m_textureCenter = null;
        this.m_transformTextureToFrames = null;
        this.m_transformFramesToTexture = null;
        this.m_minDimension = -1;
        this.m_maxDimension = -1;
        this.m_elementPerVertex = null;
        this.m_boundaryVertices = null;
        this.m_fixedTexture = null;
        this.m_fixedValuesTexture = null;
        this.m_weightsTexture = null;
    }

    public PgVectorField[] getFrames() {
        return (PgVectorField[])PsObject.clone((PsObject[])this.frames());
    }

    protected PgVectorField[] frames() {
        if (this.m_frames == null) {
            this.m_frames = PuRetargeting.computeLocalFrames(this);
        }
        return this.m_frames;
    }

    public PdVector[] baryCenters() {
        if (this.m_baryCenters == null) {
            this.m_baryCenters = new PdVector[this.m_numElements];
            int e = 0;
            while (e < this.m_numElements) {
                this.m_baryCenters[e] = this.getCenterOfElement(null, e);
                ++e;
            }
        }
        return this.m_baryCenters;
    }

    public PiVector getElementsInSphere(PdVector center, double radius, PdVector distances) {
        PiVector elements = new PiVector();
        PdVector[] baryCenters = this.baryCenters();
        if (distances != null) {
            distances.setSize(0);
            int e = 0;
            while (e < this.m_numElements) {
                double distance = PdVector.subNew((PdVector)baryCenters[e], (PdVector)center).length();
                if (distance < radius) {
                    elements.addEntry(e);
                    distances.addEntry(distance);
                }
                ++e;
            }
        } else {
            int e = 0;
            while (e < this.m_numElements) {
                if (PdVector.subNew((PdVector)baryCenters[e], (PdVector)center).length() < radius) {
                    elements.addEntry(e);
                }
                ++e;
            }
        }
        return elements;
    }

    public PiVector getElementsAround(int centerElement, double maxDistance, PdVector distances) {
        PdVector[] centers = this.baryCenters();
        return PuGeometry.getElementsAround(this, centerElement, maxDistance, centers, distances);
    }

    protected PdMatrix[] transformStdToFrames() {
        PgVectorField[] frames = this.frames();
        if (this.m_transformStdToFrames == null) {
            this.m_transformStdToFrames = new PdMatrix[this.m_numElements];
            this.m_transformFramesToStd = new PdMatrix[this.m_numElements];
            int e = 0;
            while (e < this.m_numElements) {
                PdVector[] localBasis = new PdVector[3];
                int i = 0;
                while (i < 3) {
                    localBasis[i] = frames[i].getVector(e);
                    ++i;
                }
                PdMatrix[] changeMatrices = PuUtil.localBasisChangeMatrices(localBasis);
                this.m_transformStdToFrames[e] = changeMatrices[0];
                this.m_transformFramesToStd[e] = changeMatrices[1];
                ++e;
            }
        }
        return this.m_transformStdToFrames;
    }

    protected PdMatrix[] transformFramesToStd() {
        if (this.m_transformFramesToStd == null) {
            this.transformStdToFrames();
        }
        return this.m_transformFramesToStd;
    }

    public boolean isTextured() {
        return this.m_bTextured;
    }

    public void setTextured(boolean bTextured) {
        this.m_bTextured = bTextured;
    }

    public PgVectorField[] getTextureGradients() {
        if (!this.m_bTextured) {
            return null;
        }
        return (PgVectorField[])PsObject.clone((PsObject[])this.textureGradients());
    }

    protected PgVectorField[] textureGradients() {
        if (!this.m_bTextured) {
            return null;
        }
        if (this.m_textureGradients == null) {
            this.m_textureGradients = PnRetargeting.computeGradientFields(this, this.getVertexTextures());
        }
        return this.m_textureGradients;
    }

    public PdVector getTextureCenter() {
        return (PdVector)this.textureCenter().clone();
    }

    protected PdVector textureCenter() {
        if (!this.m_bTextured) {
            return null;
        }
        if (this.m_textureCenter == null) {
            this.m_textureCenter = PuUtil.getCenter(this.getVertexTextures());
        }
        return this.m_textureCenter;
    }

    protected PdMatrix[] transformTextureToFrames() {
        if (!this.m_bTextured) {
            return null;
        }
        PgVectorField[] frames = this.frames();
        if (this.m_transformTextureToFrames == null) {
            this.m_transformTextureToFrames = new PdMatrix[this.m_numElements];
            this.m_transformFramesToTexture = new PdMatrix[this.m_numElements];
            int e = 0;
            while (e < this.m_numElements) {
                PiVector indices = this.getElement(e);
                PdVector[] triangle = new PdVector[3];
                PdVector[] textureTriangle = new PdVector[3];
                int i = 0;
                while (i < indices.getSize()) {
                    triangle[i] = this.getVertex(indices.getEntry(i));
                    textureTriangle[i] = this.getVertexTexture(indices.getEntry(i));
                    ++i;
                }
                PdVector[] localBasis = new PdVector[2];
                int i2 = 0;
                while (i2 < 2) {
                    PdBaryDir bary = PdBaryDir.getBaryDir(null, (PdVector)frames[i2].getVector(e), (PdVector)triangle[0], (PdVector)triangle[1], (PdVector)triangle[2]);
                    localBasis[i2] = PdBaryDir.getVector(null, (PdBaryDir)bary, (PdVector)textureTriangle[0], (PdVector)textureTriangle[1], (PdVector)textureTriangle[2]);
                    localBasis[i2].normalize();
                    ++i2;
                }
                PdMatrix[] changeMatrices = PuUtil.localBasisChangeMatrices(localBasis);
                this.m_transformTextureToFrames[e] = changeMatrices[0];
                this.m_transformFramesToTexture[e] = changeMatrices[1];
                ++e;
            }
        }
        return this.m_transformTextureToFrames;
    }

    protected PdMatrix[] transformFramesToTexture() {
        if (this.m_transformFramesToTexture == null) {
            this.transformTextureToFrames();
        }
        return this.m_transformFramesToTexture;
    }

    protected int getMinDimension() {
        if (this.m_minDimension == -1) {
            PdVector dims = this.dimensions();
            this.m_minDimension = dims.indexOfMin();
        }
        return this.m_minDimension;
    }

    protected int getMaxDimension() {
        if (this.m_maxDimension == -1) {
            PdVector dims = this.dimensions();
            this.m_maxDimension = dims.indexOfMax();
        }
        return this.m_maxDimension;
    }

    public PdVector textureDirFromGlobalDir(PdVector globalDir, int element) {
        if (!this.m_bTextured) {
            return null;
        }
        PdVector tangent = (PdVector)globalDir.clone();
        PuVectorGeom.projectOntoPlane((PdVector)tangent, (PdVector)globalDir, (PdVector)this.m_frames[2].getVector(element));
        PiVector vertices = this.getElement(element);
        PdVector[] triangle = new PdVector[3];
        PdVector[] textureTriangle = new PdVector[3];
        int i = 0;
        while (i < vertices.getSize()) {
            triangle[i] = this.getVertex(vertices.getEntry(i));
            textureTriangle[i] = this.getVertexTexture(vertices.getEntry(i));
            ++i;
        }
        PdBaryDir bary = PdBaryDir.getBaryDir(null, (PdVector)tangent, (PdVector)triangle[0], (PdVector)triangle[1], (PdVector)triangle[2]);
        PdVector textureDir = PdBaryDir.getVector(null, (PdBaryDir)bary, (PdVector)textureTriangle[0], (PdVector)textureTriangle[1], (PdVector)textureTriangle[2]);
        textureDir.normalize();
        return textureDir;
    }

    protected PiVector elementPerVertex() {
        if (this.m_elementPerVertex == null) {
            this.m_elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)this);
        }
        return this.m_elementPerVertex;
    }

    protected PiVector boundaryVertices() {
        if (this.m_boundaryVertices == null) {
            this.makeNeighbour();
            this.markBoundary();
            this.m_boundaryVertices = new PiVector();
            int v = 0;
            while (v < this.m_numVertices) {
                if (this.hasTagVertex(v, 14)) {
                    this.m_boundaryVertices.addEntry(v);
                }
                ++v;
            }
        }
        return this.m_boundaryVertices;
    }

    public boolean hasBoundary() {
        return this.boundaryVertices().getSize() > 0;
    }

    public void setFixBoundary(boolean fixed) {
        if (!this.hasBoundary()) {
            return;
        }
        if (fixed) {
            this.addFixedVertices(this.boundaryVertices(), null);
        } else {
            this.removeFromFixed(this.boundaryVertices());
        }
    }

    public void setFixTextureBoundary(boolean fixed) {
        if (!this.hasBoundary()) {
            return;
        }
        if (fixed) {
            this.addFixedTextureVertices(this.boundaryVertices());
        } else {
            this.removeFixedTextureVertices(this.boundaryVertices());
        }
    }

    public void setFixedTextureVertices(PiVector vertices) {
        if (!this.m_bTextured) {
            return;
        }
        if (vertices == null) {
            this.setFixedTextureVertices(null, null);
            return;
        }
        PdVector[] positions = new PdVector[vertices.getSize()];
        int i = 0;
        while (i < vertices.getSize()) {
            positions[i] = this.getVertexTexture(vertices.getEntry(i));
            ++i;
        }
        this.setFixedTextureVertices(vertices, positions);
    }

    public void setFixedTextureVertices(PiVector vertices, PdVector[] positions) {
        if (!this.m_bTextured) {
            return;
        }
        this.setFixedToTexture(vertices, positions);
    }

    private void setFixedToTexture(PiVector fixedVertices, PdVector[] positions) {
        if (fixedVertices == null && positions == null) {
            this.setFixed(null, null);
            return;
        }
        if (fixedVertices == null || positions == null || positions.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fixedVertices.getSize() != positions.length) {
            throw new IllegalArgumentException();
        }
        boolean[] fixed = new boolean[this.m_numVertices];
        PdVector[] fixedValues = new PdVector[this.m_dim];
        int d = 0;
        while (d < this.m_dim) {
            fixedValues[d] = new PdVector(this.m_numVertices);
            ++d;
        }
        int i = 0;
        while (i < fixedVertices.getSize()) {
            fixed[fixedVertices.getEntry((int)i)] = true;
            int d2 = 0;
            while (d2 < this.m_dim) {
                fixedValues[d2].setEntry(fixedVertices.getEntry(i), positions[i].getEntry(d2));
                ++d2;
            }
            ++i;
        }
        this.setFixedTexture(fixed, fixedValues);
    }

    public void setFixedTexture(boolean[] fixed, PdVector[] fixedValues) {
        if (fixed != null && this.m_numVertices != fixed.length || fixedValues != null && this.m_numVertices != fixedValues[0].getSize()) {
            throw new IllegalArgumentException();
        }
        this.m_fixedTexture = fixed;
        this.m_fixedValuesTexture = fixedValues;
    }

    public void addFixedTextureVertices(PiVector vertices, PdVector[] positions) {
        if (!this.m_bTextured) {
            return;
        }
        this.addToFixedTexture(vertices, positions);
    }

    public void addFixedTextureVertices(PiVector vertices) {
        PdVector[] positions = new PdVector[vertices.getSize()];
        int i = 0;
        while (i < vertices.getSize()) {
            positions[i] = this.getVertexTexture(vertices.getEntry(i));
            ++i;
        }
        this.addFixedTextureVertices(vertices, positions);
    }

    public void removeFixedTextureVertices(PiVector vertices) {
        if (!this.m_bTextured) {
            return;
        }
        this.removeFromFixedTexture(vertices);
    }

    public boolean hasFixedTextureVertices() {
        return this.hasFixedVerticesTexture();
    }

    public PiVector getFixedTextureVertices() {
        if (!this.m_bTextured) {
            return new PiVector();
        }
        return this.getFixedVerticesTexture();
    }

    public void setTextureWeights(PiVector elements, double weight) {
        PdVector weights = new PdVector(this.m_numElements);
        weights.setConstant(1.0);
        int e = 0;
        while (e < elements.getSize()) {
            weights.setEntry(elements.getEntry(e), weight);
            ++e;
        }
        this.setTextureWeights(weights);
    }

    public void setTextureWeights(PiVector elements, PdVector elementWeights) {
        PdVector weights = new PdVector(this.m_numElements);
        weights.setConstant(1.0);
        int e = 0;
        while (e < elements.getSize()) {
            weights.setEntry(elements.getEntry(e), elementWeights.getEntry(elements.getEntry(e)));
            ++e;
        }
        this.setTextureWeights(weights);
    }

    public void setTextureWeights(PdVector weights) {
        if (weights.getSize() != this.m_numElements) {
            throw new IllegalArgumentException();
        }
        this.setWeightsTexture(weights);
    }

    public void addFixedVerticesTexture(PiVector vertices, PdVector[] positions) {
        if (vertices != null && positions == null) {
            positions = new PdVector[vertices.getSize()];
            int i = 0;
            while (i < vertices.getSize()) {
                positions[i] = this.getVertex(vertices.getEntry(i));
                ++i;
            }
        }
        this.addToFixedTexture(vertices, positions);
    }

    public PdVector getWeightsTexture() {
        return this.m_weightsTexture;
    }

    public void setWeightsTexture(PiVector elements, double weight) {
        PdVector weights = new PdVector(this.m_numElements);
        weights.setConstant(1.0);
        int e = 0;
        while (e < elements.getSize()) {
            weights.setEntry(elements.getEntry(e), weight);
            ++e;
        }
        this.setWeightsTexture(weights);
    }

    public void setWeightsTexture(PdVector weights) {
        if (weights != null && this.m_numElements != weights.getSize()) {
            throw new IllegalArgumentException();
        }
        this.m_weightsTexture = weights;
    }

    public void addToFixedTexture(PiVector fixedVertices, PdVector[] positions) {
        if (fixedVertices == null || positions == null || fixedVertices.getSize() == 0 || positions.length == 0) {
            return;
        }
        int numCoordinates = positions[0].getSize();
        boolean[] fixed = this.m_fixedTexture;
        PdVector[] fixedValues = this.m_fixedValuesTexture;
        if (fixed == null) {
            fixed = new boolean[this.m_numVertices];
        }
        if (fixedValues == null) {
            fixedValues = new PdVector[numCoordinates];
            int d = 0;
            while (d < numCoordinates) {
                fixedValues[d] = new PdVector(this.m_numVertices);
                ++d;
            }
        }
        int i = 0;
        while (i < fixedVertices.getSize()) {
            fixed[fixedVertices.getEntry((int)i)] = true;
            int d = 0;
            while (d < numCoordinates) {
                fixedValues[d].setEntry(fixedVertices.getEntry(i), positions[i].getEntry(d));
                ++d;
            }
            ++i;
        }
        this.setFixedTexture(fixed, fixedValues);
    }

    public void removeFromFixedTexture(PiVector vertices) {
        boolean[] fixed = this.m_fixedTexture;
        PdVector[] fixedValues = this.m_fixedValuesTexture;
        if (fixed == null) {
            return;
        }
        int i = 0;
        while (i < vertices.getSize()) {
            fixed[vertices.getEntry((int)i)] = false;
            ++i;
        }
        this.setFixedTexture(fixed, fixedValues);
    }

    public boolean[] getFixedTexture() {
        return this.m_fixedTexture;
    }

    public PdVector[] getFixedValuesTexture() {
        return this.m_fixedValuesTexture;
    }

    public PiVector getFixedVerticesTexture() {
        PiVector fixed = new PiVector();
        if (this.m_fixedTexture == null) {
            return fixed;
        }
        int i = 0;
        while (i < this.m_numVertices) {
            if (this.m_fixedTexture[i]) {
                fixed.addEntry(i);
            }
            ++i;
        }
        return fixed;
    }

    public boolean hasFixedVerticesTexture() {
        if (this.m_fixedTexture == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_fixedTexture.length) {
            if (this.m_fixedTexture[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

