/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.brushes.PgBrushGeometry;
import java.awt.Color;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.vecmath.PdVector;

public class NormalPicker
extends PsObject {
    protected PgElementSet currentGeometry;
    protected PgBrushGeometry inputGeometry;
    protected PvDisplayIf display;
    protected boolean enabled = false;
    protected PdVector direction;
    protected PgPolygon visualizer = new PgPolygon(3);
    protected int lastPickedElement;
    protected boolean wasJustPicked;
    protected boolean aboutToTerminate;

    protected NormalPicker() {
        this.visualizer.setName("Normal Picker");
        this.visualizer.addUpdateListener((PsUpdateIf)this);
        this.direction = new PdVector(1.0, 1.0, 1.0);
        if (((Object)((Object)this)).getClass() == NormalPicker.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.lastPickedElement = -1;
        this.visualizer.setNumVertices(2);
        this.visualizer.setGlobalEdgeSize(4.0);
        this.visualizer.setGlobalEdgeColor(new Color(1.0f, 0.0f, 0.0f));
        this.visualizer.setGlobalVertexSize(10.0);
        this.visualizer.showVertices(true);
    }

    protected void setGeometries(PgElementSet currentGeometry, PgBrushGeometry inputGeometry) {
        this.currentGeometry = currentGeometry;
        this.inputGeometry = inputGeometry;
        Vector disps = currentGeometry.getDisplayList();
        if (disps == null) {
            return;
        }
        this.display = (PvDisplayIf)disps.elementAt(0);
        if (this.visualizer != null && this.display.containsGeometry((PgGeometryIf)this.visualizer)) {
            this.display.removeGeometry((PgGeometryIf)this.visualizer);
        }
        if (this.enabled) {
            this.display.addGeometry((PgGeometryIf)this.visualizer);
        }
        this.display.update((Object)this.visualizer);
    }

    public void setName(String name) {
        super.setName(name);
        this.visualizer.setName(name);
    }

    protected PdVector getDirection() {
        return (PdVector)this.direction.clone();
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    protected void setEnabled(boolean enabled) {
        if (enabled) {
            if (!this.display.containsGeometry((PgGeometryIf)this.visualizer)) {
                this.display.addGeometry((PgGeometryIf)this.visualizer);
            }
        } else if (this.display.containsGeometry((PgGeometryIf)this.visualizer)) {
            this.display.removeGeometry((PgGeometryIf)this.visualizer);
            this.display.selectGeometry((PgGeometryIf)this.currentGeometry);
        }
        this.enabled = enabled;
        this.display.update((Object)this.visualizer);
    }

    public boolean update(Object source) {
        if (source == this.visualizer) {
            this.wasJustPicked = true;
            this.direction.sub(this.visualizer.getVertex(1), this.visualizer.getVertex(0));
            return true;
        }
        return super.update(source);
    }

    protected void processPickEvent(PvPickEvent event) {
        if (!this.enabled) {
            return;
        }
        int element = event.getElementInd();
        if (element == -1) {
            return;
        }
        if (element == this.lastPickedElement) {
            this.display.selectGeometry((PgGeometryIf)this.visualizer);
            this.display.update((Object)this.visualizer);
            this.startTimer();
            return;
        }
        this.lastPickedElement = element;
        PdVector normal = (PdVector)this.currentGeometry.getElementNormal(element).clone();
        this.direction = (PdVector)normal.clone();
        PdVector center = this.currentGeometry.getCenterOfElement(null, element);
        normal.multScalar(0.1 * this.inputGeometry.getDiameter());
        normal.add(center);
        this.visualizer.setVertex(0, center);
        this.visualizer.setVertex(1, normal);
        this.display.selectGeometry((PgGeometryIf)this.visualizer);
        this.display.update((Object)this.visualizer);
        this.startTimer();
    }

    protected void startTimer() {
        this.wasJustPicked = false;
        Timer timer = new Timer();
        TimerTask todo = new TimerTask(){

            @Override
            public void run() {
                if (NormalPicker.this.wasJustPicked) {
                    NormalPicker.this.wasJustPicked = false;
                    NormalPicker.this.aboutToTerminate = false;
                } else if (NormalPicker.this.aboutToTerminate) {
                    NormalPicker.this.aboutToTerminate = false;
                    NormalPicker.this.display.selectGeometry((PgGeometryIf)NormalPicker.this.currentGeometry);
                    this.cancel();
                } else {
                    NormalPicker.this.aboutToTerminate = true;
                }
            }
        };
        timer.schedule(todo, 2000L, 1000L);
    }
}

