/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import jv.geom.PgElementSet;
import jv.object.PsObject;
import jv.vecmath.PiVector;

public class FlashVisualizer
extends PsObject {
    private static final long serialVersionUID = 1L;
    protected PgElementSet geometry;
    protected Color[] originalColors;
    protected Color color;
    protected Timer timer;
    protected boolean timerIsActive;
    protected HashSet flashedElements;
    protected boolean justFlashed;

    public FlashVisualizer(PgElementSet geometry) {
        this.geometry = geometry;
        this.originalColors = new Color[geometry.getNumElements()];
        int e = 0;
        while (e < geometry.getNumElements()) {
            this.originalColors[e] = geometry.getElementColor(e);
            ++e;
        }
        this.timer = new Timer();
        this.timerIsActive = false;
        this.flashedElements = new HashSet();
        this.justFlashed = false;
        if (((Object)((Object)this)).getClass() == FlashVisualizer.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setColor(new Color(1.0f, 0.0f, 1.0f));
    }

    public void flashAt(PiVector elements) {
        this.flashAt(elements, 500);
    }

    public void flashAt(PiVector elements, int milliseconds) {
        int i = 0;
        while (i < elements.getSize()) {
            int e = elements.getEntry(i);
            this.geometry.setElementColor(e, this.color);
            this.flashedElements.add(new Integer(e));
            ++i;
        }
        this.justFlashed = true;
        this.geometry.update((Object)this.geometry);
        if (!this.timerIsActive) {
            TimerTask todo = new TimerTask(){

                @Override
                public void run() {
                    if (FlashVisualizer.this.justFlashed) {
                        FlashVisualizer.this.justFlashed = false;
                    } else {
                        Iterator i = FlashVisualizer.this.flashedElements.iterator();
                        while (i.hasNext()) {
                            int element = (Integer)i.next();
                            FlashVisualizer.this.geometry.setElementColor(element, FlashVisualizer.this.originalColors[element]);
                        }
                        FlashVisualizer.this.geometry.update((Object)FlashVisualizer.this.geometry);
                        FlashVisualizer.this.flashedElements.clear();
                        FlashVisualizer.this.timerIsActive = false;
                        this.cancel();
                    }
                }
            };
            this.timer.scheduleAtFixedRate(todo, (long)milliseconds / 2L, (long)milliseconds / 2L);
            this.timerIsActive = true;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

