/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.brushes.PgBrushGeometry;
import java.awt.Color;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.object.PsObject;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.vecmath.PdVector;

public class DirectionPicker
extends PsObject {
    protected PgElementSet currentGeometry;
    protected PgBrushGeometry inputGeometry;
    protected PvDisplayIf display;
    protected boolean enabled = false;
    protected PdVector direction;
    protected PgPolygon visualizer = new PgPolygon(3);

    protected DirectionPicker() {
        this.visualizer.setName("Direction Picker");
        this.direction = new PdVector(1.0, 1.0, 1.0);
        if (((Object)((Object)this)).getClass() == DirectionPicker.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.visualizer.setGlobalEdgeSize(2.0);
        this.visualizer.setGlobalEdgeColor(new Color(1.0f, 0.0f, 0.0f));
        this.visualizer.setGlobalVertexSize(5.0);
        this.visualizer.showVertices(true);
    }

    protected void setGeometries(PgElementSet currentGeometry, PgBrushGeometry inputGeometry) {
        this.currentGeometry = currentGeometry;
        this.inputGeometry = inputGeometry;
        Vector disps = currentGeometry.getDisplayList();
        if (disps == null) {
            return;
        }
        this.display = (PvDisplayIf)disps.elementAt(0);
        if (this.visualizer != null && this.display.containsGeometry((PgGeometryIf)this.visualizer)) {
            this.display.removeGeometry((PgGeometryIf)this.visualizer);
        }
        if (this.enabled) {
            this.display.addGeometry((PgGeometryIf)this.visualizer);
        }
        this.display.update((Object)this.visualizer);
    }

    public void setName(String name) {
        super.setName(name);
        this.visualizer.setName(name);
    }

    protected PdVector getDirection() {
        return (PdVector)this.direction.clone();
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    protected void setEnabled(boolean enabled) {
        if (enabled) {
            if (!this.display.containsGeometry((PgGeometryIf)this.visualizer)) {
                this.display.addGeometry((PgGeometryIf)this.visualizer);
            }
        } else if (this.display.containsGeometry((PgGeometryIf)this.visualizer)) {
            this.display.removeGeometry((PgGeometryIf)this.visualizer);
        }
        this.enabled = enabled;
        this.display.update((Object)this.visualizer);
    }

    protected void processPickEvent(PvPickEvent event) {
        if (!this.enabled) {
            return;
        }
        int element = event.getElementInd();
        if (element == -1) {
            return;
        }
        if (this.visualizer.getNumVertices() == 1) {
            PdVector secondVertex = this.currentGeometry.getCenterOfElement(null, element);
            this.visualizer.addVertex(secondVertex);
            this.direction.sub(this.visualizer.getVertex(1), this.visualizer.getVertex(0));
            Timer timer = new Timer();
            TimerTask todo = new TimerTask(){

                @Override
                public void run() {
                    DirectionPicker.this.display.removeGeometry((PgGeometryIf)DirectionPicker.this.visualizer);
                    DirectionPicker.this.display.update((Object)DirectionPicker.this.visualizer);
                }
            };
            timer.schedule(todo, 1500L);
        } else {
            this.visualizer.setNumVertices(0);
            PdVector firstVertex = this.currentGeometry.getCenterOfElement(null, element);
            this.visualizer.addVertex(firstVertex);
            this.display.addGeometry((PgGeometryIf)this.visualizer);
        }
        this.display.update((Object)this.visualizer);
    }
}

