/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.PjBrushes;
import devRetarget.brushes.Brush;
import devRetarget.brushes.DirectionPicker;
import devRetarget.brushes.ElementTransform;
import java.util.Vector;
import jv.project.PvPickEvent;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;

public class BrTwist
extends Brush {
    protected double angle;
    protected double increaseFactor;
    protected boolean invertDirection;
    protected DirectionPicker m_directionPicker;

    public BrTwist() {
        this.setName("Brush Twist");
        this.setType(9);
        this.m_directionPicker = new DirectionPicker();
        this.m_directionPicker.setName("BrTwist: Direction Picker");
        if (((Object)((Object)this)).getClass() == BrTwist.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.angle = 0.0;
        this.increaseFactor = 1.0;
        this.invertDirection = false;
    }

    @Override
    public boolean setDock(PjBrushes dock) {
        super.setDock(dock);
        this.m_directionPicker.setGeometries(this.m_outputGeometry, this.m_inputGeometry);
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_directionPicker.setEnabled(enabled);
    }

    @Override
    public Vector computeTransforms(int centerElement, double radius) {
        return null;
    }

    @Override
    public Vector computeTransforms(PiVector elements) {
        return this.computeTransforms(-1, -1.0, elements);
    }

    protected Vector computeTransforms(int centerElement, double radius, PiVector elements) {
        Vector<ElementTransform> transforms = new Vector<ElementTransform>();
        double radians = this.angle / 180.0 * Math.PI;
        PdVector principalDirection = this.m_directionPicker.getDirection();
        PdVector lineCoordinates = new PdVector(elements.getSize());
        int e = 0;
        while (e < elements.getSize()) {
            lineCoordinates.setEntry(e, principalDirection.dot(this.m_outputGeometry.getCenterOfElement(null, elements.getEntry(e))));
            ++e;
        }
        double minCoord = lineCoordinates.min();
        double maxCoord = lineCoordinates.max();
        double coordRange = maxCoord - minCoord;
        int e2 = 0;
        while (e2 < elements.getSize()) {
            double normedCoord = Math.pow((lineCoordinates.getEntry(e2) - minCoord) / coordRange, this.increaseFactor);
            if (this.invertDirection) {
                normedCoord = 1.0 - normedCoord;
            }
            double currentRadians = radians * normedCoord;
            PdMatrix currentTransform = new PdMatrix(3);
            PuReflect.makeRotation((PdMatrix)currentTransform, (PdVector)principalDirection, (double)currentRadians);
            transforms.addElement(new ElementTransform(elements.getEntry(e2), currentTransform));
            ++e2;
        }
        return transforms;
    }

    @Override
    public void processPickEvent(PvPickEvent event) {
        this.m_directionPicker.processPickEvent(event);
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public boolean isInvertDirection() {
        return this.invertDirection;
    }

    public void setInvertDirection(boolean invertDirection) {
        this.invertDirection = invertDirection;
    }

    public double getIncreaseFactor() {
        return this.increaseFactor;
    }

    public void setIncreaseFactor(double increaseFactor) {
        this.increaseFactor = increaseFactor;
    }
}

