/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.brushes.Brush;
import devRetarget.brushes.ElementTransform;
import devRetarget.util.PuGeometry;
import devRetarget.util.PuUtil;
import java.util.Vector;
import jv.project.PvPickEvent;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class BrTextureVasarely
extends Brush {
    protected int vasaType;
    protected double scaleFactor;
    protected boolean inverse;

    public BrTextureVasarely() {
        this.setName("Brush Texture Vasarely");
        this.setType(7);
        this.setEnabledTexture(true);
        if (((Object)((Object)this)).getClass() == BrTextureVasarely.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.vasaType = 0;
        this.scaleFactor = 1.5;
        this.inverse = false;
    }

    @Override
    public Vector computeTransforms(int centerElement, double radius) {
        return this.computeTransforms(centerElement, radius, null);
    }

    @Override
    public Vector computeTransforms(PiVector elements) {
        return null;
    }

    protected Vector computeTransforms(int centerElement, double radius, PiVector elements) {
        if (!this.m_inputGeometry.isTextured()) {
            return null;
        }
        Vector<ElementTransform> transforms = new Vector<ElementTransform>();
        PdVector distances = new PdVector();
        if (elements == null) {
            elements = PuGeometry.getElementsAround(this.m_inputGeometry, centerElement, radius, this.m_inputGeometry.baryCenters(), distances);
        }
        PdVector[] centers = this.m_inputGeometry.baryCenters();
        double globalScaling = this.scaleFactor;
        int e = 0;
        while (e < elements.getSize()) {
            double factor;
            PdVector radialDirection;
            int currentElement = elements.getEntry(e);
            PdMatrix currentTransform = new PdMatrix(2);
            currentTransform = new PdMatrix(2);
            double scalingFactor = this.inverse ? globalScaling : 1.0 / globalScaling;
            currentTransform.setDiagonal(scalingFactor);
            double normalizedDistance = distances.getEntry(e) / radius;
            PdVector direction = radialDirection = PdVector.subNew((PdVector)centers[currentElement], (PdVector)centers[centerElement]);
            PdVector textureDirection = this.m_inputGeometry.textureDirFromGlobalDir(direction, currentElement);
            switch (this.vasaType) {
                case 2: {
                    factor = 1.0 / Math.pow(globalScaling, 2.0) * Math.pow(normalizedDistance, 0.5) + (1.0 - Math.pow(normalizedDistance, 0.5)) * 1.0;
                    break;
                }
                case 1: {
                    factor = Math.pow(1.0 - Math.pow(normalizedDistance, 2.0), 0.5);
                    break;
                }
                case 0: {
                    factor = 0.1 * Math.pow(normalizedDistance, 2.0) + (1.0 - Math.pow(normalizedDistance, 2.0)) * 1.0;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            factor = Math.max(factor, 0.1);
            factor = this.inverse ? factor : 1.0 / factor;
            PdMatrix transform = PuUtil.scaleInDirectionMatrix(textureDirection, factor);
            currentTransform.leftMult(transform);
            direction = PdVector.crossNew((PdVector)this.m_outputGeometry.getElementNormal(currentElement), (PdVector)radialDirection);
            textureDirection = this.m_inputGeometry.textureDirFromGlobalDir(direction, currentElement);
            factor = 1.0 / globalScaling * normalizedDistance + (1.0 - normalizedDistance) * 1.0;
            factor = this.inverse ? factor : 1.0 / factor;
            transform = PuUtil.scaleInDirectionMatrix(textureDirection, factor);
            currentTransform.leftMult(transform);
            transforms.addElement(new ElementTransform(currentElement, currentTransform));
            ++e;
        }
        return transforms;
    }

    @Override
    public void processPickEvent(PvPickEvent event) {
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        if (scaleFactor < 0.1) {
            throw new IllegalArgumentException();
        }
        this.scaleFactor = scaleFactor;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public int getVasaType() {
        return this.vasaType;
    }

    public void setVasaType(int vasaType) {
        this.vasaType = vasaType;
    }
}

