/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.PjBrushes;
import devRetarget.brushes.Brush;
import devRetarget.brushes.DirectionPicker;
import devRetarget.brushes.ElementTransform;
import devRetarget.util.PuGeometry;
import devRetarget.util.PuUtil;
import java.util.Vector;
import jv.project.PvPickEvent;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class BrTextureScale
extends Brush {
    public static final int DIRECTION_ALL = 7;
    public static final int DIRECTION_TEXTURE_U = 0;
    public static final int DIRECTION_TEXTURE_V = 1;
    public static final int DIRECTION_FRAME1 = 8;
    public static final int DIRECTION_FRAME2 = 2;
    public static final int DIRECTION_X = 3;
    public static final int DIRECTION_Y = 4;
    public static final int DIRECTION_Z = 5;
    public static final int DIRECTION_CUSTOM = 6;
    protected int direction;
    protected double scaleFactor;
    protected boolean fuzzyBrush;
    protected DirectionPicker customDirPicker;

    public BrTextureScale() {
        this.setName("Brush Texture Scale");
        this.setType(3);
        this.setEnabledTexture(true);
        this.customDirPicker = new DirectionPicker();
        this.customDirPicker.setName("BrTextureScale: Direction Picker");
        if (((Object)((Object)this)).getClass() == BrTextureScale.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.direction = 7;
        this.scaleFactor = 1.1;
        this.fuzzyBrush = false;
    }

    @Override
    public boolean setDock(PjBrushes dock) {
        super.setDock(dock);
        this.customDirPicker.setGeometries(this.m_outputGeometry, this.m_inputGeometry);
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.customDirPicker.setEnabled(enabled && this.direction == 6);
    }

    @Override
    public Vector computeTransforms(int centerElement, double radius) {
        return this.computeTransforms(centerElement, radius, null);
    }

    @Override
    public Vector computeTransforms(PiVector elements) {
        return this.computeTransforms(-1, -1.0, elements);
    }

    protected Vector computeTransforms(int centerElement, double radius, PiVector elements) {
        if (!this.m_inputGeometry.isTextured()) {
            return null;
        }
        Vector<ElementTransform> transforms = new Vector<ElementTransform>();
        PdVector distances = new PdVector();
        if (elements == null) {
            elements = PuGeometry.getElementsAround(this.m_inputGeometry, centerElement, radius, this.m_inputGeometry.baryCenters(), distances);
        }
        double actualScaleFactor = 1.0 / this.scaleFactor;
        int e = 0;
        while (e < elements.getSize()) {
            double currentFactor;
            int currentElement = elements.getEntry(e);
            if (this.fuzzyBrush && centerElement != -1) {
                double elementFactor = distances.getEntry(e) / radius;
                double customFactor = 1.0 - elementFactor;
                customFactor = Math.min(customFactor, 0.25);
                currentFactor = 1.0 * (1.0 - (customFactor *= 4.0)) + actualScaleFactor * customFactor;
            } else {
                currentFactor = actualScaleFactor;
            }
            PdMatrix currentTransform = new PdMatrix(2);
            switch (this.direction) {
                case 7: {
                    currentTransform.setDiagonal(currentFactor);
                    break;
                }
                case 0: {
                    currentTransform.setDiagonal(new PdVector(currentFactor, 1.0));
                    break;
                }
                case 1: {
                    currentTransform.setDiagonal(new PdVector(1.0, currentFactor));
                    break;
                }
                default: {
                    PdVector currentDirection;
                    switch (this.direction) {
                        case 8: {
                            currentDirection = (PdVector)this.m_inputGeometry.frames()[0].getVector(currentElement).clone();
                            break;
                        }
                        case 2: {
                            currentDirection = (PdVector)this.m_inputGeometry.frames()[1].getVector(currentElement).clone();
                            break;
                        }
                        case 3: {
                            currentDirection = new PdVector(1.0, 0.0, 0.0);
                            break;
                        }
                        case 4: {
                            currentDirection = new PdVector(1.0, 1.0, 0.0);
                            break;
                        }
                        case 5: {
                            currentDirection = new PdVector(0.0, 0.0, 1.0);
                            break;
                        }
                        case 6: {
                            currentDirection = this.customDirPicker.getDirection();
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    currentDirection = this.m_inputGeometry.textureDirFromGlobalDir(currentDirection, currentElement);
                    currentTransform = PuUtil.scaleInDirectionMatrix(currentDirection, currentFactor);
                }
            }
            transforms.addElement(new ElementTransform(currentElement, currentTransform));
            ++e;
        }
        return transforms;
    }

    @Override
    public void processPickEvent(PvPickEvent event) {
        if (this.direction != 6) {
            this.setDirection(6);
            this.getInfoPanel().update((Object)this);
        }
        this.customDirPicker.processPickEvent(event);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (direction == 6) {
            this.customDirPicker.setEnabled(true);
        } else {
            this.customDirPicker.setEnabled(false);
        }
        this.direction = direction;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        if (scaleFactor < 0.1) {
            throw new IllegalArgumentException();
        }
        this.scaleFactor = scaleFactor;
    }

    public boolean isFuzzyBrush() {
        return this.fuzzyBrush;
    }

    public void setFuzzyBrush(boolean fuzzyBrush) {
        this.fuzzyBrush = fuzzyBrush;
    }
}

