/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.brushes.Brush;
import devRetarget.brushes.ElementTransform;
import devRetarget.util.PuGeometry;
import java.util.Vector;
import jv.project.PvPickEvent;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class BrTextureRotate
extends Brush {
    protected double angle;
    protected boolean fuzzyBrush;

    public BrTextureRotate() {
        this.setName("Brush Texture Rotate");
        this.setType(4);
        if (((Object)((Object)this)).getClass() == BrTextureRotate.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.angle = 0.0;
        this.fuzzyBrush = false;
    }

    @Override
    public Vector computeTransforms(int centerElement, double radius) {
        return this.computeTransforms(centerElement, radius, null);
    }

    @Override
    public Vector computeTransforms(PiVector elements) {
        return this.computeTransforms(-1, -1.0, elements);
    }

    protected Vector computeTransforms(int centerElement, double radius, PiVector elements) {
        if (!this.m_inputGeometry.isTextured()) {
            return null;
        }
        Vector<ElementTransform> transforms = new Vector<ElementTransform>();
        PdVector distances = new PdVector();
        if (elements == null) {
            elements = PuGeometry.getElementsAround(this.m_inputGeometry, centerElement, radius, this.m_inputGeometry.baryCenters(), distances);
        }
        double radians = this.angle / 180.0 * Math.PI;
        int e = 0;
        while (e < elements.getSize()) {
            double currentRadians;
            if (this.fuzzyBrush && centerElement != -1) {
                double elementFactor = distances.getEntry(e) / radius;
                double customFactor = 1.0 - elementFactor;
                customFactor = Math.min(customFactor, 0.25);
                currentRadians = radians * (customFactor *= 4.0);
            } else {
                currentRadians = radians;
            }
            PdMatrix currentTransform = new PdMatrix(2);
            double cos = Math.cos(currentRadians);
            double sin = Math.sin(currentRadians);
            currentTransform.setDiagonal(cos);
            currentTransform.setEntry(0, 1, -sin);
            currentTransform.setEntry(1, 0, sin);
            transforms.addElement(new ElementTransform(elements.getEntry(e), currentTransform));
            ++e;
        }
        return transforms;
    }

    @Override
    public void processPickEvent(PvPickEvent event) {
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public boolean isFuzzyBrush() {
        return this.fuzzyBrush;
    }

    public void setFuzzyBrush(boolean fuzzyBrush) {
        this.fuzzyBrush = fuzzyBrush;
    }
}

