/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.brushes.BrTextureConstraints;
import devRetarget.brushes.Brush_IP;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;

public class BrTextureConstraints_IP
extends Brush_IP
implements ItemListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    protected BrTextureConstraints parent;
    protected Button addToDraggables;
    protected Button removeFromDraggables;
    protected Button projectDraggable;
    protected Button toggleSelectedGeometry;
    protected PuDouble radius;
    protected PuDouble weight;
    protected Checkbox autoProject;
    protected Checkbox hideTexture;
    protected Checkbox showWeights;

    public BrTextureConstraints_IP() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        layoutConstraints.gridy = 0;
        this.addToDraggables = new Button("Add to draggables");
        this.addToDraggables.addActionListener(this);
        this.add(this.addToDraggables, layoutConstraints);
        ++layoutConstraints.gridy;
        this.removeFromDraggables = new Button("Remove from draggables");
        this.removeFromDraggables.addActionListener(this);
        this.add(this.removeFromDraggables, layoutConstraints);
        ++layoutConstraints.gridy;
        this.projectDraggable = new Button("Project draggable");
        this.projectDraggable.addActionListener(this);
        this.add(this.projectDraggable, layoutConstraints);
        ++layoutConstraints.gridy;
        this.toggleSelectedGeometry = new Button("Toggle selected geometry");
        this.toggleSelectedGeometry.addActionListener(this);
        this.add(this.toggleSelectedGeometry, layoutConstraints);
        ++layoutConstraints.gridy;
        this.radius = new PuDouble("Radius", (PsUpdateIf)this);
        this.add((Component)this.radius.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.weight = new PuDouble("Weight", (PsUpdateIf)this);
        this.add((Component)this.weight.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.autoProject = new Checkbox("Project automatically");
        this.autoProject.addItemListener(this);
        this.add(this.autoProject, layoutConstraints);
        ++layoutConstraints.gridy;
        this.hideTexture = new Checkbox("Hide texture");
        this.hideTexture.addItemListener(this);
        this.add(this.hideTexture, layoutConstraints);
        ++layoutConstraints.gridy;
        this.showWeights = new Checkbox("Show weights");
        this.showWeights.addItemListener(this);
        this.add(this.showWeights, layoutConstraints);
        this.validate();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.parent = (BrTextureConstraints)parent;
        this.init();
    }

    public void init() {
        super.init();
        this.setName("InfoPanel for Brush Flatten");
        this.weight.setDefBounds(0.0, 20.0, 0.5, 0.5);
        this.weight.setDefValue(this.parent.getWeight());
        this.weight.init();
        this.radius.setDefBounds(0.0, 15.0, 0.5, 0.5);
        this.radius.setDefValue(this.parent.getRadius());
        this.radius.init();
    }

    public boolean update(Object eventSource) {
        if (eventSource == this.parent) {
            this.weight.setValue(this.parent.getWeight());
            this.radius.setValue(this.parent.getRadius());
            this.autoProject.setState(this.parent.isAutoProject());
            this.hideTexture.setState(this.parent.isHideTexture());
            this.showWeights.setState(this.parent.isShowWeights());
        }
        if (eventSource == this.weight) {
            this.parent.setWeight(this.weight.getValue());
        }
        if (eventSource == this.radius) {
            this.parent.setRadius(this.radius.getValue());
        }
        return super.update(eventSource);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.autoProject) {
            this.parent.setAutoProject(this.autoProject.getState());
            return;
        }
        if (source == this.hideTexture) {
            this.parent.setHideTexture(this.hideTexture.getState());
            return;
        }
        if (source == this.showWeights) {
            this.parent.setShowWeights(this.showWeights.getState());
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.addToDraggables) {
            this.parent.addToDraggables();
            return;
        }
        if (source == this.removeFromDraggables) {
            this.parent.removeFromDraggables();
            return;
        }
        if (source == this.projectDraggable) {
            this.parent.projectDraggables();
            return;
        }
        if (source == this.toggleSelectedGeometry) {
            this.parent.toggleSelectedGeometry();
            return;
        }
    }
}

