/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devProjection.PnProjection;
import devRetarget.PjBrushes;
import devRetarget.brushes.Brush;
import devRetarget.retargeting.PuRetargeting;
import devRetarget.util.PuGeometry;
import java.awt.Color;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class BrTextureConstraints
extends Brush
implements PvPickListenerIf {
    protected PvDisplayIf m_display;
    protected PiVector m_draggedVertices;
    protected PgPointSet m_draggables;
    protected int m_numVertices;
    protected double m_radius;
    protected double m_weight;
    protected boolean m_autoProject;
    protected boolean m_hideTexture;
    protected boolean m_showWeights;
    protected Color[] m_originalColors;

    public BrTextureConstraints() {
        this.setName("Brush Texture Constraints");
        this.setType(10);
        this.setEnabledTexture(false);
        this.m_draggedVertices = new PiVector();
        this.m_draggables = new PgPointSet(3);
        this.m_draggables.setName("Draggables");
        if (((Object)((Object)this)).getClass() == BrTextureConstraints.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_draggables.setGlobalVertexColor(new Color(1.0f, 0.0f, 0.0f));
        this.m_draggables.setGlobalVertexSize(6.0);
        this.m_draggables.setVisible(true);
        this.m_weight = 10.0;
        this.m_radius = 4.0;
        this.m_autoProject = true;
        this.m_hideTexture = false;
        this.m_showWeights = false;
    }

    @Override
    public boolean setDock(PjBrushes dock) {
        super.setDock(dock);
        if (this.m_outputGeometry != null) {
            this.m_display = (PvDisplayIf)this.m_outputGeometry.getDisplayList().elementAt(0);
            this.m_numVertices = this.m_outputGeometry.getNumVertices();
            this.m_originalColors = (Color[])this.m_outputGeometry.getElementColors().clone();
            this.m_display.selectGeometry((PgGeometryIf)this.m_outputGeometry);
            if (!this.m_display.hasPickListener((PvPickListenerIf)this)) {
                this.m_display.addPickListener((PvPickListenerIf)this);
            }
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.isEnabled()) {
            if (!this.m_display.containsGeometry((PgGeometryIf)this.m_draggables)) {
                this.m_display.addGeometry((PgGeometryIf)this.m_draggables);
            }
            if (!this.m_display.hasPickListener((PvPickListenerIf)this)) {
                this.m_display.addPickListener((PvPickListenerIf)this);
            }
            this.updateWeightsDisplay();
        } else {
            if (this.m_display.containsGeometry((PgGeometryIf)this.m_draggables)) {
                this.m_display.removeGeometry((PgGeometryIf)this.m_draggables);
            }
            if (this.m_display.hasPickListener((PvPickListenerIf)this)) {
                this.m_display.removePickListener((PvPickListenerIf)this);
            }
            if (this.m_showWeights) {
                this.m_outputGeometry.setElementColors(this.m_originalColors);
                this.m_display.update((Object)this.m_outputGeometry);
            }
        }
    }

    @Override
    public Vector computeTransforms(int centerElement, double radius) {
        return null;
    }

    @Override
    public Vector computeTransforms(PiVector elements) {
        return this.computeTransforms(-1, -1.0, elements);
    }

    protected Vector computeTransforms(int centerElement, double radius, PiVector elements) {
        PdBary[] projected = PnProjection.projectPointSetOntoElementSet((PgPointSet)this.m_draggables, (PgElementSet)this.m_outputGeometry, (boolean)false);
        PdVector[] textureConstraints = new PdVector[projected.length];
        int i = 0;
        while (i < projected.length) {
            int element = projected[i].getElementInd();
            PiVector vertices = this.m_outputGeometry.getElement(element);
            PdVector[] textureVertices = new PdVector[vertices.getSize()];
            int j = 0;
            while (j < vertices.getSize()) {
                textureVertices[j] = this.m_outputGeometry.getVertexTexture(vertices.getEntry(j));
                ++j;
            }
            textureConstraints[i] = projected[i].getVertex(null, textureVertices[0], textureVertices[1], textureVertices[2]);
            ++i;
        }
        this.m_inputGeometry.addFixedTextureVertices(this.m_draggedVertices, textureConstraints);
        radius = this.m_radius / 100.0 * this.m_inputGeometry.getDiameter();
        PdVector weights = PuRetargeting.computeWeightsFromVertices(this.m_inputGeometry, this.m_draggedVertices, this.m_weight, radius);
        this.updateWeightsDisplay(weights);
        this.m_inputGeometry.setTextureWeights(weights);
        int i2 = 0;
        while (i2 < this.m_draggedVertices.getSize()) {
            this.m_draggables.setVertex(i2, this.m_outputGeometry.getVertex(this.m_draggedVertices.getEntry(i2)));
            ++i2;
        }
        PuGeometry.setMarkedVertices(this.m_draggables, null);
        this.m_display.update((Object)this.m_draggables);
        return null;
    }

    @Override
    public void processPickEvent(PvPickEvent event) {
        if (event.getGeometry() != this.m_outputGeometry) {
            return;
        }
    }

    public void addToDraggables() {
        PiVector markedVertices = this.m_outputGeometry.getMarkedVertices(1);
        int numMarked = markedVertices.getSize();
        int i = 0;
        while (i < numMarked) {
            int index = markedVertices.getEntry(i);
            int pos = this.m_draggedVertices.getIndexOf(index);
            if (pos == -1) {
                this.m_draggedVertices.addEntry(index);
                this.m_draggables.addVertex(this.m_outputGeometry.getVertex(index));
            }
            ++i;
        }
        PuGeometry.setMarkedVertices((PgPointSet)this.m_outputGeometry, null);
        this.m_display.selectGeometry((PgGeometryIf)this.m_draggables);
        PuGeometry.setMarkedVertices(this.m_draggables, null);
        this.m_display.update((Object)this.m_outputGeometry);
        this.m_display.update((Object)this.m_draggables);
    }

    public void removeFromDraggables() {
        int i = 0;
        while (i < this.m_draggables.getNumVertices()) {
            if (this.m_draggables.hasTagVertex(i, 1)) {
                this.m_draggables.removeVertex(i);
                this.m_draggedVertices.removeEntry(i);
                --i;
            }
            ++i;
        }
        this.m_display.update((Object)this.m_draggables);
    }

    public void fixMarkedDraggables() {
        PiVector markedVertices = this.m_draggables.getMarkedVertices(1);
        int numMarked = markedVertices.getSize();
        PiVector fixed = new PiVector(numMarked);
        PdVector[] positions = new PdVector[numMarked];
        int i = 0;
        while (i < numMarked) {
            int index = markedVertices.getEntry(i);
            fixed.setEntry(i, this.m_draggedVertices.getEntry(index));
            positions[i] = this.m_draggables.getVertex(index);
            this.m_draggedVertices.removeEntry(index);
            this.m_draggables.removeVertex(index);
            ++i;
        }
        this.m_display.update((Object)this.m_draggables);
    }

    public void projectDraggables() {
        PiVector markedVertices = this.m_draggables.getMarkedVertices(1);
        PdBary[] projected = PnProjection.projectPointSetOntoElementSet((PgPointSet)this.m_draggables, (PgElementSet)this.m_outputGeometry, (boolean)false);
        int i = 0;
        while (i < projected.length) {
            int element = projected[i].getElementInd();
            PdVector[] vertices = this.m_outputGeometry.getElementVertices(element);
            PdVector v = projected[i].getVertex(null, vertices[0], vertices[1], vertices[2]);
            this.m_draggables.setVertex(i, v);
            ++i;
        }
        PuGeometry.setMarkedVertices(this.m_draggables, markedVertices);
        this.m_display.update((Object)this.m_draggables);
    }

    public void toggleSelectedGeometry() {
        if (this.m_display.getSelectedGeometry() == this.m_draggables) {
            this.m_display.selectGeometry((PgGeometryIf)this.m_outputGeometry);
        } else {
            this.m_display.selectGeometry((PgGeometryIf)this.m_draggables);
        }
    }

    public double getWeight() {
        return this.m_weight;
    }

    public void setWeight(double weight) {
        this.m_weight = weight;
        this.updateWeightsDisplay();
    }

    public boolean isAutoProject() {
        return this.m_autoProject;
    }

    public void setAutoProject(boolean autoProject) {
        this.m_autoProject = autoProject;
    }

    protected void updateWeightsDisplay(PdVector weights) {
        if (this.m_showWeights) {
            int w = 0;
            while (w < weights.getSize()) {
                float factor = (float)(1.0 - (weights.getEntry(w) - 1.0) / this.m_weight);
                Color c = new Color(0.9019608f, 0.9019608f * factor, 0.9411765f * factor);
                this.m_outputGeometry.setElementColor(w, c);
                ++w;
            }
            this.m_outputGeometry.showElementColors(true);
            this.m_display.update((Object)this.m_outputGeometry);
        }
    }

    protected void updateWeightsDisplay() {
        if (this.m_showWeights) {
            double radius = this.m_radius / 100.0 * this.m_inputGeometry.getDiameter();
            PdVector weights = PuRetargeting.computeWeightsFromVertices(this.m_inputGeometry, this.m_draggedVertices, this.m_weight, radius);
            this.updateWeightsDisplay(weights);
        }
    }

    public void dragVertex(PgGeometryIf geom, int index, PdVector vertex) {
        if (geom != this.m_draggables || !this.m_autoProject) {
            return;
        }
        this.projectDraggables();
    }

    public void pickInitial(PvPickEvent pos) {
        PgGeometryIf geom = pos.getGeometry();
        if (geom != this.m_outputGeometry) {
            return;
        }
        int vertex = pos.getVertexInd();
        if (vertex != -1) {
            this.m_outputGeometry.setTagVertex(vertex, 1);
            this.m_display.update((Object)this.m_outputGeometry);
        }
    }

    public void dragDisplay(PvPickEvent pos) {
    }

    public void dragInitial(PvPickEvent pos) {
    }

    public void markVertices(PvPickEvent pos) {
    }

    public void pickDisplay(PvPickEvent pos) {
    }

    public void pickVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void selectGeometry(PgGeometryIf geom) {
    }

    public void unmarkVertices(PvPickEvent pos) {
    }

    public boolean isHideTexture() {
        return this.m_hideTexture;
    }

    public void setHideTexture(boolean hideTexture) {
        this.m_outputGeometry.showVertexTexture(!hideTexture);
        this.m_display.update((Object)this.m_outputGeometry);
        this.m_hideTexture = hideTexture;
    }

    public double getRadius() {
        return this.m_radius;
    }

    public void setRadius(double radius) {
        this.m_radius = radius;
        this.updateWeightsDisplay();
    }

    public boolean isShowWeights() {
        return this.m_showWeights;
    }

    public void setShowWeights(boolean showWeights) {
        this.m_showWeights = showWeights;
        if (showWeights) {
            this.updateWeightsDisplay();
        } else {
            this.m_outputGeometry.setElementColors(this.m_originalColors);
            this.m_display.update((Object)this.m_outputGeometry);
        }
    }
}

