/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.brushes.Brush;
import devRetarget.brushes.ElementTransform;
import devRetarget.util.PuGeometry;
import devRetarget.util.PuUtil;
import java.util.Vector;
import jv.project.PvPickEvent;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class BrSmooth
extends Brush {
    protected int imprintSize;
    protected double maxAngle;

    public BrSmooth() {
        this.setName("Brush Smooth");
        this.setType(6);
        if (((Object)((Object)this)).getClass() == BrSmooth.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.imprintSize = 2;
        this.maxAngle = 60.0;
    }

    @Override
    public Vector computeTransforms(int centerElement, double radius) {
        return this.computeTransforms(centerElement, radius, null);
    }

    @Override
    public Vector computeTransforms(PiVector elements) {
        return this.computeTransforms(-1, -1.0, elements);
    }

    protected Vector computeTransforms(int centerElement, double radius, PiVector elements) {
        Vector<ElementTransform> transforms = new Vector<ElementTransform>();
        PdVector distances = new PdVector();
        if (elements == null) {
            elements = PuGeometry.getElementsAround(this.m_inputGeometry, centerElement, radius, this.m_inputGeometry.baryCenters(), distances);
        }
        PdVector[] normals = this.m_outputGeometry.getElementNormals();
        int e = 0;
        while (e < elements.getSize()) {
            PdMatrix transform = new PdMatrix(3);
            int element = elements.getEntry(e);
            int[] neighbours = PuGeometry.getElementNeighbourhood(this.m_outputGeometry, element, this.imprintSize);
            PdVector[] neighbourNormals = new PdVector[neighbours.length];
            PdVector center = this.m_outputGeometry.getCenterOfElement(null, element);
            PdVector neighbourDistances = new PdVector(neighbours.length);
            int i = 0;
            while (i < neighbours.length) {
                neighbourNormals[i] = normals[neighbours[i]];
                PdVector neighbourCenter = this.m_outputGeometry.getCenterOfElement(null, neighbours[i]);
                neighbourCenter.sub(center);
                neighbourDistances.setEntry(i, neighbourCenter.length());
                ++i;
            }
            double maxDistance = neighbourDistances.max();
            int i2 = 0;
            while (i2 < neighbours.length) {
                neighbourDistances.setEntry(i2, 1.0 - neighbourDistances.getEntry(i2) / maxDistance);
                if (PdVector.angle((PdVector)normals[element], (PdVector)neighbourNormals[i2]) > this.maxAngle) {
                    neighbourDistances.setEntry(i2, 0.0);
                }
                ++i2;
            }
            PdVector meanNormal = PuUtil.weightedMeanOf(neighbourNormals, neighbourDistances.m_data);
            transform = PuUtil.rotateVectorIntoVectorMatrix(normals[element], meanNormal);
            transforms.addElement(new ElementTransform(element, transform));
            ++e;
        }
        return transforms;
    }

    @Override
    public void processPickEvent(PvPickEvent event) {
    }

    public int getImprintSize() {
        return this.imprintSize;
    }

    public void setImprintSize(int imprintSize) {
        if (imprintSize < 1) {
            throw new IllegalArgumentException();
        }
        this.imprintSize = imprintSize;
    }

    public double getMaxAngle() {
        return this.maxAngle;
    }

    public void setMaxAngle(double maxAngle) {
        this.maxAngle = maxAngle;
    }
}

