/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.brushes.BrScale;
import devRetarget.brushes.Brush_IP;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;

public class BrScale_IP
extends Brush_IP
implements ItemListener {
    private static final long serialVersionUID = 1L;
    protected static final int[] directionsMapping;
    protected BrScale parent;
    protected Choice direction;
    protected PuDouble scaleFactor;
    protected Checkbox fuzzyBrush;
    protected Checkbox projectDirection;

    static {
        int[] nArray = new int[8];
        nArray[0] = 7;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 4;
        nArray[6] = 5;
        nArray[7] = 6;
        directionsMapping = nArray;
    }

    protected static int directionsToIndex(int direction) {
        int i = 0;
        while (i < directionsMapping.length) {
            if (directionsMapping[i] == direction) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToDirections(int index) {
        if (index < directionsMapping.length) {
            return directionsMapping[index];
        }
        throw new IllegalArgumentException();
    }

    public BrScale_IP() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        layoutConstraints.gridwidth = 1;
        layoutConstraints.gridy = 0;
        layoutConstraints.gridx = 0;
        this.add(new Label("Scaling directions:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.direction = new Choice();
        this.direction.add("All");
        this.direction.add("Tangential");
        this.direction.add("Larger Princ. Curv. (red)");
        this.direction.add("Smaller Princ. Curv. (green)");
        this.direction.add("X");
        this.direction.add("Y");
        this.direction.add("Z");
        this.direction.add("Custom");
        this.direction.addItemListener(this);
        this.add(this.direction, layoutConstraints);
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        ++layoutConstraints.gridy;
        this.scaleFactor = new PuDouble("Scaling factor", (PsUpdateIf)this);
        this.add((Component)this.scaleFactor.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.fuzzyBrush = new Checkbox("Use fuzzy brush");
        this.fuzzyBrush.addItemListener(this);
        this.add(this.fuzzyBrush, layoutConstraints);
        ++layoutConstraints.gridy;
        this.projectDirection = new Checkbox("Project directions onto elements");
        this.projectDirection.addItemListener(this);
        this.add(this.projectDirection, layoutConstraints);
        this.validate();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.parent = (BrScale)parent;
        this.init();
    }

    public void init() {
        super.init();
        this.setName("InfoPanel for Retargeting Method Scalar");
        this.scaleFactor.setDefBounds(0.8, 1.3, 0.01, 0.01);
        this.scaleFactor.setDefValue(this.parent.getScaleFactor());
        this.scaleFactor.init();
    }

    public boolean update(Object eventSource) {
        if (eventSource == this.parent) {
            this.direction.select(BrScale_IP.directionsToIndex(this.parent.getDirection()));
            this.scaleFactor.setValue(this.parent.getScaleFactor());
            this.fuzzyBrush.setState(this.parent.isFuzzyBrush());
            this.projectDirection.setState(this.parent.isProjectDirection());
        }
        if (eventSource == this.scaleFactor) {
            this.parent.setScaleFactor(this.scaleFactor.getValue());
        }
        return super.update(eventSource);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.direction) {
            this.parent.setDirection(BrScale_IP.indexToDirections(this.direction.getSelectedIndex()));
            return;
        }
        if (source == this.projectDirection) {
            this.parent.setProjectDirection(this.projectDirection.getState());
            return;
        }
        if (source == this.fuzzyBrush) {
            this.parent.setFuzzyBrush(this.fuzzyBrush.getState());
            return;
        }
    }
}

