/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.PjBrushes;
import devRetarget.brushes.Brush;
import devRetarget.brushes.DirectionPicker;
import devRetarget.brushes.ElementTransform;
import devRetarget.util.PuGeometry;
import devRetarget.util.PuUtil;
import java.util.Vector;
import jv.project.PvPickEvent;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class BrScale
extends Brush {
    public static final int DIRECTION_ALL = 7;
    public static final int DIRECTION_FRAME12 = 0;
    public static final int DIRECTION_FRAME1 = 1;
    public static final int DIRECTION_FRAME2 = 2;
    public static final int DIRECTION_X = 3;
    public static final int DIRECTION_Y = 4;
    public static final int DIRECTION_Z = 5;
    public static final int DIRECTION_CUSTOM = 6;
    protected int direction;
    protected double scaleFactor;
    protected boolean fuzzyBrush;
    protected boolean projectDirection;
    protected boolean respectProjectionLength;
    protected DirectionPicker customDirPicker;

    public BrScale() {
        this.setName("Brush Scale");
        this.setType(0);
        this.customDirPicker = new DirectionPicker();
        this.customDirPicker.setName("BrScale: Direction Picker");
        if (((Object)((Object)this)).getClass() == BrScale.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.direction = 7;
        this.scaleFactor = 1.05;
        this.fuzzyBrush = false;
        this.projectDirection = false;
    }

    @Override
    public boolean setDock(PjBrushes dock) {
        super.setDock(dock);
        this.customDirPicker.setGeometries(this.m_outputGeometry, this.m_inputGeometry);
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.customDirPicker.setEnabled(enabled && this.direction == 6);
    }

    @Override
    public Vector computeTransforms(int centerElement, double radius) {
        return this.computeTransforms(centerElement, radius, null);
    }

    @Override
    public Vector computeTransforms(PiVector elements) {
        return this.computeTransforms(-1, -1.0, elements);
    }

    protected Vector computeTransforms(int centerElement, double radius, PiVector elements) {
        Vector<ElementTransform> transforms = new Vector<ElementTransform>();
        PdVector distances = new PdVector();
        if (elements == null) {
            elements = PuGeometry.getElementsAround(this.m_inputGeometry, centerElement, radius, this.m_inputGeometry.baryCenters(), distances);
        }
        PdVector[] normals = this.m_outputGeometry.getElementNormals();
        int e = 0;
        while (e < elements.getSize()) {
            double currentFactor;
            int currentElement = elements.getEntry(e);
            if (this.fuzzyBrush && centerElement != -1) {
                double elementFactor = distances.getEntry(e) / radius;
                currentFactor = 1.0 * elementFactor + this.scaleFactor * (1.0 - elementFactor);
            } else {
                currentFactor = this.scaleFactor;
            }
            PdMatrix currentTransform = new PdMatrix(3);
            switch (this.direction) {
                case 7: {
                    currentTransform.setDiagonal(currentFactor);
                    break;
                }
                case 0: {
                    PdVector dir1 = (PdVector)this.m_inputGeometry.frames()[0].getVector(currentElement).clone();
                    PdVector dir2 = (PdVector)this.m_inputGeometry.frames()[1].getVector(currentElement).clone();
                    currentTransform = PuUtil.scaleInDirectionMatrix(dir1, currentFactor);
                    PdMatrix t2 = PuUtil.scaleInDirectionMatrix(dir2, currentFactor);
                    currentTransform.leftMult(t2);
                    break;
                }
                default: {
                    PdVector currentDirection;
                    switch (this.direction) {
                        case 1: {
                            currentDirection = (PdVector)this.m_inputGeometry.frames()[0].getVector(currentElement).clone();
                            break;
                        }
                        case 2: {
                            currentDirection = (PdVector)this.m_inputGeometry.frames()[1].getVector(currentElement).clone();
                            break;
                        }
                        case 3: {
                            currentDirection = new PdVector(1.0, 0.0, 0.0);
                            if (!this.projectDirection) break;
                            PuVectorGeom.projectOntoPlane((PdVector)currentDirection, (PdVector)currentDirection, (PdVector)normals[currentElement]);
                            break;
                        }
                        case 4: {
                            currentDirection = new PdVector(0.0, 1.0, 0.0);
                            if (!this.projectDirection) break;
                            PuVectorGeom.projectOntoPlane((PdVector)currentDirection, (PdVector)currentDirection, (PdVector)normals[currentElement]);
                            break;
                        }
                        case 5: {
                            currentDirection = new PdVector(0.0, 0.0, 1.0);
                            if (!this.projectDirection) break;
                            PuVectorGeom.projectOntoPlane((PdVector)currentDirection, (PdVector)currentDirection, (PdVector)normals[currentElement]);
                            break;
                        }
                        case 6: {
                            currentDirection = this.customDirPicker.getDirection();
                            if (!this.projectDirection) break;
                            PuVectorGeom.projectOntoPlane((PdVector)currentDirection, (PdVector)currentDirection, (PdVector)normals[currentElement]);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    currentTransform = PuUtil.scaleInDirectionMatrix(currentDirection, currentFactor);
                }
            }
            transforms.addElement(new ElementTransform(currentElement, currentTransform));
            ++e;
        }
        return transforms;
    }

    @Override
    public void processPickEvent(PvPickEvent event) {
        if (this.direction != 6) {
            this.setDirection(6);
            this.getInfoPanel().update((Object)this);
        }
        this.customDirPicker.processPickEvent(event);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
        this.customDirPicker.setEnabled(this.isEnabled() && direction == 6);
    }

    public boolean isProjectDirection() {
        return this.projectDirection;
    }

    public void setProjectDirection(boolean projectDirection) {
        this.projectDirection = projectDirection;
    }

    public boolean isFuzzyBrush() {
        return this.fuzzyBrush;
    }

    public void setFuzzyBrush(boolean fuzzyBrush) {
        this.fuzzyBrush = fuzzyBrush;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        if (scaleFactor < 0.0) {
            throw new IllegalArgumentException();
        }
        this.scaleFactor = scaleFactor;
    }
}

