/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.brushes.BrRotate;
import devRetarget.brushes.Brush_IP;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;

public class BrRotate_IP
extends Brush_IP
implements ItemListener {
    private static final long serialVersionUID = 1L;
    protected static final int[] axisMapping = new int[]{1, 2, 3, 4, 5, 6};
    protected BrRotate parent;
    protected PuDouble angle;
    protected Choice axis;
    protected Checkbox fuzzyBrush;

    protected static int axisToIndex(int axis) {
        int i = 0;
        while (i < axisMapping.length) {
            if (axisMapping[i] == axis) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToAxis(int index) {
        if (index < axisMapping.length) {
            return axisMapping[index];
        }
        throw new IllegalArgumentException();
    }

    public BrRotate_IP() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        layoutConstraints.gridwidth = 1;
        layoutConstraints.gridy = 0;
        layoutConstraints.gridx = 0;
        this.add(new Label("Rotation Axis:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.axis = new Choice();
        this.axis.add("Normals");
        this.axis.add("Normal of central Element");
        this.axis.add("X");
        this.axis.add("Y");
        this.axis.add("Z");
        this.axis.add("Custom");
        this.axis.addItemListener(this);
        this.add(this.axis, layoutConstraints);
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        ++layoutConstraints.gridy;
        this.angle = new PuDouble("Rotate by (deg):", (PsUpdateIf)this);
        this.add((Component)this.angle.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.fuzzyBrush = new Checkbox("Use fuzzy brush");
        this.fuzzyBrush.addItemListener(this);
        this.add(this.fuzzyBrush, layoutConstraints);
        this.validate();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.parent = (BrRotate)parent;
        this.init();
    }

    public void init() {
        super.init();
        this.setName("InfoPanel for Brush Rotate");
        this.angle.setDefBounds(-9.0, 9.0, 0.1, 0.1);
        this.angle.setDefValue(this.parent.getAngle());
        this.angle.init();
    }

    public boolean update(Object eventSource) {
        if (eventSource == this.parent) {
            this.angle.setValue(this.parent.getAngle());
            this.axis.select(BrRotate_IP.axisToIndex(this.parent.getAxis()));
            this.fuzzyBrush.setState(this.parent.isFuzzyBrush());
        }
        if (eventSource == this.angle) {
            this.parent.setAngle(this.angle.getValue());
        }
        return super.update(eventSource);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.axis) {
            this.parent.setAxis(BrRotate_IP.indexToAxis(this.axis.getSelectedIndex()));
        }
        if (source == this.fuzzyBrush) {
            this.parent.setFuzzyBrush(this.fuzzyBrush.getState());
            return;
        }
    }
}

