/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.PjBrushes;
import devRetarget.brushes.Brush;
import devRetarget.brushes.ElementTransform;
import devRetarget.brushes.NormalPicker;
import devRetarget.util.PuGeometry;
import java.util.Vector;
import jv.project.PvPickEvent;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;

public class BrRotate
extends Brush {
    public static final int AXIS_NORMALS = 1;
    public static final int AXIS_NORMAL = 2;
    public static final int AXIS_X = 3;
    public static final int AXIS_Y = 4;
    public static final int AXIS_Z = 5;
    public static final int AXIS_CUSTOM = 6;
    protected double angle;
    protected int axis;
    protected boolean fuzzyBrush;
    protected NormalPicker customNormalPicker;

    public BrRotate() {
        this.setName("Brush Rotate");
        this.setType(1);
        this.customNormalPicker = new NormalPicker();
        this.customNormalPicker.setName("BrRotate: Normal Picker");
        if (((Object)((Object)this)).getClass() == BrRotate.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.axis = 1;
        this.angle = 0.0;
        this.fuzzyBrush = false;
    }

    @Override
    public boolean setDock(PjBrushes dock) {
        super.setDock(dock);
        this.customNormalPicker.setGeometries(this.m_outputGeometry, this.m_inputGeometry);
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.customNormalPicker.setEnabled(enabled && this.axis == 6);
    }

    @Override
    public Vector computeTransforms(int centerElement, double radius) {
        return this.computeTransforms(centerElement, radius, null);
    }

    @Override
    public Vector computeTransforms(PiVector elements) {
        return this.computeTransforms(-1, -1.0, elements);
    }

    protected Vector computeTransforms(int centerElement, double radius, PiVector elements) {
        Vector<ElementTransform> transforms = new Vector<ElementTransform>();
        PdVector distances = new PdVector();
        if (elements == null) {
            elements = PuGeometry.getElementsAround(this.m_inputGeometry, centerElement, radius, this.m_inputGeometry.baryCenters(), distances);
        }
        PdVector[] normals = this.m_outputGeometry.getElementNormals();
        double radians = this.angle / 180.0 * Math.PI;
        int e = 0;
        while (e < elements.getSize()) {
            PdVector currentAxis;
            double currentRadians;
            if (this.fuzzyBrush && centerElement != -1) {
                double elementFactor = distances.getEntry(e) / radius;
                currentRadians = radians * (1.0 - elementFactor);
            } else {
                currentRadians = radians;
            }
            PdMatrix currentTransform = new PdMatrix(3);
            switch (this.axis) {
                case 1: {
                    currentAxis = normals[elements.getEntry(e)];
                    break;
                }
                case 2: {
                    if (centerElement != -1) {
                        currentAxis = normals[centerElement];
                        break;
                    }
                    currentAxis = normals[elements.getEntry(e)];
                    break;
                }
                case 3: {
                    currentAxis = new PdVector(1.0, 0.0, 0.0);
                    break;
                }
                case 4: {
                    currentAxis = new PdVector(0.0, 1.0, 0.0);
                    break;
                }
                case 5: {
                    currentAxis = new PdVector(0.0, 0.0, 1.0);
                    break;
                }
                case 6: {
                    currentAxis = this.customNormalPicker.getDirection();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            PuReflect.makeRotation((PdMatrix)currentTransform, (PdVector)currentAxis, (double)currentRadians);
            transforms.addElement(new ElementTransform(elements.getEntry(e), currentTransform));
            ++e;
        }
        return transforms;
    }

    @Override
    public void processPickEvent(PvPickEvent event) {
        if (this.axis != 6) {
            this.setAxis(6);
            this.getInfoPanel().update((Object)this);
        }
        this.customNormalPicker.processPickEvent(event);
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public boolean isFuzzyBrush() {
        return this.fuzzyBrush;
    }

    public void setFuzzyBrush(boolean fuzzyBrush) {
        this.fuzzyBrush = fuzzyBrush;
    }

    public int getAxis() {
        return this.axis;
    }

    public void setAxis(int axis) {
        this.axis = axis;
        this.customNormalPicker.setEnabled(this.isEnabled() && axis == 6);
    }
}

