/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.brushes.BrFlatten;
import devRetarget.brushes.Brush_IP;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;

public class BrFlatten_IP
extends Brush_IP
implements ItemListener {
    private static final long serialVersionUID = 1L;
    protected static final int[] directionsMapping;
    protected BrFlatten parent;
    protected Choice direction;
    protected PuDouble power;
    protected Checkbox fuzzyBrush;
    protected Checkbox adjustArea;

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[4] = 5;
        nArray[5] = 6;
        directionsMapping = nArray;
    }

    protected static int directionsToIndex(int direction) {
        int i = 0;
        while (i < directionsMapping.length) {
            if (directionsMapping[i] == direction) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToDirections(int index) {
        if (index < directionsMapping.length) {
            return directionsMapping[index];
        }
        throw new IllegalArgumentException();
    }

    public BrFlatten_IP() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        layoutConstraints.gridwidth = 1;
        layoutConstraints.gridy = 0;
        layoutConstraints.gridx = 0;
        this.add(new Label("Direction:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.direction = new Choice();
        this.direction.add("Normal");
        this.direction.add("Mean normal");
        this.direction.add("X");
        this.direction.add("Y");
        this.direction.add("Z");
        this.direction.add("Custom");
        this.direction.addItemListener(this);
        this.add(this.direction, layoutConstraints);
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        ++layoutConstraints.gridy;
        this.power = new PuDouble("Power", (PsUpdateIf)this);
        this.add((Component)this.power.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.fuzzyBrush = new Checkbox("Fuzzy-Brush");
        this.fuzzyBrush.addItemListener(this);
        this.add(this.fuzzyBrush, layoutConstraints);
        ++layoutConstraints.gridy;
        this.adjustArea = new Checkbox("Adjust area");
        this.adjustArea.addItemListener(this);
        this.add(this.adjustArea, layoutConstraints);
        this.validate();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.parent = (BrFlatten)parent;
        this.init();
    }

    public void init() {
        super.init();
        this.setName("InfoPanel for Brush Flatten");
        this.power.setDefBounds(0.0, 1.0, 0.1, 0.1);
        this.power.setDefValue(this.parent.getPower());
        this.power.init();
    }

    public boolean update(Object eventSource) {
        if (eventSource == this.parent) {
            this.direction.select(BrFlatten_IP.directionsToIndex(this.parent.getDirection()));
            this.power.setValue(this.parent.getPower());
            this.fuzzyBrush.setState(this.parent.isFuzzyBrush());
            this.adjustArea.setState(this.parent.isAdjustArea());
        }
        if (eventSource == this.power) {
            this.parent.setPower(this.power.getValue());
        }
        return super.update(eventSource);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.direction) {
            this.parent.setDirection(BrFlatten_IP.indexToDirections(this.direction.getSelectedIndex()));
            return;
        }
        if (source == this.fuzzyBrush) {
            this.parent.setFuzzyBrush(this.fuzzyBrush.getState());
            return;
        }
        if (source == this.adjustArea) {
            this.parent.setAdjustArea(this.adjustArea.getState());
            return;
        }
    }
}

