/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.PjBrushes;
import devRetarget.brushes.Brush;
import devRetarget.brushes.ElementTransform;
import devRetarget.brushes.NormalPicker;
import devRetarget.util.PuGeometry;
import devRetarget.util.PuUtil;
import java.util.Vector;
import jv.project.PvPickEvent;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class BrFlatten
extends Brush {
    public static final int DIRECTION_NORMAL = 0;
    public static final int DIRECTION_MEAN_NORMAL = 1;
    public static final int DIRECTION_X = 3;
    public static final int DIRECTION_Y = 4;
    public static final int DIRECTION_Z = 5;
    public static final int DIRECTION_CUSTOM = 6;
    protected int direction;
    protected double power;
    protected boolean fuzzyBrush;
    protected boolean adjustArea;
    protected NormalPicker customNormalPicker;

    public BrFlatten() {
        this.setName("Brush Flatten");
        this.setType(5);
        this.customNormalPicker = new NormalPicker();
        this.customNormalPicker.setName("BrFlatten: Normal Picker");
        if (((Object)((Object)this)).getClass() == BrFlatten.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.direction = 0;
        this.power = 0.5;
        this.fuzzyBrush = true;
        this.adjustArea = true;
    }

    @Override
    public boolean setDock(PjBrushes dock) {
        super.setDock(dock);
        this.customNormalPicker.setGeometries(this.m_outputGeometry, this.m_inputGeometry);
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.customNormalPicker.setEnabled(enabled && this.direction == 6);
    }

    @Override
    public Vector computeTransforms(int centerElement, double radius) {
        return this.computeTransforms(centerElement, radius, null);
    }

    @Override
    public Vector computeTransforms(PiVector elements) {
        return this.computeTransforms(-1, -1.0, elements);
    }

    protected Vector computeTransforms(int centerElement, double radius, PiVector elements) {
        PdVector plateauNormal;
        Vector<ElementTransform> transforms = new Vector<ElementTransform>();
        PdVector distances = new PdVector();
        if (elements == null) {
            elements = PuGeometry.getElementsAround(this.m_inputGeometry, centerElement, radius, this.m_inputGeometry.baryCenters(), distances);
        }
        PdVector[] normals = this.m_outputGeometry.getElementNormals();
        PdVector[] elementNormals = new PdVector[elements.getSize()];
        int e = 0;
        while (e < elements.getSize()) {
            elementNormals[e] = normals[elements.getEntry(e)];
            ++e;
        }
        PdVector meanNormal = PuUtil.meanOf(elementNormals);
        switch (this.direction) {
            case 1: {
                plateauNormal = meanNormal;
                break;
            }
            case 0: {
                if (centerElement == -1) {
                    plateauNormal = meanNormal;
                    break;
                }
                plateauNormal = (PdVector)normals[centerElement].clone();
                break;
            }
            case 3: {
                plateauNormal = new PdVector(1.0, 0.0, 0.0);
                break;
            }
            case 4: {
                plateauNormal = new PdVector(0.0, 1.0, 0.0);
                break;
            }
            case 5: {
                plateauNormal = new PdVector(0.0, 0.0, 1.0);
                break;
            }
            case 6: {
                plateauNormal = this.customNormalPicker.getDirection();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (plateauNormal.dot(meanNormal) < 0.0) {
            plateauNormal.multScalar(-1.0);
        }
        int e2 = 0;
        while (e2 < elements.getSize()) {
            int element = elements.getEntry(e2);
            double factor = this.fuzzyBrush && centerElement != -1 ? 1.0 - distances.getEntry(e2) / radius : 1.0;
            PdVector sourceNormal = normals[element];
            PdVector targetNormal = PuUtil.interpolate(plateauNormal, normals[element], factor *= this.power);
            targetNormal.normalize();
            PdMatrix currentTransform = PuUtil.rotateVectorIntoVectorMatrix(sourceNormal, targetNormal);
            if (this.adjustArea) {
                double scaleFactor = Math.abs(sourceNormal.dot(targetNormal));
                PdVector scaleDirection = new PdVector(3);
                PuVectorGeom.projectOntoPlane((PdVector)scaleDirection, (PdVector)targetNormal, (PdVector)sourceNormal);
                PdMatrix scale = PuUtil.scaleInDirectionMatrix(scaleDirection, scaleFactor);
                currentTransform.rightMult(scale);
            }
            transforms.addElement(new ElementTransform(element, currentTransform));
            ++e2;
        }
        return transforms;
    }

    @Override
    public void processPickEvent(PvPickEvent event) {
        if (this.direction != 6) {
            this.setDirection(6);
            this.getInfoPanel().update((Object)this);
        }
        this.customNormalPicker.processPickEvent(event);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
        this.customNormalPicker.setEnabled(this.isEnabled() && direction == 6);
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        if (power < 0.0 || power > 1.0) {
            throw new IllegalArgumentException();
        }
        this.power = power;
    }

    public boolean isFuzzyBrush() {
        return this.fuzzyBrush;
    }

    public void setFuzzyBrush(boolean fuzzyBrush) {
        this.fuzzyBrush = fuzzyBrush;
    }

    public boolean isAdjustArea() {
        return this.adjustArea;
    }

    public void setAdjustArea(boolean adjustArea) {
        this.adjustArea = adjustArea;
    }
}

