/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.PjBrushes;
import devRetarget.brushes.Brush;
import devRetarget.brushes.DirectionPicker;
import devRetarget.brushes.ElementTransform;
import devRetarget.brushes.NormalPicker;
import java.util.Vector;
import jv.project.PvPickEvent;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;

public class BrCurl
extends Brush {
    protected double angle;
    protected double increaseFactor;
    protected boolean invertDirection;
    protected boolean chooseNormal;
    protected DirectionPicker directionPicker;
    protected NormalPicker normalPicker;

    public BrCurl() {
        this.setName("Brush Curl");
        this.setType(8);
        this.directionPicker = new DirectionPicker();
        this.directionPicker.setName("BrCurl: Direction Picker");
        this.normalPicker = new NormalPicker();
        this.normalPicker.setName("BrCurl: Normal Picker");
        if (((Object)((Object)this)).getClass() == BrCurl.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.angle = 0.0;
        this.increaseFactor = 1.0;
        this.invertDirection = false;
        this.chooseNormal = false;
    }

    @Override
    public boolean setDock(PjBrushes dock) {
        super.setDock(dock);
        this.directionPicker.setGeometries(this.m_outputGeometry, this.m_inputGeometry);
        this.normalPicker.setGeometries(this.m_outputGeometry, this.m_inputGeometry);
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.directionPicker.setEnabled(enabled);
        this.normalPicker.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public Vector computeTransforms(int centerElement, double radius) {
        return null;
    }

    @Override
    public Vector computeTransforms(PiVector elements) {
        return this.computeTransforms(-1, -1.0, elements);
    }

    protected Vector computeTransforms(int centerElement, double radius, PiVector elements) {
        Vector<ElementTransform> transforms = new Vector<ElementTransform>();
        double radians = this.angle / 180.0 * Math.PI;
        PdVector principalDirection = this.directionPicker.getDirection();
        PdVector axis = this.normalPicker.getDirection();
        PdVector lineCoordinates = new PdVector(elements.getSize());
        int e = 0;
        while (e < elements.getSize()) {
            lineCoordinates.setEntry(e, principalDirection.dot(this.m_outputGeometry.getCenterOfElement(null, elements.getEntry(e))));
            ++e;
        }
        double minCoord = lineCoordinates.min();
        double maxCoord = lineCoordinates.max();
        double coordRange = maxCoord - minCoord;
        int e2 = 0;
        while (e2 < elements.getSize()) {
            double normedCoord = Math.pow((lineCoordinates.getEntry(e2) - minCoord) / coordRange, this.increaseFactor);
            if (this.invertDirection) {
                normedCoord = 1.0 - normedCoord;
            }
            double currentRadians = radians * normedCoord;
            PdMatrix currentTransform = new PdMatrix(3);
            PuReflect.makeRotation((PdMatrix)currentTransform, (PdVector)axis, (double)currentRadians);
            transforms.addElement(new ElementTransform(elements.getEntry(e2), currentTransform));
            ++e2;
        }
        return transforms;
    }

    @Override
    public void processPickEvent(PvPickEvent event) {
        if (this.chooseNormal) {
            this.normalPicker.processPickEvent(event);
        } else {
            this.directionPicker.processPickEvent(event);
        }
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public boolean isInvertDirection() {
        return this.invertDirection;
    }

    public void setInvertDirection(boolean invertDirection) {
        this.invertDirection = invertDirection;
    }

    public double getIncreaseFactor() {
        return this.increaseFactor;
    }

    public void setIncreaseFactor(double increaseFactor) {
        this.increaseFactor = increaseFactor;
    }

    public boolean isChooseNormal() {
        return this.chooseNormal;
    }

    public void setChooseNormal(boolean chooseNormal) {
        this.chooseNormal = chooseNormal;
    }

    public void toggleChooseNormal() {
        this.chooseNormal = !this.chooseNormal;
    }
}

