/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.brushes.BrBulge;
import devRetarget.brushes.Brush_IP;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;

public class BrBulge_IP
extends Brush_IP
implements ItemListener {
    private static final long serialVersionUID = 1L;
    protected static final int[] directionsMapping = new int[]{1, 3, 4, 5, 6};
    protected BrBulge parent;
    protected Choice direction;
    protected Checkbox outward;
    protected Checkbox toTarget;
    protected Checkbox actualNormals;
    protected PuDouble slope;
    protected PuDouble plateauSize;
    protected PuDouble smoothness;
    protected PuDouble fadeOut;

    protected static int directionsToIndex(int direction) {
        int i = 0;
        while (i < directionsMapping.length) {
            if (directionsMapping[i] == direction) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToDirections(int index) {
        if (index < directionsMapping.length) {
            return directionsMapping[index];
        }
        throw new IllegalArgumentException();
    }

    public BrBulge_IP() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        layoutConstraints.gridwidth = 1;
        layoutConstraints.gridy = 0;
        layoutConstraints.gridx = 0;
        this.add(new Label("Direction:"), layoutConstraints);
        layoutConstraints.gridx = 1;
        this.direction = new Choice();
        this.direction.add("Normal");
        this.direction.add("X");
        this.direction.add("Y");
        this.direction.add("Z");
        this.direction.add("Custom");
        this.direction.addItemListener(this);
        this.add(this.direction, layoutConstraints);
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridx = 0;
        ++layoutConstraints.gridy;
        this.outward = new Checkbox("Outward, i.e. in normal-direction");
        this.outward.addItemListener(this);
        this.add(this.outward, layoutConstraints);
        ++layoutConstraints.gridy;
        this.toTarget = new Checkbox("Transform to target shape");
        this.toTarget.addItemListener(this);
        this.add(this.toTarget, layoutConstraints);
        ++layoutConstraints.gridy;
        this.actualNormals = new Checkbox("Use the current normals");
        this.actualNormals.addItemListener(this);
        this.add(this.actualNormals, layoutConstraints);
        ++layoutConstraints.gridy;
        this.slope = new PuDouble("Slope (deg)", (PsUpdateIf)this);
        this.add((Component)this.slope.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.plateauSize = new PuDouble("Plateau-size (%)", (PsUpdateIf)this);
        this.add((Component)this.plateauSize.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.smoothness = new PuDouble("Smoothness", (PsUpdateIf)this);
        this.add((Component)this.smoothness.newInspector("_IP"), layoutConstraints);
        ++layoutConstraints.gridy;
        this.fadeOut = new PuDouble("Strength of fade-out", (PsUpdateIf)this);
        this.add((Component)this.fadeOut.newInspector("_IP"), layoutConstraints);
        this.validate();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.parent = (BrBulge)parent;
        this.init();
    }

    public void init() {
        super.init();
        this.setName("InfoPanel for Brush Bulge");
        this.slope.setDefBounds(1.0, 90.0, 1.0, 1.0);
        this.slope.setDefValue(this.parent.getSlope());
        this.slope.init();
        this.plateauSize.setDefBounds(0.0, 0.8, 0.01, 0.01);
        this.plateauSize.setDefValue(this.parent.getPlateauSize());
        this.plateauSize.init();
        this.smoothness.setDefBounds(0.0, 1.0, 0.01, 0.01);
        this.smoothness.setDefValue(this.parent.getSmoothness());
        this.smoothness.init();
        this.fadeOut.setDefBounds(0.0, 4.0, 0.1, 0.1);
        this.fadeOut.setDefValue(this.parent.getFadeOut());
        this.fadeOut.init();
    }

    public boolean update(Object eventSource) {
        if (eventSource == this.parent) {
            this.direction.select(BrBulge_IP.directionsToIndex(this.parent.getDirection()));
            this.outward.setState(this.parent.isOutward());
            this.toTarget.setState(this.parent.isToTarget());
            this.actualNormals.setState(this.parent.isActualNormals());
            this.slope.setValue(this.parent.getSlope());
            this.plateauSize.setValue(this.parent.getPlateauSize());
            this.smoothness.setValue(this.parent.getSmoothness());
            this.fadeOut.setValue(this.parent.getFadeOut());
        }
        if (eventSource == this.slope) {
            this.parent.setSlope(this.slope.getValue());
            return true;
        }
        if (eventSource == this.plateauSize) {
            this.parent.setPlateauSize(this.plateauSize.getValue());
            return true;
        }
        if (eventSource == this.smoothness) {
            this.parent.setSmoothness(this.smoothness.getValue());
            return true;
        }
        if (eventSource == this.fadeOut) {
            this.parent.setFadeOut(this.fadeOut.getValue());
            return true;
        }
        return super.update(eventSource);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.direction) {
            this.parent.setDirection(BrBulge_IP.indexToDirections(this.direction.getSelectedIndex()));
            return;
        }
        if (source == this.outward) {
            this.parent.setOutward(this.outward.getState());
            return;
        }
        if (source == this.toTarget) {
            this.parent.setToTarget(this.toTarget.getState());
            return;
        }
        if (source == this.actualNormals) {
            this.parent.setActualNormals(this.actualNormals.getState());
            return;
        }
    }
}

