/*
 * Decompiled with CFR 0.152.
 */
package devRetarget.brushes;

import devRetarget.PjBrushes;
import devRetarget.brushes.Brush;
import devRetarget.brushes.ElementTransform;
import devRetarget.brushes.NormalPicker;
import devRetarget.util.PuGeometry;
import devRetarget.util.PuUtil;
import java.util.Vector;
import jv.object.PsDebug;
import jv.project.PvPickEvent;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;

public class BrBulge
extends Brush {
    public static final int DIRECTION_NORMAL = 1;
    public static final int DIRECTION_X = 3;
    public static final int DIRECTION_Y = 4;
    public static final int DIRECTION_Z = 5;
    public static final int DIRECTION_CUSTOM = 6;
    protected int direction;
    protected boolean outward;
    protected boolean toTarget;
    protected boolean actualNormals;
    protected double plateauSize;
    protected double smoothness;
    protected double hillness;
    protected double slope;
    protected double fadeOut;
    protected NormalPicker customNormalPicker;

    public BrBulge() {
        this.setName("Brush Bulge");
        this.setType(2);
        this.customNormalPicker = new NormalPicker();
        this.customNormalPicker.setName("BrBulge: Normal Picker");
        if (((Object)((Object)this)).getClass() == BrBulge.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.direction = 1;
        this.outward = true;
        this.toTarget = false;
        this.actualNormals = false;
        this.plateauSize = 0.0;
        this.smoothness = 0.0;
        this.slope = 45.0;
        this.fadeOut = 0.0;
    }

    @Override
    public boolean setDock(PjBrushes dock) {
        super.setDock(dock);
        this.customNormalPicker.setGeometries(this.m_outputGeometry, this.m_inputGeometry);
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.customNormalPicker.setEnabled(enabled && this.direction == 6);
    }

    @Override
    public Vector computeTransforms(int centerElement, double radius) {
        PdVector plateauNormal;
        Vector<ElementTransform> transforms = new Vector<ElementTransform>();
        PdVector distances = new PdVector();
        PiVector elements = PuGeometry.getElementsAround(this.m_inputGeometry, centerElement, radius, this.m_inputGeometry.baryCenters(), distances);
        if (elements.getSize() < 30) {
            PsDebug.warning((String)"Brush Bulge. \n\t Less then 30 elements are inside the radius of the bulge brush. \n\t This may yield a bad result as the mesh is to coarse to add additional curvature.");
        }
        PdVector[] centers = this.m_inputGeometry.baryCenters();
        PdVector[] normals = this.actualNormals ? this.m_outputGeometry.getElementNormals() : PdVector.copyNew((PdVector[])this.m_inputGeometry.frames()[2].getVectors());
        switch (this.direction) {
            case 1: {
                plateauNormal = (PdVector)normals[centerElement].clone();
                break;
            }
            case 3: {
                plateauNormal = new PdVector(1.0, 0.0, 0.0);
                break;
            }
            case 4: {
                plateauNormal = new PdVector(0.0, 1.0, 0.0);
                break;
            }
            case 5: {
                plateauNormal = new PdVector(0.0, 0.0, 1.0);
                break;
            }
            case 6: {
                plateauNormal = this.customNormalPicker.getDirection();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (plateauNormal.dot(normals[centerElement]) < 0.0) {
            plateauNormal.multScalar(-1.0);
        }
        int e = 0;
        while (e < elements.getSize()) {
            PdVector targetNormal;
            int element = elements.getEntry(e);
            double normalizedDistance = distances.getEntry(e) / radius;
            double angleFactor = Math.pow(Math.sin(normalizedDistance * Math.PI), 1.0 + this.smoothness);
            double currentAngle = this.slope / 180.0 * Math.PI * angleFactor;
            PdVector radialDirection = PdVector.subNew((PdVector)centers[element], (PdVector)centers[centerElement]);
            normalizedDistance = normalizedDistance < this.plateauSize ? 0.0 : (normalizedDistance - this.plateauSize) / (1.0 - this.plateauSize);
            PdVector sourceNormal = normals[element];
            PdMatrix rotationToTarget = new PdMatrix(3);
            if (normalizedDistance < 1.0E-4) {
                targetNormal = plateauNormal;
                rotationToTarget.setDiagonal(1.0);
            } else {
                PdVector rotationAxis = PdVector.crossNew((PdVector)plateauNormal, (PdVector)radialDirection);
                if (!this.toTarget && !this.outward) {
                    PuReflect.makeRotation((PdMatrix)rotationToTarget, (PdVector)rotationAxis, (double)(-currentAngle));
                } else {
                    PuReflect.makeRotation((PdMatrix)rotationToTarget, (PdVector)rotationAxis, (double)currentAngle);
                }
                targetNormal = rotationToTarget.leftMultMatrix(null, (PdVector)plateauNormal.clone());
                if (normalizedDistance > 0.5) {
                    targetNormal = PuUtil.interpolate(targetNormal, normals[element], Math.pow(angleFactor, this.fadeOut));
                }
            }
            PdMatrix transform = this.toTarget ? (this.outward ? PuUtil.rotateVectorIntoVectorMatrix(sourceNormal, targetNormal) : PuUtil.rotateVectorIntoVectorMatrix(targetNormal, sourceNormal)) : rotationToTarget;
            if (normalizedDistance >= 1.0E-4) {
                double scaling;
                if (normalizedDistance > 0.5) {
                    currentAngle *= Math.pow(angleFactor, this.fadeOut);
                }
                scaling = (scaling = Math.cos(currentAngle)) < 0.2 ? 5.0 : 1.0 / scaling;
                PdMatrix scale = PuUtil.scaleInDirectionMatrix(radialDirection, scaling);
                transform.rightMult(scale);
            }
            transforms.addElement(new ElementTransform(element, transform));
            ++e;
        }
        return transforms;
    }

    @Override
    public Vector computeTransforms(PiVector elements) {
        return null;
    }

    @Override
    public void processPickEvent(PvPickEvent event) {
        if (this.direction != 6) {
            this.setDirection(6);
            this.getInfoPanel().update((Object)this);
        }
        this.customNormalPicker.processPickEvent(event);
    }

    public boolean isOutward() {
        return this.outward;
    }

    public void setOutward(boolean outward) {
        this.outward = outward;
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        if (slope < 0.0 || slope > 90.0) {
            throw new IllegalArgumentException();
        }
        this.slope = slope;
    }

    public double getPlateauSize() {
        return this.plateauSize;
    }

    public void setPlateauSize(double plateauSize) {
        if (plateauSize < 0.0 || plateauSize > 0.85) {
            throw new IllegalArgumentException();
        }
        this.plateauSize = plateauSize;
    }

    public double getSmoothness() {
        return this.smoothness;
    }

    public void setSmoothness(double smoothness) {
        if (smoothness < 0.0 || smoothness > 1.0) {
            throw new IllegalArgumentException();
        }
        this.smoothness = smoothness;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
        this.customNormalPicker.setEnabled(this.isEnabled() && direction == 6);
    }

    public double getFadeOut() {
        return this.fadeOut;
    }

    public void setFadeOut(double fadeOut) {
        this.fadeOut = fadeOut;
    }

    public boolean isToTarget() {
        return this.toTarget;
    }

    public void setToTarget(boolean toTarget) {
        this.toTarget = toTarget;
    }

    public boolean isActualNormals() {
        return this.actualNormals;
    }

    public void setActualNormals(boolean actualNormals) {
        this.actualNormals = actualNormals;
    }
}

