/*
 * Decompiled with CFR 0.152.
 */
package devRetarget;

import devRetarget.PjRetargeting;
import devRetarget.retargeting.RetargetingModule;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsTabPanel;
import jv.project.PgGeometryIf;
import jv.project.PjProject_IP;

public class PjRetargeting_IP
extends PjProject_IP
implements ActionListener,
ItemListener {
    protected PjRetargeting m_pjRetarget;
    protected Checkbox m_cShowGradients;
    protected Checkbox m_cShowAxes;
    protected Checkbox m_cAutoFit;
    protected Checkbox m_cShowEdges;
    protected Button m_bUseCurrentGeometry;
    protected Checkbox m_cPreserveGeometryData;
    protected Button m_bSetUserValues;
    protected Button m_bAddUserValues;
    protected Button m_bSetImportant;
    protected Choice m_cModuleChooser;
    protected int[] m_moduleTypeMapping;
    protected PsPanel m_pModulePanel;
    protected Checkbox m_cAutoRetarget;
    protected Button m_bRetarget;
    protected Button m_bRestoreGeometry;
    protected Button m_bSaveScreenshot;
    protected Button m_bReset;
    protected PsPanel m_pImport;
    protected PsPanel m_pImportance;
    protected PsPanel m_pUserValue;

    public PjRetargeting_IP() {
        if (this.getClass() == PjRetargeting_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addTitle("Model Retargeting");
        PsTabPanel tabPanel = new PsTabPanel();
        PsPanel pTab = new PsPanel();
        this.m_pImport = new PsPanel();
        pTab.add((Component)this.m_pImport);
        PsPanel pInput = new PsPanel((LayoutManager)new GridLayout(1, 2));
        this.m_bUseCurrentGeometry = new Button("Set geometry as new input");
        this.m_bUseCurrentGeometry.addActionListener(this);
        pInput.add((Component)this.m_bUseCurrentGeometry);
        this.m_cPreserveGeometryData = new Checkbox("Keep measures of old geometry.");
        this.m_cPreserveGeometryData.addItemListener(this);
        pInput.add((Component)this.m_cPreserveGeometryData);
        pTab.add((Component)pInput);
        tabPanel.addPanel("Model", pTab);
        pTab = new PsPanel();
        PsPanel pOption = new PsPanel((LayoutManager)new GridLayout(2, 2));
        this.m_cShowGradients = new Checkbox("Show Gradients", false);
        this.m_cShowGradients.addItemListener(this);
        pOption.add((Component)this.m_cShowGradients);
        this.m_cShowAxes = new Checkbox("Show Axes");
        this.m_cShowAxes.addItemListener(this);
        pOption.add((Component)this.m_cShowAxes);
        this.m_cAutoFit = new Checkbox("Auto-Fit Camera");
        this.m_cAutoFit.addItemListener(this);
        pOption.add((Component)this.m_cAutoFit);
        this.m_cShowEdges = new Checkbox("Show Edges");
        this.m_cShowEdges.addItemListener(this);
        pOption.add((Component)this.m_cShowEdges);
        pTab.add((Component)pOption);
        tabPanel.addPanel("Options", pTab);
        pTab = new PsPanel();
        PsPanel pOutput = new PsPanel();
        this.m_bSetImportant = new Button("Set selected elements as important");
        this.m_bSetImportant.addActionListener(this);
        pOutput.add((Component)this.m_bSetImportant);
        this.m_pImportance = new PsPanel();
        pOutput.add((Component)this.m_pImportance);
        this.m_bSetUserValues = new Button("Set custom values for selected elements");
        this.m_bSetUserValues.addActionListener(this);
        pOutput.add((Component)this.m_bSetUserValues);
        this.m_bAddUserValues = new Button("Append custom values for selected elements");
        this.m_bAddUserValues.addActionListener(this);
        pOutput.add((Component)this.m_bAddUserValues);
        this.m_pUserValue = new PsPanel();
        pOutput.add((Component)this.m_pUserValue);
        PsPanel pRetarget = new PsPanel((LayoutManager)new GridLayout(1, 2));
        Label labelRM = new Label("Retargeting Module:");
        pRetarget.add((Component)labelRM);
        this.m_cModuleChooser = new Choice();
        this.m_cModuleChooser.addItemListener(this);
        pRetarget.add((Component)this.m_cModuleChooser);
        pOutput.add((Component)pRetarget);
        this.m_pModulePanel = new PsPanel((LayoutManager)new BorderLayout());
        this.m_pModulePanel.setInsetSizeVertical(10);
        this.m_pModulePanel.setInsetSizeHorizontal(5);
        this.m_pModulePanel.setBorderType(1);
        pOutput.add((Component)this.m_pModulePanel);
        PsPanel pBottom = new PsPanel((LayoutManager)new GridLayout(2, 2));
        this.m_cAutoRetarget = new Checkbox("Auto-Retarget");
        this.m_cAutoRetarget.addItemListener(this);
        pBottom.add((Component)this.m_cAutoRetarget);
        this.m_bRetarget = new Button("Retarget");
        this.m_bRetarget.addActionListener(this);
        pBottom.add((Component)this.m_bRetarget);
        this.m_bRestoreGeometry = new Button("Restore geometry");
        this.m_bRestoreGeometry.addActionListener(this);
        pBottom.add((Component)this.m_bRestoreGeometry);
        this.m_bSaveScreenshot = new Button("Save a screenshot");
        this.m_bSaveScreenshot.addActionListener(this);
        this.m_bSaveScreenshot.setEnabled(true);
        pBottom.add((Component)this.m_bSaveScreenshot);
        pOutput.add((Component)pBottom);
        pTab.add((Component)pOutput);
        tabPanel.addPanel("Output", pTab);
        tabPanel.setVisible("Output");
        this.add((Component)tabPanel);
        this.m_bReset = new Button("Reset");
        this.m_bReset.addActionListener(this);
        this.add(this.m_bReset);
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_pjRetarget = (PjRetargeting)parent;
        this.m_pImport.add((Component)this.m_pjRetarget.m_import.getInfoPanel());
        this.m_pImport.validate();
        this.m_pImportance.add((Component)this.m_pjRetarget.m_importance.getInfoPanel());
        this.m_pImportance.validate();
        this.m_pUserValue.add((Component)this.m_pjRetarget.m_userValue.getInfoPanel());
        this.m_pUserValue.validate();
    }

    public boolean update(Object eventSource) {
        if (eventSource == this.m_pjRetarget) {
            PsPanel.setState((Checkbox)this.m_cAutoFit, (boolean)this.m_pjRetarget.isEnabledAutoFit());
            PsPanel.setState((Checkbox)this.m_cShowGradients, (boolean)this.m_pjRetarget.isShowingGradients());
            PsPanel.setState((Checkbox)this.m_cShowAxes, (boolean)this.m_pjRetarget.isShowingAxes());
            PsPanel.setState((Checkbox)this.m_cShowEdges, (boolean)this.m_pjRetarget.isShowingEdges());
            PsPanel.setState((Checkbox)this.m_cPreserveGeometryData, (boolean)false);
            PsPanel.setState((Checkbox)this.m_cAutoRetarget, (boolean)this.m_pjRetarget.isAutoRetarget());
            this.m_cModuleChooser.removeAll();
            LinkedList modules = this.m_pjRetarget.m_modules;
            this.m_moduleTypeMapping = new int[modules.size()];
            int typeIndex = 0;
            for (RetargetingModule module : modules) {
                this.m_cModuleChooser.add(module.getName());
                this.m_moduleTypeMapping[typeIndex++] = module.getType();
            }
            if (typeIndex > 0) {
                this.m_cModuleChooser.select(this.moduleTypeToIndex(this.m_pjRetarget.m_selectedModule.getType()));
            }
            this.updateModulePanel();
            return true;
        }
        return super.update(eventSource);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_bUseCurrentGeometry) {
            if (!this.m_cPreserveGeometryData.getState()) {
                this.m_pjRetarget.setGeometry((PgGeometryIf)this.m_pjRetarget.m_outputGeometry);
            } else {
                this.m_pjRetarget.setInputGeometry(this.m_pjRetarget.m_outputGeometry);
            }
            this.m_pjRetarget.updateModules();
            this.m_pjRetarget.update(this.m_pjRetarget);
        } else if (source == this.m_bSetUserValues) {
            this.m_pjRetarget.setUserValues(this.m_pjRetarget.m_userValue.getValue());
            this.m_pjRetarget.updateModules();
        } else if (source == this.m_bAddUserValues) {
            this.m_pjRetarget.addUserValues(this.m_pjRetarget.m_userValue.getValue());
            this.m_pjRetarget.updateModules();
        } else if (source == this.m_bSetImportant) {
            this.m_pjRetarget.setImportantElements();
            this.m_pjRetarget.updateModules();
        } else if (source == this.m_bRetarget) {
            this.m_pjRetarget.retarget();
        } else if (source == this.m_bRestoreGeometry) {
            this.m_pjRetarget.restoreGeometry();
        } else if (source == this.m_bSaveScreenshot) {
            FileDialog imageSaver = new FileDialog(new Frame(), "Save the Result", 1);
            imageSaver.setDirectory(".\\images\\output");
            imageSaver.setFile("result");
            imageSaver.setVisible(true);
            if (imageSaver.getFile() != null) {
                this.m_pjRetarget.saveScreenshot(String.valueOf(imageSaver.getDirectory()) + imageSaver.getFile());
            }
        } else if (source == this.m_bReset) {
            this.m_pjRetarget.init();
        } else {
            PsDebug.warning((String)"unknown action event.");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.m_cModuleChooser) {
            this.m_pjRetarget.setSelectedModule(this.m_moduleTypeMapping[this.m_cModuleChooser.getSelectedIndex()]);
            this.updateModulePanel();
            return;
        }
        if (source == this.m_cShowGradients) {
            this.m_pjRetarget.showGradients(this.m_cShowGradients.getState());
            this.m_pjRetarget.getOutputGeometry().update((Object)this.m_pjRetarget.getOutputGeometry());
            return;
        }
        if (source == this.m_cShowAxes) {
            this.m_pjRetarget.showAxes(this.m_cShowAxes.getState());
            this.m_pjRetarget.update(this.m_pjRetarget);
            return;
        }
        if (source == this.m_cAutoFit) {
            this.m_pjRetarget.setEnabledAutoFit(this.m_cAutoFit.getState());
            return;
        }
        if (source == this.m_cShowEdges) {
            this.m_pjRetarget.showEdges(this.m_cShowEdges.getState());
            this.m_pjRetarget.update(this.m_pjRetarget);
            return;
        }
        if (source == this.m_cPreserveGeometryData) {
            return;
        }
        if (source == this.m_cAutoRetarget) {
            this.m_pjRetarget.setAutoRetarget(this.m_cAutoRetarget.getState());
            return;
        }
    }

    protected void updateModulePanel() {
        if (this.m_pjRetarget.m_selectedModule == null) {
            return;
        }
        this.m_pModulePanel.removeAll();
        this.m_pModulePanel.add((Component)this.m_pjRetarget.m_selectedModule.getInfoPanel());
        this.m_pModulePanel.validate();
        this.validate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
    }

    protected int moduleTypeToIndex(int moduleType) {
        int i = 0;
        while (i < this.m_moduleTypeMapping.length) {
            if (this.m_moduleTypeMapping[i] == moduleType) {
                return i;
            }
            ++i;
        }
        PsDebug.warning((String)("Module type out of range, type = " + moduleType));
        return -1;
    }

    protected int indexToModuleType(int index) {
        if (index >= this.m_moduleTypeMapping.length) {
            PsDebug.warning((String)("Module index out of range, index = " + index));
            return -1;
        }
        return this.m_moduleTypeMapping[index];
    }
}

