/*
 * Decompiled with CFR 0.152.
 */
package devRetarget;

import devRetarget.retargeting.PgRetargetingGeometry;
import devRetarget.retargeting.PnRetargeting;
import devRetarget.retargeting.RetargetingModule;
import devRetarget.retargeting.RmConstraints;
import devRetarget.retargeting.RmGlobalDirectionsIntrinsic;
import devRetarget.retargeting.RmGlobalDirectionsScaling;
import devRetarget.retargeting.RmLocalDirectionsIntrinsic;
import devRetarget.retargeting.RmLocalDirectionsScaling;
import devRetarget.retargeting.RmLocalScalar;
import devRetarget.util.PuGeometry;
import devRetarget.util.PuUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.loader.PjImportModel;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.viewer.PvDisplay;

public class PjRetargeting
extends PjProject
implements ActionListener {
    public static final int TYPE_LOCAL_SCALAR = 0;
    public static final int TYPE_LOCAL_DIRECTIONS_SCALING = 1;
    public static final int TYPE_LOCAL_DIRECTIONS_INTRINSIC = 2;
    public static final int TYPE_GLOBAL_DIRECTIONS_SCALING = 3;
    public static final int TYPE_GLOBAL_DIRECTIONS_INTRINSIC = 4;
    public static final int TYPE_CONSTRAINTS = 5;
    private static final String m_defaultFileName = "models\\byu\\Brezel_1920.byu";
    private static final int[] defaultModuleTypes;
    protected PjImportModel m_import;
    protected PgElementSet m_outputGeometry;
    protected PgRetargetingGeometry m_inputGeometry;
    protected PgRetargetingGeometry m_measureGeometry;
    protected RetargetingModule m_selectedModule;
    protected LinkedList m_modules = new LinkedList();
    protected boolean m_bShowGradients;
    protected boolean m_bShowAxes;
    protected boolean m_bAutoRetarget;
    protected PuDouble m_importance = new PuDouble("Importance", (PsUpdateIf)this);
    protected PuDouble m_userValue = new PuDouble("Custom value", (PsUpdateIf)this);
    protected PgElementSet m_tempElemSet;
    protected PnRetargeting m_solver;

    static {
        int[] nArray = new int[5];
        nArray[1] = 2;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[4] = 5;
        defaultModuleTypes = nArray;
    }

    public PjRetargeting() {
        super("Project Retargeting");
        this.m_import = new PjImportModel();
        this.m_import.setTypeOfInfoPanel(1);
        this.m_import.addActionListener((ActionListener)this);
        this.m_import.setFileName(m_defaultFileName);
        this.m_outputGeometry = new PgElementSet();
        this.m_outputGeometry.setName("Output Geometry");
        this.m_outputGeometry.addUpdateListener((PsUpdateIf)this);
        this.m_inputGeometry = new PgRetargetingGeometry();
        this.m_inputGeometry.setName("Domain Geometry");
        this.m_inputGeometry.setVisible(false);
        this.m_inputGeometry.addUpdateListener((PsUpdateIf)this);
        this.m_solver = new PnRetargeting();
        this.m_solver.setGeometry(this.m_inputGeometry);
        if (this.getClass() == PjRetargeting.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_importance.setDefBounds(0.5, 50.0, 0.5, 0.5);
        this.m_importance.setDefValue(10.0);
        this.m_importance.init();
        this.m_userValue.setDefBounds(0.0, 1.0, 0.05, 0.05);
        this.m_userValue.setDefValue(0.5);
        this.m_userValue.init();
        this.m_tempElemSet = null;
        this.m_selectedModule = null;
        this.m_import.setBase(String.valueOf(PsConfig.getCodeBase()) + "models\\");
        this.m_import.setCategory("retargeting\\");
        this.showEdges(false);
        this.m_bShowGradients = false;
        this.setEnabledAutoFit(true);
        this.m_bShowAxes = false;
        this.m_bAutoRetarget = true;
    }

    public void start() {
        PvDisplay disp = (PvDisplay)this.getViewer().getDisplay();
        disp.showAxes(this.m_bShowAxes);
        this.setAutoRetarget(this.m_bAutoRetarget);
        this.addGeometry((PgGeometryIf)this.m_outputGeometry);
        this.addGeometry((PgGeometryIf)this.m_inputGeometry);
        this.selectGeometry((PgGeometryIf)this.m_outputGeometry);
        if (!this.m_import.load(m_defaultFileName)) {
            PsDebug.warning((String)"failed loading model: models\\byu\\Brezel_1920.byu");
            return;
        }
        this.setGeometry((PgGeometryIf)((PgElementSet)this.m_import.getGeometry()));
        RetargetingModule module = null;
        int i = 0;
        while (i < defaultModuleTypes.length) {
            switch (defaultModuleTypes[i]) {
                case 0: {
                    module = new RmLocalScalar();
                    break;
                }
                case 1: {
                    module = new RmLocalDirectionsScaling();
                    break;
                }
                case 2: {
                    module = new RmLocalDirectionsIntrinsic();
                    break;
                }
                case 3: {
                    module = new RmGlobalDirectionsScaling();
                    break;
                }
                case 4: {
                    module = new RmGlobalDirectionsIntrinsic();
                    break;
                }
                case 5: {
                    module = new RmConstraints();
                    break;
                }
                default: {
                    PsDebug.warning((String)("unknown retargeting module of type " + defaultModuleTypes[i]));
                }
            }
            module.setSolver(this.m_solver);
            this.registerModule(module);
            module.setDock(this);
            ++i;
        }
        this.setSelectedModule(0);
        super.update((Object)this);
        super.start();
    }

    public PgElementSet getOutputGeometry() {
        return this.m_outputGeometry;
    }

    public boolean setGeometry(PgGeometryIf geom) {
        if (geom == null || !(geom instanceof PgElementSet)) {
            PsDebug.warning((String)"geometry missing or not of type PgElementSet.");
            return false;
        }
        PgElementSet geometry = (PgElementSet)geom;
        this.m_outputGeometry.copy((PsObject)geometry);
        PgElementSet.triangulate((PgElementSet)this.m_outputGeometry);
        PdVector center = PuUtil.getCenter(this.m_outputGeometry.getVertices());
        center.multScalar(-1.0);
        this.m_outputGeometry.translate(center);
        this.setInputGeometry(this.m_outputGeometry);
        if (this.isShowingGradients()) {
            this.computeGradients();
        }
        this.m_outputGeometry.update((Object)this.m_outputGeometry);
        this.updateModules();
        this.update(this);
        return true;
    }

    public PgRetargetingGeometry getInputGeometry() {
        return this.m_inputGeometry;
    }

    protected void setInputGeometry(PgElementSet geom) {
        if (geom == null || geom != this.m_outputGeometry) {
            PsDebug.warning((String)"missing or incompatible geometry, must be equal to base geometry.");
            return;
        }
        boolean bInputVisible = this.m_inputGeometry.isVisible();
        this.m_inputGeometry.init();
        this.m_inputGeometry.copy((PsObject)geom);
        this.m_inputGeometry.setVisible(bInputVisible);
        this.m_inputGeometry.markBoundary();
        this.m_inputGeometry.makeVertexNormals();
        this.m_inputGeometry.makeElementNormals();
        this.setMeasureGeometry(this.m_inputGeometry);
        this.m_solver.setGeometry(this.m_inputGeometry);
        this.m_solver.computeAndFactorizeStiffnessMatrix();
        this.m_inputGeometry.update((Object)this.m_inputGeometry);
    }

    public void computeGradients() {
        this.m_outputGeometry.removeAllVectorFields();
        PgVectorField[] gradients = this.m_inputGeometry.getCoordinateGradients();
        int i = 0;
        while (i < 3) {
            gradients[i].setGeometry((PgPointSet)this.m_outputGeometry);
            gradients[i].setGlobalVectorLength(0.05 * this.m_inputGeometry.getDiameter());
            gradients[i].setGlobalVectorSize(1.0);
            Color vectorColor = PdColor.getColorFromID((int)i, (boolean)false);
            gradients[i].setGlobalVectorColor(vectorColor);
            gradients[i].showIndividualMaterial(true);
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.m_outputGeometry.addVectorField(gradients[i]);
            ++i;
        }
        this.m_outputGeometry.showVectorFields(this.m_bShowGradients);
    }

    public PgRetargetingGeometry getMeasureGeometry() {
        return this.m_measureGeometry;
    }

    public void setMeasureGeometry(PgRetargetingGeometry measureGeometry) {
        this.m_measureGeometry = measureGeometry;
    }

    public void retarget() {
        this.m_selectedModule.retarget();
        if (this.isEnabledAutoFit()) {
            this.fitDisplays();
        }
    }

    public boolean update(Object source) {
        if (source == this) {
            return super.update((Object)this);
        }
        if (source == this.m_outputGeometry) {
            if (this.m_outputGeometry.getNumElements() != this.m_inputGeometry.getNumElements()) {
                PsDebug.warning((String)"Number of elements changed, resetting input- and measureData.");
                this.setGeometry((PgGeometryIf)this.m_outputGeometry);
            }
            if (this.isEnabledAutoFit()) {
                this.fitDisplays();
            }
            return true;
        }
        if (source == this.m_measureGeometry) {
            this.m_importance.setValue(this.m_measureGeometry.getImportance());
            return this.update(this.m_importance);
        }
        if (source == this.m_importance) {
            this.setImportance(this.m_importance.getValue());
            return true;
        }
        if (source == this.m_userValue) {
            return true;
        }
        return super.update(source);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_import) {
            switch (this.m_import.getConfirm()) {
                case 2: {
                    if (this.m_tempElemSet != null) {
                        this.removeGeometry((PgGeometryIf)this.m_tempElemSet);
                        this.m_tempElemSet = null;
                    }
                    if (!(this.m_import.getGeometry() instanceof PgElementSet)) break;
                    this.m_tempElemSet = (PgElementSet)this.m_import.getGeometry();
                    this.addGeometry((PgGeometryIf)this.m_tempElemSet);
                    this.fitDisplays();
                    break;
                }
                case 1: {
                    if (this.m_tempElemSet != null) {
                        this.removeGeometry((PgGeometryIf)this.m_tempElemSet);
                    }
                    this.m_tempElemSet = null;
                    this.fitDisplays();
                    break;
                }
                case 0: {
                    if (this.m_tempElemSet != null) {
                        this.removeGeometry((PgGeometryIf)this.m_tempElemSet);
                    }
                    this.m_tempElemSet = null;
                    this.setGeometry((PgGeometryIf)((PgElementSet)this.m_import.getGeometry()));
                }
            }
        }
    }

    public void registerModule(RetargetingModule module) {
        if (module == null) {
            PsDebug.warning((String)"missing module");
            return;
        }
        Iterator i = this.m_modules.iterator();
        while (i.hasNext()) {
            if (((RetargetingModule)((Object)i.next())).getType() != module.getType()) continue;
            PsDebug.warning((String)("module of same type is already registered, type = " + module.getType()));
        }
        this.m_modules.add(module);
        if (this.m_selectedModule != null) {
            this.getInfoPanel().update((Object)this);
        }
    }

    protected void updateModules() {
        Iterator i = this.m_modules.iterator();
        while (i.hasNext()) {
            ((RetargetingModule)((Object)i.next())).update(this);
        }
    }

    public void setImportantElements() {
        int[] elements = PuGeometry.getMarkedElements(this.m_outputGeometry);
        this.m_measureGeometry.setImportantElements(elements);
        this.m_inputGeometry.setWeights(new PiVector(elements), this.m_measureGeometry.getImportance());
    }

    public void setImportance(double value) {
        if (value < 0.5) {
            PsDebug.warning((String)"value must be equal or bigger than 0.5.");
            return;
        }
        this.m_measureGeometry.setImportance(value);
        this.m_inputGeometry.setWeights(this.m_measureGeometry.getImportantElements(), value);
    }

    public void setUserValues(double value) {
        double[] userValues = this.assureUserValues(value);
        this.m_measureGeometry.setUserValues(userValues);
    }

    public void addUserValues(double value) {
        double[] userValues = this.assureUserValues(value);
        this.m_measureGeometry.addUserValues(userValues);
    }

    private double[] assureUserValues(double value) {
        if (value < 0.0 || value > 1.0) {
            PsDebug.warning((String)"value outside of range [0,1].");
            return null;
        }
        double[] userValues = new double[this.m_inputGeometry.getNumElements()];
        Arrays.fill(userValues, -1.0);
        int[] elements = PuGeometry.getMarkedElements(this.m_outputGeometry);
        int i = 0;
        while (i < elements.length) {
            userValues[elements[i]] = value;
            ++i;
        }
        PuGeometry.setMarkedElements(this.m_outputGeometry, null);
        return userValues;
    }

    public void restoreGeometry() {
        this.m_outputGeometry.setVertices(this.m_inputGeometry.getVertices());
        this.m_outputGeometry.update((Object)this.m_outputGeometry);
        this.fitDisplays();
    }

    public void saveScreenshot(String target) {
        PvViewerIf viewer = this.getViewer();
        if (viewer == null) {
            PsDebug.warning((String)"missing viewer.");
            return;
        }
        Dimension dim = viewer.getDisplay().getSize();
        viewer.export(61, String.valueOf(target) + ".gif", dim.width, dim.height);
    }

    public RetargetingModule getSelectedModule() {
        return this.m_selectedModule;
    }

    public void setSelectedModule(int type) {
        for (RetargetingModule module : this.m_modules) {
            if (module.getType() != type) continue;
            Iterator j = this.m_modules.iterator();
            while (j.hasNext()) {
                ((RetargetingModule)((Object)j.next())).setEnabled(false);
            }
            this.m_selectedModule = module;
            this.m_selectedModule.setEnabled(true);
            return;
        }
        throw new IllegalArgumentException("Retargeting Module of requested type does not exist.");
    }

    public LinkedList getModules() {
        return this.m_modules;
    }

    public boolean isShowingGradients() {
        return this.m_bShowGradients;
    }

    public void showGradients(boolean showGradients) {
        if (this.m_bShowGradients == showGradients) {
            return;
        }
        this.m_bShowGradients = showGradients;
        if (this.m_bShowGradients) {
            this.computeGradients();
        } else {
            this.m_outputGeometry.removeAllVectorFields();
        }
    }

    public boolean isShowingAxes() {
        return this.m_bShowAxes;
    }

    public void showAxes(boolean showAxes) {
        this.m_bShowAxes = showAxes;
    }

    public boolean isShowingEdges() {
        return this.m_outputGeometry.isShowingEdges();
    }

    public void showEdges(boolean bShowEdges) {
        this.m_outputGeometry.showEdges(bShowEdges);
    }

    public boolean isAutoRetarget() {
        return this.m_bAutoRetarget;
    }

    public void setAutoRetarget(boolean autoRetarget) {
        Iterator i = this.m_modules.iterator();
        while (i.hasNext()) {
            ((RetargetingModule)((Object)i.next())).setAutoRetarget(autoRetarget);
        }
        this.m_bAutoRetarget = autoRetarget;
    }
}

