/*
 * Decompiled with CFR 0.152.
 */
package devRetarget;

import devRetarget.PjBrushes;
import devRetarget.brushes.Brush;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;

public class PjBrushes_IP
extends PjProject_IP
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    protected static final int[] visualizerMapping;
    protected PjBrushes m_pjBrushes;
    protected Checkbox m_cShowAxes;
    protected Checkbox m_cAutoFit;
    protected Checkbox m_cShowEdges;
    protected Checkbox m_cShowFrames;
    protected Checkbox m_cShowDouble;
    protected Choice m_cVisualizer;
    protected Checkbox m_cVisualizerJustOnce;
    protected Checkbox m_cShowRadiusOnly;
    protected Choice m_cBrushChooser;
    protected int[] brushTypeMapping;
    protected PsPanel m_pBrush;
    protected Checkbox m_cFixBoundary;
    protected Checkbox m_cAutoUpdateGradients;
    protected Checkbox m_cAutoRetarget;
    protected Button m_bUpdateGradients;
    protected Button m_bUpdateFrames;
    protected Button m_bModifyMarked;
    protected Checkbox m_cConstrainTexture;
    protected Button m_bFixSelected;
    protected Button m_bAddToFixed;
    protected Button m_bRemoveFromFixed;
    protected Checkbox m_cShowFixed;
    protected Button m_bRetarget;
    protected Button m_bResetGeometry;
    protected Button m_bSetCurrentAsGeometry;
    protected Button m_bSaveScreenshot;
    protected Button m_bReset;
    protected PsPanel m_pImportModel;
    protected PsPanel m_pBrushPanel;
    protected PsPanel m_pStencilPanel;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        visualizerMapping = nArray;
    }

    protected static int visualizerToIndex(int visualizer) {
        int i = 0;
        while (i < visualizerMapping.length) {
            if (visualizerMapping[i] == visualizer) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected static int indexToVisualizer(int index) {
        if (index < visualizerMapping.length) {
            return visualizerMapping[index];
        }
        throw new IllegalArgumentException();
    }

    public PjBrushes_IP() {
        this.addTitle("Brushes for Local Retargeting");
        this.m_pImportModel = new PsPanel();
        this.add((Component)this.m_pImportModel);
        this.addSubTitle("Display Options");
        PsPanel pChecks = new PsPanel((LayoutManager)new GridLayout(3, 2));
        this.m_cShowAxes = new Checkbox("Show Axes");
        this.m_cShowAxes.addItemListener(this);
        pChecks.add((Component)this.m_cShowAxes);
        this.m_cAutoFit = new Checkbox("Auto-Fit Camera");
        this.m_cAutoFit.addItemListener(this);
        pChecks.add((Component)this.m_cAutoFit);
        this.m_cShowEdges = new Checkbox("Show Edges");
        this.m_cShowEdges.addItemListener(this);
        pChecks.add((Component)this.m_cShowEdges);
        this.m_cShowFrames = new Checkbox("Show Local Frames");
        this.m_cShowFrames.addItemListener(this);
        pChecks.add((Component)this.m_cShowFrames);
        this.m_cShowDouble = new Checkbox("Show Copy Geometry");
        this.m_cShowDouble.addItemListener(this);
        pChecks.add((Component)this.m_cShowDouble);
        this.m_cVisualizerJustOnce = new Checkbox("Show Visualizer Once");
        this.m_cVisualizerJustOnce.addItemListener(this);
        pChecks.add((Component)this.m_cVisualizerJustOnce);
        this.add((Component)pChecks);
        this.m_cVisualizer = new Choice();
        this.m_cVisualizer.addItemListener(this);
        this.m_cVisualizer.add("Sphere");
        this.m_cVisualizer.add("Ring");
        this.m_cVisualizer.add("Flashing Elements");
        this.addLabelComponent("Visualizer:", this.m_cVisualizer);
        this.addSubTitle("Brushes");
        this.m_cBrushChooser = new Choice();
        this.m_cBrushChooser.addItemListener(this);
        this.addLabelComponent("Brush type:", this.m_cBrushChooser);
        this.m_pBrushPanel = new PsPanel();
        this.add((Component)this.m_pBrushPanel);
        this.m_cShowRadiusOnly = new Checkbox("Show radius of brush only");
        this.m_cShowRadiusOnly.addItemListener(this);
        this.add(this.m_cShowRadiusOnly);
        this.m_pBrush = new PsPanel((LayoutManager)new BorderLayout());
        this.m_pBrush.setInsetSizeVertical(10);
        this.m_pBrush.setInsetSizeHorizontal(5);
        this.m_pBrush.setBorderType(1);
        this.add((Component)this.m_pBrush);
        this.m_cFixBoundary = new Checkbox("Fix boundary vertices");
        this.m_cFixBoundary.addItemListener(this);
        this.add(this.m_cFixBoundary);
        this.m_bModifyMarked = new Button("Apply brush to marked elements.");
        this.m_bModifyMarked.addActionListener(this);
        this.add(this.m_bModifyMarked);
        PsPanel pUpdate = new PsPanel((LayoutManager)new GridLayout(2, 2));
        this.m_cAutoUpdateGradients = new Checkbox("Auto-update gradients");
        this.m_cAutoUpdateGradients.addItemListener(this);
        pUpdate.add((Component)this.m_cAutoUpdateGradients);
        this.m_cAutoRetarget = new Checkbox("Auto-retarget");
        this.m_cAutoRetarget.addItemListener(this);
        pUpdate.add((Component)this.m_cAutoRetarget);
        this.m_bUpdateGradients = new Button("Update gradients");
        this.m_bUpdateGradients.addActionListener(this);
        pUpdate.add((Component)this.m_bUpdateGradients);
        this.m_bUpdateFrames = new Button("Update local frames");
        this.m_bUpdateFrames.addActionListener(this);
        pUpdate.add((Component)this.m_bUpdateFrames);
        this.add((Component)pUpdate);
        this.addSubTitle("Constraints");
        this.m_cConstrainTexture = new Checkbox("Constrain texture instead of positions");
        this.m_cConstrainTexture.addItemListener(this);
        this.add(this.m_cConstrainTexture);
        this.m_bAddToFixed = new Button("Add selected to fixed");
        this.m_bAddToFixed.addActionListener(this);
        this.add(this.m_bAddToFixed);
        this.m_bRemoveFromFixed = new Button("Remove selected from fixed");
        this.m_bRemoveFromFixed.addActionListener(this);
        this.add(this.m_bRemoveFromFixed);
        this.m_pStencilPanel = new PsPanel();
        this.add((Component)this.m_pStencilPanel);
        this.m_cShowFixed = new Checkbox("Show fixed vertices");
        this.m_cShowFixed.addItemListener(this);
        this.add(this.m_cShowFixed);
        this.m_bFixSelected = new Button("Fix selected vertices");
        this.m_bFixSelected.addActionListener(this);
        this.m_bRetarget = new Button("Retarget");
        this.m_bRetarget.addActionListener(this);
        this.add(this.m_bRetarget);
        this.m_bSetCurrentAsGeometry = new Button("Update domain");
        this.m_bSetCurrentAsGeometry.addActionListener(this);
        this.add(this.m_bSetCurrentAsGeometry);
        this.m_bResetGeometry = new Button("Revert to domain");
        this.m_bResetGeometry.addActionListener(this);
        this.add(this.m_bResetGeometry);
        this.m_bSaveScreenshot = new Button("Save a screenshot");
        this.m_bSaveScreenshot.addActionListener(this);
        this.m_bSaveScreenshot.setEnabled(true);
        this.add(this.m_bSaveScreenshot);
        this.m_bReset = new Button("Reset");
        this.m_bReset.addActionListener(this);
        this.add(this.m_bReset);
        this.validate();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_pjBrushes = (PjBrushes)parent;
        this.m_pImportModel.removeAll();
        this.m_pImportModel.add((Component)this.m_pjBrushes.m_import.getInfoPanel());
        this.m_pBrushPanel.removeAll();
        this.m_pBrushPanel.add((Component)this.m_pjBrushes.m_brushSize.getInfoPanel());
        this.m_pStencilPanel.removeAll();
        this.m_pStencilPanel.add((Component)this.m_pjBrushes.m_stencilSize.getInfoPanel());
        this.m_pStencilPanel.add((Component)this.m_pjBrushes.m_stencilPower.getInfoPanel());
        this.m_pBrush.removeAll();
        if (this.m_pjBrushes.m_selectedBrush != null) {
            this.m_pBrush.add((Component)this.m_pjBrushes.m_selectedBrush.getInfoPanel());
        }
        this.validate();
    }

    public boolean update(Object eventSource) {
        if (eventSource == this.m_pjBrushes) {
            PsPanel.setState((Checkbox)this.m_cAutoFit, (boolean)this.m_pjBrushes.isEnabledAutoFit());
            PsPanel.setState((Checkbox)this.m_cShowAxes, (boolean)this.m_pjBrushes.isShowingAxes());
            PsPanel.setState((Checkbox)this.m_cShowEdges, (boolean)this.m_pjBrushes.isShowingEdges());
            PsPanel.setState((Checkbox)this.m_cShowFrames, (boolean)this.m_pjBrushes.isShowingFrames());
            PsPanel.setState((Checkbox)this.m_cShowDouble, (boolean)this.m_pjBrushes.isShowingDouble());
            this.m_cVisualizer.select(PjBrushes_IP.visualizerToIndex(this.m_pjBrushes.getVisualizer()));
            PsPanel.setState((Checkbox)this.m_cVisualizerJustOnce, (boolean)this.m_pjBrushes.isVisualizerJustOnce());
            PsPanel.setState((Checkbox)this.m_cShowRadiusOnly, (boolean)this.m_pjBrushes.isShowRadiusOnly());
            PsPanel.setState((Checkbox)this.m_cFixBoundary, (boolean)this.m_pjBrushes.isFixBoundary());
            PsPanel.setState((Checkbox)this.m_cAutoUpdateGradients, (boolean)this.m_pjBrushes.isUpdateGradients());
            PsPanel.setState((Checkbox)this.m_cAutoRetarget, (boolean)this.m_pjBrushes.isAutoRetarget());
            PsPanel.setState((Checkbox)this.m_cShowFixed, (this.m_pjBrushes.isShowingFixedVertices() || this.m_pjBrushes.isShowingFixedTextureVertices() ? 1 : 0) != 0);
            this.m_cBrushChooser.removeAll();
            Vector brushes = this.m_pjBrushes.getBrushes();
            this.brushTypeMapping = new int[brushes.size()];
            int typeIndex = 0;
            for (Brush brush : brushes) {
                this.m_cBrushChooser.add(brush.getName());
                this.brushTypeMapping[typeIndex++] = brush.getType();
            }
            int brushType = this.brushTypeToIndex(this.m_pjBrushes.getTypeOfSelectedBrush());
            if (brushType != -1) {
                this.m_cBrushChooser.select(brushType);
            }
            this.m_pBrush.removeAll();
            if (this.m_pjBrushes.m_selectedBrush != null) {
                this.m_pBrush.add((Component)this.m_pjBrushes.m_selectedBrush.getInfoPanel());
            }
            this.validate();
            return true;
        }
        return super.update(eventSource);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_bRetarget) {
            this.m_pjBrushes.retarget();
            return;
        }
        if (source == this.m_bUpdateGradients) {
            this.m_pjBrushes.updateCoordinateGradients();
            this.m_pjBrushes.updateTextureGradients();
        } else if (source == this.m_bUpdateFrames) {
            this.m_pjBrushes.updateFrames();
        } else {
            if (source == this.m_bAddToFixed) {
                if (this.m_cConstrainTexture.getState()) {
                    this.m_pjBrushes.fixSelectedTextureVertices();
                } else {
                    this.m_pjBrushes.fixSelectedVertices();
                }
                return;
            }
            if (source == this.m_bRemoveFromFixed) {
                if (this.m_cConstrainTexture.getState()) {
                    this.m_pjBrushes.unfixSelectedTextureVertices();
                } else {
                    this.m_pjBrushes.unfixSelectedVertices();
                }
                return;
            }
            if (source == this.m_bFixSelected) {
                this.m_pjBrushes.fixSelectedVertices();
                return;
            }
            if (source == this.m_bFixSelected) {
                this.m_pjBrushes.fixSelectedVertices();
                return;
            }
            if (source == this.m_bModifyMarked) {
                this.m_pjBrushes.modifyMarkedElements();
                return;
            }
            if (source == this.m_bResetGeometry) {
                this.m_pjBrushes.resetGeometry();
                return;
            }
            if (source == this.m_bSetCurrentAsGeometry) {
                this.m_pjBrushes.setGeometry(this.m_pjBrushes.m_outputGeometry);
                return;
            }
            if (source == this.m_bSaveScreenshot) {
                FileDialog imageSaver = new FileDialog(new Frame(), "Save the Result", 1);
                imageSaver.setDirectory(".\\images\\output");
                imageSaver.setFile("result");
                imageSaver.setVisible(true);
                if (imageSaver.getFile() != null) {
                    this.m_pjBrushes.saveScreenshot(String.valueOf(imageSaver.getDirectory()) + imageSaver.getFile());
                }
                return;
            }
            if (source == this.m_bReset) {
                this.m_pjBrushes.init();
                return;
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.m_cShowAxes) {
            this.m_pjBrushes.setShowingAxes(this.m_cShowAxes.getState());
            return;
        }
        if (source == this.m_cAutoFit) {
            this.m_pjBrushes.setEnabledAutoFit(this.m_cAutoFit.getState());
            return;
        }
        if (source == this.m_cShowEdges) {
            this.m_pjBrushes.setShowingEdges(this.m_cShowEdges.getState());
            return;
        }
        if (source == this.m_cShowFrames) {
            this.m_pjBrushes.setShowingFrames(this.m_cShowFrames.getState());
            return;
        }
        if (source == this.m_cShowDouble) {
            this.m_pjBrushes.setShowingDouble(this.m_cShowDouble.getState());
            return;
        }
        if (source == this.m_cVisualizer) {
            this.m_pjBrushes.setVisualizer(PjBrushes_IP.indexToVisualizer(this.m_cVisualizer.getSelectedIndex()));
            return;
        }
        if (source == this.m_cVisualizerJustOnce) {
            this.m_pjBrushes.setVisualizerJustOnce(this.m_cVisualizerJustOnce.getState());
            return;
        }
        if (source == this.m_cBrushChooser) {
            this.m_pjBrushes.setTypeOfSelectedBrush(this.indexToBrushType(this.m_cBrushChooser.getSelectedIndex()));
            this.m_pBrush.removeAll();
            if (this.m_pjBrushes.m_selectedBrush != null) {
                this.m_pBrush.add((Component)this.m_pjBrushes.m_selectedBrush.getInfoPanel());
            }
            this.validate();
            return;
        }
        if (source == this.m_cShowRadiusOnly) {
            this.m_pjBrushes.setShowRadiusOnly(this.m_cShowRadiusOnly.getState());
            return;
        }
        if (source == this.m_cFixBoundary) {
            this.m_pjBrushes.setFixBoundary(this.m_cFixBoundary.getState());
            return;
        }
        if (source == this.m_cAutoUpdateGradients) {
            this.m_pjBrushes.setUpdateGradients(this.m_cAutoUpdateGradients.getState());
            return;
        }
        if (source == this.m_cAutoRetarget) {
            this.m_pjBrushes.setAutoRetarget(this.m_cAutoRetarget.getState());
            return;
        }
        if (source == this.m_cConstrainTexture) {
            this.m_cShowFixed.setState(this.m_cShowFixed.getState());
        } else if (source == this.m_cShowFixed) {
            boolean show = this.m_cShowFixed.getState();
            if (this.m_cConstrainTexture.getState()) {
                this.m_pjBrushes.setShowFixedVertices(false);
                this.m_pjBrushes.setShowFixedTextureVertices(show);
            } else {
                this.m_pjBrushes.setShowFixedTextureVertices(false);
                this.m_pjBrushes.setShowFixedVertices(show);
            }
            return;
        }
    }

    protected int brushTypeToIndex(int moduleType) {
        int i = 0;
        while (i < this.brushTypeMapping.length) {
            if (this.brushTypeMapping[i] == moduleType) {
                return i;
            }
            ++i;
        }
        PsDebug.warning((String)("brush type not available, moduleType = " + moduleType));
        return -1;
    }

    protected int indexToBrushType(int index) {
        if (index < this.brushTypeMapping.length) {
            return this.brushTypeMapping[index];
        }
        throw new IllegalArgumentException();
    }
}

