/*
 * Decompiled with CFR 0.152.
 */
package devRetarget;

import devRetarget.brushes.BrBulge;
import devRetarget.brushes.BrCurl;
import devRetarget.brushes.BrFlatten;
import devRetarget.brushes.BrRotate;
import devRetarget.brushes.BrScale;
import devRetarget.brushes.BrSmooth;
import devRetarget.brushes.BrTextureConstraints;
import devRetarget.brushes.BrTextureRotate;
import devRetarget.brushes.BrTextureScale;
import devRetarget.brushes.BrTextureVasarely;
import devRetarget.brushes.BrTwist;
import devRetarget.brushes.Brush;
import devRetarget.brushes.ElementTransform;
import devRetarget.brushes.FlashVisualizer;
import devRetarget.brushes.PgBrushGeometry;
import devRetarget.brushes.RingVisualizer;
import devRetarget.brushes.SphereVisualizer;
import devRetarget.retargeting.PnRetargeting;
import devRetarget.retargeting.PuRetargeting;
import devRetarget.util.PuGeometry;
import devRetarget.util.PuUtil;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.loader.PjImportModel;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.viewer.PvDisplay;

public class PjBrushes
extends PjProject
implements ActionListener,
PvPickListenerIf {
    public static final int TYPE_SCALE = 0;
    public static final int TYPE_ROTATE = 1;
    public static final int TYPE_CURL = 8;
    public static final int TYPE_TWIST = 9;
    public static final int TYPE_BULGE = 2;
    public static final int TYPE_FLATTEN = 5;
    public static final int TYPE_SMOOTH = 6;
    public static final int TYPE_TEXTURE_SCALE = 3;
    public static final int TYPE_TEXTURE_ROTATE = 4;
    public static final int TYPE_TEXTURE_VASARELY = 7;
    public static final int TYPE_TEXTURE_CONSTRAINTS = 10;
    private static final int[] DEFAULT_BRUSHES;
    public static final int VISUALIZER_SPHERE = 0;
    public static final int VISUALIZER_RING = 1;
    public static final int VISUALIZER_FLASH = 2;
    private static final String m_defaultFileName = "models\\byu\\Brezel_1920.byu";
    protected PjImportModel m_import;
    protected PgElementSet m_outputGeometry;
    protected PgBrushGeometry m_inputGeometry;
    protected PgElementSet m_doubleGeometry;
    protected PgVectorField[] m_modifiedGradients;
    protected PgVectorField[] m_currentGradients;
    protected PgVectorField[] m_origFrames;
    protected PgVectorField[] m_currentFrames;
    protected boolean m_bGeometryModified;
    protected PgVectorField[] m_currentTextureGradients;
    protected boolean m_bTexturesModified;
    protected Brush m_selectedBrush;
    protected Vector m_brushes = new Vector();
    protected boolean m_bShowAxes;
    protected boolean m_bShowEdges;
    protected boolean m_bShowFrames;
    protected boolean m_bShowDouble;
    protected int m_visualizer;
    protected boolean m_bVisualizerJustOnce;
    protected PuDouble m_brushSize;
    protected PuDouble m_stencilSize;
    protected PuDouble m_stencilPower;
    protected boolean m_bSizeWasChanged;
    protected boolean m_bShowRadiusOnly;
    protected boolean m_bFixBoundary;
    protected HashSet m_draggedVertices = new HashSet();
    protected boolean m_bShowFixedVertices;
    protected boolean m_bShowFixedTextureVertices;
    protected boolean m_bUpdateGradients;
    protected boolean m_bAutoRetarget;
    protected Toolkit m_toolkit;
    protected SphereVisualizer m_sphereVis;
    protected RingVisualizer m_ringVis;
    protected FlashVisualizer m_flashVis;
    protected PgElementSet m_tempElemSet;
    protected PnRetargeting m_solver;
    protected PnRetargeting m_textureSolver;

    static {
        int[] nArray = new int[11];
        nArray[1] = 1;
        nArray[2] = 8;
        nArray[3] = 9;
        nArray[4] = 2;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 3;
        nArray[8] = 4;
        nArray[9] = 7;
        nArray[10] = 10;
        DEFAULT_BRUSHES = nArray;
    }

    public PjBrushes() {
        super("Retargeting using Brushes");
        this.m_brushSize = new PuDouble("Brush size", (PsUpdateIf)this);
        this.m_stencilSize = new PuDouble("Stencil size", (PsUpdateIf)this);
        this.m_stencilPower = new PuDouble("Stencil power", (PsUpdateIf)this);
        this.m_import = new PjImportModel();
        this.m_import.setTypeOfInfoPanel(1);
        this.m_import.addActionListener((ActionListener)this);
        this.m_import.setFileName(m_defaultFileName);
        this.m_outputGeometry = new PgElementSet();
        this.m_outputGeometry.setName("Output Geometry");
        this.m_outputGeometry.addUpdateListener((PsUpdateIf)this);
        this.m_inputGeometry = new PgBrushGeometry();
        this.m_inputGeometry.setName("Domain Geometry");
        this.m_inputGeometry.setVisible(false);
        this.m_inputGeometry.addUpdateListener((PsUpdateIf)this);
        this.m_doubleGeometry = new PgElementSet();
        this.m_doubleGeometry.setName("Double Geometry");
        this.m_doubleGeometry.setVisible(false);
        this.m_solver = new PnRetargeting();
        this.m_solver.setGeometry(this.m_inputGeometry);
        this.m_textureSolver = new PnRetargeting();
        this.m_textureSolver.setGeometry(this.m_inputGeometry);
        if (this.getClass() == PjBrushes.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_brushSize.setDefBounds(0.5, 50.0, 0.5, 0.5);
        this.m_brushSize.setDefValue(5.0);
        this.m_brushSize.init();
        this.m_stencilSize.setDefBounds(0.0, 30.0, 0.5, 0.5);
        this.m_stencilSize.setDefValue(10.0);
        this.m_stencilSize.init();
        this.m_stencilPower.setDefBounds(0.0, 40.0, 0.5, 0.5);
        this.m_stencilPower.setDefValue(12.0);
        this.m_stencilPower.init();
        this.m_tempElemSet = null;
        this.m_import.setBase(String.valueOf(PsConfig.getCodeBase()) + "models\\");
        this.m_import.setCategory("retargeting\\");
        this.m_bAutoFit = false;
        this.m_bShowAxes = false;
        this.m_bShowEdges = true;
        this.m_bShowFrames = true;
        this.m_bShowDouble = true;
        this.m_visualizer = 0;
        this.m_bVisualizerJustOnce = false;
        this.m_bAutoRetarget = true;
        this.m_bSizeWasChanged = true;
        this.m_bFixBoundary = false;
        this.m_bUpdateGradients = false;
        this.m_bShowRadiusOnly = false;
    }

    public void start() {
        PvDisplay display = (PvDisplay)this.getViewer().getDisplay();
        display.showAxes(this.m_bShowAxes);
        if (!display.hasPickListener((PvPickListenerIf)this)) {
            display.addPickListener((PvPickListenerIf)this);
        }
        display.setEnabledTags(true);
        this.m_sphereVis = new SphereVisualizer((PvDisplayIf)display);
        this.m_ringVis = new RingVisualizer((PvDisplayIf)display);
        this.addGeometry((PgGeometryIf)this.m_outputGeometry);
        this.addGeometry((PgGeometryIf)this.m_inputGeometry);
        this.addGeometry((PgGeometryIf)this.m_doubleGeometry);
        this.selectGeometry((PgGeometryIf)this.m_outputGeometry);
        if (!this.m_import.load(m_defaultFileName)) {
            PsDebug.warning((String)"failed loading model: models\\byu\\Brezel_1920.byu");
            return;
        }
        this.setGeometry((PgElementSet)this.m_import.getGeometry());
        Brush brush = null;
        int i = 0;
        while (i < DEFAULT_BRUSHES.length) {
            switch (DEFAULT_BRUSHES[i]) {
                case 0: {
                    brush = new BrScale();
                    break;
                }
                case 1: {
                    brush = new BrRotate();
                    break;
                }
                case 8: {
                    brush = new BrCurl();
                    break;
                }
                case 9: {
                    brush = new BrTwist();
                    break;
                }
                case 2: {
                    brush = new BrBulge();
                    break;
                }
                case 5: {
                    brush = new BrFlatten();
                    break;
                }
                case 6: {
                    brush = new BrSmooth();
                    break;
                }
                case 3: {
                    brush = new BrTextureScale();
                    break;
                }
                case 4: {
                    brush = new BrTextureRotate();
                    break;
                }
                case 7: {
                    brush = new BrTextureVasarely();
                    break;
                }
                case 10: {
                    brush = new BrTextureConstraints();
                    break;
                }
                default: {
                    PsDebug.error((String)("unknown brush, type = " + DEFAULT_BRUSHES[i]));
                }
            }
            brush.setDock(this);
            this.registerBrush(brush);
            ++i;
        }
        this.setTypeOfSelectedBrush(0);
        this.m_toolkit = Toolkit.getDefaultToolkit();
        super.start();
    }

    public PgElementSet getOutputGeometry() {
        return this.m_outputGeometry;
    }

    public PgGeometryIf getGeometry() {
        return this.m_outputGeometry;
    }

    public boolean setGeometry(PgElementSet geom) {
        boolean bNewGeometry;
        if (geom == null || !(geom instanceof PgElementSet)) {
            PsDebug.warning((String)"geometry missing or not of type PgElementSet.");
            return false;
        }
        PgElementSet geometry = geom;
        boolean bl = bNewGeometry = geometry != this.m_outputGeometry;
        if (bNewGeometry) {
            this.m_outputGeometry.copy((PsObject)geometry);
            PgElementSet.triangulate((PgElementSet)this.m_outputGeometry);
            PdVector center = PuUtil.getCenter(this.m_outputGeometry.getVertices());
            center.multScalar(-1.0);
            this.m_outputGeometry.translate(center);
        }
        this.setInputGeometry(this.m_outputGeometry, bNewGeometry);
        this.setOutputGeometry();
        this.m_flashVis = new FlashVisualizer(this.m_outputGeometry);
        this.m_bSizeWasChanged = true;
        this.updateBrushes();
        this.update(this);
        if (bNewGeometry) {
            this.fitDisplays();
        }
        return true;
    }

    private void setOutputGeometry() {
        Color defaultColor = new Color(230, 230, 240);
        int e = this.m_outputGeometry.getNumElements() - 1;
        while (e >= 0) {
            this.m_outputGeometry.setElementColor(e, defaultColor);
            --e;
        }
        this.m_outputGeometry.showElementColors(true);
        this.m_outputGeometry.setGlobalElementColor(defaultColor);
        this.createModifiedGradients(this.m_outputGeometry);
        this.initializeModifiedGradients(this.m_currentGradients, 0.05 * this.m_inputGeometry.getDiameter());
    }

    public PgBrushGeometry getInputGeometry() {
        return this.m_inputGeometry;
    }

    protected void setInputGeometry(PgElementSet geom, boolean isNewGeometry) {
        if (geom == null || geom != this.m_outputGeometry) {
            PsDebug.warning((String)"missing or incompatible geometry, must be equal to base geometry.");
            return;
        }
        PiVector oldFixedVertices = null;
        PiVector oldFixedTextures = null;
        if (!isNewGeometry) {
            oldFixedVertices = this.m_inputGeometry.getFixedVertices();
            oldFixedTextures = this.m_inputGeometry.getFixedTextureVertices();
        }
        boolean bInputVisible = this.m_inputGeometry.isVisible();
        this.m_inputGeometry.init();
        this.m_inputGeometry.copy((PsObject)geom);
        this.m_inputGeometry.setVisible(bInputVisible);
        this.m_inputGeometry.markBoundary();
        this.m_inputGeometry.makeVertexNormals();
        this.m_inputGeometry.makeElementNormals();
        this.m_inputGeometry.setTextured(geom.hasVertexTextures());
        this.m_inputGeometry.setFixBoundary(this.m_bFixBoundary);
        this.m_inputGeometry.setFixTextureBoundary(this.m_bFixBoundary);
        if (!isNewGeometry) {
            this.m_inputGeometry.addFixedVertices(oldFixedVertices, null);
            this.m_inputGeometry.addFixedTextureVertices(oldFixedTextures);
        }
        this.m_solver.setGeometry(this.m_inputGeometry);
        this.m_solver.computeAndFactorizeStiffnessMatrix();
        if (this.m_textureSolver != null) {
            this.m_textureSolver.setGeometry(this.m_inputGeometry);
            this.m_textureSolver.computeAndFactorizeStiffnessMatrix();
        }
        this.m_bGeometryModified = false;
        this.m_currentTextureGradients = this.m_inputGeometry.getTextureGradients();
        this.m_bTexturesModified = false;
        this.setDoubleGeometry();
        this.m_inputGeometry.update((Object)this.m_inputGeometry);
    }

    protected void setDoubleGeometry() {
        this.m_doubleGeometry.init();
        this.m_doubleGeometry.copy((PsObject)this.m_inputGeometry);
        this.m_doubleGeometry.setVisible(this.m_bShowDouble);
        this.m_doubleGeometry.setGlobalElementColor(new Color(0.9019608f, 0.9019608f, 0.9411765f));
        this.m_doubleGeometry.translate(new PdVector(this.m_inputGeometry.getDiameter(), 0.0, 0.0));
        this.createCurrentGradients(this.m_doubleGeometry);
        this.initializeCurrentGradients(this.m_inputGeometry.coordinateGradients(), 0.05 * this.m_inputGeometry.getDiameter());
        this.setCurrentFrames(this.m_inputGeometry.getFrames());
    }

    private void createModifiedGradients(PgElementSet geom) {
        int i;
        if (this.m_modifiedGradients == null) {
            this.m_modifiedGradients = new PgVectorField[3];
            i = 0;
            while (i < 3) {
                this.m_modifiedGradients[i] = new PgVectorField(3, 1);
                this.m_modifiedGradients[i].setName("Modified VF[" + i + "]");
                this.m_modifiedGradients[i].setGeometry((PgPointSet)geom);
                geom.addVectorField(this.m_modifiedGradients[i]);
                ++i;
            }
        }
        i = 0;
        while (i < 3) {
            this.m_modifiedGradients[i].setGlobalVectorLength(1.0);
            ++i;
        }
    }

    private void initializeModifiedGradients(PgVectorField[] gradients, double scale) {
        int i = 0;
        while (i < 3) {
            this.m_modifiedGradients[i].copy((PsObject)gradients[i]);
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.m_modifiedGradients[i].showIndividualMaterial(true);
            if (scale >= 0.0) {
                this.m_modifiedGradients[i].setGlobalVectorLength(scale);
            }
            this.m_modifiedGradients[i].setGlobalVectorSize(1.0);
            Color vectorColor = PdColor.getColorFromID((int)i, (boolean)false);
            this.m_modifiedGradients[i].setGlobalVectorColor(vectorColor);
            ++i;
        }
    }

    private void createCurrentGradients(PgElementSet geom) {
        int i;
        if (this.m_currentGradients == null) {
            this.m_currentGradients = new PgVectorField[3];
            i = 0;
            while (i < 3) {
                this.m_currentGradients[i] = new PgVectorField(3, 1);
                this.m_currentGradients[i].setName("Current VF[" + i + "]");
                this.m_currentGradients[i].setGeometry((PgPointSet)geom);
                geom.addVectorField(this.m_currentGradients[i]);
                ++i;
            }
        }
        i = 0;
        while (i < 3) {
            this.m_currentGradients[i].setGlobalVectorLength(1.0);
            ++i;
        }
    }

    private void initializeCurrentGradients(PgVectorField[] gradients, double scale) {
        int i = 0;
        while (i < 3) {
            Color vectorColor;
            this.m_currentGradients[i].copy((PsObject)gradients[i]);
            if (scale >= 0.0) {
                this.m_currentGradients[i].setGlobalVectorLength(scale);
            }
            this.m_currentGradients[i].showIndividualMaterial(true);
            this.m_currentGradients[i].setGlobalVectorSize(1.0);
            switch (i) {
                default: {
                    vectorColor = new Color(0.0f, 1.0f, 0.0f);
                    break;
                }
                case 1: {
                    vectorColor = new Color(1.0f, 0.0f, 0.0f);
                    break;
                }
                case 2: {
                    vectorColor = new Color(0.0f, 0.0f, 1.0f);
                }
            }
            vectorColor = PdColor.getColorFromID((int)i, (boolean)false);
            this.m_currentGradients[i].setGlobalVectorColor(vectorColor);
            ++i;
        }
    }

    public boolean update(Object event) {
        if (event == this) {
            int i;
            if (this.m_bShowFrames) {
                i = 0;
                while (i < 3) {
                    this.m_currentFrames[i].setVisible(true);
                    ++i;
                }
                this.m_doubleGeometry.showVectorFields(true);
            } else {
                i = 0;
                while (i < 3) {
                    this.m_currentFrames[i].setVisible(false);
                    ++i;
                }
            }
            this.m_doubleGeometry.setVisible(this.m_bShowDouble);
            this.m_doubleGeometry.update((Object)this.m_doubleGeometry);
            if (this.m_bShowFixedVertices || this.m_bShowFixedTextureVertices) {
                int v;
                PiVector fixedVertices;
                double fixedSize;
                Color defaultColor = Color.white;
                double defaultSize = 1.0;
                int v2 = 0;
                while (v2 < this.m_outputGeometry.getNumVertices()) {
                    this.m_outputGeometry.setVertexColor(v2, defaultColor);
                    this.m_outputGeometry.setVertexSize(v2, defaultSize);
                    ++v2;
                }
                if (this.m_bShowFixedVertices) {
                    Color fixedColor = new Color(0.0f, 1.0f, 1.0f);
                    fixedSize = 4.0;
                    fixedVertices = this.m_inputGeometry.getFixedVertices();
                    v = 0;
                    while (v < fixedVertices.getSize()) {
                        this.m_outputGeometry.setVertexColor(fixedVertices.getEntry(v), fixedColor);
                        this.m_outputGeometry.setVertexSize(fixedVertices.getEntry(v), fixedSize);
                        ++v;
                    }
                }
                if (this.m_bShowFixedTextureVertices) {
                    Color fixedColor = new Color(1.0f, 1.0f, 0.0f);
                    fixedSize = 4.0;
                    fixedVertices = this.m_inputGeometry.getFixedTextureVertices();
                    v = 0;
                    while (v < fixedVertices.getSize()) {
                        this.m_outputGeometry.setVertexColor(fixedVertices.getEntry(v), fixedColor);
                        this.m_outputGeometry.setVertexSize(fixedVertices.getEntry(v), fixedSize);
                        ++v;
                    }
                }
            }
            this.m_outputGeometry.showEdges(this.m_bShowEdges);
            this.m_outputGeometry.showVertexColors(this.m_bShowFixedVertices || this.m_bShowFixedTextureVertices);
            this.m_outputGeometry.showVertexSizes(this.m_bShowFixedVertices || this.m_bShowFixedTextureVertices);
            this.m_outputGeometry.showVertices(this.m_bShowFixedVertices || this.m_bShowFixedTextureVertices);
            this.m_outputGeometry.update((Object)this.m_outputGeometry);
            if (this.isEnabledAutoFit()) {
                this.fitDisplays();
            }
            return super.update((Object)this);
        }
        if (event == this.m_outputGeometry) {
            if (this.m_outputGeometry.getNumElements() != this.m_inputGeometry.getNumElements()) {
                PsDebug.warning((String)"Number of elements was changed, can cause problems when applying brushes.");
            }
            return true;
        }
        if (event == this.m_inputGeometry) {
            return true;
        }
        if (event == this.m_brushSize) {
            return true;
        }
        if (event == this.m_stencilSize) {
            return true;
        }
        if (event == this.m_stencilPower) {
            return true;
        }
        return super.update(event);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_import) {
            switch (this.m_import.getConfirm()) {
                case 2: {
                    if (this.m_tempElemSet != null) {
                        this.removeGeometry((PgGeometryIf)this.m_tempElemSet);
                        this.m_tempElemSet = null;
                    }
                    if (!(this.m_import.getGeometry() instanceof PgElementSet)) break;
                    this.m_tempElemSet = (PgElementSet)this.m_import.getGeometry();
                    this.addGeometry((PgGeometryIf)this.m_tempElemSet);
                    this.fitDisplays();
                    break;
                }
                case 1: {
                    if (this.m_tempElemSet != null) {
                        this.removeGeometry((PgGeometryIf)this.m_tempElemSet);
                    }
                    this.m_tempElemSet = null;
                    this.fitDisplays();
                    break;
                }
                case 0: {
                    if (this.m_tempElemSet != null) {
                        this.removeGeometry((PgGeometryIf)this.m_tempElemSet);
                    }
                    this.m_tempElemSet = null;
                    this.setGeometry((PgElementSet)this.m_import.getGeometry());
                }
            }
        }
    }

    public void dragVertex(PgGeometryIf geom, int index, PdVector vertex) {
        this.m_draggedVertices.add(new Integer(index));
        PiVector markedVertices = this.m_outputGeometry.getMarkedVertices(1);
        int numMarked = markedVertices.getSize();
        int i = 0;
        while (i < numMarked) {
            this.m_draggedVertices.add(new Integer(markedVertices.getEntry(i)));
            ++i;
        }
    }

    public void pickInitial(PvPickEvent pickEvent) {
        if (this.m_toolkit.getLockingKeyState(20)) {
            this.m_selectedBrush.processPickEvent(pickEvent);
            return;
        }
        int element = pickEvent.getElementInd();
        if (element == -1) {
            return;
        }
        if (!this.m_bVisualizerJustOnce || this.m_bShowRadiusOnly || this.m_bSizeWasChanged) {
            PdVector position = this.m_outputGeometry.getCenterOfElement(null, element);
            switch (this.m_visualizer) {
                case 0: {
                    this.m_sphereVis.setRadius(this.currentBrushRadius());
                    this.m_sphereVis.flashAt(position);
                    break;
                }
                case 1: {
                    PdVector viewDir = this.getDisplay().getCamera().getViewDir();
                    PdVector displacement = (PdVector)this.m_outputGeometry.getElementNormal(element).clone();
                    if (viewDir.dot(displacement) > 0.0) {
                        displacement.multScalar(-1.0);
                    }
                    position.add(this.m_inputGeometry.getDiameter() * 0.015, displacement);
                    this.m_ringVis.setRadius(this.currentBrushRadius());
                    this.m_ringVis.flashAt(this.m_outputGeometry.getCenterOfElement(null, element), this.m_outputGeometry.getElementNormal(element));
                    break;
                }
                case 2: {
                    PiVector elements = PuGeometry.getElementsAround(this.m_inputGeometry, element, this.currentBrushRadius(), this.m_inputGeometry.baryCenters(), null);
                    this.m_flashVis.flashAt(elements);
                }
            }
            if (this.m_bShowRadiusOnly || this.m_bSizeWasChanged) {
                this.m_bSizeWasChanged = false;
                return;
            }
        }
        double brushRadius = this.currentBrushRadius();
        Vector transforms = this.m_selectedBrush.computeTransforms(element, brushRadius);
        if (this.m_selectedBrush.isEnabledTexture()) {
            this.applyTextureTransforms(transforms);
            this.m_bTexturesModified = true;
        } else {
            this.applyTransforms(transforms);
            this.m_bGeometryModified = true;
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    public void modifyMarkedElements() {
        if (this.m_selectedBrush.getType() == 10) {
            this.m_bTexturesModified = true;
            this.m_selectedBrush.computeTransforms(null);
            this.retarget();
            return;
        }
        int[] marked = PuGeometry.getMarkedElements(this.m_outputGeometry);
        PiVector elements = new PiVector(marked);
        Vector transforms = this.m_selectedBrush.computeTransforms(elements);
        if (this.m_selectedBrush.isEnabledTexture()) {
            this.applyTextureTransforms(transforms);
            this.m_bTexturesModified = true;
        } else {
            this.applyTransforms(transforms);
            this.m_bGeometryModified = true;
        }
        if (this.m_bAutoRetarget) {
            this.retarget();
        }
    }

    protected void applyTransforms(Vector transforms) {
        if (transforms == null) {
            return;
        }
        PdMatrix result = new PdMatrix(3);
        PdMatrix stackedGradients = new PdMatrix(3);
        Enumeration i = transforms.elements();
        while (i.hasMoreElements()) {
            ElementTransform currentTransform = (ElementTransform)i.nextElement();
            PdMatrix transform = currentTransform.getTransform();
            int element = currentTransform.getElementIndex();
            stackedGradients.setRow(0, this.m_currentGradients[0].getVector(element));
            stackedGradients.setRow(1, this.m_currentGradients[1].getVector(element));
            stackedGradients.setRow(2, this.m_currentGradients[2].getVector(element));
            result.mult(transform, stackedGradients);
            int j = 0;
            while (j < this.m_currentGradients.length) {
                this.m_currentGradients[j].setVector(element, result.getRow(j));
                ++j;
            }
        }
        this.initializeModifiedGradients(this.m_currentGradients, -1.0);
        if (this.m_bShowDouble) {
            this.m_doubleGeometry.update(null);
        }
    }

    protected void applyTextureTransforms(Vector transforms) {
        if (transforms == null) {
            return;
        }
        PdMatrix result = new PdMatrix(2, 3);
        PdMatrix stackedGradients = new PdMatrix(2, 3);
        Enumeration i = transforms.elements();
        while (i.hasMoreElements()) {
            ElementTransform currentTransform = (ElementTransform)i.nextElement();
            PdMatrix transform = currentTransform.getTransform();
            int element = currentTransform.getElementIndex();
            stackedGradients.setRow(0, this.m_currentTextureGradients[0].getVector(element));
            stackedGradients.setRow(1, this.m_currentTextureGradients[1].getVector(element));
            result.mult(transform, stackedGradients);
            int j = 0;
            while (j < this.m_currentTextureGradients.length) {
                this.m_currentTextureGradients[j].setVector(element, result.getRow(j));
                ++j;
            }
        }
    }

    public void retarget() {
        this.m_outputGeometry.update((Object)this.m_outputGeometry);
    }

    public boolean hasBrushOfType(int type) {
        Enumeration i = this.m_brushes.elements();
        while (i.hasMoreElements()) {
            if (((Brush)((Object)i.nextElement())).getType() != type) continue;
            return true;
        }
        return false;
    }

    public boolean registerBrush(Brush brush) {
        if (brush == null) {
            PsDebug.warning((String)"null can not be regeistered as a brush.");
            return false;
        }
        Enumeration i = this.m_brushes.elements();
        while (i.hasMoreElements()) {
            if (((Brush)((Object)i.nextElement())).getType() != brush.getType()) continue;
            PsDebug.warning((String)"Dock allows only for one brush of each type. Brush of same type is already registered.");
        }
        this.m_brushes.add(brush);
        if (this.m_selectedBrush != null) {
            this.getInfoPanel().update((Object)this);
        }
        return true;
    }

    public boolean unregisterBrush(Brush brush) {
        this.m_brushes.remove((Object)brush);
        if (this.m_selectedBrush != null) {
            this.getInfoPanel().update((Object)this);
        }
        return true;
    }

    public boolean isRegisteredBrush(Brush brush) {
        return this.m_brushes.contains((Object)brush);
    }

    public void saveScreenshot(String target) {
        PvViewerIf viewer = this.getViewer();
        if (viewer != null) {
            int width = viewer.getDisplay().getSize().width;
            int height = viewer.getDisplay().getSize().height;
            viewer.export(61, String.valueOf(target) + ".gif", width, height);
        }
    }

    public void resetGeometry() {
        this.m_outputGeometry.setVertices(this.m_inputGeometry.getVertices());
        this.m_outputGeometry.makeElementNormals();
        if (this.m_inputGeometry.isTextured()) {
            this.m_outputGeometry.setVertexTextures(this.m_inputGeometry.getVertexTextures());
        }
        this.m_currentGradients = this.m_inputGeometry.getCoordinateGradients();
        this.setCurrentFrames(this.m_inputGeometry.getFrames());
        this.m_currentTextureGradients = this.m_inputGeometry.getTextureGradients();
        this.m_bGeometryModified = false;
        this.m_bTexturesModified = false;
        this.update(this);
    }

    public void fixSelectedVertices() {
        PiVector markedVertices = this.m_outputGeometry.getMarkedVertices(1);
        int numMarked = markedVertices.getSize();
        PdVector[] positions = new PdVector[numMarked];
        int i = 0;
        while (i < numMarked) {
            positions[i] = this.m_outputGeometry.getVertex(markedVertices.getEntry(i));
            ++i;
        }
        this.m_inputGeometry.addFixedVertices(markedVertices, positions);
        this.setShowFixedVertices(true);
        this.getInfoPanel().update((Object)this);
    }

    public void unfixSelectedVertices() {
        PiVector markedVertices = this.m_outputGeometry.getMarkedVertices(1);
        this.m_inputGeometry.removeFromFixed(markedVertices);
        this.updateCoordinateGradients();
        if (this.m_bShowFixedVertices) {
            this.update(this);
        }
    }

    public void fixSelectedTextureVertices() {
        if (!this.m_inputGeometry.isTextured()) {
            return;
        }
        PiVector markedVertices = this.m_outputGeometry.getMarkedVertices(1);
        int numMarked = markedVertices.getSize();
        PdVector[] positions = new PdVector[numMarked];
        int i = 0;
        while (i < numMarked) {
            positions[i] = this.m_outputGeometry.getVertexTexture(markedVertices.getEntry(i));
            ++i;
        }
        this.m_inputGeometry.addFixedTextureVertices(markedVertices, positions);
        this.setShowFixedTextureVertices(true);
        this.getInfoPanel().update((Object)this);
    }

    public void unfixSelectedTextureVertices() {
        if (!this.m_inputGeometry.isTextured()) {
            return;
        }
        PiVector markedVertices = this.m_outputGeometry.getMarkedVertices(1);
        this.m_inputGeometry.removeFixedTextureVertices(markedVertices);
        this.updateTextureGradients();
        if (this.m_bShowFixedTextureVertices && this.m_inputGeometry.isTextured()) {
            this.update(this);
        }
    }

    protected void updateBrushes() {
        Enumeration i = this.m_brushes.elements();
        while (i.hasMoreElements()) {
            ((Brush)((Object)i.nextElement())).setDock(this);
        }
    }

    protected double currentBrushRadius() {
        return this.m_inputGeometry.getDiameter() / 100.0 * this.m_brushSize.getValue();
    }

    protected void makeConstraintsFromDragged() {
        PiVector verticesToFix = new PiVector(this.m_draggedVertices.size());
        PdVector[] positionsToFix = new PdVector[this.m_draggedVertices.size()];
        int counter = 0;
        Iterator i = this.m_draggedVertices.iterator();
        while (i.hasNext()) {
            int currentVertex = (Integer)i.next();
            verticesToFix.setEntry(counter, currentVertex);
            positionsToFix[counter] = this.m_outputGeometry.getVertex(currentVertex);
            ++counter;
        }
        this.m_inputGeometry.addFixedVertices(verticesToFix, positionsToFix);
        double radius = this.m_inputGeometry.getDiameter() * (this.m_stencilSize.getValue() / 100.0);
        PdVector weights = PuRetargeting.computeWeightsFromVertices(this.m_inputGeometry, verticesToFix, this.m_stencilPower.getValue(), radius);
        this.m_inputGeometry.setWeights(weights);
    }

    public void updateCoordinateGradients() {
        this.m_currentGradients = PnRetargeting.computeGradientFields(this.m_inputGeometry, this.m_outputGeometry.getVertices());
    }

    public void updateTextureGradients() {
        if (!this.m_inputGeometry.isTextured()) {
            return;
        }
        this.m_currentTextureGradients = PnRetargeting.computeGradientFields(this.m_inputGeometry, this.m_outputGeometry.getVertexTextures());
    }

    public void updateFrames() {
        this.setCurrentFrames(PuRetargeting.computeLocalFrames(this.m_outputGeometry));
        if (this.m_bShowFrames) {
            this.update(this);
        }
    }

    protected void setCurrentFrames(PgVectorField[] frames) {
        int i;
        if (frames == null) {
            return;
        }
        if (this.m_currentFrames != null) {
            i = 0;
            while (i < this.m_currentFrames.length) {
                this.m_doubleGeometry.removeVectorField((PgGeometryIf)this.m_currentFrames[i]);
                ++i;
            }
        }
        this.m_currentFrames = frames;
        i = 0;
        while (i < 3) {
            this.m_currentFrames[i].setGeometry((PgPointSet)this.m_doubleGeometry);
            Color vectorColor = PdColor.getColorFromID((int)i, (boolean)true);
            this.m_currentFrames[i].setGlobalVectorColor(vectorColor);
            this.m_currentFrames[i].setGlobalVectorLength(0.015 * this.m_inputGeometry.getDiameter());
            this.m_currentFrames[i].setGlobalVectorSize(2.0);
            this.m_currentFrames[i].showIndividualMaterial(true);
            this.m_currentFrames[i].setVisible(this.m_bShowFrames);
            this.m_doubleGeometry.addVectorField(this.m_currentFrames[i]);
            ++i;
        }
        this.m_draggedVertices.clear();
    }

    public boolean isShowingAxes() {
        return this.m_bShowAxes;
    }

    public void setShowingAxes(boolean bShowAxes) {
        this.m_bShowAxes = bShowAxes;
        this.update(this);
    }

    public boolean isShowingEdges() {
        return this.m_bShowEdges;
    }

    public void setShowingEdges(boolean bShowEdges) {
        this.m_bShowEdges = bShowEdges;
        this.update(this);
    }

    public boolean isShowingFrames() {
        return this.m_bShowFrames;
    }

    public void setShowingFrames(boolean bShowFrames) {
        this.m_bShowFrames = bShowFrames;
        this.update(this);
    }

    protected Brush getSelectedBrush() {
        return this.m_selectedBrush;
    }

    protected void setSelectedBrush(Brush brush) {
        if (!this.m_brushes.contains((Object)brush)) {
            PsDebug.warning((String)"brush not registered, cannot select.");
        }
        if (this.m_selectedBrush != null) {
            this.m_selectedBrush.setEnabled(false);
        }
        this.m_selectedBrush = brush;
        this.m_selectedBrush.setEnabled(true);
    }

    public int getTypeOfSelectedBrush() {
        if (this.m_selectedBrush == null) {
            PsDebug.warning((String)"missing selected brush.");
            return -1;
        }
        return this.m_selectedBrush.getType();
    }

    public void setTypeOfSelectedBrush(int brushType) {
        if (brushType == this.getTypeOfSelectedBrush()) {
            PsDebug.warning((String)"brush type already selected.");
            return;
        }
        Enumeration i = this.m_brushes.elements();
        while (i.hasMoreElements()) {
            Brush current = (Brush)((Object)i.nextElement());
            if (current.getType() != brushType) continue;
            this.setSelectedBrush(current);
            return;
        }
        PsDebug.warning((String)("Brush of type " + brushType + " not available."));
    }

    protected Vector getBrushes() {
        return this.m_brushes;
    }

    public double getBrushSize() {
        return this.m_brushSize.getValue();
    }

    public void setBrushSize(double brushSize) {
        this.m_brushSize.setValue(brushSize);
        this.m_bSizeWasChanged = true;
    }

    public boolean isAutoRetarget() {
        return this.m_bAutoRetarget;
    }

    public void setAutoRetarget(boolean bAutoRetarget) {
        this.m_bAutoRetarget = bAutoRetarget;
    }

    public boolean isShowRadiusOnly() {
        return this.m_bShowRadiusOnly;
    }

    public void setShowRadiusOnly(boolean bShowRadiusOnly) {
        this.m_bShowRadiusOnly = bShowRadiusOnly;
    }

    public double getStencilSize() {
        return this.m_stencilSize.getValue();
    }

    public void setStencilSize(double stencilSize) {
        this.m_stencilSize.setValue(stencilSize);
    }

    public boolean isFixBoundary() {
        return this.m_bFixBoundary;
    }

    public void setFixBoundary(boolean bFixBoundary) {
        if (this.m_bFixBoundary == bFixBoundary) {
            return;
        }
        if (this.m_inputGeometry.hasBoundary()) {
            this.m_bFixBoundary = bFixBoundary;
            this.m_inputGeometry.setFixBoundary(bFixBoundary);
            this.m_inputGeometry.setFixTextureBoundary(bFixBoundary);
            this.updateCoordinateGradients();
            this.updateTextureGradients();
            this.update(this);
        }
    }

    public int getVisualizer() {
        return this.m_visualizer;
    }

    public void setVisualizer(int visualizer) {
        this.m_visualizer = visualizer;
    }

    public boolean isVisualizerJustOnce() {
        return this.m_bVisualizerJustOnce;
    }

    public void setVisualizerJustOnce(boolean visualizerJustOnce) {
        this.m_bVisualizerJustOnce = visualizerJustOnce;
    }

    public boolean isUpdateGradients() {
        return this.m_bUpdateGradients;
    }

    public void setUpdateGradients(boolean updateGradients) {
        this.m_bUpdateGradients = updateGradients;
    }

    public boolean isShowingFixedVertices() {
        return this.m_bShowFixedVertices;
    }

    public void setShowFixedVertices(boolean showFixedVertices) {
        if (this.m_bShowFixedVertices == showFixedVertices) {
            return;
        }
        this.m_bShowFixedVertices = showFixedVertices;
        this.update(this);
    }

    public boolean isShowingFixedTextureVertices() {
        return this.m_bShowFixedTextureVertices;
    }

    public void setShowFixedTextureVertices(boolean showFixedTextureVertices) {
        if (this.m_bShowFixedTextureVertices == showFixedTextureVertices) {
            return;
        }
        this.m_bShowFixedTextureVertices = showFixedTextureVertices;
        this.update(this);
    }

    public double getStencilPower() {
        return this.m_stencilPower.getValue();
    }

    public void setStencilPower(double stencilPower) {
        this.m_stencilPower.setValue(stencilPower);
    }

    public boolean isShowingDouble() {
        return this.m_bShowDouble;
    }

    public void setShowingDouble(boolean showDouble) {
        if (this.m_bShowDouble == showDouble) {
            return;
        }
        this.m_bShowDouble = showDouble;
        this.update(this);
    }
}

