/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.vecmath;

import devRegularMap.functions.symGroup;
import devRegularMap.grid.PwPutGrid;
import devRegularMap.vecmath.PuIsometry;
import devRegularMap.vecmath.PuSpace;
import devRegularMap.vecmath.PuSubgroup;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;

public class PuUniCover {
    protected int m_p;
    protected int m_q;
    protected int m_layer;
    protected static int m_discr;
    protected PdVector m_O;
    protected PdVector m_Q;
    protected PdVector m_P;
    protected double m_eps = 1.0E-8;
    PgElementSet m_elementSet;
    private PgElementSet m_PgonPattern;
    private PgElementSet m_Tesselation;
    protected PgElementSet m_tubemodel;
    private static int m_numPpattern;
    private String m_RotateQ;
    private String m_RotateP;
    private String m_Rotate2P;
    private String m_Rotate3P;
    private Color[] m_color;
    protected PiVector m_param;
    protected String m_gen;
    protected boolean m_dual;
    protected symGroup m_sym;
    protected PdMatrix[] m_rst;
    protected String[] m_eltG;
    protected int[][] m_perm;
    protected String[] m_eltH;
    protected int[][] m_cosetPerm;

    static {
        m_numPpattern = 2;
    }

    public PuUniCover(symGroup symGroup2) {
        this.m_sym = symGroup2;
        this.init();
    }

    private void init() {
        this.m_param = this.m_sym.getParameters();
        this.m_p = this.m_param.m_data[2];
        this.m_q = this.m_param.m_data[3];
        this.m_color = this.m_sym.getColors();
        this.m_eltH = this.m_sym.getSubGroupElements();
        this.m_perm = this.m_sym.getPermutation();
        this.m_cosetPerm = this.m_sym.getCosetPermutation();
        this.m_PgonPattern = new PgElementSet(3);
    }

    public PgElementSet fundPgon() {
        this.fTriangle(this.m_PgonPattern);
        PdVector[] vertex = this.m_PgonPattern.getVertices();
        PuIsometry.setTriangle(vertex);
        PuIsometry.setpq(this.m_p, this.m_q);
        this.m_rst = PuIsometry.getIsometries();
        this.m_PgonPattern.setElementColor(0, this.m_color[0]);
        PwPutGrid.makeCurvedEdge(this.m_PgonPattern);
        vertex = this.m_PgonPattern.getVertices();
        int nov = this.m_PgonPattern.getNumVertices();
        int noe = this.m_eltH.length;
        int newnov = nov * noe;
        int newnoe = noe;
        this.m_PgonPattern.setNumVertices(newnov);
        this.m_PgonPattern.setNumElements(newnoe);
        this.m_PgonPattern.getElement(0).setName("1,I");
        PdMatrix trans = new PdMatrix(3);
        int indv = 0;
        int index = -1;
        int j = 0;
        while (j < this.m_eltH.length) {
            String mov = this.m_eltH[j];
            index = PuSubgroup.getIndexOfEltInG(mov, this.m_cosetPerm, "rst", true);
            PdVector[] rotVertex = new PdVector[nov];
            trans = PuIsometry.getTrans(mov, this.m_rst, "rst");
            int k = 0;
            while (k < nov) {
                rotVertex[k] = new PdVector(3);
                PdVector vhomo = PdVector.copyNew((PdVector)vertex[k]);
                trans.leftMultMatrix(rotVertex[k], vhomo);
                ++k;
            }
            k = 0;
            while (k < nov) {
                this.m_PgonPattern.setVertex(indv, rotVertex[k]);
                ++indv;
                ++k;
            }
            PiVector tmp = PiVector.copyNew((PiVector)this.m_PgonPattern.getElement(0));
            tmp.add(j * nov);
            this.m_PgonPattern.setElement(j, tmp);
            int indexG = PuSubgroup.getIndexOfEltInG(mov, this.m_perm, "rst", false);
            this.m_PgonPattern.getElement(j).setName(String.valueOf(indexG) + "," + this.m_eltH[j]);
            this.m_PgonPattern.setElementColor(j, this.m_color[index]);
            this.m_PgonPattern.setElementNormal(j, new PdVector(1.0, 0.0, 0.0));
            ++j;
        }
        this.m_PgonPattern.showElementColors(true);
        return this.m_PgonPattern;
    }

    private void Replicate(String InitialTran, int LayersTodo, int AdjacencyType) {
        String RotateCenter = new String();
        String RotateVertex = new String();
        this.DrawPgonPattern(InitialTran);
        if (LayersTodo > 0) {
            int ExposedEdges;
            if (AdjacencyType == 1) {
                ExposedEdges = this.m_p - 3;
                RotateCenter = String.valueOf(InitialTran) + this.m_Rotate3P;
            } else {
                ExposedEdges = this.m_p - 2;
                RotateCenter = String.valueOf(InitialTran) + this.m_Rotate2P;
            }
            int i = 0;
            while (i < ExposedEdges) {
                RotateVertex = String.valueOf(RotateCenter) + this.m_RotateQ;
                this.Replicate(RotateVertex, LayersTodo - 1, 1);
                int VertexPgons = i < ExposedEdges - 1 ? this.m_q - 3 : this.m_q - 4;
                int j = 0;
                while (j < VertexPgons) {
                    RotateVertex = String.valueOf(RotateVertex) + this.m_RotateQ;
                    this.Replicate(RotateVertex, LayersTodo - 1, 0);
                    ++j;
                }
                RotateCenter = String.valueOf(RotateCenter) + this.m_RotateP;
                ++i;
            }
        }
    }

    private void DrawPgonPattern(String rep) {
        int numVert = this.m_PgonPattern.getNumVertices();
        int numElement = this.m_PgonPattern.getNumElements();
        PdVector[] vertex = this.m_PgonPattern.getVertices();
        PdVector[] rotVertex = new PdVector[numVert];
        PdMatrix rotateVertex2 = PuIsometry.getTrans(rep, this.m_rst, "rst");
        int index = PuSubgroup.getIndexOfEltInG(rep, this.m_cosetPerm, "rst", false);
        int i = 0;
        while (i < numVert) {
            rotVertex[i] = new PdVector(3);
            rotateVertex2.leftMultMatrix(rotVertex[i], vertex[i]);
            ++i;
        }
        this.m_Tesselation.setNumVertices(m_numPpattern * numVert);
        this.m_Tesselation.setNumElements(m_numPpattern * numElement);
        i = 0;
        while (i < numVert) {
            this.m_Tesselation.setVertex((m_numPpattern - 1) * numVert + i, rotVertex[i]);
            ++i;
        }
        String repG = "";
        int i2 = 0;
        while (i2 < numElement) {
            PiVector tmp = (PiVector)this.m_PgonPattern.getElement(i2).clone();
            String[] name = this.m_PgonPattern.getElement(i2).getName().split(",");
            repG = name.length > 1 ? name[1] : "";
            tmp.add((m_numPpattern - 1) * numVert);
            this.m_Tesselation.setElement(i2 + (m_numPpattern - 1) * numElement, tmp);
            this.m_Tesselation.setElementColor(i2 + (m_numPpattern - 1) * numElement, this.m_color[index]);
            this.m_Tesselation.setElementNormal(i2 + (m_numPpattern - 1) * numElement, new PdVector(1.0, 0.0, 0.0));
            int indexG = PuSubgroup.getIndexOfEltInG(String.valueOf(rep) + repG, this.m_perm, "rst", false);
            this.m_Tesselation.getElement(i2 + (m_numPpattern - 1) * numElement).setName(String.valueOf(indexG) + "," + rep + repG);
            ++i2;
        }
        ++m_numPpattern;
    }

    public PgElementSet getTesselation(int nLayers) {
        m_numPpattern = 2;
        this.fundPgon();
        this.m_RotateQ = "s";
        this.m_RotateP = "r";
        this.m_Rotate2P = "rr";
        this.m_Rotate3P = "rrr";
        this.m_Tesselation = (PgElementSet)this.m_PgonPattern.clone();
        int i = 0;
        while (i < this.m_Tesselation.getNumElements()) {
            this.m_Tesselation.setElementColor(i, this.m_color[0]);
            ++i;
        }
        String RotateCenter = "";
        String RotateVertex = new String();
        int i2 = 0;
        while (i2 < this.m_p) {
            RotateVertex = String.valueOf(RotateCenter) + this.m_RotateQ;
            this.Replicate(RotateVertex, nLayers - 2, 1);
            int j = 0;
            while (j < this.m_q - 3) {
                RotateVertex = String.valueOf(RotateVertex) + this.m_RotateQ;
                this.Replicate(RotateVertex, nLayers - 2, 0);
                ++j;
            }
            RotateCenter = String.valueOf(RotateCenter) + this.m_RotateP;
            ++i2;
        }
        this.m_Tesselation.showElementColors(true);
        return this.m_Tesselation;
    }

    public void fTriangle(PgElementSet geom) {
        geom.setNumVertices(3);
        geom.setNumElements(1);
        switch (PuSpace.SPACE) {
            case -1: {
                geom.setVertex(2, new PdVector(1.0, 0.0, 0.0));
                double cosa = Math.cos(Math.PI / (double)this.m_q) / Math.sin(Math.PI / (double)this.m_p);
                double cosb = Math.cos(Math.PI / (double)this.m_p) / Math.sin(Math.PI / (double)this.m_q);
                geom.setVertex(1, new PdVector(cosb, -Math.sinh(PuMath.acosh((double)cosb)), 0.0));
                geom.setVertex(0, new PdVector(cosa, 0.0, PuMath.sinh((double)PuMath.acosh((double)cosa))));
                break;
            }
            case 0: {
                geom.setVertex(2, new PdVector(0.0, 0.0, 0.0));
                geom.setVertex(0, new PdVector(0.0, 0.5, 0.0));
                geom.setVertex(1, new PdVector(-0.5 * Math.tan(Math.PI / (double)this.m_p), 0.0, 0.0));
                break;
            }
            case 1: {
                PuIsometry.isSpherical2D(true);
                geom.setVertex(2, new PdVector(0.0, 0.0, 0.0));
                geom.setVertex(0, new PdVector(0.0, 1.0, 0.0));
                if (this.m_p == 2) {
                    geom.setVertex(1, new PdVector(-Math.tan(0.9424777960769379)));
                    break;
                }
                geom.setVertex(1, new PdVector(-Math.tan(Math.PI / (double)this.m_p)));
            }
        }
        geom.setElement(0, 0, 1, 2);
    }
}

