/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.vecmath;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import jv.object.PsDebug;

public class PuTargetTubeSymmGroup {
    protected int m_pt;
    protected int m_qt;
    protected int m_gt;
    protected int m_it;
    protected int m_a;
    protected int m_b;
    protected boolean m_dual;
    protected String[] m_elt;
    protected String[] m_coset;
    protected int[] m_ordCoset;
    protected int[][] m_cosetPerm;
    protected String[] m_eltH;
    protected int m_ordG;
    protected int[] m_ordElt;
    protected int[][] m_perm;
    protected static final String m_absolute_path = String.valueOf(System.getProperty("user.dir")) + "\\src\\devRegularMap\\ioFile\\";
    protected final String m_aceInG = String.valueOf(m_absolute_path) + "aceIn.in";
    protected String m_aceOutG;
    protected String m_aceOutCoset;
    protected File m_aceOutPath;
    protected File m_aceOutPathCoset;
    protected String m_relator;

    public PuTargetTubeSymmGroup(int g, int i, int p, int q, boolean dual) {
        this.m_gt = g;
        this.m_it = i;
        this.m_pt = p;
        this.m_qt = q;
        this.m_dual = dual;
        this.makeGroupInformation();
    }

    public PuTargetTubeSymmGroup(int g, int i, int p, int q, boolean dual, int a, int b) {
        this.m_gt = g;
        this.m_it = i;
        this.m_pt = p;
        this.m_qt = q;
        this.m_dual = dual;
        this.m_a = a;
        this.m_b = b;
        this.makeGroupInformation();
    }

    public void makeGroupInformation() {
        this.m_aceOutG = "R" + this.m_gt + "." + this.m_it + "{" + this.m_pt + "_" + this.m_qt + "}_T.out";
        this.m_aceOutCoset = "R" + this.m_gt + "." + this.m_it + "{" + this.m_pt + "_" + this.m_qt + "}_T_coset.out";
        this.m_relator = "a^" + this.m_pt + ",b^" + this.m_qt + ",c^2,(ab)^2,(bc)^2,(abc)^2";
        if (this.m_dual) {
            this.m_aceOutG = "R" + this.m_gt + "." + this.m_it + "'{" + this.m_pt + "_" + this.m_qt + "}_T.out";
            this.m_aceOutCoset = "R" + this.m_gt + "." + this.m_it + "'{" + this.m_pt + "_" + this.m_qt + "}_T_coset.out";
        }
        if (this.m_gt == 1) {
            this.m_aceOutG = "R" + this.m_gt + "." + this.m_it + "{" + this.m_pt + "_" + this.m_qt + "}_" + this.m_a + this.m_b + ".out";
            this.m_aceOutCoset = "R" + this.m_gt + "." + this.m_it + "{" + this.m_pt + "_" + this.m_qt + "}_" + this.m_a + this.m_b + "_coset.out";
        }
        if (this.m_aceOutPath == null) {
            this.m_aceOutPath = new File(String.valueOf(m_absolute_path) + this.m_aceOutG);
            this.m_aceOutPathCoset = new File(String.valueOf(m_absolute_path) + this.m_aceOutCoset);
        } else {
            this.m_aceOutPath.delete();
            this.m_aceOutPathCoset.delete();
            this.m_aceOutPath = new File(String.valueOf(m_absolute_path) + this.m_aceOutG);
            this.m_aceOutPathCoset = new File(String.valueOf(m_absolute_path) + this.m_aceOutCoset);
        }
        this.m_aceOutPath.deleteOnExit();
        this.m_aceOutPathCoset.deleteOnExit();
        try {
            boolean exist = this.m_aceOutPath.exists();
            if (!exist) {
                this.m_aceOutPath.createNewFile();
                this.m_aceOutPathCoset.createNewFile();
                this.getTable();
            }
            this.parseOutputGroup();
        }
        catch (IOException e) {
            PsDebug.error((String)e.getMessage());
        }
    }

    protected void getTable() {
        String commands;
        PrintStream write;
        FileOutputStream fin;
        File file = new File(this.m_aceInG);
        try {
            boolean exist = file.exists();
            if (!exist) {
                FileWriter fstream = new FileWriter(this.m_aceInG);
                BufferedWriter out = new BufferedWriter(fstream);
                out.close();
            }
        }
        catch (IOException e) {
            PsDebug.error((String)"Unable to write aceIn");
        }
        if (this.m_gt > 1) {
            String symM_Trel = "";
            try {
                String str;
                FileInputStream fstream = new FileInputStream(String.valueOf(m_absolute_path) + "OrientableRegularMaps101.txt");
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                int readline = 0;
                while ((str = br.readLine()) != null) {
                    if (readline >= 18) {
                        if (str.length() == 0) {
                            str = br.readLine();
                        }
                        String[] line = str.split("\\s+");
                        String[] g = line[0].split("\\.");
                        int g_T = Integer.parseInt(g[0].substring(1, g[0].length()));
                        int j = Integer.parseInt(g[1]);
                        if (str.length() != 0) {
                            if (this.m_gt == g_T && this.m_it == j) {
                                br.readLine();
                                str = br.readLine();
                                String extraLine = br.readLine();
                                if (extraLine.length() != 0) {
                                    symM_Trel = str.substring(2, str.length());
                                    symM_Trel = String.valueOf(symM_Trel) + extraLine.substring(0, extraLine.length() - 1);
                                } else {
                                    symM_Trel = str.substring(2, str.length() - 1);
                                }
                                String nrelator = "";
                                if (!this.m_dual) break;
                                int i = 0;
                                while (i < symM_Trel.length()) {
                                    Character c = Character.valueOf(symM_Trel.charAt(i));
                                    nrelator = c.charValue() == 'S' ? String.valueOf(nrelator) + "R" : (c.charValue() == 'R' ? String.valueOf(nrelator) + "S" : String.valueOf(nrelator) + c.toString());
                                    ++i;
                                }
                                symM_Trel = nrelator;
                                break;
                            }
                            br.readLine();
                            br.readLine();
                            br.readLine();
                        }
                    }
                    ++readline;
                }
                br.close();
            }
            catch (Exception e) {
                PsDebug.error((String)e.getMessage());
            }
            String[] r = symM_Trel.split(",\\s+");
            int len = r.length;
            String[] extraRelators = new String[len];
            int i = 0;
            while (i < len) {
                String nrelator = "";
                int k = 0;
                while (k < r[i].length()) {
                    Character c = Character.valueOf(r[i].charAt(k));
                    nrelator = c.charValue() == 'R' ? String.valueOf(nrelator) + "a" : (c.charValue() == 'S' ? String.valueOf(nrelator) + "b" : (c.charValue() == 'T' ? String.valueOf(nrelator) + "(bc)" : String.valueOf(nrelator) + c.toString()));
                    ++k;
                }
                extraRelators[i] = nrelator;
                ++i;
            }
            i = 0;
            while (i < len) {
                this.m_relator = String.valueOf(this.m_relator) + "," + extraRelators[i];
                ++i;
            }
        } else if (this.m_gt == 1) {
            if (this.m_pt == 4 && this.m_qt == 4) {
                if (this.m_a == this.m_b) {
                    this.m_relator = String.valueOf(this.m_relator) + ",(Babc)^" + 2 * this.m_b;
                }
                if (this.m_b == 0) {
                    this.m_relator = String.valueOf(this.m_relator) + ",(aB)^" + this.m_a;
                }
            } else if (this.m_pt == 3 && this.m_qt == 6) {
                if (this.m_a == this.m_b) {
                    this.m_relator = String.valueOf(this.m_relator) + ",(abcbb)^" + 2 * this.m_b;
                }
                if (this.m_b == 0) {
                    this.m_relator = String.valueOf(this.m_relator) + ",(aBB)^" + this.m_a;
                }
            } else if (this.m_pt == 6 && this.m_qt == 3) {
                if (this.m_a == this.m_b) {
                    this.m_relator = String.valueOf(this.m_relator) + ",(bbcaa)^" + 2 * this.m_b;
                }
                if (this.m_b == 0) {
                    this.m_relator = String.valueOf(this.m_relator) + ",(bAA)^" + this.m_a;
                }
            }
        }
        try {
            fin = new FileOutputStream(this.m_aceInG);
            write = new PrintStream(fin);
            write.println("group name:g;\n");
            write.println("group generators:abc;\n");
            write.println("group relators:" + this.m_relator + ";");
            write.println("end");
            write.println("st;pr:-1,1000;");
            fin.close();
        }
        catch (IOException e) {
            PsDebug.error((String)"Unable to write to aceIn for element Input");
        }
        try {
            commands = "cmd /c ace.exe <aceIn.in> " + this.m_aceOutG;
            Runtime.getRuntime().exec(commands, null, new File(m_absolute_path));
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            PsDebug.error((String)"Unable to write aceOut for Group");
        }
        try {
            fin = new FileOutputStream(this.m_aceInG);
            write = new PrintStream(fin);
            write.println("group name:g;");
            write.println("group generators:abc;");
            write.println("group relators:" + this.m_relator + ";");
            write.println("subgroup name:H;");
            write.println("subgroup generators:c,ab;");
            write.println("end");
            write.println("st;pr:-1,1000;");
            fin.close();
        }
        catch (IOException e) {
            PsDebug.error((String)"Unable to write to aceIn For coset enumeration ");
        }
        try {
            commands = "cmd /c ace.exe <aceIn.in> " + this.m_aceOutCoset;
            Runtime.getRuntime().exec(commands, null, new File(m_absolute_path));
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            PsDebug.error((String)"Unable to write aceOut for coset");
        }
    }

    protected void parseOutputGroup() {
        int i;
        int readline;
        String str;
        BufferedReader br;
        DataInputStream in;
        FileInputStream fstream;
        int ind = 0;
        try {
            fstream = new FileInputStream(this.m_aceOutPath);
            in = new DataInputStream(fstream);
            br = new BufferedReader(new InputStreamReader(in));
            str = " ";
            readline = 0;
            int i2 = 0;
            while (i2 < 5) {
                str = br.readLine();
                ++i2;
            }
            String[] line = str.split("\\s+");
            this.m_ordG = Integer.parseInt(line[2]);
            this.m_elt = new String[this.m_ordG];
            this.m_ordElt = new int[this.m_ordG];
            this.m_perm = new int[5][this.m_ordG];
            readline = 8;
            br.readLine();
            br.readLine();
            str = br.readLine();
            str = str.trim();
            line = str.split("\\s+");
            int numGen = line.length - 4;
            String gen = "aAbBc";
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            int[] perm = nArray;
            int i3 = 0;
            while (i3 < numGen) {
                int j1 = 0;
                while (j1 < gen.length()) {
                    if (line[i3 + 2].charAt(0) == gen.charAt(j1)) {
                        perm[i3] = j1;
                    }
                    ++j1;
                }
                ++i3;
            }
            while ((str = br.readLine()) != null) {
                if (readline >= 9 && readline < this.m_ordG + 9) {
                    str = str.trim();
                    line = str.split("\\s+");
                    int len = line.length;
                    if (ind == 0) {
                        this.m_elt[ind] = " ";
                        this.m_ordElt[ind] = 1;
                    } else {
                        this.m_elt[ind] = line[len - 1];
                        this.m_ordElt[ind] = Integer.parseInt(line[len - 2]);
                    }
                    i = 0;
                    while (i < numGen) {
                        this.m_perm[perm[i]][ind] = Integer.parseInt(line[2 + i]);
                        ++i;
                    }
                    ++ind;
                }
                ++readline;
            }
            in.close();
        }
        catch (Exception e) {
            PsDebug.error((String)"Unable to open aceOut for permutation");
            PsDebug.error((String)e.getMessage());
        }
        ind = 0;
        try {
            fstream = new FileInputStream(this.m_aceOutPathCoset);
            in = new DataInputStream(fstream);
            br = new BufferedReader(new InputStreamReader(in));
            str = " ";
            readline = 0;
            int i4 = 0;
            while (i4 < 5) {
                str = br.readLine();
                ++i4;
            }
            String[] line = str.split("\\s+");
            int ord = Integer.parseInt(line[2]);
            this.m_coset = new String[ord];
            this.m_ordCoset = new int[ord];
            this.m_cosetPerm = new int[5][ord];
            this.m_coset[0] = "";
            readline = 8;
            br.readLine();
            br.readLine();
            str = br.readLine();
            str = str.trim();
            line = str.split("\\s+");
            int numGen = line.length - 4;
            String gen = "aAbBc";
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            int[] perm = nArray;
            i = 0;
            while (i < numGen) {
                int j1 = 0;
                while (j1 < gen.length()) {
                    if (line[i + 2].equals(gen)) {
                        perm[i] = j1;
                    }
                    ++j1;
                }
                ++i;
            }
            while ((str = br.readLine()) != null) {
                if (readline >= 9 && readline < ord + 9) {
                    str = str.trim();
                    line = str.split("\\s+");
                    int len = line.length;
                    if (ind == 0) {
                        this.m_coset[ind] = " ";
                        this.m_ordCoset[ind] = 1;
                    } else {
                        this.m_coset[ind] = line[len - 1];
                        this.m_ordCoset[ind] = Integer.parseInt(line[len - 2]);
                    }
                    int i5 = 0;
                    while (i5 < numGen) {
                        this.m_cosetPerm[perm[i5]][ind] = Integer.parseInt(line[2 + i5]);
                        ++i5;
                    }
                    ++ind;
                }
                ++readline;
            }
            br.close();
        }
        catch (Exception e) {
            PsDebug.error((String)"Unable to open aceOut for coset");
            PsDebug.error((String)e.getMessage());
        }
        this.m_eltH = new String[]{"", "c", "ab", "abc"};
    }

    public void setTorusMap(int a, int b) {
        this.m_a = a;
        this.m_b = b;
    }

    public void setParameter(int g, int i, int p, int q, boolean dual) {
        this.m_gt = g;
        this.m_it = i;
        this.m_pt = p;
        this.m_qt = q;
        this.m_dual = dual;
        this.makeGroupInformation();
    }

    public String[] getElementTable() {
        return this.m_elt;
    }

    public int[][] getPermutationTable() {
        return this.m_perm;
    }

    public String[] getCosetSubgroupTable() {
        return this.m_coset;
    }

    public int[][] getCosetPermutation() {
        return this.m_cosetPerm;
    }

    public String[] getSubgroup() {
        return this.m_eltH;
    }
}

